(window["webpackJsonp"] = window["webpackJsonp"] || []).push([[37],{

/***/ 10:
/***/ (function(module, exports) {

/*
	MIT License http://www.opensource.org/licenses/mit-license.php
	Author Tobias Koppers @sokra
*/
// css base code, injected by the css-loader
module.exports = function(useSourceMap) {
	var list = [];

	// return the list of modules as css string
	list.toString = function toString() {
		return this.map(function (item) {
			var content = cssWithMappingToString(item, useSourceMap);
			if(item[2]) {
				return "@media " + item[2] + "{" + content + "}";
			} else {
				return content;
			}
		}).join("");
	};

	// import a list of modules into the list
	list.i = function(modules, mediaQuery) {
		if(typeof modules === "string")
			modules = [[null, modules, ""]];
		var alreadyImportedModules = {};
		for(var i = 0; i < this.length; i++) {
			var id = this[i][0];
			if(typeof id === "number")
				alreadyImportedModules[id] = true;
		}
		for(i = 0; i < modules.length; i++) {
			var item = modules[i];
			// skip already imported module
			// this implementation is not 100% perfect for weird media query combinations
			//  when a module is imported multiple times with different media queries.
			//  I hope this will never occur (Hey this way we have smaller bundles)
			if(typeof item[0] !== "number" || !alreadyImportedModules[item[0]]) {
				if(mediaQuery && !item[2]) {
					item[2] = mediaQuery;
				} else if(mediaQuery) {
					item[2] = "(" + item[2] + ") and (" + mediaQuery + ")";
				}
				list.push(item);
			}
		}
	};
	return list;
};

function cssWithMappingToString(item, useSourceMap) {
	var content = item[1] || '';
	var cssMapping = item[3];
	if (!cssMapping) {
		return content;
	}

	if (useSourceMap && typeof btoa === 'function') {
		var sourceMapping = toComment(cssMapping);
		var sourceURLs = cssMapping.sources.map(function (source) {
			return '/*# sourceURL=' + cssMapping.sourceRoot + source + ' */'
		});

		return [content].concat(sourceURLs).concat([sourceMapping]).join('\n');
	}

	return [content].join('\n');
}

// Adapted from convert-source-map (MIT)
function toComment(sourceMap) {
	// eslint-disable-next-line no-undef
	var base64 = btoa(unescape(encodeURIComponent(JSON.stringify(sourceMap))));
	var data = 'sourceMappingURL=data:application/json;charset=utf-8;base64,' + base64;

	return '/*# ' + data + ' */';
}


/***/ }),

/***/ 11:
/***/ (function(module, exports, __webpack_require__) {

/*
	MIT License http://www.opensource.org/licenses/mit-license.php
	Author Tobias Koppers @sokra
*/

var stylesInDom = {};

var	memoize = function (fn) {
	var memo;

	return function () {
		if (typeof memo === "undefined") memo = fn.apply(this, arguments);
		return memo;
	};
};

var isOldIE = memoize(function () {
	// Test for IE <= 9 as proposed by Browserhacks
	// @see http://browserhacks.com/#hack-e71d8692f65334173fee715c222cb805
	// Tests for existence of standard globals is to allow style-loader
	// to operate correctly into non-standard environments
	// @see https://github.com/webpack-contrib/style-loader/issues/177
	return window && document && document.all && !window.atob;
});

var getElement = (function (fn) {
	var memo = {};

	return function(selector) {
		if (typeof memo[selector] === "undefined") {
			var styleTarget = fn.call(this, selector);
			// Special case to return head of iframe instead of iframe itself
			if (styleTarget instanceof window.HTMLIFrameElement) {
				try {
					// This will throw an exception if access to iframe is blocked
					// due to cross-origin restrictions
					styleTarget = styleTarget.contentDocument.head;
				} catch(e) {
					styleTarget = null;
				}
			}
			memo[selector] = styleTarget;
		}
		return memo[selector]
	};
})(function (target) {
	return document.querySelector(target)
});

var singleton = null;
var	singletonCounter = 0;
var	stylesInsertedAtTop = [];

var	fixUrls = __webpack_require__(35);

module.exports = function(list, options) {
	if (typeof DEBUG !== "undefined" && DEBUG) {
		if (typeof document !== "object") throw new Error("The style-loader cannot be used in a non-browser environment");
	}

	options = options || {};

	options.attrs = typeof options.attrs === "object" ? options.attrs : {};

	// Force single-tag solution on IE6-9, which has a hard limit on the # of <style>
	// tags it will allow on a page
	if (!options.singleton && typeof options.singleton !== "boolean") options.singleton = isOldIE();

	// By default, add <style> tags to the <head> element
	if (!options.insertInto) options.insertInto = "head";

	// By default, add <style> tags to the bottom of the target
	if (!options.insertAt) options.insertAt = "bottom";

	var styles = listToStyles(list, options);

	addStylesToDom(styles, options);

	return function update (newList) {
		var mayRemove = [];

		for (var i = 0; i < styles.length; i++) {
			var item = styles[i];
			var domStyle = stylesInDom[item.id];

			domStyle.refs--;
			mayRemove.push(domStyle);
		}

		if(newList) {
			var newStyles = listToStyles(newList, options);
			addStylesToDom(newStyles, options);
		}

		for (var i = 0; i < mayRemove.length; i++) {
			var domStyle = mayRemove[i];

			if(domStyle.refs === 0) {
				for (var j = 0; j < domStyle.parts.length; j++) domStyle.parts[j]();

				delete stylesInDom[domStyle.id];
			}
		}
	};
};

function addStylesToDom (styles, options) {
	for (var i = 0; i < styles.length; i++) {
		var item = styles[i];
		var domStyle = stylesInDom[item.id];

		if(domStyle) {
			domStyle.refs++;

			for(var j = 0; j < domStyle.parts.length; j++) {
				domStyle.parts[j](item.parts[j]);
			}

			for(; j < item.parts.length; j++) {
				domStyle.parts.push(addStyle(item.parts[j], options));
			}
		} else {
			var parts = [];

			for(var j = 0; j < item.parts.length; j++) {
				parts.push(addStyle(item.parts[j], options));
			}

			stylesInDom[item.id] = {id: item.id, refs: 1, parts: parts};
		}
	}
}

function listToStyles (list, options) {
	var styles = [];
	var newStyles = {};

	for (var i = 0; i < list.length; i++) {
		var item = list[i];
		var id = options.base ? item[0] + options.base : item[0];
		var css = item[1];
		var media = item[2];
		var sourceMap = item[3];
		var part = {css: css, media: media, sourceMap: sourceMap};

		if(!newStyles[id]) styles.push(newStyles[id] = {id: id, parts: [part]});
		else newStyles[id].parts.push(part);
	}

	return styles;
}

function insertStyleElement (options, style) {
	var target = getElement(options.insertInto)

	if (!target) {
		throw new Error("Couldn't find a style target. This probably means that the value for the 'insertInto' parameter is invalid.");
	}

	var lastStyleElementInsertedAtTop = stylesInsertedAtTop[stylesInsertedAtTop.length - 1];

	if (options.insertAt === "top") {
		if (!lastStyleElementInsertedAtTop) {
			target.insertBefore(style, target.firstChild);
		} else if (lastStyleElementInsertedAtTop.nextSibling) {
			target.insertBefore(style, lastStyleElementInsertedAtTop.nextSibling);
		} else {
			target.appendChild(style);
		}
		stylesInsertedAtTop.push(style);
	} else if (options.insertAt === "bottom") {
		target.appendChild(style);
	} else if (typeof options.insertAt === "object" && options.insertAt.before) {
		var nextSibling = getElement(options.insertInto + " " + options.insertAt.before);
		target.insertBefore(style, nextSibling);
	} else {
		throw new Error("[Style Loader]\n\n Invalid value for parameter 'insertAt' ('options.insertAt') found.\n Must be 'top', 'bottom', or Object.\n (https://github.com/webpack-contrib/style-loader#insertat)\n");
	}
}

function removeStyleElement (style) {
	if (style.parentNode === null) return false;
	style.parentNode.removeChild(style);

	var idx = stylesInsertedAtTop.indexOf(style);
	if(idx >= 0) {
		stylesInsertedAtTop.splice(idx, 1);
	}
}

function createStyleElement (options) {
	var style = document.createElement("style");

	options.attrs.type = "text/css";

	addAttrs(style, options.attrs);
	insertStyleElement(options, style);

	return style;
}

function createLinkElement (options) {
	var link = document.createElement("link");

	options.attrs.type = "text/css";
	options.attrs.rel = "stylesheet";

	addAttrs(link, options.attrs);
	insertStyleElement(options, link);

	return link;
}

function addAttrs (el, attrs) {
	Object.keys(attrs).forEach(function (key) {
		el.setAttribute(key, attrs[key]);
	});
}

function addStyle (obj, options) {
	var style, update, remove, result;

	// If a transform function was defined, run it on the css
	if (options.transform && obj.css) {
	    result = options.transform(obj.css);

	    if (result) {
	    	// If transform returns a value, use that instead of the original css.
	    	// This allows running runtime transformations on the css.
	    	obj.css = result;
	    } else {
	    	// If the transform function returns a falsy value, don't add this css.
	    	// This allows conditional loading of css
	    	return function() {
	    		// noop
	    	};
	    }
	}

	if (options.singleton) {
		var styleIndex = singletonCounter++;

		style = singleton || (singleton = createStyleElement(options));

		update = applyToSingletonTag.bind(null, style, styleIndex, false);
		remove = applyToSingletonTag.bind(null, style, styleIndex, true);

	} else if (
		obj.sourceMap &&
		typeof URL === "function" &&
		typeof URL.createObjectURL === "function" &&
		typeof URL.revokeObjectURL === "function" &&
		typeof Blob === "function" &&
		typeof btoa === "function"
	) {
		style = createLinkElement(options);
		update = updateLink.bind(null, style, options);
		remove = function () {
			removeStyleElement(style);

			if(style.href) URL.revokeObjectURL(style.href);
		};
	} else {
		style = createStyleElement(options);
		update = applyToTag.bind(null, style);
		remove = function () {
			removeStyleElement(style);
		};
	}

	update(obj);

	return function updateStyle (newObj) {
		if (newObj) {
			if (
				newObj.css === obj.css &&
				newObj.media === obj.media &&
				newObj.sourceMap === obj.sourceMap
			) {
				return;
			}

			update(obj = newObj);
		} else {
			remove();
		}
	};
}

var replaceText = (function () {
	var textStore = [];

	return function (index, replacement) {
		textStore[index] = replacement;

		return textStore.filter(Boolean).join('\n');
	};
})();

function applyToSingletonTag (style, index, remove, obj) {
	var css = remove ? "" : obj.css;

	if (style.styleSheet) {
		style.styleSheet.cssText = replaceText(index, css);
	} else {
		var cssNode = document.createTextNode(css);
		var childNodes = style.childNodes;

		if (childNodes[index]) style.removeChild(childNodes[index]);

		if (childNodes.length) {
			style.insertBefore(cssNode, childNodes[index]);
		} else {
			style.appendChild(cssNode);
		}
	}
}

function applyToTag (style, obj) {
	var css = obj.css;
	var media = obj.media;

	if(media) {
		style.setAttribute("media", media)
	}

	if(style.styleSheet) {
		style.styleSheet.cssText = css;
	} else {
		while(style.firstChild) {
			style.removeChild(style.firstChild);
		}

		style.appendChild(document.createTextNode(css));
	}
}

function updateLink (link, options, obj) {
	var css = obj.css;
	var sourceMap = obj.sourceMap;

	/*
		If convertToAbsoluteUrls isn't defined, but sourcemaps are enabled
		and there is no publicPath defined then lets turn convertToAbsoluteUrls
		on by default.  Otherwise default to the convertToAbsoluteUrls option
		directly
	*/
	var autoFixUrls = options.convertToAbsoluteUrls === undefined && sourceMap;

	if (options.convertToAbsoluteUrls || autoFixUrls) {
		css = fixUrls(css);
	}

	if (sourceMap) {
		// http://stackoverflow.com/a/26603875
		css += "\n/*# sourceMappingURL=data:application/json;base64," + btoa(unescape(encodeURIComponent(JSON.stringify(sourceMap)))) + " */";
	}

	var blob = new Blob([css], { type: "text/css" });

	var oldSrc = link.href;

	link.href = URL.createObjectURL(blob);

	if(oldSrc) URL.revokeObjectURL(oldSrc);
}


/***/ }),

/***/ 112:
/***/ (function(module, exports) {

module.exports = "\"data:image/svg+xml,%3C?xml version='1.0' encoding='utf-8'?%3E %3C!-- Generator: Adobe Illustrator 21.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0) --%3E %3Csvg version='1.1' id='Ebene_1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' x='0px' y='0px' viewBox='0 0 42.5 42.5' style='enable-background:new 0 0 42.5 42.5;' xml:space='preserve' width='42.5' height='42.5'%3E %3Cpath d='M28.1,21c0-2-0.7-3.7-2.1-5.1s-3.1-2.1-5.1-2.1s-3.7,0.7-5.1,2.1S13.8,19,13.8,21s0.7,3.7,2.1,5.1s3.1,2.1,5.1,2.1 s3.7-0.7,5.1-2.1S28.1,22.9,28.1,21z M37.9,18.5v4.9c0,0.2-0.1,0.3-0.2,0.5c-0.1,0.2-0.3,0.3-0.4,0.3l-4.1,0.6 c-0.3,0.8-0.6,1.5-0.9,2c0.5,0.7,1.3,1.8,2.4,3c0.1,0.2,0.2,0.4,0.2,0.6s-0.1,0.4-0.2,0.5c-0.4,0.5-1.1,1.3-2.2,2.4 c-1.1,1-1.8,1.6-2.1,1.6c-0.2,0-0.4-0.1-0.6-0.2l-3-2.4c-0.6,0.3-1.3,0.6-2,0.8c-0.2,2-0.4,3.4-0.6,4.1c-0.1,0.4-0.4,0.6-0.8,0.6 h-4.9c-0.2,0-0.4-0.1-0.5-0.2c-0.2-0.1-0.2-0.3-0.3-0.5l-0.6-4.1c-0.7-0.2-1.4-0.5-2-0.8L12,34.7c-0.1,0.1-0.3,0.2-0.6,0.2 c-0.2,0-0.4-0.1-0.6-0.2C9,33,7.8,31.8,7.2,31c-0.1-0.1-0.2-0.3-0.2-0.5c0-0.2,0.1-0.3,0.2-0.5c0.2-0.3,0.6-0.8,1.1-1.5 s0.9-1.2,1.2-1.6c-0.4-0.7-0.7-1.5-0.9-2.2l-4-0.6c-0.2,0-0.3-0.1-0.5-0.3C4.1,23.7,4,23.5,4,23.4v-4.9c0-0.2,0.1-0.3,0.2-0.5 s0.3-0.3,0.4-0.3L8.7,17c0.2-0.7,0.5-1.4,0.9-2c-0.6-0.8-1.4-1.9-2.4-3C7.1,11.8,7,11.6,7,11.4c0-0.1,0.1-0.3,0.2-0.5 c0.4-0.5,1.1-1.3,2.2-2.4S11.1,7,11.4,7c0.2,0,0.4,0.1,0.6,0.2l3,2.4c0.6-0.3,1.3-0.6,2-0.8c0.2-2,0.4-3.4,0.6-4.1 C17.8,4.2,18.1,4,18.5,4h4.9c0.2,0,0.4,0.1,0.5,0.2c0.2,0.1,0.2,0.3,0.3,0.5l0.6,4.1c0.7,0.2,1.4,0.5,2,0.8l3.1-2.4 C30.1,7,30.2,7,30.5,7c0.2,0,0.4,0.1,0.6,0.2c1.9,1.8,3.1,3,3.6,3.8c0.1,0.1,0.2,0.3,0.2,0.5c0,0.2-0.1,0.3-0.2,0.5 c-0.2,0.3-0.6,0.8-1.1,1.5c-0.5,0.7-0.9,1.2-1.2,1.6c0.4,0.7,0.7,1.5,0.9,2.2l4,0.6c0.2,0,0.3,0.1,0.5,0.3 C37.8,18.2,37.9,18.4,37.9,18.5z'/%3E %3C/svg%3E\""

/***/ }),

/***/ 119:
/***/ (function(module, exports) {

module.exports = "\"data:image/svg+xml,%3C?xml version='1.0' encoding='utf-8'?%3E %3C!-- Generator: Adobe Illustrator 21.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0) --%3E %3Csvg version='1.1' id='Ebene_1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' x='0px' y='0px' viewBox='0 0 42.5 42.5' style='enable-background:new 0 0 42.5 42.5;' xml:space='preserve' width='42.5' height='42.5'%3E %3Cpath d='M14.2,20.9c-2,0.1-3.7,0.9-5,2.4H6.7c-1,0-1.9-0.3-2.6-0.8C3.4,22.1,3,21.3,3,20.3c0-4.4,0.8-6.7,2.3-6.7 c0.1,0,0.3,0.1,0.8,0.4c0.5,0.3,1.1,0.5,1.8,0.8c0.8,0.3,1.5,0.4,2.2,0.4c0.8,0,1.7-0.1,2.5-0.4c-0.1,0.5-0.1,0.9-0.1,1.2 C12.7,17.8,13.2,19.4,14.2,20.9z M34.7,33.1c0,1.5-0.5,2.7-1.4,3.6c-0.9,0.9-2.1,1.3-3.7,1.3H13.2c-1.5,0-2.7-0.4-3.7-1.3 c-0.9-0.9-1.4-2.1-1.4-3.6c0-0.7,0-1.3,0.1-2s0.1-1.3,0.3-2.1c0.1-0.7,0.3-1.4,0.5-2s0.5-1.2,0.8-1.8c0.3-0.6,0.7-1.1,1.2-1.5 c0.4-0.4,1-0.8,1.6-1s1.3-0.4,2.1-0.4c0.1,0,0.4,0.1,0.8,0.4c0.4,0.3,0.9,0.6,1.4,0.9s1.2,0.6,2,0.9c0.8,0.3,1.7,0.4,2.5,0.4 s1.7-0.1,2.5-0.4c0.8-0.3,1.5-0.6,2-0.9c0.5-0.3,1-0.6,1.4-0.9s0.7-0.4,0.8-0.4c0.8,0,1.5,0.1,2.1,0.4s1.2,0.6,1.6,1 c0.4,0.4,0.8,0.9,1.2,1.5c0.3,0.6,0.6,1.2,0.8,1.8c0.2,0.6,0.4,1.3,0.5,2c0.1,0.7,0.2,1.4,0.3,2.1S34.7,32.5,34.7,33.1z M15.1,8.8 c0,1.3-0.5,2.5-1.4,3.4s-2.1,1.4-3.4,1.4s-2.5-0.5-3.4-1.4s-1.4-2.1-1.4-3.4s0.5-2.5,1.4-3.4S8.9,4,10.2,4s2.5,0.5,3.4,1.4 S15.1,7.5,15.1,8.8z M27.8,16.1c0,1.8-0.6,3.3-1.9,4.5c-1.3,1.3-2.8,1.9-4.5,1.9c-1.8,0-3.3-0.6-4.5-1.9c-1.3-1.3-1.9-2.8-1.9-4.5 s0.6-3.3,1.9-4.5s2.8-1.9,4.5-1.9c1.8,0,3.3,0.6,4.5,1.9C27.2,12.8,27.8,14.3,27.8,16.1z M39.8,20.3c0,1-0.4,1.7-1.1,2.2 c-0.7,0.5-1.6,0.8-2.6,0.8h-2.5c-1.3-1.5-3-2.4-5-2.4c1-1.5,1.5-3.1,1.5-4.8c0-0.4,0-0.8-0.1-1.2c0.8,0.3,1.7,0.4,2.5,0.4 c0.7,0,1.5-0.1,2.2-0.4c0.8-0.3,1.4-0.5,1.8-0.8c0.5-0.3,0.7-0.4,0.8-0.4C39,13.7,39.8,15.9,39.8,20.3z M37.4,8.8 c0,1.3-0.5,2.5-1.4,3.4c-0.9,0.9-2.1,1.4-3.4,1.4c-1.3,0-2.5-0.5-3.4-1.4c-0.9-0.9-1.4-2.1-1.4-3.4s0.5-2.5,1.4-3.4 C30.1,4.5,31.2,4,32.6,4C33.9,4,35,4.5,36,5.4C36.9,6.4,37.4,7.5,37.4,8.8z'/%3E %3C/svg%3E\""

/***/ }),

/***/ 143:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 * 
 * @package     Voipmanager
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Philipp Schuele <p.schuele@metaways.de>
 * @copyright   Copyright (c) 2010 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 */
Ext.namespace('Tine.Voipmanager');
/**
 * Account Picker GridPanel
 * 
 * @namespace   Tine.Voipmanager
 * @class       Tine.Voipmanager.CallForwardPanel
 * @extends     Ext.Panel
 * 
 * <p>Call Forward Form Panel</p>
 * <p><pre>
 * </pre></p>
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Philipp Schuele <p.schuele@metaways.de>
 * @copyright   Copyright (c) 2010 Metaways Infosystems GmbH (http://www.metaways.de)
 * 
 * @param       {Object} config
 * @constructor
 * Create a new Tine.Voipmanager.CallForwardPanel
 */

Tine.Voipmanager.CallForwardPanel = Ext.extend(Ext.Panel, {
  /**
   * @cfg
   */
  border: false,
  frame: true,
  anchor: '100%',

  /**
   * @type Tine.Tinebase.data.Record
   */
  record: null,

  /**
   * @type Tine.widgets.dialog.EditDialog
   */
  editDialog: null,

  /**
   * @private
   */
  initComponent: function initComponent() {
    this.addEvents(
    /**
     * @event change
     * Fired when one of the input fields changed
     */
    'change');
    this.items = this.getFormItems();
    Tine.Voipmanager.CallForwardPanel.superclass.initComponent.call(this);
    this.on('afterrender', this.onAfterRender, this);
  },

  /**
   * returns dialog
   * 
   * NOTE: when this method gets called, all initalisation is done.
   */
  getFormItems: function getFormItems() {
    // we need to init translations because it could be that we call this from Phone app without Voipmanager
    var translations;

    if (!this.app) {
      translations = new Locale.Gettext();
      translations.textdomain('Voipmanager');
    } else {
      translations = this.app.i18n;
    }

    return [{
      title: translations._('Forward immediately'),
      autoHeight: true,
      xtype: 'fieldset',
      layout: 'form',
      defaults: {
        anchor: '100%'
      },
      items: [{
        name: 'cfi_mode',
        xtype: 'combo',
        fieldLabel: translations._('Mode'),
        typeAhead: true,
        triggerAction: 'all',
        lazyRender: true,
        allowBlank: false,
        editable: false,
        blurOnSelect: true,
        value: 'off',
        store: [['off', 'off'], ['number', 'number'], ['voicemail', 'voicemail']],
        listeners: {
          scope: this,
          select: function select(combo, record) {
            // disable number if != number
            this.editDialog.getForm().findField('cfi_number').setDisabled(record.data.field1 != 'number');
            this.onFieldChange();
          }
        }
      }, {
        name: 'cfi_number',
        fieldLabel: translations._('Number'),
        xtype: 'textfield',
        enableKeyEvents: true,
        listeners: {
          keyup: this.onFieldChange,
          scope: this
        }
      }]
    }, {
      title: translations._('Forward busy'),
      autoHeight: true,
      xtype: 'fieldset',
      layout: 'form',
      defaults: {
        anchor: '100%'
      },
      items: [{
        name: 'cfb_mode',
        xtype: 'combo',
        fieldLabel: translations._('Mode'),
        typeAhead: true,
        triggerAction: 'all',
        lazyRender: true,
        allowBlank: false,
        editable: false,
        blurOnSelect: true,
        value: 'off',
        store: [['off', 'off'], ['number', 'number'], ['voicemail', 'voicemail']],
        listeners: {
          scope: this,
          select: function select(combo, record) {
            this.editDialog.getForm().findField('cfb_number').setDisabled(record.data.field1 != 'number');
            this.onFieldChange();
          }
        }
      }, {
        name: 'cfb_number',
        fieldLabel: translations._('Number'),
        xtype: 'textfield',
        enableKeyEvents: true,
        listeners: {
          keyup: this.onFieldChange,
          scope: this
        }
      }]
    }, {
      title: translations._('Forward delayed'),
      autoHeight: true,
      xtype: 'fieldset',
      layout: 'form',
      defaults: {
        anchor: '100%'
      },
      items: [{
        name: 'cfd_mode',
        xtype: 'combo',
        fieldLabel: translations._('Mode'),
        typeAhead: true,
        triggerAction: 'all',
        lazyRender: true,
        allowBlank: false,
        editable: false,
        blurOnSelect: true,
        value: 'off',
        store: [['off', 'off'], ['number', 'number'], ['voicemail', 'voicemail']],
        listeners: {
          scope: this,
          select: function select(combo, record) {
            this.editDialog.getForm().findField('cfd_number').setDisabled(record.data.field1 != 'number');
            this.editDialog.getForm().findField('cfd_time').setDisabled(record.data.field1 == 'off');
            this.onFieldChange();
          }
        }
      }, {
        name: 'cfd_number',
        fieldLabel: translations._('Number'),
        xtype: 'textfield',
        enableKeyEvents: true,
        listeners: {
          keyup: this.onFieldChange,
          scope: this
        }
      }, {
        name: 'cfd_time',
        fieldLabel: translations._('Delay time'),
        xtype: 'numberfield',
        allowNegative: false,
        value: 30,
        enableKeyEvents: true,
        listeners: {
          keyup: this.onFieldChange,
          scope: this
        }
      }]
    }];
  },

  /**
   * disable some fields after render
   */
  onAfterRender: function onAfterRender() {
    if (this.record !== null) {
      this.disableFields();
    }
  },

  /**
   * 
   * @param {Object} record
   */
  onRecordLoad: function onRecordLoad(record) {
    this.record = record;

    if (this.rendered) {
      this.disableFields();
    }
  },

  /**
   * fire change event if field changes
   */
  onFieldChange: function onFieldChange() {
    this.fireEvent('change');
  },
  disableFields: function disableFields() {
    this.editDialog.getForm().findField('cfi_number').setDisabled(this.record.data.cfi_mode != 'number');
    this.editDialog.getForm().findField('cfb_number').setDisabled(this.record.data.cfb_mode != 'number');
    this.editDialog.getForm().findField('cfd_number').setDisabled(this.record.data.cfd_mode != 'number');
    this.editDialog.getForm().findField('cfd_time').setDisabled(this.record.data.cfd_mode == 'off');
  }
});

/***/ }),

/***/ 169:
/***/ (function(module, exports) {

module.exports = "\"data:image/svg+xml,%3C?xml version='1.0' encoding='utf-8'?%3E %3C!-- Generator: Adobe Illustrator 21.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0) --%3E %3Csvg version='1.1' id='Ebene_1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' x='0px' y='0px' viewBox='0 0 42.5 42.5' style='enable-background:new 0 0 42.5 42.5;' xml:space='preserve' width='42.5' height='42.5'%3E %3Cpath id='Icon_Phone' d='M35.3,29.4c0,0.4-0.1,0.8-0.2,1.4c-0.1,0.6-0.3,1-0.4,1.4c-0.3,0.7-1.1,1.4-2.5,2.1c-1.3,0.7-2.5,1-3.7,1 c-0.4,0-0.7,0-1.1-0.1s-0.7-0.1-1.2-0.3s-0.7-0.2-0.9-0.3c-0.2-0.1-0.6-0.2-1.1-0.4s-0.9-0.3-1-0.4c-1.3-0.5-2.5-1-3.5-1.7 c-1.7-1.1-3.5-2.5-5.3-4.3c-1.8-1.8-3.3-3.6-4.3-5.3c-0.6-1-1.2-2.2-1.7-3.5c0-0.1-0.2-0.4-0.4-1c-0.2-0.5-0.3-0.9-0.4-1.1 S7.4,16.5,7.3,16c-0.1-0.4-0.2-0.8-0.3-1.2C7,14.5,7,14.2,7,13.8c0-1.2,0.3-2.5,1-3.7c0.8-1.4,1.5-2.2,2.1-2.5 c0.3-0.1,0.8-0.3,1.4-0.4S12.6,7,13,7c0.2,0,0.3,0,0.4,0.1c0.2,0.1,0.6,0.6,1.1,1.5c0.1,0.3,0.3,0.6,0.6,1.1 c0.3,0.5,0.5,0.9,0.7,1.3c0.2,0.4,0.4,0.7,0.6,1.1c0,0.1,0.2,0.2,0.4,0.5c0.2,0.3,0.3,0.5,0.4,0.7s0.1,0.4,0.1,0.6 c0,0.3-0.2,0.6-0.6,1c-0.4,0.4-0.8,0.8-1.2,1.1s-0.9,0.7-1.2,1.1c-0.4,0.4-0.6,0.7-0.6,0.9c0,0.1,0,0.3,0.1,0.5 c0.1,0.2,0.1,0.3,0.2,0.4s0.1,0.3,0.3,0.5c0.1,0.2,0.2,0.4,0.2,0.4c1,1.8,2.2,3.4,3.5,4.7c1.3,1.3,2.9,2.5,4.7,3.5 c0,0,0.2,0.1,0.4,0.2c0.2,0.1,0.4,0.2,0.5,0.3s0.2,0.1,0.4,0.2c0.2,0.1,0.3,0.1,0.5,0.1c0.2,0,0.6-0.2,0.9-0.6 c0.4-0.4,0.7-0.8,1.1-1.2c0.3-0.4,0.7-0.9,1.1-1.2c0.4-0.4,0.7-0.6,1-0.6c0.2,0,0.4,0,0.6,0.1s0.4,0.2,0.7,0.4s0.4,0.3,0.5,0.4 c0.3,0.2,0.7,0.4,1.1,0.6c0.4,0.2,0.8,0.4,1.3,0.7c0.5,0.3,0.8,0.5,1.1,0.6c0.9,0.5,1.4,0.8,1.5,1.1C35.3,29.1,35.3,29.2,35.3,29.4z '/%3E %3C/svg%3E\""

/***/ }),

/***/ 2127:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Thomas Wadewitz <t.wadewitz@metaways.de>
 * @baseVersion Cornelius Weiss <c.weiss@metaways.de>
 * @copyright   Copyright (c) 2007-2008 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 */
Ext.namespace('Tine.Voipmanager', 'Tine.Voipmanager.widgets');
Tine.Voipmanager.widgets.ContextCombo = Ext.extend(Ext.ux.form.ClearableComboBox, {
  id: 'ContextCombo',
  emptyText: 'context',
  typeAhead: true,
  editable: false,
  mode: 'remote',
  triggerAction: 'all',
  displayField: 'name',
  valueField: 'id',
  width: 100,

  /**
   * @private
   */
  initComponent: function initComponent() {
    this.store = new Ext.data.JsonStore({
      id: 'id',
      root: 'results',
      totalProperty: 'totalCount',
      fields: ['id', 'name', 'description'],
      baseParams: {
        method: 'Voipmanager.getAsteriskContexts',
        sort: '',
        dir: 'ASC',
        query: ''
      }
    });
    Tine.Voipmanager.widgets.ContextCombo.superclass.initComponent.call(this);
    this.on('select', function () {
      var v = this.getValue();

      if (String(v) !== String(this.startValue)) {
        this.fireEvent('change', this, v, this.startValue);
      }
    }, this);
  }
});

/***/ }),

/***/ 2128:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Thomas Wadewitz <t.wadewitz@metaways.de>
 * @copyright   Copyright (c) 2007-2008 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 * @todo        check this for deprecated code
 * @todo        use snom phone grid as initial grid
 */
Ext.namespace('Tine.Voipmanager');
Tine.Voipmanager.PhoneTreePanel = Ext.extend(Ext.tree.TreePanel, {
  rootVisible: false,
  border: false,
  initComponent: function initComponent() {
    this.root = {
      id: 'root',
      children: [{
        text: this.app.i18n._('Asterisk'),
        cls: 'treemain',
        allowDrag: false,
        allowDrop: true,
        id: 'Asterisk',
        icon: false,
        children: [{
          text: this.app.i18n._('SipPeer'),
          cls: "treemain",
          allowDrag: false,
          allowDrop: true,
          id: "SipPeer",
          icon: false,
          children: [],
          leaf: true,
          expanded: true
        }, {
          text: this.app.i18n._('Dialplan'),
          cls: "treemain",
          allowDrag: false,
          allowDrop: true,
          id: "Dialplan",
          icon: false,
          children: [],
          leaf: true,
          disabled: true,
          expanded: true
        }, {
          text: this.app.i18n._('Context'),
          cls: "treemain",
          allowDrag: false,
          allowDrop: true,
          id: "Context",
          icon: false,
          children: [],
          leaf: true,
          expanded: true
        }, {
          text: this.app.i18n._('Voicemail'),
          cls: "treemain",
          allowDrag: false,
          allowDrop: true,
          id: "Voicemail",
          icon: false,
          children: [],
          leaf: true,
          expanded: true
        }, {
          text: this.app.i18n._('Meetme'),
          cls: "treemain",
          allowDrag: false,
          allowDrop: true,
          id: "Meetme",
          icon: false,
          children: [],
          leaf: true,
          expanded: true
        }, {
          text: this.app.i18n._('Queues'),
          cls: "treemain",
          allowDrag: false,
          allowDrop: true,
          id: "Queues",
          icon: false,
          disabled: true,
          children: [],
          leaf: true,
          expanded: true
        }],
        leaf: null,
        expanded: true,
        dataPanelType: 'asterisk',
        viewRight: 'asterisk'
      }, {
        text: this.app.i18n._('Snom'),
        cls: 'treemain',
        allowDrag: false,
        allowDrop: true,
        id: 'Snom',
        icon: false,
        children: [{
          text: this.app.i18n._('Phones'),
          cls: 'treemain',
          allowDrag: false,
          allowDrop: true,
          id: 'Phone',
          icon: false,
          children: [],
          leaf: true,
          expanded: true
        }, {
          text: this.app.i18n._('Location'),
          cls: "treemain",
          allowDrag: false,
          allowDrop: true,
          id: "Location",
          icon: false,
          children: [],
          leaf: true,
          expanded: true
        }, {
          text: this.app.i18n._('Templates'),
          cls: "treemain",
          allowDrag: false,
          allowDrop: true,
          id: "Template",
          icon: false,
          children: [],
          leaf: null,
          expanded: true
        }, {
          text: this.app.i18n._('Keylayout'),
          cls: "treemain",
          allowDrag: false,
          allowDrop: true,
          id: "Keylayout",
          icon: false,
          children: [],
          leaf: null,
          expanded: true,
          disabled: true
        }, {
          text: this.app.i18n._('Setting'),
          cls: "treemain",
          allowDrag: false,
          allowDrop: true,
          id: "Setting",
          icon: false,
          children: [],
          leaf: null,
          expanded: true
        }, {
          text: this.app.i18n._('Software'),
          cls: "treemain",
          allowDrag: false,
          allowDrop: true,
          id: "Software",
          icon: false,
          children: [],
          leaf: null,
          expanded: true
        }],
        leaf: null,
        expanded: true,
        dataPanelType: 'snom',
        viewRight: 'snom'
      }]
    };
    Tine.Voipmanager.PhoneTreePanel.superclass.initComponent.call(this);
    this.on('click', function (node) {
      if (node.disabled) {
        return false;
      }

      var contentType = node.getPath().split('/')[3];
      var contentGroup = node.getPath().split('/')[2];
      this.app.getMainScreen().activeContentGroup = contentGroup;
      this.app.getMainScreen().setActiveContentType(contentType);
      Tine.Tinebase.MainScreen.activate(this.app);
    }, this);
  },

  /**
   * @private
   */
  afterRender: function afterRender() {
    Tine.Voipmanager.PhoneTreePanel.superclass.afterRender.call(this);
    var type = this.app.getMainScreen().activeContentType;
    this.expandPath('/root/snom');
    this.selectPath('/root/snom/phones');
  },

  /**
   * returns a filter plugin to be used in a grid
   * 
   * @deprecated
   * @todo remove that
   */
  getFilterPlugin: function getFilterPlugin() {
    if (!this.filterPlugin) {
      var scope = this;
      this.filterPlugin = new Tine.widgets.grid.FilterPlugin({
        getValue: function getValue() {
          var nodeAttributes = scope.getSelectionModel().getSelectedNode().attributes || {};
          return [{
            field: 'containerType',
            operator: 'equals',
            value: nodeAttributes.containerType ? nodeAttributes.containerType : 'all'
          }, {
            field: 'container',
            operator: 'equals',
            value: nodeAttributes.container ? nodeAttributes.container.id : null
          }, {
            field: 'owner',
            operator: 'equals',
            value: nodeAttributes.owner ? nodeAttributes.owner.accountId : null
          }];
        }
      });
    }

    return this.filterPlugin;
  }
});
/**
 * default Asterisk.Context backend
 */

Tine.Voipmanager.AsteriskContextBackend = new Tine.Tinebase.data.RecordProxy({
  appName: 'Voipmanager',
  modelName: 'AsteriskContext',
  recordClass: Tine.Voipmanager.Model.AsteriskContext
});
/**
 * default Asterisk.SipPeer backend
 */

Tine.Voipmanager.AsteriskSipPeerBackend = new Tine.Tinebase.data.RecordProxy({
  appName: 'Voipmanager',
  modelName: 'AsteriskSipPeer',
  recordClass: Tine.Voipmanager.Model.AsteriskSipPeer
});
/**
 * default Asterisk.Voicemail backend
 */

Tine.Voipmanager.AsteriskVoicemailBackend = new Tine.Tinebase.data.RecordProxy({
  appName: 'Voipmanager',
  modelName: 'AsteriskVoicemail',
  recordClass: Tine.Voipmanager.Model.AsteriskVoicemail
});
/**
 * default Asterisk.Meetme backend
 */

Tine.Voipmanager.AsteriskMeetmeBackend = new Tine.Tinebase.data.RecordProxy({
  appName: 'Voipmanager',
  modelName: 'AsteriskMeetme',
  recordClass: Tine.Voipmanager.Model.AsteriskMeetme
});
/**
 * default Snom.Phone backend
 */

Tine.Voipmanager.SnomPhoneBackend = new Tine.Tinebase.data.RecordProxy({
  appName: 'Voipmanager',
  modelName: 'SnomPhone',
  recordClass: Tine.Voipmanager.Model.SnomPhone
});
/**
 * default Snom.Location backend
 */

Tine.Voipmanager.SnomLocationBackend = new Tine.Tinebase.data.RecordProxy({
  appName: 'Voipmanager',
  modelName: 'SnomLocation',
  recordClass: Tine.Voipmanager.Model.SnomLocation
});
/**
 * default Snom.Template backend
 */

Tine.Voipmanager.SnomTemplateBackend = new Tine.Tinebase.data.RecordProxy({
  appName: 'Voipmanager',
  modelName: 'SnomTemplate',
  recordClass: Tine.Voipmanager.Model.SnomTemplate
});
/**
 * default Snom.Software backend
 */

Tine.Voipmanager.SnomSoftwareBackend = new Tine.Tinebase.data.RecordProxy({
  appName: 'Voipmanager',
  modelName: 'SnomSoftware',
  recordClass: Tine.Voipmanager.Model.SnomSoftware
});
/**
 * default Snom.SoftwareImage backend
 */

Tine.Voipmanager.SnomSoftwareImageBackend = new Tine.Tinebase.data.RecordProxy({
  appName: 'Voipmanager',
  modelName: 'SnomSoftwareImage',
  recordClass: Tine.Voipmanager.Model.SnomSoftwareImage
});
/**
 * default Snom.Line backend
 */

Tine.Voipmanager.SnomLineBackend = new Tine.Tinebase.data.RecordProxy({
  appName: 'Voipmanager',
  modelName: 'SnomLine',
  recordClass: Tine.Voipmanager.Model.SnomLine
});
/**
 * default Snom.Setting backend
 */

Tine.Voipmanager.SnomSettingBackend = new Tine.Tinebase.data.RecordProxy({
  appName: 'Voipmanager',
  modelName: 'SnomSetting',
  recordClass: Tine.Voipmanager.Model.SnomSetting
});
/*
 * default Snom.Owner backend
 * @depricated
Tine.Voipmanager.SnomOwnerBackend = new Tine.Tinebase.data.RecordProxy({
    appName: 'Voipmanager',
    modelName: 'SnomOwner',
    recordClass: Tine.Voipmanager.Model.SnomOwner
});
*/

Tine.Voipmanager.Data = {
  loadPhoneModelData: function loadPhoneModelData(_model) {
    var phoneModelDataStore = new Ext.data.SimpleStore({
      autoLoad: true,
      id: 'model',
      fields: ['id', 'model', 'lines'],
      data: [['snom300', 'Snom 300', '4'], ['snom320', 'Snom 320', '12'], ['snom360', 'Snom 360', '12'], ['snom370', 'Snom 370', '12']]
    });

    if (_model) {
      var _idx = phoneModelDataStore.find('model', _model);

      return phoneModelDataStore.getAt(_idx);
    }

    return phoneModelDataStore;
  },
  loadTimezoneData: function loadTimezoneData() {
    var timezoneDataStore = new Ext.data.SimpleStore({
      autoLoad: true,
      fields: ['key', 'timezone'],
      data: [['USA-10', '-10 Vereinigte Staaten - Hawaii-Aleutian'], ['USA-9', '-9 Vereinigte Staaten - Alaska Time'], ['CAN-8', '-8 Kanada (Vancouver, Whitehorse)'], ['MEX-8', '-8 Mexiko (Tijuana, Mexicali)'], ['USA-8', '-8 Vereinigte Staaten - Pacific Time'], ['CAN-7', '-7 Kanada (Edmonton, Calgary)'], ['MEX-7', '-7 Mexiko (Mazatlan, Chihuahua)'], ['USA-7', '-7 Vereinigte Staaten - Mountain Time'], ['USA2-7', '-7 Vereinigte Staaten - Mountain Time'], ['CAN-6', '-6 Kanada - Manitoba (Winnipeg)'], ['CHL-6', '-6 Chile (Easter Islands)'], ['MEX-6', '-6 Mexiko (Mexiko City, Acapulco)'], ['USA-6', '-6 Vereinigte Staaten - Central Time'], ['BHS-5', '-5 Bahamas (Nassau)'], ['CAN-5', '-5 Kanada (Montreal, Ottawa, Quebec)'], ['CUB-5', '-5 Kuba (Havana)'], ['USA-5', '-5 Vereinigte Staaten - Eastern Time'], ['CAN-4', '-4 Kanada (Halifax, Saint John)'], ['CHL-4', '-4 Chile (Santiago)'], ['PRY-4', '-4 Paraguay (Asunçion)'], ['BMU-4', '-4 Großbritannien (Bermuda)'], ['FLK-4', '-4 Großbritannien (Falkland Inseln)'], ['TTB-4', '-4 Trinidad&amp;Tobago'], ['CAN-3.5', '-3.5 Kanada - Neufundland (St. Johns)'], ['GRL-3', '-3 Dänemark - Grönland (Nuuk)'], ['ARG-3', '-3 Argentinien (Buenos Aires)'], ['BRA2-3', '-3 Brasilien (keine SZ)'], ['BRA1-3', '-3 Brasilien (SZ)'], ['BRA-2', '-2 Brasilien (keine SZ)'], ['PRT-1', '-1 Portugal (Azoren)'], ['FRO-0', '0 Dänemark - Faroer Inseln (Torshaven)'], ['IRL-0', '0 Irland (Dublin)'], ['PRT-0', '0 Portugal (Lissabon, Porto, Funchal)'], ['ESP-0', '0 Spanien - Canary Islands (Las Palmas)'], ['GBR-0', '0 Großbritannien (London)'], ['ALB+1', '+1 Albanien (Tirana)'], ['AUT+1', '+1 Österreich (Wien)'], ['BEL+1', '+1 Belgien (Brüssel)'], ['CAI+1', '+1 Caicos'], ['CHA+1', '+1 Chatam'], ['HRV+1', '+1 Hrvska (Zagreb)'], ['CZE+1', '+1 Czech Republic (Prague)'], ['DNK+1', '+1 Dänemark (Kopenhagen)'], ['FRA+1', '+1 Frankreich (Nizza)'], ['GER+1', '+1 Deutschland (Berlin)'], ['HUN+1', '+1 Ungarn (Budapest)'], ['ITA+1', '+1 Italien (Rom)'], ['LUX+1', '+1 Luxemburg (Luxenburg)'], ['MAK+1', '+1 Mazedonien (Skopje)'], ['NLD+1', '+1 Niederlande (Amsterdam)'], ['NAM+1', '+1 Namibia (Windhoek)'], ['NOR+1', '+1 Norwegen (Oslo)'], ['POL+1', '+1 Polen (Warszawa)'], ['SVK+1', '+1 Slovakei (Breslau)'], ['ESP+1', '+1 Spanien (Madrid)'], ['SWE+1', '+1 Schweden (Stockholm)'], ['CHE+1', '+1 Schweiz (Bern)'], ['GIB+1', '+1 Großbritannien (Gibraltar)'], ['YUG+1', '+1 Serbien Montenegro (Belgrad)'], ['WAT+1', '+1 West Afrika'], ['BLR+2', '+2 Weissrussland (Minsk)'], ['BGR+2', '+2 Bulgarien (Sofia)'], ['CYP+2', '+2 Zypern (Nicosia)'], ['CAT+2', '+2 Zentral Afrika'], ['EGY+2', '+2 Ägypten (Kairo)'], ['EST+2', '+2 Estland (Tallin)'], ['FIN+2', '+2 Finnland (Helsinki)'], ['GAZ+2', '+2 Gazastreifen (Gaza)'], ['GRC+2', '+2 Griechenland (Athen)'], ['ISR+2', '+2 Israel (Tel Aviv)'], ['JOR+2', '+2 Jordanien (Amman)'], ['LVA+2', '+2 Litauen (Riga)'], ['LBN+2', '+2 Libanon (Beirut)'], ['MDA+2', '+2 Moldavien (Kishinev)'], ['RUS+2', '+2 Russland (Kaliningrad)'], ['ROU+2', '+2 Rumänien (Bucharest)'], ['SYR+2', '+2 Syrien (Damascus)'], ['TUR+2', '+2 Tärkei (Ankara)'], ['UKR+2', '+2 Ukraine (Kiev, Odessa)'], ['EAT+3', '+3 Ost Afrika'], ['IRQ+3', '+3 Irak (Baghdad)'], ['RUS+3', '+3 Russland (Moscow)'], ['IRN+3.5', '+3.5 Iran (Teheran)'], ['ARM+4', '+4 Armenien (Yerevan)'], ['AZE+4', '+4 Azerbaijan (Baku)'], ['GEO+4', '+4 Georgien (Tbilisi)'], ['KAZ+4', '+4 Kazastan (Aqtau)'], ['RUS+4', '+4 Russland (Samara)'], ['KAZ+5', '+5 Kazastan (Aqtobe)'], ['KGZ+5', '+5 Kyrgyzien (Bishkek)'], ['PAK+5', '+5 Pakistan (Islamabad)'], ['RUS+5', '+5 Russland (Chelyabinsk)'], ['IND+5.5', '+5.5 Indien (Kalkutta)'], ['KAZ+6', '+6 Kazastan (Astana, Almaty)'], ['RUS+6', '+6 Russland (Novosibirsk, Omsk)'], ['RUS+7', '+7 Russland (Krasnoyarsk)'], ['THA+7', '+7 Thailand (Bangkok)'], ['CHN+7', '+8 China (Peking)'], ['SGP+8', '+8 Singapur (Singapur)'], ['KOR+8', '+8 Korea (Seoul)'], ['AUS+8', '+8 Australien (Perth)'], ['JPN+9', '+9 Japan (Tokyo)'], ['AUS+9.5', '+9.5 Australien (Adelaide)'], ['AUS2+9.5', '+9.5 Australien (Darwin)'], ['AUS+10', '+10 Australien (Sydney, Melbourne, Canberra)'], ['AUS2+10', '+10 Australien (Brisbane)'], ['AUS3+10', '+10 Australien (Hobart)'], ['RUS+10', '+10 Russland (Vladivostok)'], ['AUS+10.5', '+10.5 Australien (Lord Howe Islands)'], ['NZL+12', '+12 Neuseeland (Wellington, Auckland)'], ['RUS+12', '+12 Russland (Anadyr, Kamchatka)'], ['NZL+12.75', '+12.75 Neuseeland (Chatham Islands)'], ['TON+13', '+13 Tonga (Nukualofa)']]
    });
    return timezoneDataStore;
  },
  loadTemplateData: function loadTemplateData() {
    var templateDataStore = new Ext.data.JsonStore({
      baseParams: {
        method: 'Voipmanager.getSnomTemplates',
        sort: 'name',
        dir: 'ASC',
        query: ''
      },
      root: 'results',
      totalProperty: 'totalcount',
      id: 'id',
      fields: [{
        name: 'id'
      }, {
        name: 'name'
      }],
      // turn on remote sorting
      remoteSort: true
    });
    templateDataStore.setDefaultSort('name', 'asc'); //        Ext.StoreMgr.add('templateStore', templateDataStore);

    return templateDataStore;
  },
  loadLocationData: function loadLocationData() {
    var locationDataStore = new Ext.data.JsonStore({
      baseParams: {
        method: 'Voipmanager.getSnomLocations',
        sort: 'name',
        dir: 'ASC',
        query: ''
      },
      root: 'results',
      totalProperty: 'totalcount',
      id: 'id',
      fields: [{
        name: 'id'
      }, {
        name: 'name'
      }],
      // turn on remote sorting
      remoteSort: true
    });
    locationDataStore.setDefaultSort('name', 'asc');
    return locationDataStore;
  },
  loadSoftwareData: function loadSoftwareData() {
    var softwareDataStore = new Ext.data.JsonStore({
      baseParams: {
        method: 'Voipmanager.searchSnomSoftware',
        sort: 'description',
        dir: 'ASC'
      },
      root: 'results',
      totalProperty: 'totalcount',
      id: 'id',
      fields: [{
        name: 'id'
      }, {
        name: 'model'
      }, {
        name: 'description'
      }],
      // turn on remote sorting
      remoteSort: true
    });
    softwareDataStore.setDefaultSort('description', 'asc');
    return softwareDataStore;
  },
  loadKeylayoutData: function loadKeylayoutData() {
    var keylayoutDataStore = new Ext.data.JsonStore({
      baseParams: {
        method: 'Voipmanager.getSnomKeylayouts',
        sort: 'description',
        dir: 'ASC'
      },
      root: 'results',
      totalProperty: 'totalcount',
      id: 'id',
      fields: [{
        name: 'id'
      }, {
        name: 'model'
      }, {
        name: 'description'
      }],
      // turn on remote sorting
      remoteSort: true
    });
    keylayoutDataStore.setDefaultSort('description', 'asc'); //        Ext.StoreMgr.add('swData', keylayoutDataStore);

    return keylayoutDataStore;
  },
  loadSettingsData: function loadSettingsData(_query) {
    var settingsDataStore = new Ext.data.JsonStore({
      baseParams: {
        method: 'Voipmanager.getSnomSettings',
        sort: 'description',
        dir: 'ASC'
      },
      root: 'results',
      totalProperty: 'totalcount',
      id: 'id',
      fields: [{
        name: 'id'
      }, {
        name: 'model'
      }, {
        name: 'description'
      }],
      // turn on remote sorting
      remoteSort: true
    });
    settingsDataStore.setDefaultSort('description', 'asc'); //        Ext.StoreMgr.add('swData', settingsDataStore);

    return settingsDataStore;
  }
};

/***/ }),

/***/ 2129:
/***/ (function(module, exports) {

/**
 * Tine 2.0
 * 
 * @package     Voipmanager
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Thomas Wadewitz <t.wadewitz@metaways.de>
 * @copyright   Copyright (c) 2007-2011 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 */
Ext.namespace('Tine.Voipmanager');
/**
 * Software grid panel
 */

Tine.Voipmanager.SnomSoftwareGridPanel = Ext.extend(Tine.widgets.grid.GridPanel, {
  // model generics
  recordClass: Tine.Voipmanager.Model.SnomSoftware,
  evalGrants: false,
  // grid specific
  defaultSortInfo: {
    field: 'description',
    direction: 'ASC'
  },
  gridConfig: {
    autoExpandColumn: 'description'
  },
  initComponent: function initComponent() {
    this.recordProxy = Tine.Voipmanager.SnomSoftwareBackend;
    this.gridConfig.columns = this.getColumns();
    this.actionToolbarItems = this.getToolbarItems();
    Tine.Voipmanager.SnomSoftwareGridPanel.superclass.initComponent.call(this);
  },

  /**
   * returns cm
   * @private
   * 
   */
  getColumns: function getColumns() {
    return [{
      id: 'id',
      header: this.app.i18n._('id'),
      dataIndex: 'id',
      width: 20,
      sortable: true,
      hidden: true
    }, {
      id: 'name',
      header: this.app.i18n._('name'),
      dataIndex: 'name',
      width: 150,
      sortable: true
    }, {
      id: 'description',
      header: this.app.i18n._('Description'),
      dataIndex: 'description',
      width: 250,
      sortable: true
    }];
  },
  initDetailsPanel: function initDetailsPanel() {
    return false;
  },

  /**
   * return additional tb items
   * 
   * @todo add duplicate button
   * @todo move export buttons to single menu/split button
   */
  getToolbarItems: function getToolbarItems() {
    return [];
  }
});

/***/ }),

/***/ 2130:
/***/ (function(module, exports) {

/**
 * Tine 2.0
 * 
 * @package     Voipmanager
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Thomas Wadewitz <t.wadewitz@metaways.de>
 * @copyright   Copyright (c) 2007-2009 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 */
Ext.namespace('Tine.Voipmanager');
/**
 * Snom Software Edit Dialog
 * @todo in the model the snom models are hard coded, but in the dialog not... check it
 */

Tine.Voipmanager.SnomSoftwareEditDialog = Ext.extend(Tine.widgets.dialog.EditDialog, {
  /**
   * @private
   */
  windowNamePrefix: 'SnomSoftwareEditWindow_',
  appName: 'Voipmanager',
  recordClass: Tine.Voipmanager.Model.SnomSoftware,
  recordProxy: Tine.Voipmanager.SnomSoftwareBackend,
  evalGrants: false,

  /**
   * returns dialog
   * 
   * NOTE: when this method gets called, all initalisation is done.
   */
  getSoftwareVersion: function getSoftwareVersion() {
    var softwareVersion = [];
    var phoneModels = Tine.Voipmanager.Data.loadPhoneModelData();
    phoneModels.each(function (rec) {
      softwareVersion.push(new Ext.form.TextField({
        fieldLabel: rec.data.model,
        name: 'softwareimage_' + rec.data.id,
        id: 'softwareimage_' + rec.data.id,
        anchor: '100%',
        maxLength: 128,
        hideLabel: false
      }));
    });
    return softwareVersion;
  },
  getFormItems: function getFormItems() {
    return {
      layout: 'form',
      border: false,
      items: [{
        xtype: 'textfield',
        name: 'name',
        fieldLabel: this.app.i18n._('name'),
        anchor: '100%'
      }, {
        //labelSeparator: '',
        xtype: 'textarea',
        name: 'description',
        fieldLabel: this.app.i18n._('Description'),
        grow: false,
        preventScrollbars: false,
        anchor: '100%',
        height: 60
      }, {
        layout: 'form',
        border: false,
        anchor: '100%',
        items: this.getSoftwareVersion()
      }]
    };
  }
});
/**
 * Snom Software Edit Popup
 */

Tine.Voipmanager.SnomSoftwareEditDialog.openWindow = function (config) {
  var id = config.record && config.record.id ? config.record.id : 0;
  var window = Tine.WindowFactory.getWindow({
    width: 500,
    height: 300,
    name: Tine.Voipmanager.SnomSoftwareEditDialog.prototype.windowNamePrefix + id,
    contentPanelConstructor: 'Tine.Voipmanager.SnomSoftwareEditDialog',
    contentPanelConstructorConfig: config
  });
  return window;
};

/***/ }),

/***/ 2131:
/***/ (function(module, exports) {

/**
 * Tine 2.0
 * 
 * @package     Voipmanager
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Thomas Wadewitz <t.wadewitz@metaways.de>
 * @copyright   Copyright (c) 2007-2011 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 */
Ext.namespace('Tine.Voipmanager');
/**
 * Context grid panel
 */

Tine.Voipmanager.SnomTemplateGridPanel = Ext.extend(Tine.widgets.grid.GridPanel, {
  // model generics
  recordClass: Tine.Voipmanager.Model.SnomTemplate,
  evalGrants: false,
  // grid specific
  defaultSortInfo: {
    field: 'description',
    direction: 'ASC'
  },
  gridConfig: {
    autoExpandColumn: 'description'
  },
  initComponent: function initComponent() {
    this.recordProxy = Tine.Voipmanager.SnomTemplateBackend;
    this.gridConfig.columns = this.getColumns();
    this.actionToolbarItems = this.getToolbarItems();
    Tine.Voipmanager.SnomTemplateGridPanel.superclass.initComponent.call(this);
  },

  /**
   * returns cm
   * @private
   * 
   */
  getColumns: function getColumns() {
    return [{
      id: 'id',
      header: this.app.i18n._('id'),
      dataIndex: 'id',
      width: 10,
      sortable: true,
      hidden: true
    }, {
      id: 'name',
      header: this.app.i18n._('name'),
      dataIndex: 'name',
      width: 100,
      sortable: true
    }, {
      id: 'description',
      header: this.app.i18n._('Description'),
      dataIndex: 'description',
      width: 350,
      sortable: true
    }, {
      id: 'keylayout_id',
      header: this.app.i18n._('Keylayout Id'),
      dataIndex: 'keylayout_id',
      width: 10,
      sortable: true,
      hidden: true
    }, {
      id: 'setting_id',
      header: this.app.i18n._('Settings Id'),
      dataIndex: 'setting_id',
      width: 10,
      sortable: true,
      hidden: true
    }, {
      id: 'software_id',
      header: this.app.i18n._('Software Id'),
      dataIndex: 'software_id',
      width: 10,
      sortable: true,
      hidden: true
    }];
  },
  initDetailsPanel: function initDetailsPanel() {
    return false;
  },

  /**
   * return additional tb items
   * 
   * @todo add duplicate button
   * @todo move export buttons to single menu/split button
   */
  getToolbarItems: function getToolbarItems() {
    return [];
  }
});

/***/ }),

/***/ 2132:
/***/ (function(module, exports) {

/**
 * Tine 2.0
 * 
 * @package     Voipmanager
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Thomas Wadewitz <t.wadewitz@metaways.de>
 * @copyright   Copyright (c) 2007-2011 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 */
Ext.namespace('Tine.Voipmanager');
/**
 * Snom Template Edit Dialog
 */

Tine.Voipmanager.SnomTemplateEditDialog = Ext.extend(Tine.widgets.dialog.EditDialog, {
  /**
   * @private
   */
  windowNamePrefix: 'SnomTemplateEditWindow_',
  appName: 'Voipmanager',
  recordClass: Tine.Voipmanager.Model.SnomTemplate,
  recordProxy: Tine.Voipmanager.SnomTemplateBackend,
  evalGrants: false,

  /**
   * returns dialog
   * 
   * NOTE: when this method gets called, all initalisation is done.
   */
  getFormItems: function getFormItems() {
    return {
      layout: 'form',
      border: false,
      defaults: {
        anchor: '100%'
      },
      items: [{
        xtype: 'textfield',
        fieldLabel: this.app.i18n._('Name'),
        name: 'name',
        maxLength: 80,
        allowBlank: false
      }, {
        xtype: 'textarea',
        name: 'description',
        fieldLabel: this.app.i18n._('Description'),
        grow: false,
        preventScrollbars: false,
        height: 40
      }, {
        xtype: 'reccombo',
        name: 'software_id',
        fieldLabel: this.app.i18n._('Software Version'),
        displayField: 'name',
        store: new Ext.data.Store({
          fields: Tine.Voipmanager.Model.SnomSoftware,
          proxy: Tine.Voipmanager.SnomSoftwareBackend,
          reader: Tine.Voipmanager.SnomSoftwareBackend.getReader(),
          remoteSort: true,
          sortInfo: {
            field: 'name',
            dir: 'ASC'
          }
        }),
        allowBlank: false
      }, {
        xtype: 'reccombo',
        name: 'setting_id',
        fieldLabel: this.app.i18n._('Settings'),
        displayField: 'name',
        store: new Ext.data.Store({
          fields: Tine.Voipmanager.Model.SnomSetting,
          proxy: Tine.Voipmanager.SnomSettingBackend,
          reader: Tine.Voipmanager.SnomSettingBackend.getReader(),
          remoteSort: true,
          sortInfo: {
            field: 'name',
            dir: 'ASC'
          }
        }),
        allowBlank: false
      }, {
        xtype: 'combo',
        fieldLabel: this.app.i18n._('Keylayout'),
        name: 'keylayout_id',
        mode: 'local',
        disabled: true,
        displayField: 'description',
        valueField: 'id',
        triggerAction: 'all',
        editable: false,
        forceSelection: true,
        store: new Ext.data.JsonStore({
          storeId: 'Voipmanger_EditTemplate_Keylayout',
          id: 'id',
          fields: ['id', 'model', 'description']
        })
      }]
    };
  }
});
/**
 * Snom Template Edit Popup
 */

Tine.Voipmanager.SnomTemplateEditDialog.openWindow = function (config) {
  var id = config.record && config.record.id ? config.record.id : 0;
  var window = Tine.WindowFactory.getWindow({
    width: 500,
    height: 350,
    name: Tine.Voipmanager.SnomTemplateEditDialog.prototype.windowNamePrefix + id,
    contentPanelConstructor: 'Tine.Voipmanager.SnomTemplateEditDialog',
    contentPanelConstructorConfig: config
  });
  return window;
};

/***/ }),

/***/ 2133:
/***/ (function(module, exports) {

/**
 * Tine 2.0
 * 
 * @package     Voipmanager
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Thomas Wadewitz <t.wadewitz@metaways.de>
 * @copyright   Copyright (c) 2007-2011 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 */
Ext.namespace('Tine.Voipmanager');
/**
 * Context grid panel
 */

Tine.Voipmanager.SnomPhoneGridPanel = Ext.extend(Tine.widgets.grid.GridPanel, {
  // model generics
  recordClass: Tine.Voipmanager.Model.SnomPhone,
  evalGrants: false,
  // grid specific
  defaultSortInfo: {
    field: 'description',
    direction: 'ASC'
  },
  gridConfig: {
    autoExpandColumn: 'description'
  },
  initComponent: function initComponent() {
    this.recordProxy = Tine.Voipmanager.SnomPhoneBackend;
    this.gridConfig.columns = this.getColumns();
    this.actionToolbarItems = this.getToolbarItems(); // add context menu actions

    var action_resetHttpClientInfo = new Ext.Action({
      text: this.app.i18n._('reset phones HTTP authentication'),
      handler: this.resetHttpClientInfo,
      iconCls: 'action_resetHttpClientInfo',
      scope: this
    });
    var action_openPhonesWebGui = new Ext.Action({
      text: this.app.i18n._('Open phones web gui'),
      handler: this.openPhonesWebGui,
      iconCls: 'action_openPhonesWebGui',
      scope: this
    });
    this.contextMenuItems = [action_resetHttpClientInfo, action_openPhonesWebGui];
    Tine.Voipmanager.SnomPhoneGridPanel.superclass.initComponent.call(this);
  },

  /**
   * returns cm
   * @private
   * 
   */
  getColumns: function getColumns() {
    return [{
      id: 'id',
      header: this.app.i18n._('Id'),
      dataIndex: 'id',
      width: 30,
      sortable: true,
      hidden: true
    }, {
      id: 'macaddress',
      header: this.app.i18n._('MAC address'),
      dataIndex: 'macaddress',
      width: 50,
      sortable: true
    }, {
      id: 'description',
      header: this.app.i18n._('description'),
      dataIndex: 'description',
      sortable: true
    }, {
      id: 'location_id',
      header: this.app.i18n._('Location'),
      dataIndex: 'location_id',
      width: 70,
      sortable: true,
      renderer: function renderer(_data, _obj, _rec) {
        return _rec.data.location;
      }
    }, {
      id: 'template_id',
      header: this.app.i18n._('Template'),
      dataIndex: 'template_id',
      width: 70,
      sortable: true,
      renderer: function renderer(_data, _obj, _rec) {
        return _rec.data.template;
      }
    }, {
      id: 'ipaddress',
      header: this.app.i18n._('IP Address'),
      dataIndex: 'ipaddress',
      width: 50,
      sortable: true
    }, {
      id: 'current_software',
      header: this.app.i18n._('Software'),
      dataIndex: 'current_software',
      width: 50,
      sortable: true
    }, {
      id: 'current_model',
      header: this.app.i18n._('current model'),
      dataIndex: 'current_model',
      width: 70,
      sortable: true,
      hidden: true
    }, {
      id: 'redirect_event',
      header: this.app.i18n._('redirect event'),
      dataIndex: 'redirect_event',
      width: 70,
      sortable: true,
      hidden: true
    }, {
      id: 'redirect_number',
      header: this.app.i18n._('redirect number'),
      dataIndex: 'redirect_number',
      width: 100,
      sortable: true,
      hidden: true
    }, {
      id: 'redirect_time',
      header: this.app.i18n._('redirect time'),
      dataIndex: 'redirect_time',
      width: 25,
      sortable: true,
      hidden: true
    }, {
      id: 'settings_loaded_at',
      header: this.app.i18n._('settings loaded at'),
      dataIndex: 'settings_loaded_at',
      width: 100,
      sortable: true,
      hidden: true,
      renderer: Tine.Tinebase.common.dateTimeRenderer
    }, {
      id: 'last_modified_time',
      header: this.app.i18n._('last modified'),
      dataIndex: 'last_modified_time',
      width: 100,
      sortable: true,
      hidden: true,
      renderer: Tine.Tinebase.common.dateTimeRenderer
    }];
  },
  initDetailsPanel: function initDetailsPanel() {
    return false;
  },

  /**
   * return additional tb items
   * 
   * @todo add duplicate button
   * @todo move export buttons to single menu/split button
   */
  getToolbarItems: function getToolbarItems() {
    return [];
  },

  /**
   * onclick handler for resetHttpClientInfo
   */
  resetHttpClientInfo: function resetHttpClientInfo(_button, _event) {
    Ext.MessageBox.confirm('Confirm', 'Do you really want to send HTTP Client Info again?', function (_button) {
      if (_button == 'yes') {
        var phoneIds = [];
        var selectedRows = this.selectionModel.getSelections();

        for (var i = 0; i < selectedRows.length; ++i) {
          phoneIds.push(selectedRows[i].id);
        }

        Ext.Ajax.request({
          url: 'index.php',
          params: {
            method: 'Voipmanager.resetHttpClientInfo',
            phoneIds: phoneIds
          },
          text: 'sending HTTP Client Info to phone(s)...',
          success: function success(_result, _request) {// not really needed to reload store
            //Ext.getCmp('Voipmanager_Phones_Grid').getStore().reload();
          },
          failure: function failure(result, request) {
            Ext.MessageBox.alert('Failed', 'Some error occured while trying to send HTTP Client Info to the phone(s).');
          }
        });
      }
    }, this);
  },

  /**
   * onclick handler for openPhonesWebGui
   */
  openPhonesWebGui: function openPhonesWebGui(_button, _event) {
    var phoneIp;
    var selectedRows = this.selectionModel.getSelections();

    for (var i = 0; i < selectedRows.length; ++i) {
      phoneIp = selectedRows[i].get('ipaddress');

      if (phoneIp && phoneIp.length >= 7) {
        window.open('http://' + phoneIp, '_blank', 'width=1024,height=768,scrollbars=1');
      }
    }
  }
});

/***/ }),

/***/ 2134:
/***/ (function(module, exports) {

/**
 * Tine 2.0
 * 
 * @package     Voipmanager
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Thomas Wadewitz <t.wadewitz@metaways.de>
 * @copyright   Copyright (c) 2007-2011 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 */
Ext.namespace('Tine.Voipmanager');
/**
 * Context grid panel
 */

Tine.Voipmanager.SnomLocationGridPanel = Ext.extend(Tine.widgets.grid.GridPanel, {
  // model generics
  recordClass: Tine.Voipmanager.Model.SnomLocation,
  evalGrants: false,
  // grid specific
  defaultSortInfo: {
    field: 'description',
    direction: 'ASC'
  },
  gridConfig: {
    autoExpandColumn: 'description'
  },
  initComponent: function initComponent() {
    this.recordProxy = Tine.Voipmanager.SnomLocationBackend;
    this.gridConfig.columns = this.getColumns();
    this.actionToolbarItems = this.getToolbarItems();
    Tine.Voipmanager.SnomLocationGridPanel.superclass.initComponent.call(this);
  },

  /**
   * initialises filter toolbar
   */
  initFilterToolbar: function initFilterToolbar() {
    this.filterToolbar = new Tine.widgets.grid.FilterToolbar({
      filterModels: [{
        label: i18n._('Quick Search'),
        field: 'query',
        operators: ['contains']
      }],
      defaultFilter: 'query',
      filters: [],
      plugins: [new Tine.widgets.grid.FilterToolbarQuickFilterPlugin()]
    });
  },

  /**
   * returns cm
   * @private
   * 
   */
  getColumns: function getColumns() {
    return [{
      id: 'firmware_interval',
      header: this.app.i18n._('FW Interval'),
      dataIndex: 'firmware_interval',
      width: 10,
      sortable: true,
      hidden: true
    }, {
      id: 'update_policy',
      header: this.app.i18n._('Update Policy'),
      dataIndex: 'update_policy',
      width: 30,
      sortable: true,
      hidden: true
    }, {
      id: 'registrar',
      header: this.app.i18n._('Registrar'),
      dataIndex: 'registrar',
      width: 100,
      sortable: true,
      hidden: true
    }, {
      id: 'admin_mode',
      header: this.app.i18n._('Admin Mode'),
      dataIndex: 'admin_mode',
      width: 10,
      sortable: true,
      hidden: true
    }, {
      id: 'ntp_server',
      header: this.app.i18n._('NTP Server'),
      dataIndex: 'ntp_server',
      width: 50,
      sortable: true,
      hidden: true
    }, {
      id: 'webserver_type',
      header: this.app.i18n._('Webserver Type'),
      dataIndex: 'webserver_type',
      width: 30,
      sortable: true,
      hidden: true
    }, {
      id: 'https_port',
      header: this.app.i18n._('HTTPS Port'),
      dataIndex: 'https_port',
      width: 10,
      sortable: true,
      hidden: true
    }, {
      id: 'http_user',
      header: this.app.i18n._('HTTP User'),
      dataIndex: 'http_user',
      width: 15,
      sortable: true,
      hidden: true
    }, {
      id: 'id',
      header: this.app.i18n._('id'),
      dataIndex: 'id',
      width: 10,
      sortable: true,
      hidden: true
    }, {
      id: 'name',
      header: this.app.i18n._('Name'),
      dataIndex: 'name',
      width: 80,
      sortable: true
    }, {
      id: 'description',
      header: this.app.i18n._('Description'),
      dataIndex: 'description',
      width: 350,
      sortable: true
    }];
  },
  initDetailsPanel: function initDetailsPanel() {
    return false;
  },

  /**
   * return additional tb items
   * 
   * @todo add duplicate button
   * @todo move export buttons to single menu/split button
   */
  getToolbarItems: function getToolbarItems() {
    return [];
  }
});

/***/ }),

/***/ 2135:
/***/ (function(module, exports) {

/**
 * Tine 2.0
 * 
 * @package     Voipmanager
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Thomas Wadewitz <t.wadewitz@metaways.de>
 * @copyright   Copyright (c) 2007-2009 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 */
Ext.namespace('Tine.Voipmanager');
/**
 * Snom Location Edit Dialog
 */

Tine.Voipmanager.SnomLocationEditDialog = Ext.extend(Tine.widgets.dialog.EditDialog, {
  /**
   * @private
   */
  windowNamePrefix: 'SnomLocationEditWindow_',
  appName: 'Voipmanager',
  recordClass: Tine.Voipmanager.Model.SnomLocation,
  recordProxy: Tine.Voipmanager.SnomLocationBackend,
  evalGrants: false,

  /**
   * returns dialog
   * 
   * NOTE: when this method gets called, all initalisation is done.
   */
  getFormItems: function getFormItems() {
    return {
      layout: 'form',
      border: false,
      defaults: {
        anchor: '100%'
      },
      items: [{
        xtype: 'textfield',
        fieldLabel: this.app.i18n._('Name'),
        name: 'name',
        maxLength: 80,
        allowBlank: false
      }, {
        xtype: 'textarea',
        name: 'description',
        fieldLabel: this.app.i18n._('Description'),
        grow: false,
        preventScrollbars: false,
        height: 30
      }, {
        xtype: 'textfield',
        fieldLabel: this.app.i18n._('Registrar'),
        name: 'registrar',
        maxLength: 255,
        allowBlank: false
      }, {
        xtype: 'textfield',
        vtype: 'url',
        fieldLabel: this.app.i18n._('Base Download URL'),
        name: 'base_download_url',
        maxLength: 255,
        allowBlank: false
      }, {
        layout: 'column',
        border: false,
        anchor: '100%',
        items: [{
          columnWidth: 0.5,
          layout: 'form',
          border: false,
          anchor: '100%',
          items: [{
            xtype: 'combo',
            fieldLabel: this.app.i18n._('Update Policy'),
            name: 'update_policy',
            mode: 'local',
            displayField: 'policy',
            valueField: 'key',
            anchor: '98%',
            triggerAction: 'all',
            allowBlank: false,
            editable: false,
            store: new Ext.data.SimpleStore({
              fields: ['key', 'policy'],
              data: [['auto_update', 'auto update'], ['ask_for_update', 'ask for update'], ['never_update_firm', 'never update firm'], ['never_update_boot', 'never update boot'], ['settings_only', 'settings only'], ['never_update', 'never update']]
            })
          }]
        }, {
          columnWidth: 0.5,
          layout: 'form',
          border: false,
          anchor: '100%',
          items: [{
            xtype: 'numberfield',
            fieldLabel: this.app.i18n._('Firmware Interval'),
            name: 'firmware_interval',
            maxLength: 11,
            anchor: '100%',
            allowBlank: false
          }]
        }]
      }, {
        layout: 'column',
        border: false,
        anchor: '100%',
        items: [{
          columnWidth: 0.33,
          layout: 'form',
          border: false,
          anchor: '100%',
          items: [{
            xtype: 'combo',
            fieldLabel: this.app.i18n._('tone_scheme'),
            name: 'tone_scheme',
            id: 'tone_scheme',
            mode: 'local',
            anchor: '98%',
            triggerAction: 'all',
            editable: false,
            forceSelection: true,
            value: 'GER',
            store: [['AUS', Locale.getTranslationData('CountryList', 'AU')], ['AUT', Locale.getTranslationData('CountryList', 'AT')], ['CHN', Locale.getTranslationData('CountryList', 'CN')], ['DNK', Locale.getTranslationData('CountryList', 'DK')], ['FRA', Locale.getTranslationData('CountryList', 'FR')], ['GER', Locale.getTranslationData('CountryList', 'DE')], ['GBR', Locale.getTranslationData('CountryList', 'GB')], ['IND', Locale.getTranslationData('CountryList', 'IN')], ['ITA', Locale.getTranslationData('CountryList', 'IT')], ['JPN', Locale.getTranslationData('CountryList', 'JP')], ['MEX', Locale.getTranslationData('CountryList', 'MX')], ['NLD', Locale.getTranslationData('CountryList', 'NL')], ['NOR', Locale.getTranslationData('CountryList', 'NO')], ['NZL', Locale.getTranslationData('CountryList', 'NZ')], ['ESP', Locale.getTranslationData('CountryList', 'ES')], ['SWE', Locale.getTranslationData('CountryList', 'SE')], ['SWI', Locale.getTranslationData('CountryList', 'CH')], ['USA', Locale.getTranslationData('CountryList', 'US')]]
          }]
        }, {
          columnWidth: 0.33,
          layout: 'form',
          border: false,
          anchor: '100%',
          items: [{
            xtype: 'combo',
            fieldLabel: this.app.i18n._('date_us_format'),
            name: 'date_us_format',
            id: 'date_us_format',
            mode: 'local',
            anchor: '98%',
            triggerAction: 'all',
            editable: false,
            forceSelection: true,
            value: '1',
            store: [['1', this.app.i18n._('on')], ['0', this.app.i18n._('off')]]
          }]
        }, {
          columnWidth: 0.33,
          layout: 'form',
          border: false,
          anchor: '100%',
          items: [{
            xtype: 'combo',
            fieldLabel: this.app.i18n._('time_24_format'),
            name: 'time_24_format',
            id: 'time_24_format',
            mode: 'local',
            anchor: '100%',
            triggerAction: 'all',
            editable: false,
            forceSelection: true,
            value: '1',
            store: [['1', this.app.i18n._('on')], ['0', this.app.i18n._('off')]]
          }]
        }]
      }, {
        xtype: 'fieldset',
        checkboxToggle: false,
        checkboxName: 'ntpSetting',
        id: 'ntp_setting',
        title: this.app.i18n._('NTP Server'),
        autoHeight: true,
        anchor: '100%',
        defaults: {
          anchor: '100%'
        },
        items: [{
          layout: 'column',
          border: false,
          anchor: '100%',
          items: [{
            columnWidth: 0.7,
            layout: 'form',
            border: false,
            anchor: '100%',
            items: [{
              xtype: 'textfield',
              fieldLabel: this.app.i18n._('NTP Server Address'),
              name: 'ntp_server',
              maxLength: 255,
              anchor: '98%',
              allowBlank: false
            }]
          }, {
            columnWidth: 0.3,
            layout: 'form',
            border: false,
            anchor: '100%',
            items: [{
              xtype: 'numberfield',
              fieldLabel: this.app.i18n._('NTP Refresh'),
              name: 'ntp_refresh',
              maxLength: 20,
              anchor: '100%'
            }]
          }]
        }, new Ext.form.ComboBox({
          fieldLabel: this.app.i18n._('Timezone'),
          id: 'timezone',
          name: 'timezone',
          mode: 'local',
          displayField: 'timezone',
          valueField: 'key',
          anchor: '98%',
          triggerAction: 'all',
          allowBlank: false,
          editable: false,
          store: Tine.Voipmanager.Data.loadTimezoneData()
        })]
      }, {
        xtype: 'fieldset',
        checkboxToggle: true,
        checkboxName: 'admin_mode',
        id: 'admin_mode_switch',
        listeners: {
          expand: function expand() {
            Ext.getCmp('admin_mode').setValue('true');
          },
          collapse: function collapse() {
            Ext.getCmp('admin_mode').setValue('false');
          }
        },
        title: this.app.i18n._('Enable admin mode'),
        autoHeight: true,
        anchor: '100%',
        defaults: {
          anchor: '100%'
        },
        items: [{
          xtype: 'hidden',
          name: 'admin_mode',
          id: 'admin_mode'
        }, {
          xtype: 'numberfield',
          fieldLabel: this.app.i18n._('Admin Mode Password'),
          name: 'admin_mode_password',

          /*inputType: 'password',*/
          maxLength: 20,
          anchor: '100%'
        }]
      }, {
        xtype: 'fieldset',
        checkboxToggle: true,
        checkboxName: 'enableWebserver',
        title: this.app.i18n._('Enable webserver'),
        autoHeight: true,
        id: 'enable_webserver_switch',
        listeners: {
          collapse: function collapse() {
            Ext.getCmp('webserver_type').setValue('off');
          },
          expand: function expand() {
            if (Ext.getCmp('webserver_type').getValue() == 'off') {
              Ext.getCmp('webserver_type').setValue('http_https');
            }
          }
        },
        defaults: {
          anchor: '100%'
        },
        items: [{
          layout: 'column',
          border: false,
          anchor: '100%',
          items: [{
            columnWidth: 0.5,
            layout: 'form',
            border: false,
            anchor: '100%',
            items: [{
              xtype: 'combo',
              fieldLabel: this.app.i18n._('Webserver Type'),
              name: 'webserver_type',
              id: 'webserver_type',
              mode: 'local',
              displayField: 'wwwtype',
              valueField: 'key',
              listeners: {
                select: function select(_field, _newValue, _oldValue) {
                  if (_newValue.data.key == 'https') {
                    Ext.getCmp('http_port').disable();
                    Ext.getCmp('https_port').enable();
                  }

                  if (_newValue.data.key == 'http') {
                    Ext.getCmp('http_port').enable();
                    Ext.getCmp('https_port').disable();
                  }

                  if (_newValue.data.key == 'http_https') {
                    Ext.getCmp('http_port').enable();
                    Ext.getCmp('https_port').enable();
                  }
                }
              },
              anchor: '98%',
              triggerAction: 'all',
              allowBlank: false,
              editable: false,
              store: new Ext.data.SimpleStore({
                fields: ['key', 'wwwtype'],
                data: [['https', 'https'], ['http', 'http'], ['http_https', 'http https']]
              })
            }]
          }, {
            columnWidth: 0.5,
            layout: 'form',
            border: false,
            anchor: '100%',
            items: [{
              layout: 'column',
              border: false,
              anchor: '100%',
              items: [{
                columnWidth: 0.5,
                layout: 'form',
                border: false,
                anchor: '100%',
                items: [{
                  xtype: 'textfield',
                  fieldLabel: this.app.i18n._('HTTP Port'),
                  name: 'http_port',
                  id: 'http_port',
                  maxLength: 6,
                  anchor: '98%',
                  allowBlank: true
                }]
              }, {
                columnWidth: 0.5,
                layout: 'form',
                border: false,
                anchor: '100%',
                items: [{
                  xtype: 'textfield',
                  fieldLabel: this.app.i18n._('HTTPS Port'),
                  name: 'https_port',
                  id: 'https_port',
                  maxLength: 6,
                  anchor: '100%',
                  allowBlank: true
                }]
              }]
            }]
          }]
        }, {
          layout: 'column',
          border: false,
          anchor: '100%',
          items: [{
            columnWidth: 0.5,
            layout: 'form',
            border: false,
            anchor: '100%',
            items: [{
              xtype: 'textfield',
              fieldLabel: this.app.i18n._('HTTP User'),
              name: 'http_user',
              maxLength: 20,
              anchor: '98%'
            }]
          }, {
            columnWidth: 0.5,
            layout: 'form',
            border: false,
            anchor: '100%',
            items: [{
              xtype: 'textfield',
              fieldLabel: this.app.i18n._('HTTP Password'),
              name: 'http_pass',
              inputType: 'textfield',
              maxLength: 20,
              anchor: '100%'
            }]
          }]
        }]
      }]
    };
  }
});
/**
 * Snom Location Edit Popup
 */

Tine.Voipmanager.SnomLocationEditDialog.openWindow = function (config) {
  var id = config.record && config.record.id ? config.record.id : 0;
  var window = Tine.WindowFactory.getWindow({
    width: 800,
    height: 470,
    name: Tine.Voipmanager.SnomLocationEditDialog.prototype.windowNamePrefix + id,
    contentPanelConstructor: 'Tine.Voipmanager.SnomLocationEditDialog',
    contentPanelConstructorConfig: config
  });
  return window;
};

/***/ }),

/***/ 2136:
/***/ (function(module, exports) {

/**
 * Tine 2.0
 * 
 * @package     Voipmanager
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Thomas Wadewitz <t.wadewitz@metaways.de>
 * @copyright   Copyright (c) 2007-2011 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 */
Ext.namespace('Tine.Voipmanager');
/**
 * Context grid panel
 */

Tine.Voipmanager.SnomSettingGridPanel = Ext.extend(Tine.widgets.grid.GridPanel, {
  // model generics
  recordClass: Tine.Voipmanager.Model.SnomSetting,
  evalGrants: false,
  // grid specific
  defaultSortInfo: {
    field: 'description',
    direction: 'ASC'
  },
  gridConfig: {
    autoExpandColumn: 'description'
  },
  initComponent: function initComponent() {
    this.recordProxy = Tine.Voipmanager.SnomSettingBackend;
    this.gridConfig.columns = this.getColumns();
    this.actionToolbarItems = this.getToolbarItems();
    Tine.Voipmanager.SnomSettingGridPanel.superclass.initComponent.call(this);
  },

  /**
   * returns cm
   * @private
   * 
   */
  getColumns: function getColumns() {
    return [{
      id: 'id',
      header: this.app.i18n._('Id'),
      dataIndex: 'id',
      width: 30,
      sortable: true,
      hidden: true
    }, {
      id: 'name',
      header: this.app.i18n._('name'),
      dataIndex: 'name',
      width: 150,
      sortable: true
    }, {
      id: 'description',
      header: this.app.i18n._('description'),
      dataIndex: 'description',
      width: 200,
      sortable: true
    }, {
      id: 'web_language',
      header: this.app.i18n._('web_language'),
      dataIndex: 'web_language',
      width: 10,
      sortable: true,
      hidden: true
    }, {
      id: 'language',
      header: this.app.i18n._('language'),
      dataIndex: 'language',
      width: 10,
      sortable: true,
      hidden: true
    }, {
      id: 'display_method',
      header: this.app.i18n._('display_method'),
      dataIndex: 'display_method',
      width: 10,
      sortable: true,
      hidden: true
    }, {
      id: 'mwi_notification',
      header: this.app.i18n._('mwi_notification'),
      dataIndex: 'mwi_notification',
      width: 10,
      sortable: true,
      hidden: true
    }, {
      id: 'mwi_dialtone',
      header: this.app.i18n._('mwi_dialtone'),
      dataIndex: 'mwi_dialtone',
      width: 10,
      sortable: true,
      hidden: true
    }, {
      id: 'headset_device',
      header: this.app.i18n._('headset_device'),
      dataIndex: 'headset_device',
      width: 10,
      sortable: true,
      hidden: true
    }, {
      id: 'message_led_other',
      header: this.app.i18n._('message_led_other'),
      dataIndex: 'message_led_other',
      width: 10,
      sortable: true,
      hidden: true
    }, {
      id: 'global_missed_counter',
      header: this.app.i18n._('global_missed_counter'),
      dataIndex: 'global_missed_counter',
      width: 10,
      sortable: true,
      hidden: true
    }, {
      id: 'pickup_indication',
      header: this.app.i18n._('Pickup indication'),
      dataIndex: 'pickup_indication',
      width: 10,
      sortable: true,
      hidden: true
    }, {
      id: 'scroll_outgoing',
      header: this.app.i18n._('scroll_outgoing'),
      dataIndex: 'scroll_outgoing',
      width: 10,
      sortable: true,
      hidden: true
    }, {
      id: 'show_local_line',
      header: this.app.i18n._('show_local_line'),
      dataIndex: 'show_local_line',
      width: 10,
      sortable: true,
      hidden: true
    }, {
      id: 'show_call_status',
      header: this.app.i18n._('show_call_status'),
      dataIndex: 'show_call_status',
      width: 10,
      sortable: true,
      hidden: true
    }, {
      id: 'call_waiting',
      header: this.app.i18n._('call_waiting'),
      dataIndex: 'call_waiting',
      width: 25,
      sortable: true,
      hidden: true
    }];
  },
  initDetailsPanel: function initDetailsPanel() {
    return false;
  },

  /**
   * return additional tb items
   * 
   * @todo add duplicate button
   * @todo move export buttons to single menu/split button
   */
  getToolbarItems: function getToolbarItems() {
    return [];
  }
});

/***/ }),

/***/ 2137:
/***/ (function(module, exports) {

/**
 * Tine 2.0
 * 
 * @package     Voipmanager
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Thomas Wadewitz <t.wadewitz@metaways.de>
 * @copyright   Copyright (c) 2007-2011 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 */
Ext.namespace('Tine.Voipmanager');
/**
 * Snom Setting Edit Dialog
 */

Tine.Voipmanager.SnomSettingEditDialog = Ext.extend(Tine.widgets.dialog.EditDialog, {
  /**
   * @private
   */
  windowNamePrefix: 'SnomSettingEditWindow_',
  appName: 'Voipmanager',
  recordClass: Tine.Voipmanager.Model.SnomSetting,
  recordProxy: Tine.Voipmanager.SnomSettingBackend,
  evalGrants: false,

  /**
   * 
   * @type array 
   */
  writableFields: ["web_language_w", "language_w", "display_method_w", "call_waiting_w", "mwi_notification_w", "mwi_dialtone_w", "headset_device_w", "message_led_other_w", "global_missed_counter_w", 'pickup_indication_w', "scroll_outgoing_w", "show_local_line_w", "show_call_status_w"],

  /**
   * record load
   */
  onRecordLoad: function onRecordLoad() {
    // set lock combos
    Ext.each(this.writableFields, function (_item, _index, _array) {
      var field = _item;
      field = field.replace(/_w$/, '');

      if (this.record.get(_item) == '0') {
        this.getForm().findField(field).onTrigger2Click();
      }
    }, this);
    Tine.Voipmanager.SnomPhoneEditDialog.superclass.onRecordLoad.call(this);
  },

  /**
   * record update
   */
  onRecordUpdate: function onRecordUpdate() {
    Tine.Voipmanager.SnomPhoneEditDialog.superclass.onRecordUpdate.call(this);
    Ext.each(this.writableFields, function (_item, _index, _array) {
      if (Ext.getCmp(_item)) {
        var value = Ext.getCmp(_item).getValue();
      }

      this.record.set(_item, value);
    }, this);
  },

  /**
   * returns dialog
   * 
   * NOTE: when this method gets called, all initalisation is done.
   */
  getFormItems: function getFormItems() {
    return {
      xtype: 'tabpanel',
      border: false,
      plain: true,
      activeTab: 0,
      items: [{
        title: this.app.i18n._('Settings'),
        frame: true,
        border: false,
        xtype: 'columnform',
        formDefaults: {
          columnWidth: 0.333,
          labelSeparator: '',
          xtype: 'lockCombo',
          mode: 'local',
          displayField: 'name',
          valueField: 'id',
          anchor: '100%',
          triggerAction: 'all',
          editable: false,
          forceSelection: true
        },
        items: [[{
          columnWidth: 0.35,
          xtype: 'textfield',
          fieldLabel: this.app.i18n._('name'),
          name: 'name',
          maxLength: 150,
          allowBlank: false,
          editable: true
        }, {
          columnWidth: 0.65,
          xtype: 'textfield',
          name: 'description',
          fieldLabel: this.app.i18n._('Description'),
          maxLength: 255,
          editable: true
        }], [{
          fieldLabel: this.app.i18n._('web_language'),
          name: 'web_language',
          hiddenFieldId: 'web_language_w',
          store: new Ext.data.SimpleStore({
            id: 'id',
            fields: ['id', 'name'],
            data: [[null, this.app.i18n._('- factory default -')], ['English', Locale.getTranslationData('Language', 'en')], ['Deutsch', Locale.getTranslationData('Language', 'de')], ['Espanol', Locale.getTranslationData('Language', 'es')], ['Francais', Locale.getTranslationData('Language', 'fr')], ['Italiano', Locale.getTranslationData('Language', 'it')], ['Nederlands', Locale.getTranslationData('Language', 'nl')], ['Portugues', Locale.getTranslationData('Language', 'pt')], ['Suomi', Locale.getTranslationData('Language', 'fi')], ['Svenska', Locale.getTranslationData('Language', 'sv')], ['Dansk', Locale.getTranslationData('Language', 'da')], ['Norsk', Locale.getTranslationData('Language', 'no')]]
          })
        }, {
          fieldLabel: this.app.i18n._('language'),
          name: 'language',
          hiddenFieldId: 'language_w',
          store: new Ext.data.SimpleStore({
            id: 'id',
            fields: ['id', 'name'],
            data: [[null, this.app.i18n._('- factory default -')], ['English', Locale.getTranslationData('Language', 'en')], ['English(UK)', Locale.getTranslationData('Language', 'en_GB')], ['Deutsch', Locale.getTranslationData('Language', 'de')], ['Espanol', Locale.getTranslationData('Language', 'es')], ['Francais', Locale.getTranslationData('Language', 'fr')], ['Italiano', Locale.getTranslationData('Language', 'it')], ['Cestina', Locale.getTranslationData('Language', 'cs')], ['Nederlands', Locale.getTranslationData('Language', 'nl')], ['Polski', Locale.getTranslationData('Language', 'pl')], ['Portugues', Locale.getTranslationData('Language', 'pt')], ['Slovencina', Locale.getTranslationData('Language', 'sl')], ['Suomi', Locale.getTranslationData('Language', 'fi')], ['Svenska', Locale.getTranslationData('Language', 'sv')], ['Dansk', Locale.getTranslationData('Language', 'da')], ['Norsk', Locale.getTranslationData('Language', 'no')], ['Japanese', Locale.getTranslationData('Language', 'ja')], ['Chinese', Locale.getTranslationData('Language', 'zh')]]
          })
        }, {
          fieldLabel: this.app.i18n._('display_method'),
          name: 'display_method',
          hiddenFieldId: 'display_method_w',
          store: new Ext.data.SimpleStore({
            id: 'id',
            fields: ['id', 'name'],
            data: [[null, this.app.i18n._('- factory default -')], ['full_contact', this.app.i18n._('whole url')], ['display_name', this.app.i18n._('name')], ['display_number', this.app.i18n._('number')], ['display_name_number', this.app.i18n._('name + number')], ['display_number_name', this.app.i18n._('number + name')]]
          })
        }], [{
          fieldLabel: this.app.i18n._('call_waiting'),
          name: 'call_waiting',
          hiddenFieldId: 'call_waiting_w',
          store: new Ext.data.SimpleStore({
            id: 'id',
            fields: ['id', 'name'],
            data: [[null, this.app.i18n._('- factory default -')], ['on', this.app.i18n._('on')], ['visual', this.app.i18n._('visual')], ['ringer', this.app.i18n._('ringer')], ['off', this.app.i18n._('off')]]
          })
        }, {
          fieldLabel: this.app.i18n._('mwi_notification'),
          name: 'mwi_notification',
          hiddenFieldId: 'mwi_notification_w',
          store: new Ext.data.SimpleStore({
            id: 'id',
            fields: ['id', 'name'],
            data: [[null, this.app.i18n._('- factory default -')], ['silent', this.app.i18n._('silent')], ['beep', this.app.i18n._('beep')], ['reminder', this.app.i18n._('reminder')]]
          })
        }, {
          fieldLabel: this.app.i18n._('mwi_dialtone'),
          name: 'mwi_dialtone',
          hiddenFieldId: 'mwi_dialtone_w',
          store: new Ext.data.SimpleStore({
            id: 'id',
            fields: ['id', 'name'],
            data: [[null, this.app.i18n._('- factory default -')], ['normal', this.app.i18n._('normal')], ['stutter', this.app.i18n._('stutter')]]
          })
        }], [{
          fieldLabel: this.app.i18n._('headset_device'),
          name: 'headset_device',
          hiddenFieldId: 'headset_device_w',
          store: new Ext.data.SimpleStore({
            id: 'id',
            fields: ['id', 'name'],
            data: [[null, this.app.i18n._('- factory default -')], ['none', this.app.i18n._('none')], ['headset_rj', this.app.i18n._('headset_rj')]]
          })
        }, {
          fieldLabel: this.app.i18n._('message_led_other'),
          name: 'message_led_other',
          hiddenFieldId: 'message_led_other_w',
          store: new Ext.data.SimpleStore({
            id: 'id',
            fields: ['id', 'name'],
            data: [[null, this.app.i18n._('- factory default -')], ['1', this.app.i18n._('on')], ['0', this.app.i18n._('off')]]
          })
        }, {
          fieldLabel: this.app.i18n._('global_missed_counter'),
          name: 'global_missed_counter',
          hiddenFieldId: 'global_missed_counter_w',
          store: new Ext.data.SimpleStore({
            id: 'id',
            fields: ['id', 'name'],
            data: [[null, this.app.i18n._('- factory default -')], ['1', this.app.i18n._('on')], ['0', this.app.i18n._('off')]]
          })
        }], [{
          fieldLabel: this.app.i18n._('scroll_outgoing'),
          name: 'scroll_outgoing',
          hiddenFieldId: 'scroll_outgoing_w',
          store: new Ext.data.SimpleStore({
            id: 'id',
            fields: ['id', 'name'],
            data: [[null, this.app.i18n._('- factory default -')], ['1', this.app.i18n._('on')], ['0', this.app.i18n._('off')]]
          })
        }, {
          fieldLabel: this.app.i18n._('show_local_line'),
          name: 'show_local_line',
          hiddenFieldId: 'show_local_line_w',
          store: new Ext.data.SimpleStore({
            id: 'id',
            fields: ['id', 'name'],
            data: [[null, this.app.i18n._('- factory default -')], ['1', this.app.i18n._('on')], ['0', this.app.i18n._('off')]]
          })
        }, {
          fieldLabel: this.app.i18n._('show_call_status'),
          name: 'show_call_status',
          hiddenFieldId: 'show_call_status_w',
          store: new Ext.data.SimpleStore({
            id: 'id',
            fields: ['id', 'name'],
            data: [[null, this.app.i18n._('- factory default -')], ['1', this.app.i18n._('on')], ['0', this.app.i18n._('off')]]
          })
        }], [{
          fieldLabel: this.app.i18n._('Pickup indication'),
          name: 'pickup_indication',
          hiddenFieldId: 'pickup_indication_w',
          store: new Ext.data.SimpleStore({
            id: 'id',
            fields: ['id', 'name'],
            data: [[null, this.app.i18n._('- factory default -')], ['1', this.app.i18n._('on')], ['0', this.app.i18n._('off')]]
          })
        }]]
      }]
    };
  }
});
/**
 * Snom Setting Edit Popup
 */

Tine.Voipmanager.SnomSettingEditDialog.openWindow = function (config) {
  var id = config.record && config.record.id ? config.record.id : 0;
  var window = Tine.WindowFactory.getWindow({
    width: 800,
    height: 470,
    name: Tine.Voipmanager.SnomSettingEditDialog.prototype.windowNamePrefix + id,
    contentPanelConstructor: 'Tine.Voipmanager.SnomSettingEditDialog',
    contentPanelConstructorConfig: config
  });
  return window;
};

/***/ }),

/***/ 2138:
/***/ (function(module, exports) {

/**
 * Tine 2.0
 * 
 * @package     Voipmanager
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Thomas Wadewitz <t.wadewitz@metaways.de>
 * @copyright   Copyright (c) 2007-2011 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 */
Ext.namespace('Tine.Voipmanager');
/**
 * SipPeers grid panel
 */

Tine.Voipmanager.AsteriskSipPeerGridPanel = Ext.extend(Tine.widgets.grid.GridPanel, {
  // model generics
  recordClass: Tine.Voipmanager.Model.AsteriskSipPeer,
  evalGrants: false,
  // grid specific
  defaultSortInfo: {
    field: 'name',
    direction: 'ASC'
  },
  gridConfig: {
    autoExpandColumn: 'callerid'
  },
  initComponent: function initComponent() {
    this.recordProxy = Tine.Voipmanager.AsteriskSipPeerBackend;
    this.gridConfig.columns = this.getColumns();
    this.actionToolbarItems = this.getToolbarItems();
    Tine.Voipmanager.AsteriskSipPeerGridPanel.superclass.initComponent.call(this);
  },

  /**
   * returns cm
   * @private
   * 
   */
  getColumns: function getColumns() {
    return [{
      id: 'id',
      header: this.app.i18n._('Id'),
      dataIndex: 'id',
      width: 30,
      sortable: true,
      hidden: true
    }, {
      id: 'name',
      header: this.app.i18n._('name'),
      dataIndex: 'name',
      width: 50,
      sortable: true
    }, {
      id: 'accountcode',
      header: this.app.i18n._('account code'),
      dataIndex: 'accountcode',
      width: 30,
      sortable: true,
      hidden: true
    }, {
      id: 'amaflags',
      header: this.app.i18n._('ama flags'),
      dataIndex: 'amaflags',
      width: 30,
      sortable: true,
      hidden: true
    }, {
      id: 'callgroup',
      header: this.app.i18n._('call group'),
      dataIndex: 'callgroup',
      width: 30,
      sortable: true,
      hidden: true
    }, {
      id: 'callerid',
      header: this.app.i18n._('caller id'),
      dataIndex: 'callerid',
      width: 80,
      sortable: true
    }, {
      id: 'canreinvite',
      header: this.app.i18n._('can reinvite'),
      dataIndex: 'canreinvite',
      width: 30,
      sortable: true,
      hidden: true
    }, {
      id: 'context',
      header: this.app.i18n._('context'),
      dataIndex: 'context',
      width: 50,
      sortable: false
    }, {
      id: 'defaultip',
      header: this.app.i18n._('default ip'),
      dataIndex: 'defaultip',
      width: 30,
      sortable: true,
      hidden: true
    }, {
      id: 'dtmfmode',
      header: this.app.i18n._('dtmf mode'),
      dataIndex: 'dtmfmode',
      width: 30,
      sortable: true,
      hidden: true
    }, {
      id: 'fromuser',
      header: this.app.i18n._('from user'),
      dataIndex: 'fromuser',
      width: 30,
      sortable: true,
      hidden: true
    }, {
      id: 'fromdomain',
      header: this.app.i18n._('from domain'),
      dataIndex: 'fromdomain',
      width: 30,
      sortable: true,
      hidden: true
    }, {
      id: 'fullcontact',
      header: this.app.i18n._('full contact'),
      dataIndex: 'fullcontact',
      width: 200,
      sortable: true,
      hidden: true
    }, {
      id: 'host',
      header: this.app.i18n._('host'),
      dataIndex: 'host',
      width: 30,
      sortable: true,
      hidden: true
    }, {
      id: 'insecure',
      header: this.app.i18n._('insecure'),
      dataIndex: 'insecure',
      width: 30,
      sortable: true,
      hidden: true
    }, {
      id: 'language',
      header: this.app.i18n._('language'),
      dataIndex: 'language',
      width: 30,
      sortable: true,
      hidden: true
    }, {
      id: 'mailbox',
      header: this.app.i18n._('mailbox'),
      dataIndex: 'mailbox',
      width: 30,
      sortable: true
    }, {
      id: 'md5secret',
      header: this.app.i18n._('md5 secret'),
      dataIndex: 'md5secret',
      width: 30,
      sortable: true,
      hidden: true
    }, {
      id: 'nat',
      header: this.app.i18n._('nat'),
      dataIndex: 'nat',
      width: 30,
      sortable: true,
      hidden: true
    }, {
      id: 'deny',
      header: this.app.i18n._('deny'),
      dataIndex: 'deny',
      width: 30,
      sortable: true,
      hidden: true
    }, {
      id: 'permit',
      header: this.app.i18n._('permit'),
      dataIndex: 'permit',
      width: 30,
      sortable: true,
      hidden: true
    }, {
      id: 'mask',
      header: this.app.i18n._('mask'),
      dataIndex: 'mask',
      width: 30,
      sortable: true,
      hidden: true
    }, {
      id: 'pickupgroup',
      header: this.app.i18n._('pickup group'),
      dataIndex: 'pickupgroup',
      width: 40,
      sortable: true
    }, {
      id: 'port',
      header: this.app.i18n._('port'),
      dataIndex: 'port',
      width: 30,
      sortable: true,
      hidden: true
    }, {
      id: 'qualify',
      header: this.app.i18n._('qualify'),
      dataIndex: 'qualify',
      width: 30,
      sortable: true,
      hidden: true
    }, {
      id: 'restrictcid',
      header: this.app.i18n._('restrict cid'),
      dataIndex: 'restrictcid',
      width: 30,
      sortable: true,
      hidden: true
    }, {
      id: 'rtptimeout',
      header: this.app.i18n._('rtp timeout'),
      dataIndex: 'rtptimeout',
      width: 30,
      sortable: true,
      hidden: true
    }, {
      id: 'rtpholdtimeout',
      header: this.app.i18n._('rtp hold timeout'),
      dataIndex: 'rtpholdtimeout',
      width: 30,
      sortable: true,
      hidden: true
    }, {
      id: 'secret',
      header: this.app.i18n._('secret'),
      dataIndex: 'secret',
      width: 30,
      sortable: true,
      hidden: true
    }, {
      id: 'type',
      header: this.app.i18n._('type'),
      dataIndex: 'type',
      width: 30,
      sortable: true
    }, {
      id: 'defaultuser',
      header: this.app.i18n._('defaultuser'),
      dataIndex: 'defaultuser',
      width: 30,
      sortable: true,
      hidden: true
    }, {
      id: 'disallow',
      header: this.app.i18n._('disallow'),
      dataIndex: 'disallow',
      width: 30,
      sortable: true,
      hidden: true
    }, {
      id: 'allow',
      header: this.app.i18n._('allow'),
      dataIndex: 'allow',
      width: 30,
      sortable: true,
      hidden: true
    }, {
      id: 'musiconhold',
      header: this.app.i18n._('music on hold'),
      dataIndex: 'musiconhold',
      width: 30,
      sortable: true,
      hidden: true
    }, {
      id: 'regseconds',
      header: this.app.i18n._('reg seconds'),
      dataIndex: 'regseconds',
      width: 50,
      sortable: true,
      renderer: Tine.Tinebase.common.dateTimeRenderer
    }, {
      id: 'ipaddr',
      header: this.app.i18n._('ip address'),
      dataIndex: 'ipaddr',
      width: 30,
      sortable: true,
      hidden: true
    }, {
      id: 'regexten',
      header: this.app.i18n._('reg exten'),
      dataIndex: 'regexten',
      width: 30,
      sortable: true,
      hidden: true
    }, {
      id: 'cancallforward',
      header: this.app.i18n._('can call forward'),
      dataIndex: 'cancallforward',
      width: 30,
      sortable: true,
      hidden: true
    }, {
      id: 'setvar',
      header: this.app.i18n._('set var'),
      dataIndex: 'setvar',
      width: 30,
      sortable: true,
      hidden: true
    }, {
      id: 'notifyringing',
      header: this.app.i18n._('notify ringing'),
      dataIndex: 'notifyringing',
      width: 30,
      sortable: true,
      hidden: true
    }, {
      id: 'useclientcode',
      header: this.app.i18n._('use client code'),
      dataIndex: 'useclientcode',
      width: 30,
      sortable: true,
      hidden: true
    }, {
      id: 'authuser',
      header: this.app.i18n._('auth user'),
      dataIndex: 'authuser',
      width: 30,
      sortable: true,
      hidden: true
    }, {
      id: 'call-limit',
      header: this.app.i18n._('call limit'),
      dataIndex: 'call-limit',
      width: 30,
      sortable: true,
      hidden: true
    }, {
      id: 'busy-level',
      header: this.app.i18n._('busy level'),
      dataIndex: 'busy-level',
      width: 30,
      sortable: true,
      hidden: true
    }];
  },
  initDetailsPanel: function initDetailsPanel() {
    return false;
  },

  /**
   * return additional tb items
   * 
   * @todo add duplicate button
   * @todo move export buttons to single menu/split button
   */
  getToolbarItems: function getToolbarItems() {
    return [];
  }
});

/***/ }),

/***/ 2139:
/***/ (function(module, exports, __webpack_require__) {

/**
 * Tine 2.0
 * 
 * @package     Voipmanager
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Thomas Wadewitz <t.wadewitz@metaways.de>
 * @copyright   Copyright (c) 2007-2010 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 */
Ext.namespace('Tine.Voipmanager');

__webpack_require__(143);
/**
 * Asterisk SipPeer Edit Dialog
 */


Tine.Voipmanager.AsteriskSipPeerEditDialog = Ext.extend(Tine.widgets.dialog.EditDialog, {
  /**
   * @private
   */
  windowNamePrefix: 'AsteriskSipPeerEditWindow_',
  appName: 'Voipmanager',
  recordClass: Tine.Voipmanager.Model.AsteriskSipPeer,
  recordProxy: Tine.Voipmanager.AsteriskSipPeerBackend,
  evalGrants: false,

  /**
   * executed when record is loaded
   * @private
   */
  onRecordLoad: function onRecordLoad() {
    Tine.Voipmanager.AsteriskSipPeerEditDialog.superclass.onRecordLoad.call(this); // update tabpanels

    if (this.callForwardPanel) {
      this.callForwardPanel.onRecordLoad(this.record);
    }
  },

  /**
   * returns dialog
   * 
   * NOTE: when this method gets called, all initalisation is done.
   */
  getFormItems: function getFormItems() {
    // init tabpanels
    this.callForwardPanel = new Tine.Voipmanager.CallForwardPanel({
      title: this.app.i18n._('Call Forwards'),
      app: this.app,
      editDialog: this
    });
    return {
      xtype: 'tabpanel',
      border: false,
      plain: true,
      activeTab: 0,
      items: [{
        title: this.app.i18n._('General'),
        border: false,
        frame: true,
        anchor: '100%',
        xtype: 'columnform',
        items: [[{
          xtype: 'textfield',
          fieldLabel: this.app.i18n._('Name'),
          name: 'name',
          maxLength: 80,
          anchor: '98%',
          allowBlank: false
        }, {
          xtype: 'reccombo',
          name: 'context_id',
          fieldLabel: this.app.i18n._('Context'),
          valueField: 'id',
          displayField: 'name',
          allowBlank: false,
          store: new Ext.data.Store({
            fields: Tine.Voipmanager.Model.AsteriskContext,
            proxy: Tine.Voipmanager.AsteriskContextBackend,
            reader: Tine.Voipmanager.AsteriskContextBackend.getReader(),
            remoteSort: true,
            sortInfo: {
              field: 'name',
              dir: 'ASC'
            }
          })
        }, {
          xtype: 'combo',
          fieldLabel: this.app.i18n._('Type'),
          name: 'type',
          mode: 'local',
          anchor: '98%',
          triggerAction: 'all',
          editable: false,
          forceSelection: true,
          value: 'peer',
          store: [['friend', this.app.i18n._('friend')], ['user', this.app.i18n._('user')], ['peer', this.app.i18n._('peer')]]
        }], [{
          xtype: 'textfield',
          fieldLabel: this.app.i18n._('Secret'),
          name: 'secret',
          maxLength: 80,
          anchor: '98%',
          allowBlank: false
        }, {
          xtype: 'textfield',
          fieldLabel: this.app.i18n._('Callerid'),
          name: 'callerid',
          maxLength: 80,
          anchor: '100%',
          allowBlank: true
        }, {
          xtype: 'textfield',
          fieldLabel: this.app.i18n._('Mailbox'),
          name: 'mailbox',
          maxLength: 50,
          anchor: '98%',
          allowBlank: true
        }], [{
          xtype: 'textfield',
          fieldLabel: this.app.i18n._('Callgroup'),
          name: 'callgroup',
          maxLength: 10,
          anchor: '98%',
          allowBlank: true
        }, {
          xtype: 'textfield',
          fieldLabel: this.app.i18n._('Pickup group'),
          name: 'pickupgroup',
          maxLength: 10,
          anchor: '98%',
          allowBlank: true
        }, {
          xtype: 'textfield',
          fieldLabel: this.app.i18n._('Accountcode'),
          name: 'accountcode',
          maxLength: 20,
          anchor: '98%',
          allowBlank: true
        }], [{
          xtype: 'textfield',
          fieldLabel: this.app.i18n._('Language'),
          name: 'language',
          maxLength: 2,
          anchor: '98%',
          allowBlank: true
        }, {
          xtype: 'combo',
          fieldLabel: this.app.i18n._('NAT'),
          name: 'nat',
          mode: 'local',
          anchor: '98%',
          triggerAction: 'all',
          editable: false,
          forceSelection: true,
          value: 'no',
          store: [['no', this.app.i18n._('off')], ['yes', this.app.i18n._('on')]]
        }, {
          xtype: 'combo',
          fieldLabel: this.app.i18n._('Qualify'),
          name: 'qualify',
          mode: 'local',
          anchor: '98%',
          triggerAction: 'all',
          editable: false,
          forceSelection: true,
          value: 'no',
          store: [['no', this.app.i18n._('off')], ['yes', this.app.i18n._('on')]]
        }], [{
          xtype: 'combo',
          fieldLabel: this.app.i18n._('Direct Media (canreinvite)'),
          // canreinvite is deprecated in asterisk 10,11 and will be replaced by directmedia, but we use the old asterisk here
          name: 'canreinvite',
          mode: 'local',
          anchor: '98%',
          triggerAction: 'all',
          editable: false,
          forceSelection: true,
          value: 'yes',
          store: [['yes', this.app.i18n._('yes')], ['no', this.app.i18n._('no')]
          /* next asterisk versions (>1.8), when this is called directmedia we have an additional option:
          ['nonat', this.app.i18n._('nonat')],  */
          ]
        }]]
      }, this.callForwardPanel]
    };
  }
});
/**
 * Asterisk SipPeer Edit Popup
 */

Tine.Voipmanager.AsteriskSipPeerEditDialog.openWindow = function (config) {
  var id = config.record && config.record.id ? config.record.id : 0;
  var window = Tine.WindowFactory.getWindow({
    width: 800,
    height: 470,
    name: Tine.Voipmanager.AsteriskSipPeerEditDialog.prototype.windowNamePrefix + id,
    contentPanelConstructor: 'Tine.Voipmanager.AsteriskSipPeerEditDialog',
    contentPanelConstructorConfig: config
  });
  return window;
};

/***/ }),

/***/ 2140:
/***/ (function(module, exports) {

/**
 * Tine 2.0
 * 
 * @package     Voipmanager
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Thomas Wadewitz <t.wadewitz@metaways.de>
 * @copyright   Copyright (c) 2007-2011 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 */
Ext.namespace('Tine.Voipmanager');
/**
 * Context grid panel
 */

Tine.Voipmanager.AsteriskContextGridPanel = Ext.extend(Tine.widgets.grid.GridPanel, {
  // model generics
  recordClass: Tine.Voipmanager.Model.AsteriskContext,
  evalGrants: false,
  // grid specific
  defaultSortInfo: {
    field: 'name',
    direction: 'ASC'
  },
  gridConfig: {
    autoExpandColumn: 'description'
  },
  initComponent: function initComponent() {
    this.recordProxy = Tine.Voipmanager.AsteriskContextBackend;
    this.gridConfig.columns = this.getColumns();
    this.actionToolbarItems = this.getToolbarItems();
    Tine.Voipmanager.AsteriskContextGridPanel.superclass.initComponent.call(this);
  },

  /**
   * returns cm
   * @private
   * 
   */
  getColumns: function getColumns() {
    return [{
      id: 'id',
      header: this.app.i18n._("id"),
      width: 10,
      sortable: true,
      hidden: true,
      dataIndex: 'id'
    }, {
      id: 'name',
      header: this.app.i18n._("Name"),
      width: 100,
      sortable: true,
      dataIndex: 'name',
      renderer: function renderer(name) {
        return Ext.util.Format.htmlEncode(name);
      }
    }, {
      id: 'description',
      header: this.app.i18n._("Description"),
      width: 350,
      sortable: true,
      dataIndex: 'description',
      renderer: function renderer(description) {
        return Ext.util.Format.htmlEncode(description);
      }
    }];
  },
  initDetailsPanel: function initDetailsPanel() {
    return false;
  },

  /**
   * return additional tb items
   * 
   * @todo add duplicate button
   * @todo move export buttons to single menu/split button
   */
  getToolbarItems: function getToolbarItems() {
    return [];
  }
});

/***/ }),

/***/ 2141:
/***/ (function(module, exports) {

/**
 * Tine 2.0
 * 
 * @package     Voipmanager
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Thomas Wadewitz <t.wadewitz@metaways.de>
 * @copyright   Copyright (c) 2007-2009 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 */
Ext.namespace('Tine.Voipmanager');
/**
 * Asterisk Context Edit Dialog
 */

Tine.Voipmanager.AsteriskContextEditDialog = Ext.extend(Tine.widgets.dialog.EditDialog, {
  /**
   * @private
   */
  windowNamePrefix: 'AsteriskContextEditWindow_',
  appName: 'Voipmanager',
  recordClass: Tine.Voipmanager.Model.AsteriskContext,
  recordProxy: Tine.Voipmanager.AsteriskContextBackend,
  evalGrants: false,

  /**
   * returns dialog
   * 
   * NOTE: when this method gets called, all initalisation is done.
   */
  getFormItems: function getFormItems() {
    return {
      layout: 'form',
      border: false,
      items: [{
        xtype: 'textfield',
        fieldLabel: this.app.i18n._('Name'),
        name: 'name',
        maxLength: 80,
        anchor: '100%',
        allowBlank: false
      }, {
        xtype: 'textarea',
        name: 'description',
        fieldLabel: this.app.i18n._('Description'),
        grow: false,
        preventScrollbars: false,
        anchor: '100%',
        height: 40
      }]
    };
  }
});
/**
 * Asterisk Context Edit Popup
 */

Tine.Voipmanager.AsteriskContextEditDialog.openWindow = function (config) {
  var id = config.record && config.record.id ? config.record.id : 0;
  var window = Tine.WindowFactory.getWindow({
    width: 500,
    height: 300,
    name: Tine.Voipmanager.AsteriskContextEditDialog.prototype.windowNamePrefix + id,
    contentPanelConstructor: 'Tine.Voipmanager.AsteriskContextEditDialog',
    contentPanelConstructorConfig: config
  });
  return window;
};

/***/ }),

/***/ 2142:
/***/ (function(module, exports) {

/**
 * Tine 2.0
 * 
 * @package     Voipmanager
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Thomas Wadewitz <t.wadewitz@metaways.de>
 * @copyright   Copyright (c) 2007-2011 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 */
Ext.namespace('Tine.Voipmanager');
/**
 * Voicemail grid panel
 */

Tine.Voipmanager.AsteriskVoicemailGridPanel = Ext.extend(Tine.widgets.grid.GridPanel, {
  // model generics
  recordClass: Tine.Voipmanager.Model.AsteriskVoicemail,
  evalGrants: false,
  // grid specific
  defaultSortInfo: {
    field: 'fullname',
    direction: 'ASC'
  },
  gridConfig: {
    autoExpandColumn: 'fullname'
  },
  initComponent: function initComponent() {
    this.recordProxy = Tine.Voipmanager.AsteriskVoicemailBackend;
    this.gridConfig.columns = this.getColumns();
    this.actionToolbarItems = this.getToolbarItems();
    Tine.Voipmanager.AsteriskVoicemailGridPanel.superclass.initComponent.call(this);
  },

  /**
   * returns cm
   * @private
   * 
   */
  getColumns: function getColumns() {
    return [{
      id: 'id',
      header: this.app.i18n._('id'),
      dataIndex: 'id',
      width: 10,
      sortable: true,
      hidden: true
    }, {
      id: 'mailbox',
      header: this.app.i18n._('mailbox'),
      dataIndex: 'mailbox',
      width: 50,
      sortable: true
    }, {
      id: 'context',
      header: this.app.i18n._('context'),
      dataIndex: 'context',
      width: 70,
      sortable: true
    }, {
      id: 'fullname',
      header: this.app.i18n._('fullname'),
      dataIndex: 'fullname',
      width: 180,
      sortable: true
    }, {
      id: 'email',
      header: this.app.i18n._('email'),
      dataIndex: 'email',
      width: 120,
      sortable: true
    }, {
      id: 'pager',
      header: this.app.i18n._('pager'),
      dataIndex: 'pager',
      width: 120,
      sortable: true
    }, {
      id: 'tz',
      header: this.app.i18n._('tz'),
      dataIndex: 'tz',
      width: 10,
      sortable: true,
      hidden: true
    }, {
      id: 'attach',
      header: this.app.i18n._('attach'),
      dataIndex: 'attach',
      width: 10,
      sortable: true,
      hidden: true
    }, {
      id: 'saycid',
      header: this.app.i18n._('saycid'),
      dataIndex: 'saycid',
      width: 10,
      sortable: true,
      hidden: true
    }, {
      id: 'dialout',
      header: this.app.i18n._('dialout'),
      dataIndex: 'dialout',
      width: 10,
      sortable: true,
      hidden: true
    }, {
      id: 'callback',
      header: this.app.i18n._('callback'),
      dataIndex: 'callback',
      width: 10,
      sortable: true,
      hidden: true
    }, {
      id: 'review',
      header: this.app.i18n._('review'),
      dataIndex: 'review',
      width: 10,
      sortable: true,
      hidden: true
    }, {
      id: 'operator',
      header: this.app.i18n._('operator'),
      dataIndex: 'operator',
      width: 10,
      sortable: true,
      hidden: true
    }, {
      id: 'envelope',
      header: this.app.i18n._('envelope'),
      dataIndex: 'envelope',
      width: 10,
      sortable: true,
      hidden: true
    }, {
      id: 'sayduration',
      header: this.app.i18n._('sayduration'),
      dataIndex: 'sayduration',
      width: 10,
      sortable: true,
      hidden: true
    }, {
      id: 'saydurationm',
      header: this.app.i18n._('saydurationm'),
      dataIndex: 'saydurationm',
      width: 10,
      sortable: true,
      hidden: true
    }, {
      id: 'sendvoicemail',
      header: this.app.i18n._('sendvoicemail'),
      dataIndex: 'sendvoicemail',
      width: 10,
      sortable: true,
      hidden: true
    }, {
      id: 'delete',
      header: this.app.i18n._('delete'),
      dataIndex: 'delete',
      width: 10,
      sortable: true,
      hidden: true
    }, {
      id: 'nextaftercmd',
      header: this.app.i18n._('nextaftercmd'),
      dataIndex: 'nextaftercmd',
      width: 10,
      sortable: true,
      hidden: true
    }, {
      id: 'forcename',
      header: this.app.i18n._('forcename'),
      dataIndex: 'forcename',
      width: 10,
      sortable: true,
      hidden: true
    }, {
      id: 'forcegreetings',
      header: this.app.i18n._('forcegreetings'),
      dataIndex: 'forcegreetings',
      width: 10,
      sortable: true,
      hidden: true
    }, {
      id: 'hidefromdir',
      header: this.app.i18n._('hidefromdir'),
      dataIndex: 'hidefromdir',
      width: 10,
      sortable: true,
      hidden: true
    }];
  },
  initDetailsPanel: function initDetailsPanel() {
    return false;
  },

  /**
   * return additional tb items
   * 
   * @todo add duplicate button
   * @todo move export buttons to single menu/split button
   */
  getToolbarItems: function getToolbarItems() {
    return [];
  }
});

/***/ }),

/***/ 2143:
/***/ (function(module, exports) {

/**
 * Tine 2.0
 * 
 * @package     Voipmanager
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Thomas Wadewitz <t.wadewitz@metaways.de>
 * @copyright   Copyright (c) 2007-2009 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 * @todo        make 'additional' tab work
 */
Ext.namespace('Tine.Voipmanager');
/**
 * Asterisk Voicemail Edit Dialog
 */

Tine.Voipmanager.AsteriskVoicemailEditDialog = Ext.extend(Tine.widgets.dialog.EditDialog, {
  /**
   * @private
   */
  windowNamePrefix: 'AsteriskVoicemailEditWindow_',
  appName: 'Voipmanager',
  recordClass: Tine.Voipmanager.Model.AsteriskVoicemail,
  recordProxy: Tine.Voipmanager.AsteriskVoicemailBackend,
  evalGrants: false,

  /**
   * returns dialog
   * 
   * NOTE: when this method gets called, all initalisation is done.
   */
  getFormItems: function getFormItems() {
    return {
      xtype: 'tabpanel',
      border: false,
      plain: true,
      activeTab: 0,
      deferredRender: false,
      items: [{
        title: this.app.i18n._('General'),
        frame: true,
        border: false,
        layout: 'form',
        items: [{
          xtype: 'textfield',
          fieldLabel: this.app.i18n._('Mailbox'),
          name: 'mailbox',
          maxLength: 11,
          anchor: '100%',
          allowBlank: false
        }, {
          xtype: 'reccombo',
          name: 'context_id',
          fieldLabel: this.app.i18n._('Context'),
          displayField: 'name',
          anchor: '100%',

          /*triggerAction: 'all',*/
          store: new Ext.data.Store({
            fields: Tine.Voipmanager.Model.AsteriskContext,
            proxy: Tine.Voipmanager.AsteriskContextBackend,
            reader: Tine.Voipmanager.AsteriskContextBackend.getReader(),
            remoteSort: true,
            sortInfo: {
              field: 'name',
              dir: 'ASC'
            }
          })
        }, {
          xtype: 'textfield',
          fieldLabel: this.app.i18n._('Name'),
          name: 'fullname',
          maxLength: 150,
          anchor: '100%',
          allowBlank: false
        }, {
          xtype: 'numberfield',
          fieldLabel: this.app.i18n._('Password'),
          name: 'password',
          maxLength: 5,
          anchor: '100%',
          allowBlank: false
        }, {
          xtype: 'textfield',
          vtype: 'email',
          fieldLabel: this.app.i18n._('email'),
          name: 'email',
          maxLength: 50,
          anchor: '100%'
        }, {
          xtype: 'textfield',
          fieldLabel: this.app.i18n._('pager'),
          name: 'pager',
          maxLength: 50,
          anchor: '100%'
        }]
      }, {
        title: this.app.i18n._('Additional'),
        frame: true,
        border: false,
        xtype: 'columnform',
        formDefaults: {
          xtype: 'combo',
          anchor: '100%',
          labelSeparator: '',
          columnWidth: .333,
          mode: 'local',
          displayField: 'value',
          valueField: 'id',
          triggerAction: 'all',
          editable: false,
          forceSelection: true,
          value: '1',
          store: [['1', this.app.i18n._('on')], ['0', this.app.i18n._('off')]]
        },
        items: [[{
          xtype: 'textfield',
          fieldLabel: this.app.i18n._('tz'),
          name: 'tz',
          maxLength: 10,
          editable: true
        }, {
          xtype: 'textfield',
          fieldLabel: this.app.i18n._('dialout'),
          name: 'dialout',
          maxLength: 10,
          editable: true
        }, {
          xtype: 'textfield',
          fieldLabel: this.app.i18n._('callback'),
          name: 'callback',
          maxLength: 10,
          editable: true
        }], [{
          xtype: 'combo',
          fieldLabel: this.app.i18n._('sayduration'),
          name: 'sayduration'
        }, {
          xtype: 'numberfield',
          fieldLabel: this.app.i18n._('saydurationm'),
          name: 'saydurationm',
          maxLength: 4
        }, {
          xtype: 'combo',
          fieldLabel: this.app.i18n._('attach'),
          name: 'attach'
        }], [{
          xtype: 'combo',
          fieldLabel: this.app.i18n._('saycid'),
          name: 'saycid'
        }, {
          xtype: 'combo',
          fieldLabel: this.app.i18n._('review'),
          name: 'review'
        }, {
          xtype: 'combo',
          fieldLabel: this.app.i18n._('operator'),
          name: 'operator'
        }], [{
          xtype: 'combo',
          fieldLabel: this.app.i18n._('envelope'),
          name: 'envelope'
        }, {
          xtype: 'combo',
          fieldLabel: this.app.i18n._('sendvoicemail'),
          name: 'sendvoicemail'
        }, {
          xtype: 'combo',
          fieldLabel: this.app.i18n._('delete'),
          name: 'delete'
        }], [{
          xtype: 'combo',
          fieldLabel: this.app.i18n._('nextaftercmd'),
          name: 'nextaftercmd'
        }, {
          xtype: 'combo',
          fieldLabel: this.app.i18n._('forcename'),
          name: 'forcename'
        }, {
          xtype: 'combo',
          fieldLabel: this.app.i18n._('forcegreetings'),
          name: 'forcegreetings'
        }], [{
          xtype: 'combo',
          fieldLabel: this.app.i18n._('hidefromdir'),
          name: 'hidefromdir'
        }]]
      }]
    };
  }
});
/**
 * Asterisk Voicemail Edit Popup
 */

Tine.Voipmanager.AsteriskVoicemailEditDialog.openWindow = function (config) {
  var id = config.record && config.record.id ? config.record.id : 0;
  var window = Tine.WindowFactory.getWindow({
    width: 800,
    height: 470,
    name: Tine.Voipmanager.AsteriskVoicemailEditDialog.prototype.windowNamePrefix + id,
    contentPanelConstructor: 'Tine.Voipmanager.AsteriskVoicemailEditDialog',
    contentPanelConstructorConfig: config
  });
  return window;
};

/***/ }),

/***/ 2144:
/***/ (function(module, exports) {

/**
 * Tine 2.0
 * 
 * @package     Voipmanager
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Thomas Wadewitz <t.wadewitz@metaways.de>
 * @copyright   Copyright (c) 2007-2011 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 */
Ext.namespace('Tine.Voipmanager');
/**
 * Meetme grid panel
 */

Tine.Voipmanager.AsteriskMeetmeGridPanel = Ext.extend(Tine.widgets.grid.GridPanel, {
  // model generics
  recordClass: Tine.Voipmanager.Model.AsteriskMeetme,
  evalGrants: false,
  // grid specific
  defaultSortInfo: {
    field: 'confno',
    direction: 'ASC'
  },
  gridConfig: {
    autoExpandColumn: 'confno'
  },
  initComponent: function initComponent() {
    this.recordProxy = Tine.Voipmanager.AsteriskMeetmeBackend;
    this.gridConfig.columns = this.getColumns();
    this.actionToolbarItems = this.getToolbarItems();
    Tine.Voipmanager.AsteriskMeetmeGridPanel.superclass.initComponent.call(this);
  },

  /**
   * returns cm
   * @private
   * 
   */
  getColumns: function getColumns() {
    return [{
      id: 'id',
      header: this.app.i18n._("id"),
      width: 10,
      sortable: true,
      hidden: true,
      dataIndex: 'id'
    }, {
      id: 'confno',
      header: this.app.i18n._("confno"),
      width: 80,
      sortable: true,
      dataIndex: 'confno',
      renderer: function renderer(confno) {
        return Ext.util.Format.htmlEncode(confno);
      }
    }, {
      id: 'pin',
      header: this.app.i18n._("pin"),
      width: 80,
      sortable: true,
      dataIndex: 'pin',
      renderer: function renderer(pin) {
        return Ext.util.Format.htmlEncode(pin);
      }
    }, {
      id: 'adminpin',
      header: this.app.i18n._("adminpin"),
      width: 80,
      sortable: true,
      dataIndex: 'adminpin',
      renderer: function renderer(adminpin) {
        return Ext.util.Format.htmlEncode(adminpin);
      }
    }];
  },
  initDetailsPanel: function initDetailsPanel() {
    return false;
  },

  /**
   * return additional tb items
   * 
   * @todo add duplicate button
   * @todo move export buttons to single menu/split button
   */
  getToolbarItems: function getToolbarItems() {
    return [];
  }
});

/***/ }),

/***/ 2145:
/***/ (function(module, exports) {

/**
 * Tine 2.0
 * 
 * @package     Voipmanager
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Thomas Wadewitz <t.wadewitz@metaways.de>
 * @copyright   Copyright (c) 2007-2009 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 */
Ext.namespace('Tine.Voipmanager');
/**
 * Asterisk Meetme Edit Dialog
 */

Tine.Voipmanager.AsteriskMeetmeEditDialog = Ext.extend(Tine.widgets.dialog.EditDialog, {
  /**
   * @private
   */
  windowNamePrefix: 'AsteriskMeetmeEditWindow_',
  appName: 'Voipmanager',
  recordClass: Tine.Voipmanager.Model.AsteriskMeetme,
  recordProxy: Tine.Voipmanager.AsteriskMeetmeBackend,
  evalGrants: false,

  /**
   * returns dialog
   * 
   * NOTE: when this method gets called, all initalisation is done.
   */
  getFormItems: function getFormItems() {
    return {
      layout: 'form',
      border: false,
      width: 440,
      height: 280,
      items: [{
        xtype: 'numberfield',
        fieldLabel: this.app.i18n._('confno'),
        name: 'confno',
        id: 'confno',
        maxLength: 80,
        anchor: '100%',
        allowBlank: false
      }, {
        xtype: 'numberfield',
        fieldLabel: this.app.i18n._('pin'),
        name: 'pin',
        id: 'pin',
        maxLength: 80,
        anchor: '100%',
        allowBlank: false
      }, {
        xtype: 'numberfield',
        fieldLabel: this.app.i18n._('adminpin'),
        name: 'adminpin',
        id: 'adminpin',
        maxLength: 80,
        anchor: '100%',
        allowBlank: false
      }]
    };
  }
});
/**
 * Asterisk Meetme Edit Popup
 */

Tine.Voipmanager.AsteriskMeetmeEditDialog.openWindow = function (config) {
  var id = config.record && config.record.id ? config.record.id : 0;
  var window = Tine.WindowFactory.getWindow({
    width: 500,
    height: 300,
    name: Tine.Voipmanager.AsteriskMeetmeEditDialog.prototype.windowNamePrefix + id,
    contentPanelConstructor: 'Tine.Voipmanager.AsteriskMeetmeEditDialog',
    contentPanelConstructorConfig: config
  });
  return window;
};

/***/ }),

/***/ 2146:
/***/ (function(module, exports) {

/**
 * Tine 2.0
 * 
 * @package     Voipmanager
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Thomas Wadewitz <t.wadewitz@metaways.de>
 * @copyright   Copyright (c) 2007-2009 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 * @todo        check if we need this
 */
Ext.ns('Tine.Voipmanager'); // default mainscreen

Tine.Voipmanager.MainScreen = Ext.extend(Tine.widgets.MainScreen, {
  activeContentType: 'Phone',
  activeContentGroup: 'Snom',

  /**
   * returns active content type
   * 
   * @return {String}
   */
  getActiveContentType: function getActiveContentType() {
    var ac = this.activeContentType ? this.activeContentType : '';
    var ag = this.activeContentGroup ? this.activeContentGroup : '';
    return ag + ac;
  },
  getCenterPanel: function getCenterPanel(contentType) {
    // which content panel?
    var type = this.activeContentType;
    var group = this.activeContentGroup; //console.log(group +  '/' + type);

    if (!this[group + type + 'GridPanel']) {
      this[group + type + 'GridPanel'] = new Tine[this.app.appName][group + type + 'GridPanel']({
        app: this.app
      });
    }

    this[group + type + 'GridPanel'].store.load();
    return this[group + type + 'GridPanel'];
  },

  /**
   * get north panel for given contentType
   *
   * @param {String} contentType
   * @return {Ext.Panel}
   */
  getNorthPanel: function getNorthPanel(contentType) {
    var type = this.activeContentType;
    var group = this.activeContentGroup;

    if (!this[group + type + 'ActionToolbar']) {
      this[group + type + 'ActionToolbar'] = this[group + type + 'GridPanel'].actionToolbar;
    }

    return this[group + type + 'ActionToolbar'];
  },

  /**
   * overwrite default
   * @return Tine.Voipmanager.PhoneTreePanel
   */
  getWestPanel: function getWestPanel(contentType) {
    if (!this.PhoneTreePanel) {
      this.PhoneTreePanel = new Tine.Voipmanager.PhoneTreePanel({
        app: this.app
      });
    }

    return this.PhoneTreePanel;
  }
});

/***/ }),

/***/ 2147:
/***/ (function(module, exports, __webpack_require__) {

// style-loader: Adds some css to the DOM by adding a <style> tag

// load the styles
var content = __webpack_require__(2148);
if(typeof content === 'string') content = [[module.i, content, '']];
// Prepare cssTransformation
var transform;

var options = {"hmr":true}
options.transform = transform
// add the styles to the DOM
var update = __webpack_require__(11)(content, options);
if(content.locals) module.exports = content.locals;
// Hot Module Replacement
if(false) {}

/***/ }),

/***/ 2148:
/***/ (function(module, exports, __webpack_require__) {

var escape = __webpack_require__(98);
exports = module.exports = __webpack_require__(10)(false);
// imports


// module
exports.push([module.i, ".action_settings {\n    background-image:url(" + escape(__webpack_require__(112)) + ") !important;\n}\n\n.action_permissions {\n    background-image:url(" + escape(__webpack_require__(2149)) + ") !important;\n}\n\n.action_addGroup {\n    background-image:url(" + escape(__webpack_require__(119)) + ") !important;\n}\n\n\n.action_resetHttpClientInfo {\n    background-image:url(" + escape(__webpack_require__(287)) + ") !important;\n}\n\n.action_openPhonesWebGui {\n    background-image:url(" + escape(__webpack_require__(293)) + ") !important;\n}\n\n\n.VoipmanagerIconCls {\n    background-image:url(" + escape(__webpack_require__(169)) + ") !important;\n}\n\n.cboxmiddle {\n    vertical-align: middle;\n    left: 2px !important;\n    top: 9px !important;\n}\n\n.x-form-check-wrap {\n    line-height:24px !important;\n}\n\n.down {\n    position: relative;\n    bottom: -14px;\n}\n\n.voipmanager-row-changed td{\n    font-weight: bold;\n}\n\n", ""]);

// exports


/***/ }),

/***/ 2149:
/***/ (function(module, exports) {

module.exports = "\"data:image/svg+xml,%3C?xml version='1.0' encoding='utf-8'?%3E %3C!-- Generator: Adobe Illustrator 21.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0) --%3E %3Csvg version='1.1' id='Ebene_1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' x='0px' y='0px' viewBox='0 0 42.5 42.5' style='enable-background:new 0 0 42.5 42.5;' xml:space='preserve' width='42.5' height='42.5'%3E %3Cpath id='Icon_Passwort' d='M12.5,19.5h16.7v-4.4c0-2.4-0.8-4.4-2.5-6.1c-1.7-1.7-3.3-2.5-5.7-2.5S16.7,7.3,15,9s-2.5,3.7-2.5,6.1 V19.5z M34.8,21.8v13.9c0,0.6-0.2,1.2-0.7,1.6c-0.5,0.5-1,0.7-1.6,0.7H9.3c-0.6,0-1.2-0.2-1.6-0.7c-0.5-0.5-0.7-1-0.7-1.6V21.8 c0-0.6,0.2-1.2,0.7-1.6c0.5-0.5,1-0.7,1.6-0.7h0.8v-4.6c0-3,1.1-5.5,3.2-7.6S17.9,4,20.9,4s5.5,1.1,7.6,3.2s3.2,4.7,3.2,7.6v4.6h0.8 c0.6,0,1.2,0.2,1.6,0.7C34.6,20.6,34.8,21.1,34.8,21.8z'/%3E %3C/svg%3E\""

/***/ }),

/***/ 287:
/***/ (function(module, exports) {

module.exports = "\"data:image/svg+xml,%3C?xml version='1.0' encoding='utf-8'?%3E %3C!-- Generator: Adobe Illustrator 21.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0) --%3E %3Csvg version='1.1' id='Ebene_1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' x='0px' y='0px' viewBox='0 0 42.5 42.5' style='enable-background:new 0 0 42.5 42.5;' xml:space='preserve' width='42.5' height='42.5'%3E %3Cpath d='M38.5,33.1H41v3.1c0,0.5-0.2,0.9-0.5,1.3S39.6,38,39.1,38H13.6c-0.5,0-0.9-0.2-1.3-0.5s-0.5-0.8-0.5-1.3v-3.1h2.4v2.5h24.3 V33.1z M41,14.3v18.8h-2.4v-17h-7.9c-0.5,0-0.9-0.2-1.3-0.5c-0.4-0.4-0.5-0.8-0.5-1.3V6.4H14.2v11.7h-2.4V5.8c0-0.5,0.2-0.9,0.5-1.3 C12.7,4.2,13.1,4,13.6,4h17c0.5,0,1.1,0.1,1.7,0.4c0.6,0.3,1.1,0.6,1.4,0.9l5.9,5.9c0.4,0.4,0.7,0.8,0.9,1.4 C40.8,13.3,41,13.8,41,14.3z M38.4,13.7c-0.1-0.4-0.3-0.6-0.4-0.8L32,7c-0.2-0.2-0.4-0.3-0.8-0.4v7.1H38.4z M23.3,25.3 c0,0.3-0.1,0.5-0.3,0.7l-5.2,5.2c-0.2,0.2-0.4,0.3-0.7,0.3c-0.3,0-0.5-0.1-0.7-0.3l-0.6-0.6c-0.2-0.2-0.3-0.4-0.3-0.7 s0.1-0.5,0.3-0.7l2.3-2.3H2.9c-0.3,0-0.5-0.1-0.7-0.3C2.1,26.3,2,26.1,2,25.8v-1c0-0.3,0.1-0.5,0.3-0.7c0.2-0.2,0.4-0.3,0.7-0.3 h15.2l-2.3-2.3c-0.2-0.2-0.3-0.4-0.3-0.7s0.1-0.5,0.3-0.7l0.6-0.6c0.2-0.2,0.4-0.3,0.7-0.3c0.3,0,0.5,0.1,0.7,0.3l5.2,5.2 C23.2,24.7,23.3,25,23.3,25.3z'/%3E %3C/svg%3E\""

/***/ }),

/***/ 293:
/***/ (function(module, exports) {

module.exports = "\"data:image/svg+xml,%3C?xml version='1.0' encoding='utf-8'?%3E %3C!-- Generator: Adobe Illustrator 21.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0) --%3E %3Csvg version='1.1' id='Ebene_1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' x='0px' y='0px' viewBox='0 0 42.5 42.5' style='enable-background:new 0 0 42.5 42.5;' xml:space='preserve' width='42.5' height='42.5'%3E %3Cpath d='M5.2,21.9h6c0.1,2.2,0.4,4.3,0.8,6.2c-1.4,0.5-2.7,1.1-3.8,1.8C6.4,27.7,5.4,24.9,5.2,21.9z M8.1,11.5 c1.1,0.7,2.4,1.3,3.8,1.8c-0.5,2-0.7,4.1-0.8,6.2h-6C5.4,16.5,6.4,13.8,8.1,11.5z M36.9,19.5h-6c-0.1-2.2-0.4-4.3-0.8-6.2 c1.4-0.5,2.7-1.1,3.8-1.8C35.7,13.8,36.7,16.5,36.9,19.5z M34,30c-1.1-0.7-2.4-1.3-3.8-1.8c0.5-2,0.7-4.1,0.8-6.3h6 C36.7,24.9,35.7,27.7,34,30z M19.9,26.7c-2,0.1-3.9,0.3-5.6,0.8c-0.4-1.7-0.6-3.6-0.7-5.6h6.4V26.7z M19.9,29.1v7.3 c-2.5-0.9-4.1-4.2-5-6.7C16.4,29.4,18.1,29.2,19.9,29.1z M22.2,36.4v-7.3c1.7,0.1,3.4,0.3,5,0.7C26.4,32.3,24.7,35.5,22.2,36.4z M22.2,26.7v-4.8h6.4c-0.1,2-0.3,3.8-0.7,5.6C26.1,27.1,24.2,26.8,22.2,26.7z M28.6,19.5h-6.4v-4.8c2-0.1,3.9-0.3,5.6-0.8 C28.3,15.7,28.5,17.6,28.6,19.5z M22.2,12.3V5c2.5,0.9,4.1,4.2,5,6.7C25.7,12,24,12.3,22.2,12.3z M19.9,5v7.3 c-1.7-0.1-3.4-0.3-5-0.7C15.7,9.2,17.4,5.9,19.9,5z M19.9,14.7v4.8h-6.4c0.1-2,0.3-3.8,0.7-5.6C16,14.4,17.9,14.6,19.9,14.7z M9.6,31.8c0.9-0.5,1.9-1,2.9-1.4c0.6,1.7,1.4,3.5,2.5,5C13,34.7,11.2,33.4,9.6,31.8z M27,35.5c1.1-1.5,1.9-3.3,2.5-5 c1.1,0.4,2.1,0.8,2.9,1.4C30.9,33.4,29.1,34.7,27,35.5z M32.5,9.6c-0.9,0.5-1.9,1-2.9,1.4c-0.6-1.7-1.4-3.5-2.5-5 C29.1,6.8,30.9,8,32.5,9.6z M15.1,5.9c-1.1,1.5-1.9,3.3-2.5,5c-1.1-0.4-2.1-0.8-2.9-1.4C11.2,8,13,6.8,15.1,5.9z'/%3E %3C/svg%3E\""

/***/ }),

/***/ 311:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 * 
 * @package     Voipmanager
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Thomas Wadewitz <t.wadewitz@metaways.de>
 * @copyright   Copyright (c) 2007-2008 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 */
Ext.ns('Tine.Voipmanager', 'Tine.Voipmanager.Model');
/*
 *  SNOM
 */

/**
 * @type {Array}
 * Voipmanager model fields
 */

Tine.Voipmanager.Model.SnomPhoneArray = Tine.Tinebase.Model.modlogFields.concat([{
  name: 'id'
}, {
  name: 'macaddress'
}, {
  name: 'description'
}, {
  name: 'location_id'
}, {
  name: 'template_id'
}, {
  name: 'settings_id'
}, {
  name: 'ipaddress'
}, {
  name: 'last_modified_time',
  type: 'date',
  dateFormat: Date.patterns.ISO8601Long
}, {
  name: 'current_software'
}, {
  name: 'current_model'
}, {
  name: 'settings_loaded_at',
  type: 'date',
  dateFormat: Date.patterns.ISO8601Long
}, {
  name: 'firmware_checked_at',
  type: 'date',
  dateFormat: Date.patterns.ISO8601Long
}, {
  name: 'location'
}, {
  name: 'template'
}, {
  name: 'http_client_info_sent'
}, {
  name: 'http_client_user'
}, {
  name: 'http_client_pass'
}, {
  name: 'setting_id'
}, {
  name: 'web_language'
}, {
  name: 'language'
}, {
  name: 'display_method'
}, {
  name: 'mwi_notification'
}, {
  name: 'mwi_dialtone'
}, {
  name: 'headset_device'
}, {
  name: 'message_led_other'
}, {
  name: 'global_missed_counter'
}, {
  name: 'pickup_indication'
}, {
  name: 'scroll_outgoing'
}, {
  name: 'show_local_line'
}, {
  name: 'show_call_status'
}, {
  name: 'call_waiting'
}, {
  name: 'web_language_w'
}, {
  name: 'language_w'
}, {
  name: 'display_method_w'
}, {
  name: 'call_waiting_w'
}, {
  name: 'mwi_notification_w'
}, {
  name: 'mwi_dialtone_w'
}, {
  name: 'headset_device_w'
}, {
  name: 'message_led_other_w'
}, {
  name: 'global_missed_counter_w'
}, {
  name: 'pickup_indication_w'
}, {
  name: 'scroll_outgoing_w'
}, {
  name: 'show_local_line_w'
}, {
  name: 'show_call_status_w'
}, {
  name: 'lines'
}, {
  name: 'rights'
}]);
/**
 * @type {Tine.Tinebase.data.Record}
 * Voipmanager record definition
 */

Tine.Voipmanager.Model.SnomPhone = Tine.Tinebase.data.Record.create(Tine.Voipmanager.Model.SnomPhoneArray, {
  appName: 'Voipmanager',
  modelName: 'SnomPhone',
  idProperty: 'id',
  titleProperty: 'description',
  // ngettext('Phone', 'Phones', n);
  recordName: 'SnomPhone',
  recordsName: 'SnomPhones',
  containerProperty: 'phone_id',
  // ngettext('phones list', 'phones lists', n);
  containerName: 'phones list',
  containersName: 'phones lists',
  getTitle: function getTitle() {
    return this.get('description') ? this.get('description') + ' ' + this.get('macaddress') : false;
  }
});

Tine.Voipmanager.Model.SnomPhone.getDefaultData = function () {
  return {};
};

Tine.Voipmanager.Model.SnomPhone.getFilterModel = function () {
  return [{
    label: i18n._('Quick Search'),
    field: 'query',
    operators: ['contains']
  }];
};

Tine.Voipmanager.Model.SnomLocationArray = Tine.Tinebase.Model.modlogFields.concat([{
  name: 'id'
}, {
  name: 'name'
}, {
  name: 'description'
}, {
  name: 'firmware_interval'
}, {
  name: 'update_policy'
}, {
  name: 'registrar'
}, {
  name: 'base_download_url'
}, {
  name: 'admin_mode'
}, {
  name: 'admin_mode_password'
}, {
  name: 'ntp_server'
}, {
  name: 'ntp_refresh'
}, {
  name: 'timezone'
}, {
  name: 'webserver_type'
}, {
  name: 'http_port'
}, {
  name: 'https_port'
}, {
  name: 'http_user'
}, {
  name: 'http_pass'
}, {
  name: 'tone_scheme'
}, {
  name: 'date_us_format'
}, {
  name: 'time_24_format'
}]);
/**
 * @type {Tine.Tinebase.data.Record}
 * Voipmanager record definition
 */

Tine.Voipmanager.Model.SnomLocation = Tine.Tinebase.data.Record.create(Tine.Voipmanager.Model.SnomLocationArray, {
  appName: 'Voipmanager',
  modelName: 'SnomLocation',
  idProperty: 'id',
  titleProperty: 'name',
  // ngettext('Location', 'Locations', n);
  recordName: 'SnomLocation',
  recordsName: 'SnomLocations',
  containerProperty: 'location_id',
  // ngettext('locations list', 'locations lists', n);
  containerName: 'locations list',
  containersName: 'locations lists',
  getTitle: function getTitle() {
    return this.get('name') ? this.get('name') : false;
  }
});

Tine.Voipmanager.Model.SnomLocation.getDefaultData = function () {
  return {};
};

Tine.Voipmanager.Model.SnomLocation.getFilterModel = function () {
  return [{
    label: i18n._('Quick Search'),
    field: 'query',
    operators: ['contains']
  }];
};

Tine.Voipmanager.Model.SnomTemplateArray = Tine.Tinebase.Model.modlogFields.concat([{
  name: 'id'
}, {
  name: 'name'
}, {
  name: 'description'
}, {
  name: 'keylayout_id'
}, {
  name: 'setting_id'
}, {
  name: 'software_id'
}]);
/**
 * @type {Tine.Tinebase.data.Record}
 * Voipmanager record definition
 */

Tine.Voipmanager.Model.SnomTemplate = Tine.Tinebase.data.Record.create(Tine.Voipmanager.Model.SnomTemplateArray, {
  appName: 'Voipmanager',
  modelName: 'SnomTemplate',
  idProperty: 'id',
  titleProperty: 'name',
  // ngettext('Template', 'Templates', n);
  recordName: 'SnomTemplate',
  recordsName: 'SnomTemplates',
  containerProperty: 'template_id',
  // ngettext('templates list', 'templates lists', n);
  containerName: 'templates list',
  containersName: 'templates lists',
  getTitle: function getTitle() {
    return this.get('name') ? this.get('name') : false;
  }
});

Tine.Voipmanager.Model.SnomTemplate.getDefaultData = function () {
  return {};
};

Tine.Voipmanager.Model.SnomTemplate.getFilterModel = function () {
  return [{
    label: i18n._('Quick Search'),
    field: 'query',
    operators: ['contains']
  }];
};

Tine.Voipmanager.Model.SnomSoftwareArray = Tine.Tinebase.Model.modlogFields.concat([{
  name: 'id'
}, {
  name: 'name'
}, {
  name: 'description'
}, {
  name: 'softwareimage_snom300'
}, {
  name: 'softwareimage_snom320'
}, {
  name: 'softwareimage_snom360'
}, {
  name: 'softwareimage_snom370'
}]);
/**
 * @type {Tine.Tinebase.data.Record}
 * Voipmanager record definition
 */

Tine.Voipmanager.Model.SnomSoftware = Tine.Tinebase.data.Record.create(Tine.Voipmanager.Model.SnomSoftwareArray, {
  appName: 'Voipmanager',
  modelName: 'SnomSoftware',
  idProperty: 'id',
  titleProperty: 'name',
  // ngettext('Software', 'Softwares', n);
  recordName: 'SnomSoftware',
  recordsName: 'SnomSoftwares',
  containerProperty: 'software_id',
  // ngettext('softwares list', 'softwares lists', n);
  containerName: 'softwares list',
  containersName: 'softwares lists',
  getTitle: function getTitle() {
    return this.get('name') ? this.get('name') : false;
  }
});

Tine.Voipmanager.Model.SnomSoftware.getDefaultData = function () {
  return {};
};

Tine.Voipmanager.Model.SnomSoftware.getFilterModel = function () {
  return [{
    label: i18n._('Quick Search'),
    field: 'query',
    operators: ['contains']
  }];
};

Tine.Voipmanager.Model.SnomSoftwareImageArray = Tine.Tinebase.Model.modlogFields.concat([{
  name: 'model'
}, {
  name: 'softwareimage'
}]);
/**
 * @type {Tine.Tinebase.data.Record}
 * Voipmanager record definition
 */

Tine.Voipmanager.Model.SnomSoftwareImage = Tine.Tinebase.data.Record.create(Tine.Voipmanager.Model.SnomSoftwareImageArray, {
  appName: 'Voipmanager',
  modelName: 'SnomSoftwareImage',
  idProperty: 'model',
  titleProperty: 'softwareimage',
  // ngettext('SoftwareImage', 'SoftwareImages', n);
  recordName: 'SnomSoftwareImage',
  recordsName: 'SnomSoftwareImages',
  containerProperty: 'softwareImage_model',
  // ngettext('softwareImages list', 'softwareImages lists', n);
  containerName: 'softwareImages list',
  containersName: 'softwareImages lists',
  getTitle: function getTitle() {
    return this.get('name') ? this.get('name') : false;
  }
});

Tine.Voipmanager.Model.SnomSoftwareImage.getDefaultData = function () {
  return {};
};

Tine.Voipmanager.Model.SnomLineArray = Tine.Tinebase.Model.modlogFields.concat([{
  name: 'asteriskline_id'
}, {
  name: 'id'
}, {
  name: 'idletext'
}, {
  name: 'lineactive',
  type: 'boolean'
}, {
  name: 'linenumber'
}, {
  name: 'snomphone_id'
}, {
  name: 'cfi_mode'
}, {
  name: 'cfi_number'
}, {
  name: 'cfb_mode'
}, {
  name: 'cfb_number'
}, {
  name: 'cfd_mode'
}, {
  name: 'cfd_number'
}, {
  name: 'cfd_time'
}]);
/**
 * @type {Tine.Tinebase.data.Record}
 * Voipmanager record definition
 */

Tine.Voipmanager.Model.SnomLine = Tine.Tinebase.data.Record.create(Tine.Voipmanager.Model.SnomLineArray, {
  appName: 'Voipmanager',
  modelName: 'SnomLine',
  idProperty: 'id',
  titleProperty: 'linenumber',
  // ngettext('Line', 'Lines', n);
  recordName: 'SnomLine',
  recordsName: 'SnomLines',
  containerProperty: 'line_id',
  // ngettext('lines list', 'lines lists', n);
  containerName: 'lines list',
  containersName: 'lines lists',
  getTitle: function getTitle() {
    return this.get('name') ? this.get('name') : false;
  }
});

Tine.Voipmanager.Model.SnomLine.getDefaultData = function () {
  return {};
};

Tine.Voipmanager.Model.SnomLine.getFilterModel = function () {
  return [{
    label: i18n._('Quick Search'),
    field: 'query',
    operators: ['contains']
  }];
};

Tine.Voipmanager.Model.SnomSettingArray = Tine.Tinebase.Model.modlogFields.concat([{
  name: 'id'
}, {
  name: 'name'
}, {
  name: 'description'
}, {
  name: 'web_language'
}, {
  name: 'language'
}, {
  name: 'display_method'
}, {
  name: 'mwi_notification'
}, {
  name: 'mwi_dialtone'
}, {
  name: 'headset_device'
}, {
  name: 'message_led_other'
}, {
  name: 'global_missed_counter'
}, {
  name: 'pickup_indication'
}, {
  name: 'scroll_outgoing'
}, {
  name: 'show_local_line'
}, {
  name: 'show_call_status'
}, {
  name: 'call_waiting'
}, {
  name: 'web_language_w'
}, {
  name: 'language_w'
}, {
  name: 'display_method_w'
}, {
  name: 'call_waiting_w'
}, {
  name: 'mwi_notification_w'
}, {
  name: 'mwi_dialtone_w'
}, {
  name: 'headset_device_w'
}, {
  name: 'message_led_other_w'
}, {
  name: 'global_missed_counter_w'
}, {
  name: 'pickup_indication_w'
}, {
  name: 'scroll_outgoing_w'
}, {
  name: 'show_local_line_w'
}, {
  name: 'show_call_status_w'
}]);
/**
 * @type {Tine.Tinebase.data.Record}
 * Voipmanager record definition
 */

Tine.Voipmanager.Model.SnomSetting = Tine.Tinebase.data.Record.create(Tine.Voipmanager.Model.SnomSettingArray, {
  appName: 'Voipmanager',
  modelName: 'SnomSetting',
  idProperty: 'id',
  titleProperty: 'name',
  // ngettext('Setting', 'Settings', n);
  recordName: 'SnomSetting',
  recordsName: 'SnomSettings',
  containerProperty: 'setting_id',
  // ngettext('setting list', 'settings lists', n);
  containerName: 'setting list',
  containersName: 'setting lists',
  getTitle: function getTitle() {
    return this.get('name') ? this.get('name') : false;
  }
});

Tine.Voipmanager.Model.SnomSetting.getDefaultData = function () {
  return {};
};

Tine.Voipmanager.Model.SnomSetting.getFilterModel = function () {
  return [{
    label: i18n._('Quick Search'),
    field: 'query',
    operators: ['contains']
  }];
};
/**
 * Model of a right
 */


Tine.Voipmanager.Model.SnomPhoneRight = Ext.data.Record.create([{
  name: 'id'
}, {
  name: 'account_id'
}, {
  name: 'account_type'
}, {
  name: 'account_name'
}]);
/*
 *  ASTERISK
 */

Tine.Voipmanager.Model.AsteriskSipPeerArray = Tine.Tinebase.Model.modlogFields.concat([{
  name: 'id'
}, {
  name: 'name'
}, {
  name: 'accountcode'
}, {
  name: 'amaflags'
}, {
  name: 'callgroup'
}, {
  name: 'callerid'
}, {
  name: 'canreinvite'
}, {
  name: 'context_id'
}, {
  name: 'context'
}, {
  name: 'defaultip'
}, {
  name: 'dtmfmode'
}, {
  name: 'fromuser'
}, {
  name: 'fromdomain'
}, {
  name: 'fullcontact'
}, {
  name: 'host'
}, {
  name: 'insecure'
}, {
  name: 'language'
}, {
  name: 'mailbox'
}, {
  name: 'md5secret'
}, {
  name: 'nat'
}, {
  name: 'deny'
}, {
  name: 'permit'
}, {
  name: 'mask'
}, {
  name: 'pickupgroup'
}, {
  name: 'port'
}, {
  name: 'qualify'
}, {
  name: 'restrictcid'
}, {
  name: 'rtptimeout'
}, {
  name: 'rtpholdtimeout'
}, {
  name: 'secret'
}, {
  name: 'type'
}, {
  name: 'defaultuser'
}, {
  name: 'disallow'
}, {
  name: 'allow'
}, {
  name: 'musiconhold'
}, {
  name: 'regseconds',
  type: 'date',
  dateFormat: Date.patterns.ISO8601Long
}, {
  name: 'ipaddr'
}, {
  name: 'regexten'
}, {
  name: 'cancallforward'
}, {
  name: 'setvar'
}, {
  name: 'notifyringing'
}, {
  name: 'useclientcode'
}, {
  name: 'authuser'
}, {
  name: 'call-limit'
}, {
  name: 'busy-level'
}, {
  name: 'cfi_mode'
}, {
  name: 'cfi_number'
}, {
  name: 'cfb_mode'
}, {
  name: 'cfb_number'
}, {
  name: 'cfd_mode'
}, {
  name: 'cfd_number'
}, {
  name: 'cfd_time'
}]);
/**
 * @type {Tine.Tinebase.data.Record}
 * Voipmanager record definition
 */

Tine.Voipmanager.Model.AsteriskSipPeer = Tine.Tinebase.data.Record.create(Tine.Voipmanager.Model.AsteriskSipPeerArray, {
  appName: 'Voipmanager',
  modelName: 'AsteriskSipPeer',
  idProperty: 'id',
  titleProperty: 'name',
  // ngettext('SipPeer', 'SipPeers', n);
  recordName: 'AsteriskSipPeer',
  recordsName: 'AsteriskSipPeers',
  containerProperty: 'sipPeer_id',
  // ngettext('sipPeers list', 'sipPeers lists', n);
  containerName: 'sipPeers list',
  containersName: 'sipPeers lists',
  getTitle: function getTitle() {
    return this.get('name') ? this.get('name') : false;
  }
});

Tine.Voipmanager.Model.AsteriskSipPeer.getDefaultData = function () {
  return {};
};

Tine.Voipmanager.Model.AsteriskSipPeer.getFilterModel = function () {
  if (!app) {
    var app = Tine.Tinebase.appMgr.get('Voipmanager');
  }

  return [{
    label: i18n._('Quick Search'),
    field: 'query',
    operators: ['contains']
  }, {
    label: app.i18n._('Name'),
    field: 'name'
  }];
};

Tine.Voipmanager.Model.AsteriskContextArray = Tine.Tinebase.Model.modlogFields.concat([{
  name: 'id'
}, {
  name: 'name'
}, {
  name: 'description'
}]);
/**
 * @type {Tine.Tinebase.data.Record}
 * Voipmanager record definition
 */

Tine.Voipmanager.Model.AsteriskContext = Tine.Tinebase.data.Record.create(Tine.Voipmanager.Model.AsteriskContextArray, {
  appName: 'Voipmanager',
  modelName: 'AsteriskContext',
  idProperty: 'id',
  titleProperty: 'name',
  // ngettext('Context', 'Contexts', n);
  recordName: 'AsteriskContext',
  recordsName: 'AsteriskContexts',
  containerProperty: 'context_id',
  // ngettext('contexts list', 'contexts lists', n);
  containerName: 'contexts list',
  containersName: 'contexts lists',
  getTitle: function getTitle() {
    return this.get('name') ? this.get('name') : false;
  }
});

Tine.Voipmanager.Model.AsteriskContext.getDefaultData = function () {
  return {};
};

Tine.Voipmanager.Model.AsteriskContext.getFilterModel = function () {
  return [{
    label: i18n._('Quick Search'),
    field: 'query',
    operators: ['contains']
  }];
};

Tine.Voipmanager.Model.AsteriskVoicemailArray = Tine.Tinebase.Model.modlogFields.concat([{
  name: 'id'
}, {
  name: 'context_id'
}, {
  name: 'context'
}, {
  name: 'mailbox'
}, {
  name: 'password'
}, {
  name: 'fullname'
}, {
  name: 'email'
}, {
  name: 'pager'
}, {
  name: 'tz'
}, {
  name: 'attach'
}, {
  name: 'saycid'
}, {
  name: 'dialout'
}, {
  name: 'callback'
}, {
  name: 'review'
}, {
  name: 'operator'
}, {
  name: 'envelope'
}, {
  name: 'sayduration'
}, {
  name: 'saydurationm'
}, {
  name: 'sendvoicemail'
}, {
  name: 'delete'
}, {
  name: 'nextaftercmd'
}, {
  name: 'forcename'
}, {
  name: 'forcegreetings'
}, {
  name: 'hidefromdir'
}]);
/**
 * @type {Tine.Tinebase.data.Record}
 * Voipmanager record definition
 */

Tine.Voipmanager.Model.AsteriskVoicemail = Tine.Tinebase.data.Record.create(Tine.Voipmanager.Model.AsteriskVoicemailArray, {
  appName: 'Voipmanager',
  modelName: 'AsteriskVoicemail',
  idProperty: 'id',
  titleProperty: 'mailbox',
  // ngettext('Voicemail', 'Voicemails', n);
  recordName: 'AsteriskVoicemail',
  recordsName: 'AsteriskVoicemails',
  containerProperty: 'voicemail_id',
  // ngettext('voicemails list', 'voicemails lists', n);
  containerName: 'voicemails list',
  containersName: 'voicemails lists',
  getTitle: function getTitle() {
    return this.get('mailbox') ? this.get('mailbox') : false;
  }
});

Tine.Voipmanager.Model.AsteriskVoicemail.getDefaultData = function () {
  return {};
};

Tine.Voipmanager.Model.AsteriskVoicemail.getFilterModel = function () {
  return [{
    label: i18n._('Quick Search'),
    field: 'query',
    operators: ['contains']
  }];
};

Tine.Voipmanager.Model.AsteriskMeetmeArray = Tine.Tinebase.Model.modlogFields.concat([{
  name: 'id'
}, {
  name: 'confno'
}, {
  name: 'pin'
}, {
  name: 'adminpin'
}]);
/**
 * @type {Tine.Tinebase.data.Record}
 * Voipmanager record definition
 */

Tine.Voipmanager.Model.AsteriskMeetme = Tine.Tinebase.data.Record.create(Tine.Voipmanager.Model.AsteriskMeetmeArray, {
  appName: 'Voipmanager',
  modelName: 'AsteriskMeetme',
  idProperty: 'id',
  titleProperty: 'confno',
  // ngettext('Meetme', 'Meetmes', n);
  recordName: 'AsteriskMeetme',
  recordsName: 'AsteriskMeetmes',
  containerProperty: 'meetme_id',
  // ngettext('meetmes list', 'meetmes lists', n);
  containerName: 'meetmes list',
  containersName: 'meetmes lists',
  getTitle: function getTitle() {
    return this.get('number') ? this.get('number') + ' ' + this.get('confno') : false;
  }
});

Tine.Voipmanager.Model.AsteriskMeetme.getDefaultData = function () {
  return {};
};

Tine.Voipmanager.Model.AsteriskMeetme.getFilterModel = function () {
  return [{
    label: i18n._('Quick Search'),
    field: 'query',
    operators: ['contains']
  }];
};

/***/ }),

/***/ 312:
/***/ (function(module, exports, __webpack_require__) {

/**
 * Tine 2.0
 * 
 * @package     Voipmanager
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Thomas Wadewitz <t.wadewitz@metaways.de>
 * @copyright   Copyright (c) 2007-2009 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 * TODO         perhaps we should load the settings only if settings tab is clicked
 * TODO         don't use json stores for lines/rights
 */
Ext.namespace('Tine.Voipmanager');

__webpack_require__(143);

__webpack_require__(313);
/**
 * Snom Phone Edit Dialog
 */


Tine.Voipmanager.SnomPhoneEditDialog = Ext.extend(Tine.widgets.dialog.EditDialog, {
  /**
   * @private
   */
  windowNamePrefix: 'SnomPhoneEditWindow_',
  appName: 'Voipmanager',
  recordClass: Tine.Voipmanager.Model.SnomPhone,
  recordProxy: null,
  evalGrants: false,

  /**
   * @property {Ext.data.JsonStore}
   */
  rightsStore: null,

  /**
   * @property {Ext.data.JsonStore}
   */
  linesStore: null,

  /**
   * @property {Tine.Voipmanager.LineGridPanel}
   */
  linesGrid: null,

  /**
   * max lines (depending on phone model)
   * 
   * @type Number
   */
  maxLines: 4,

  /**
   * writeable fields (from phone settings)
   * 
   * @type Object
   */
  writeableFields: null,

  /**
   * @property {Locale.Gettext}
   */
  i18n: null,

  /**
   * @private
   * 
   */
  initComponent: function initComponent() {
    this.recordProxy = this.recordProxy == null ? Tine.Voipmanager.SnomPhoneBackend : this.recordProxy; // why the hack is this a jsonStore???

    this.rightsStore = new Ext.data.JsonStore({
      root: 'results',
      totalProperty: 'totalcount',
      id: 'id',
      fields: Tine.Voipmanager.Model.SnomPhoneRight
    }); // why the hack is this a jsonStore???

    this.linesStore = new Ext.data.JsonStore({
      root: 'results',
      totalProperty: 'totalcount',
      id: 'id',
      fields: Tine.Voipmanager.Model.SnomLine
    });
    Tine.Voipmanager.SnomPhoneEditDialog.superclass.initComponent.call(this);
  },

  /**
   * record load (get rights and put them into the store)
   */
  onRecordLoad: function onRecordLoad() {
    var rights = this.record.get('rights') || [];
    this.rightsStore.loadData({
      results: rights
    }); // copy fields from asteriskline_id for lines grid

    var lines = this.record.get('lines') || [];
    var fields = ['cfi_mode', 'cfi_number', 'cfb_mode', 'cfb_number', 'cfd_mode', 'cfd_number', 'cfd_time'];

    for (var j = 0; j < lines.length; j++) {
      for (var i = 0; i < fields.length; i++) {
        lines[j][fields[i]] = lines[j].asteriskline_id[fields[i]];
      }
    }

    this.linesStore.loadData({
      results: lines
    });

    if (this.record.get('setting_id')) {
      this.getWriteableFields(this.record.get('setting_id'));
    }

    Tine.Voipmanager.SnomPhoneEditDialog.superclass.onRecordLoad.call(this);
  },

  /**
   * record update (push rights and lines into record property)
   */
  onRecordUpdate: function onRecordUpdate() {
    Tine.Voipmanager.SnomPhoneEditDialog.superclass.onRecordUpdate.call(this);
    this.record.set('rights', '');
    this.record.set('lines', '');
    var rights = [];
    this.rightsStore.each(function (_record) {
      rights.push(_record.data);
    });
    this.record.set('rights', rights); // save lines / copy fields to asteriskline_id

    var lines = [];
    var fields = ['cfi_mode', 'cfi_number', 'cfb_mode', 'cfb_number', 'cfd_mode', 'cfd_number', 'cfd_time'];
    this.linesStore.each(function (_record) {
      var data = _record.data;

      for (var i = 0; i < fields.length; i++) {
        data.asteriskline_id[fields[i]] = data[fields[i]];
      }

      lines.push(data);
    });
    this.record.set('lines', lines);
  },

  /**
   * 
   * @param {} setting_id
   */
  getWriteableFields: function getWriteableFields(setting_id) {
    Ext.Ajax.request({
      params: {
        method: 'Voipmanager.getSnomSetting',
        id: setting_id
      },
      success: function success(_result, _request) {
        _data = Ext.util.JSON.decode(_result.responseText);
        _writableFields = new Array('web_language', 'language', 'display_method', 'mwi_notification', 'mwi_dialtone', 'headset_device', 'message_led_other', 'global_missed_counter', 'pickup_indication', 'scroll_outgoing', 'show_local_line', 'show_call_status', 'call_waiting');
        this.writeableFields = new Object();

        var _settingsData = new Object();

        Ext.each(_writableFields, function (_item, _index, _all) {
          _rwField = _item.toString() + '_writable'; // update record

          if (_data[_rwField] == '0' || !this.record.get(_item)) {
            this.record.set(_item, _data[_item]);
          } // set writeable fields


          this.getForm().findField(_item).setDisabled(_data[_rwField] == '0');
          this.getForm().findField(_item).setValue(this.record.get(_item));
        }, this);
      },
      failure: function failure(result, request) {
        Ext.MessageBox.alert('Failed', 'No settings data found.');
      },
      scope: this
    });
  },

  /**
   * update settings on template change
   * 
   * @param {} _combo
   * @param {} _record
   * @param {} _index
   */
  onTemplateChange: function onTemplateChange(_combo, _record, _index) {
    var setting_id = false;

    if (_record.data && _record.data.setting_id) {
      setting_id = _record.data.setting_id;
    }

    if (!setting_id && this.getForm().findField('template_id').store.getById(this.getForm().findField('template_id').getValue())) {
      setting_id = this.getForm().findField('template_id').store.getById(this.getForm().findField('template_id').getValue()).data.setting_id;
    }

    if (setting_id) {
      this.getWriteableFields(setting_id);
    }
  },

  /**
   * returns dialog
   * 
   * NOTE: when this method gets called, all initalisation is done.
   */
  getFormItems: function getFormItems() {
    var callForwardPanel = new Tine.Voipmanager.CallForwardPanel({
      app: this.app,
      editDialog: this,
      flex: 1
    });
    this.linesGrid = new Tine.Voipmanager.LineGridPanel({
      store: this.linesStore,
      app: this.app,
      cfPanel: callForwardPanel,
      editDialog: this,
      flex: 1
    });
    this.linesPanel = new Ext.Panel({
      title: this.getTranslations()._('Lines'),
      layout: {
        type: 'hbox',
        align: 'stretch'
      },
      items: [this.linesGrid, callForwardPanel]
    });
    var items = this.recordProxy.appName == 'Voipmanager' ? [this.getPhonePanel(), this.linesPanel, this.getSettingsPanel(), this.getRightsPanel()] : [this.linesPanel, this.getSettingsPanel()];
    return {
      xtype: 'tabpanel',
      border: false,
      plain: true,
      activeTab: 0,
      deferredRender: false,
      items: items
    };
  },

  /**
   * returns general phone panel (first panel)
   * 
   * @return {Object}
   */
  getPhonePanel: function getPhonePanel() {
    return {
      title: this.app.i18n._('Phone'),
      layout: 'hfit',
      frame: true,
      border: false,
      items: [{
        xtype: 'columnform',
        formDefaults: {
          columnWidth: 0.5,
          anchor: '100%',
          labelSeparator: ''
        },
        items: [[{
          xtype: 'textfield',
          name: 'description',
          fieldLabel: this.getTranslations()._('Name'),
          allowBlank: false
        }, {
          xtype: 'combo',
          fieldLabel: this.getTranslations()._('Phone Model'),
          name: 'current_model',
          mode: 'local',
          displayField: 'model',
          valueField: 'id',
          triggerAction: 'all',
          editable: false,
          forceSelection: true,
          store: Tine.Voipmanager.Data.loadPhoneModelData(),
          allowBlank: false
        }], [{
          xtype: 'textfield',
          fieldLabel: this.getTranslations()._('MAC Address'),
          name: 'macaddress',
          maxLength: 12,
          allowBlank: false
        }, {
          xtype: 'reccombo',
          name: 'template_id',
          fieldLabel: this.getTranslations().n_('Template', 'Templates', 1),
          displayField: 'name',
          store: new Ext.data.Store({
            fields: Tine.Voipmanager.Model.SnomTemplate,
            proxy: Tine.Voipmanager.SnomTemplateBackend,
            reader: Tine.Voipmanager.SnomTemplateBackend.getReader(),
            remoteSort: true,
            sortInfo: {
              field: 'name',
              dir: 'ASC'
            }
          }),
          listeners: {
            scope: this,
            select: this.onTemplateChange
          },
          allowBlank: false
        }], [{
          xtype: 'reccombo',
          name: 'location_id',
          fieldLabel: this.getTranslations().n_('Location', 'Locations', 1),
          displayField: 'name',
          store: new Ext.data.Store({
            fields: Tine.Voipmanager.Model.SnomLocation,
            proxy: Tine.Voipmanager.SnomLocationBackend,
            reader: Tine.Voipmanager.SnomLocationBackend.getReader(),
            remoteSort: true,
            sortInfo: {
              field: 'name',
              dir: 'ASC'
            }
          }),
          allowBlank: false
        }]]
      }, {
        title: this.getTranslations()._('infos'),
        autoHeight: true,
        xtype: 'fieldset',
        checkboxToggle: false,
        items: [{
          xtype: 'columnform',
          border: false,
          formDefaults: {
            columnWidth: 0.5,
            anchor: '100%',
            labelSeparator: ''
          },
          items: [[{
            xtype: 'textfield',
            fieldLabel: this.getTranslations()._('Current IP Address'),
            name: 'ipaddress',
            maxLength: 20,
            anchor: '98%',
            readOnly: true
          }, {
            xtype: 'datetimefield',
            fieldLabel: this.getTranslations()._('Firmware last checked at'),
            name: 'firmware_checked_at',
            anchor: '100%',
            emptyText: 'never',
            hideTrigger: true,
            readOnly: true
          }], [{
            xtype: 'textfield',
            fieldLabel: this.getTranslations()._('Current Software Version'),
            name: 'current_software',
            maxLength: 20,
            anchor: '98%',
            readOnly: true
          }, {
            xtype: 'datetimefield',
            fieldLabel: this.getTranslations()._('Settings Loaded at'),
            name: 'settings_loaded_at',
            anchor: '100%',
            emptyText: 'never',
            hideTrigger: true,
            readOnly: true
          }]]
        }]
      }]
    };
  },

  /**
   * returns settings panel (second panel)
   * 
   * @return {Object}
   */
  getSettingsPanel: function getSettingsPanel() {
    return {
      title: this.getTranslations()._('Settings'),
      id: 'settingsBorderLayout',
      frame: true,
      border: false,
      xtype: 'columnform',
      formDefaults: {
        xtype: 'combo',
        anchor: '100%',
        labelSeparator: '',
        columnWidth: .333,
        mode: 'local',
        triggerAction: 'all',
        editable: false,
        forceSelection: true,
        value: null
      },
      items: [[{
        fieldLabel: this.getTranslations()._('web_language'),
        name: 'web_language',
        disabled: this.writeableFields ? this.writeableFields.web_language : true,
        store: [[null, this.getTranslations()._('- factory default -')], ['English', Locale.getTranslationData('Language', 'en')], ['Deutsch', Locale.getTranslationData('Language', 'de')], ['Espanol', Locale.getTranslationData('Language', 'es')], ['Francais', Locale.getTranslationData('Language', 'fr')], ['Italiano', Locale.getTranslationData('Language', 'it')], ['Nederlands', Locale.getTranslationData('Language', 'nl')], ['Portugues', Locale.getTranslationData('Language', 'pt')], ['Suomi', Locale.getTranslationData('Language', 'fi')], ['Svenska', Locale.getTranslationData('Language', 'sv')], ['Dansk', Locale.getTranslationData('Language', 'da')], ['Norsk', Locale.getTranslationData('Language', 'no')]]
      }, {
        fieldLabel: this.getTranslations()._('language'),
        name: 'language',
        disabled: this.writeableFields ? this.writeableFields.language : true,
        store: [[null, this.getTranslations()._('- factory default -')], ['English', Locale.getTranslationData('Language', 'en')], ['English(UK)', Locale.getTranslationData('Language', 'en_GB')], ['Deutsch', Locale.getTranslationData('Language', 'de')], ['Espanol', Locale.getTranslationData('Language', 'es')], ['Francais', Locale.getTranslationData('Language', 'fr')], ['Italiano', Locale.getTranslationData('Language', 'it')], ['Cestina', Locale.getTranslationData('Language', 'cs')], ['Nederlands', Locale.getTranslationData('Language', 'nl')], ['Polski', Locale.getTranslationData('Language', 'pl')], ['Portugues', Locale.getTranslationData('Language', 'pt')], ['Slovencina', Locale.getTranslationData('Language', 'sl')], ['Suomi', Locale.getTranslationData('Language', 'fi')], ['Svenska', Locale.getTranslationData('Language', 'sv')], ['Dansk', Locale.getTranslationData('Language', 'da')], ['Norsk', Locale.getTranslationData('Language', 'no')], ['Japanese', Locale.getTranslationData('Language', 'ja')], ['Chinese', Locale.getTranslationData('Language', 'zh')]]
      }, {
        fieldLabel: this.getTranslations()._('display_method'),
        name: 'display_method',
        disabled: this.writeableFields ? this.writeableFields.display_method : true,
        store: [[null, this.getTranslations()._('- factory default -')], ['full_contact', this.getTranslations()._('whole url')], ['display_name', this.getTranslations()._('name')], ['display_number', this.getTranslations()._('number')], ['display_name_number', this.getTranslations()._('name + number')], ['display_number_name', this.getTranslations()._('number + name')]]
      }], [{
        fieldLabel: this.getTranslations()._('call_waiting'),
        name: 'call_waiting',
        disabled: this.writeableFields ? this.writeableFields.call_waiting : true,
        store: [[null, this.getTranslations()._('- factory default -')], ['on', this.getTranslations()._('on')], ['visual', this.getTranslations()._('visual')], ['ringer', this.getTranslations()._('ringer')], ['off', this.getTranslations()._('off')]]
      }, {
        fieldLabel: this.getTranslations()._('mwi_notification'),
        name: 'mwi_notification',
        disabled: this.writeableFields ? this.writeableFields.mwi_notification : true,
        store: [[null, this.getTranslations()._('- factory default -')], ['silent', this.getTranslations()._('silent')], ['beep', this.getTranslations()._('beep')], ['reminder', this.getTranslations()._('reminder')]]
      }, {
        fieldLabel: this.getTranslations()._('mwi_dialtone'),
        name: 'mwi_dialtone',
        disabled: this.writeableFields ? this.writeableFields.mwi_dialtone : true,
        store: [[null, this.getTranslations()._('- factory default -')], ['normal', this.getTranslations()._('normal')], ['stutter', this.getTranslations()._('stutter')]]
      }], [{
        fieldLabel: this.getTranslations()._('headset_device'),
        name: 'headset_device',
        disabled: this.writeableFields ? this.writeableFields.headset_device : true,
        store: [[null, this.getTranslations()._('- factory default -')], ['none', this.getTranslations()._('none')], ['headset_rj', this.getTranslations()._('headset_rj')]]
      }, {
        fieldLabel: this.getTranslations()._('message_led_other'),
        name: 'message_led_other',
        disabled: this.writeableFields ? this.writeableFields.message_led_other : true,
        store: [[null, this.getTranslations()._('- factory default -')], ['1', this.getTranslations()._('on')], ['0', this.getTranslations()._('off')]]
      }, {
        fieldLabel: this.getTranslations()._('global_missed_counter'),
        name: 'global_missed_counter',
        disabled: this.writeableFields ? this.writeableFields.global_missed_counter : true,
        store: [[null, this.getTranslations()._('- factory default -')], ['1', this.getTranslations()._('on')], ['0', this.getTranslations()._('off')]]
      }], [{
        fieldLabel: this.getTranslations()._('scroll_outgoing'),
        name: 'scroll_outgoing',
        disabled: this.writeableFields ? this.writeableFields.scroll_outgoing : true,
        store: [[null, this.getTranslations()._('- factory default -')], ['1', this.getTranslations()._('on')], ['0', this.getTranslations()._('off')]]
      }, {
        fieldLabel: this.getTranslations()._('show_local_line'),
        name: 'show_local_line',
        disabled: this.writeableFields ? this.writeableFields.show_local_line : true,
        store: [[null, this.getTranslations()._('- factory default -')], ['1', this.getTranslations()._('on')], ['0', this.getTranslations()._('off')]]
      }, {
        fieldLabel: this.getTranslations()._('show_call_status'),
        name: 'show_call_status',
        disabled: this.writeableFields ? this.writeableFields.show_call_status : true,
        store: [[null, this.getTranslations()._('- factory default -')], ['1', this.getTranslations()._('on')], ['0', this.getTranslations()._('off')]]
      }], [{
        fieldLabel: this.getTranslations()._('Pickup indication'),
        name: 'pickup_indication',
        disabled: this.writeableFields ? this.writeableFields.pickup_indication : true,
        store: [[null, this.getTranslations()._('- factory default -')], ['1', this.getTranslations()._('on')], ['0', this.getTranslations()._('off')]]
      }]]
    };
  },

  /**
   * returns right panel (fourth panel)
   * 
   * @return {Object}
   */
  getRightsPanel: function getRightsPanel() {
    return {
      title: this.getTranslations()._('Users'),
      layout: 'fit',
      items: new Tine.widgets.account.PickerGridPanel({
        accountPickerType: 'both',
        store: this.rightsStore,
        hasAccountPrefix: true
      })
    };
  },

  /**
   * get translations
   * 
   * @return {Locale.Gettext}
   */
  getTranslations: function getTranslations() {
    if (this.i18n == null) {
      // we need to init translations because it could be that we call this from Phone app without Voipmanager
      if (!this.app) {
        this.i18n = new Locale.Gettext();
        this.i18n.textdomain('Voipmanager');
      } else {
        this.i18n = this.app.i18n;
      }
    }

    return this.i18n;
  }
});
/**
 * Snom Phone Edit Popup
 */

Tine.Voipmanager.SnomPhoneEditDialog.openWindow = function (config) {
  var id = config.record && config.record.id ? config.record.id : 0;
  var window = Tine.WindowFactory.getWindow({
    width: 800,
    height: 350,
    name: Tine.Voipmanager.SnomPhoneEditDialog.prototype.windowNamePrefix + id,
    contentPanelConstructor: 'Tine.Voipmanager.SnomPhoneEditDialog',
    contentPanelConstructorConfig: config
  });
  return window;
};

/***/ }),

/***/ 313:
/***/ (function(module, exports, __webpack_require__) {

/*
 * Tine 2.0
 * 
 * @package     Tinebase
 * @subpackage  widgets
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Philipp Schüle <p.schuele@metaways.de>
 * @copyright   Copyright (c) 2010-2011 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 */
Ext.namespace('Tine.Voipmanager');

__webpack_require__(143);
/**
 * Line Picker GridPanel
 * 
 * @namespace   Tine.Voipmanager
 * @class       Tine.Voipmanager.LineGridPanel
 * @extends     Tine.widgets.grid.PickerGridPanel
 * 
 * <p>Line Picker GridPanel</p>
 * <p><pre>
 * TODO         check max number of lines ?
 * </pre></p>
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Philipp Schuele <p.schuele@metaways.de>
 * @copyright   Copyright (c) 2010 Metaways Infosystems GmbH (http://www.metaways.de)
 * 
 * @param       {Object} config
 * @constructor
 * Create a new Tine.Voipmanager.LineGridPanel
 */


Tine.Voipmanager.LineGridPanel = Ext.extend(Tine.widgets.grid.PickerGridPanel, {
  /**
   * 
   * @type tinebase app 
   */
  app: null,

  /**
   * 
   * @type Tine.Voipmanager.CallForwardPanel
   */
  cfPanel: null,

  /**
   * Tine record
   * @type 
   */
  activeRecord: null,

  /**
   * @type Tine.widgets.dialog.EditDialog
   */
  editDialog: null,

  /**
   * 
   * @cfg
   */
  clicksToEdit: 2,
  autoExpandColumn: 'name',
  // needed to select the first row after render!
  deferRowRender: false,

  /**
   * @private
   */
  initComponent: function initComponent() {
    this.recordClass = Tine.Voipmanager.Model.SnomLine;
    this.searchRecordClass = Tine.Voipmanager.Model.AsteriskSipPeer;
    this.cfPanel.on('change', this.onFieldChange, this);
    this.cfPanel.setDisabled(true);
    Tine.Voipmanager.LineGridPanel.superclass.initComponent.call(this);
    this.on('afterrender', this.onAfterRender, this);
    this.store.on('load', this.onStoreLoad, this);
  },

  /**
   * select first row after render
   */
  onAfterRender: function onAfterRender() {
    if (this.store.getCount() > 0) {
      this.getSelectionModel().selectFirstRow();
    }
  },

  /**
   * select first row after render
   */
  onStoreLoad: function onStoreLoad(store, records, options) {
    if (this.rendered && records.length > 0) {
      var index = store.indexOf(records[0]),
          row = this.getView().getRow(index);
      Ext.fly(row).highlight();
      this.getSelectionModel().selectRow(index);
    }
  },

  /**
   * on call forward form field change: update store
   */
  onFieldChange: function onFieldChange() {
    this.editDialog.getForm().updateRecord(this.activeRecord);
    this.getView().refresh();
  },

  /**
   * Return CSS class to apply to rows depending upon record state
   * 
   * @param {} record
   * @param {Integer} index
   * @return {String}
   */
  getViewRowClass: function getViewRowClass(record, index) {
    var result = '';

    if (record.dirty) {
      result = 'voipmanager-row-changed';
    }

    return result;
  },

  /**
   * init actions and toolbars
   */
  initActionsAndToolbars: function initActionsAndToolbars() {
    Tine.Voipmanager.LineGridPanel.superclass.initActionsAndToolbars.call(this); // only allow to add new lines from Voipmanager

    if (this.editDialog.recordProxy.appName == 'Voipmanager') {
      this.searchCombo = this.getSearchCombo();
      this.comboPanel = new Ext.Panel({
        layout: 'hfit',
        border: false,
        items: this.searchCombo,
        columnWidth: 1
      });
      this.tbar = new Ext.Toolbar({
        items: [this.comboPanel],
        layout: 'column'
      });
    }
  },

  /**
   * Is called when a record gets selected in the picker combo
   * 
   * @param {Ext.form.ComboBox} picker
   * @param {Record} recordToAdd
   */
  onAddRecordFromCombo: function onAddRecordFromCombo(picker, recordToAdd) {
    if (!recordToAdd) {
      return;
    }

    var recordData = {
      asteriskline_id: recordToAdd.data,
      linenumber: this.store.getCount() + 1,
      lineactive: 1
    };
    var record = new Tine.Voipmanager.Model.SnomLine(recordData);
    var fields = ['cfi_mode', 'cfi_number', 'cfb_mode', 'cfb_number', 'cfd_mode', 'cfd_number', 'cfd_time'];

    for (var i = 0; i < fields.length; i++) {
      record.data[fields[i]] = recordToAdd.data[fields[i]];
    } // check if already in


    var found = false;
    this.store.each(function (line) {
      if (line.data.asteriskline_id.id == recordToAdd.data.id) {
        found = true;
      }

      if (line.get('linenumber') == record.get('linenumber')) {
        // use next linenumber
        // TODO should be improved, maybe server should decide which (free) linenumber should be used
        record.set('linenumber', line.get('linenumber') + 1);
      }
    }, this);

    if (!found) {
      // if not found -> add
      this.store.add([record]);
    }

    picker.reset();
  },

  /**
   * init selection model
   */
  initGrid: function initGrid() {
    Tine.Voipmanager.LineGridPanel.superclass.initGrid.call(this);
    this.selModel.on('selectionchange', this.onSelectionChange, this); // init view

    this.view = new Ext.grid.GridView({
      getRowClass: this.getViewRowClass,
      autoFill: true,
      forceFit: true
    });
  },

  /**
   * on selection change handler
   * @param {} sm
   */
  onSelectionChange: function onSelectionChange(sm) {
    var rowCount = sm.getCount();

    if (rowCount == 1) {
      var selectedRows = sm.getSelections();
      this.activeRecord = selectedRows[0];
      this.cfPanel.setDisabled(false); //this.cfPanel.getForm().loadRecord(this.activeRecord);

      this.editDialog.getForm().loadRecord(this.activeRecord);
      this.cfPanel.onRecordLoad(this.activeRecord);
    } else {
      //this.cfPanel.getForm().reset();
      this.cfPanel.setDisabled(true);
    } // only allow to remove lines from Voipmanager and if rowCount > 0


    this.actionRemove.setDisabled(this.editDialog.recordProxy.appName != 'Voipmanager' || rowCount == 0);
  },

  /**
   * @return Ext.grid.ColumnModel
   * @private
   */
  getColumnModel: function getColumnModel() {
    if (!this.colModel) {
      // we need to init translations because it could be that we call this from Phone app without Voipmanager
      var translations;

      if (!this.app) {
        translations = new Locale.Gettext();
        translations.textdomain('Voipmanager');
      } else {
        translations = this.app.i18n;
      }

      this.colModel = new Ext.grid.ColumnModel({
        defaults: {
          sortable: true
        },
        columns: [{
          id: 'linenumber',
          header: '',
          dataIndex: 'linenumber',
          width: 20
        }, {
          id: 'name',
          header: translations._('Line'),
          dataIndex: 'asteriskline_id',
          width: 120,
          renderer: this.nameRenderer
        }, {
          id: 'idletext',
          header: translations._('Idle Text'),
          dataIndex: 'idletext',
          width: 100,
          editor: new Ext.form.TextField({
            allowBlank: false,
            allowNegative: false,
            maxLength: 60
          })
        }]
      });
    }

    return this.colModel;
  },
  nameRenderer: function nameRenderer(value) {
    return value && value.name ? value.name : '';
  },
  initFilterPanel: function initFilterPanel() {}
});

/***/ }),

/***/ 35:
/***/ (function(module, exports) {


/**
 * When source maps are enabled, `style-loader` uses a link element with a data-uri to
 * embed the css on the page. This breaks all relative urls because now they are relative to a
 * bundle instead of the current page.
 *
 * One solution is to only use full urls, but that may be impossible.
 *
 * Instead, this function "fixes" the relative urls to be absolute according to the current page location.
 *
 * A rudimentary test suite is located at `test/fixUrls.js` and can be run via the `npm test` command.
 *
 */

module.exports = function (css) {
  // get current location
  var location = typeof window !== "undefined" && window.location;

  if (!location) {
    throw new Error("fixUrls requires window.location");
  }

	// blank or null?
	if (!css || typeof css !== "string") {
	  return css;
  }

  var baseUrl = location.protocol + "//" + location.host;
  var currentDir = baseUrl + location.pathname.replace(/\/[^\/]*$/, "/");

	// convert each url(...)
	/*
	This regular expression is just a way to recursively match brackets within
	a string.

	 /url\s*\(  = Match on the word "url" with any whitespace after it and then a parens
	   (  = Start a capturing group
	     (?:  = Start a non-capturing group
	         [^)(]  = Match anything that isn't a parentheses
	         |  = OR
	         \(  = Match a start parentheses
	             (?:  = Start another non-capturing groups
	                 [^)(]+  = Match anything that isn't a parentheses
	                 |  = OR
	                 \(  = Match a start parentheses
	                     [^)(]*  = Match anything that isn't a parentheses
	                 \)  = Match a end parentheses
	             )  = End Group
              *\) = Match anything and then a close parens
          )  = Close non-capturing group
          *  = Match anything
       )  = Close capturing group
	 \)  = Match a close parens

	 /gi  = Get all matches, not the first.  Be case insensitive.
	 */
	var fixedCss = css.replace(/url\s*\(((?:[^)(]|\((?:[^)(]+|\([^)(]*\))*\))*)\)/gi, function(fullMatch, origUrl) {
		// strip quotes (if they exist)
		var unquotedOrigUrl = origUrl
			.trim()
			.replace(/^"(.*)"$/, function(o, $1){ return $1; })
			.replace(/^'(.*)'$/, function(o, $1){ return $1; });

		// already a full url? no change
		if (/^(#|data:|http:\/\/|https:\/\/|file:\/\/\/)/i.test(unquotedOrigUrl)) {
		  return fullMatch;
		}

		// convert the url to a full url
		var newUrl;

		if (unquotedOrigUrl.indexOf("//") === 0) {
		  	//TODO: should we add protocol?
			newUrl = unquotedOrigUrl;
		} else if (unquotedOrigUrl.indexOf("/") === 0) {
			// path should be relative to the base url
			newUrl = baseUrl + unquotedOrigUrl; // already starts with '/'
		} else {
			// path should be relative to current directory
			newUrl = currentDir + unquotedOrigUrl.replace(/^\.\//, ""); // Strip leading './'
		}

		// send back the fixed url(...)
		return "url(" + JSON.stringify(newUrl) + ")";
	});

	// send back the fixed css
	return fixedCss;
};


/***/ }),

/***/ 96:
/***/ (function(module, exports, __webpack_require__) {

/* pkg: Voipmanager FAT Client (js/Voipmanager-FAT.js)*/
__webpack_require__(311);
__webpack_require__(2127);
__webpack_require__(2128);
__webpack_require__(2129);
__webpack_require__(2130);
__webpack_require__(2131);
__webpack_require__(2132);
__webpack_require__(2133);
__webpack_require__(312);
__webpack_require__(2134);
__webpack_require__(2135);
__webpack_require__(2136);
__webpack_require__(2137);
__webpack_require__(2138);
__webpack_require__(2139);
__webpack_require__(2140);
__webpack_require__(2141);
__webpack_require__(2142);
__webpack_require__(2143);
__webpack_require__(2144);
__webpack_require__(2145);
__webpack_require__(2146);
/* pkg: Voipmanager FAT Client (css/Voipmanager-FAT.css)*/
__webpack_require__(2147);


/***/ }),

/***/ 98:
/***/ (function(module, exports) {

module.exports = function escape(url) {
    if (typeof url !== 'string') {
        return url
    }
    // If url is already wrapped in quotes, remove them
    if (/^['"].*['"]$/.test(url)) {
        url = url.slice(1, -1);
    }
    // Should url be wrapped?
    // See https://drafts.csswg.org/css-values-3/#urls
    if (/["'() \t\n]/.test(url)) {
        return '"' + url.replace(/"/g, '\\"').replace(/\n/g, '\\n') + '"'
    }

    return url
}


/***/ })

}]);