(window["webpackJsonp"] = window["webpackJsonp"] || []).push([[14],{

/***/ 10:
/***/ (function(module, exports) {

/*
	MIT License http://www.opensource.org/licenses/mit-license.php
	Author Tobias Koppers @sokra
*/
// css base code, injected by the css-loader
module.exports = function(useSourceMap) {
	var list = [];

	// return the list of modules as css string
	list.toString = function toString() {
		return this.map(function (item) {
			var content = cssWithMappingToString(item, useSourceMap);
			if(item[2]) {
				return "@media " + item[2] + "{" + content + "}";
			} else {
				return content;
			}
		}).join("");
	};

	// import a list of modules into the list
	list.i = function(modules, mediaQuery) {
		if(typeof modules === "string")
			modules = [[null, modules, ""]];
		var alreadyImportedModules = {};
		for(var i = 0; i < this.length; i++) {
			var id = this[i][0];
			if(typeof id === "number")
				alreadyImportedModules[id] = true;
		}
		for(i = 0; i < modules.length; i++) {
			var item = modules[i];
			// skip already imported module
			// this implementation is not 100% perfect for weird media query combinations
			//  when a module is imported multiple times with different media queries.
			//  I hope this will never occur (Hey this way we have smaller bundles)
			if(typeof item[0] !== "number" || !alreadyImportedModules[item[0]]) {
				if(mediaQuery && !item[2]) {
					item[2] = mediaQuery;
				} else if(mediaQuery) {
					item[2] = "(" + item[2] + ") and (" + mediaQuery + ")";
				}
				list.push(item);
			}
		}
	};
	return list;
};

function cssWithMappingToString(item, useSourceMap) {
	var content = item[1] || '';
	var cssMapping = item[3];
	if (!cssMapping) {
		return content;
	}

	if (useSourceMap && typeof btoa === 'function') {
		var sourceMapping = toComment(cssMapping);
		var sourceURLs = cssMapping.sources.map(function (source) {
			return '/*# sourceURL=' + cssMapping.sourceRoot + source + ' */'
		});

		return [content].concat(sourceURLs).concat([sourceMapping]).join('\n');
	}

	return [content].join('\n');
}

// Adapted from convert-source-map (MIT)
function toComment(sourceMap) {
	// eslint-disable-next-line no-undef
	var base64 = btoa(unescape(encodeURIComponent(JSON.stringify(sourceMap))));
	var data = 'sourceMappingURL=data:application/json;charset=utf-8;base64,' + base64;

	return '/*# ' + data + ' */';
}


/***/ }),

/***/ 11:
/***/ (function(module, exports, __webpack_require__) {

/*
	MIT License http://www.opensource.org/licenses/mit-license.php
	Author Tobias Koppers @sokra
*/

var stylesInDom = {};

var	memoize = function (fn) {
	var memo;

	return function () {
		if (typeof memo === "undefined") memo = fn.apply(this, arguments);
		return memo;
	};
};

var isOldIE = memoize(function () {
	// Test for IE <= 9 as proposed by Browserhacks
	// @see http://browserhacks.com/#hack-e71d8692f65334173fee715c222cb805
	// Tests for existence of standard globals is to allow style-loader
	// to operate correctly into non-standard environments
	// @see https://github.com/webpack-contrib/style-loader/issues/177
	return window && document && document.all && !window.atob;
});

var getElement = (function (fn) {
	var memo = {};

	return function(selector) {
		if (typeof memo[selector] === "undefined") {
			var styleTarget = fn.call(this, selector);
			// Special case to return head of iframe instead of iframe itself
			if (styleTarget instanceof window.HTMLIFrameElement) {
				try {
					// This will throw an exception if access to iframe is blocked
					// due to cross-origin restrictions
					styleTarget = styleTarget.contentDocument.head;
				} catch(e) {
					styleTarget = null;
				}
			}
			memo[selector] = styleTarget;
		}
		return memo[selector]
	};
})(function (target) {
	return document.querySelector(target)
});

var singleton = null;
var	singletonCounter = 0;
var	stylesInsertedAtTop = [];

var	fixUrls = __webpack_require__(35);

module.exports = function(list, options) {
	if (typeof DEBUG !== "undefined" && DEBUG) {
		if (typeof document !== "object") throw new Error("The style-loader cannot be used in a non-browser environment");
	}

	options = options || {};

	options.attrs = typeof options.attrs === "object" ? options.attrs : {};

	// Force single-tag solution on IE6-9, which has a hard limit on the # of <style>
	// tags it will allow on a page
	if (!options.singleton && typeof options.singleton !== "boolean") options.singleton = isOldIE();

	// By default, add <style> tags to the <head> element
	if (!options.insertInto) options.insertInto = "head";

	// By default, add <style> tags to the bottom of the target
	if (!options.insertAt) options.insertAt = "bottom";

	var styles = listToStyles(list, options);

	addStylesToDom(styles, options);

	return function update (newList) {
		var mayRemove = [];

		for (var i = 0; i < styles.length; i++) {
			var item = styles[i];
			var domStyle = stylesInDom[item.id];

			domStyle.refs--;
			mayRemove.push(domStyle);
		}

		if(newList) {
			var newStyles = listToStyles(newList, options);
			addStylesToDom(newStyles, options);
		}

		for (var i = 0; i < mayRemove.length; i++) {
			var domStyle = mayRemove[i];

			if(domStyle.refs === 0) {
				for (var j = 0; j < domStyle.parts.length; j++) domStyle.parts[j]();

				delete stylesInDom[domStyle.id];
			}
		}
	};
};

function addStylesToDom (styles, options) {
	for (var i = 0; i < styles.length; i++) {
		var item = styles[i];
		var domStyle = stylesInDom[item.id];

		if(domStyle) {
			domStyle.refs++;

			for(var j = 0; j < domStyle.parts.length; j++) {
				domStyle.parts[j](item.parts[j]);
			}

			for(; j < item.parts.length; j++) {
				domStyle.parts.push(addStyle(item.parts[j], options));
			}
		} else {
			var parts = [];

			for(var j = 0; j < item.parts.length; j++) {
				parts.push(addStyle(item.parts[j], options));
			}

			stylesInDom[item.id] = {id: item.id, refs: 1, parts: parts};
		}
	}
}

function listToStyles (list, options) {
	var styles = [];
	var newStyles = {};

	for (var i = 0; i < list.length; i++) {
		var item = list[i];
		var id = options.base ? item[0] + options.base : item[0];
		var css = item[1];
		var media = item[2];
		var sourceMap = item[3];
		var part = {css: css, media: media, sourceMap: sourceMap};

		if(!newStyles[id]) styles.push(newStyles[id] = {id: id, parts: [part]});
		else newStyles[id].parts.push(part);
	}

	return styles;
}

function insertStyleElement (options, style) {
	var target = getElement(options.insertInto)

	if (!target) {
		throw new Error("Couldn't find a style target. This probably means that the value for the 'insertInto' parameter is invalid.");
	}

	var lastStyleElementInsertedAtTop = stylesInsertedAtTop[stylesInsertedAtTop.length - 1];

	if (options.insertAt === "top") {
		if (!lastStyleElementInsertedAtTop) {
			target.insertBefore(style, target.firstChild);
		} else if (lastStyleElementInsertedAtTop.nextSibling) {
			target.insertBefore(style, lastStyleElementInsertedAtTop.nextSibling);
		} else {
			target.appendChild(style);
		}
		stylesInsertedAtTop.push(style);
	} else if (options.insertAt === "bottom") {
		target.appendChild(style);
	} else if (typeof options.insertAt === "object" && options.insertAt.before) {
		var nextSibling = getElement(options.insertInto + " " + options.insertAt.before);
		target.insertBefore(style, nextSibling);
	} else {
		throw new Error("[Style Loader]\n\n Invalid value for parameter 'insertAt' ('options.insertAt') found.\n Must be 'top', 'bottom', or Object.\n (https://github.com/webpack-contrib/style-loader#insertat)\n");
	}
}

function removeStyleElement (style) {
	if (style.parentNode === null) return false;
	style.parentNode.removeChild(style);

	var idx = stylesInsertedAtTop.indexOf(style);
	if(idx >= 0) {
		stylesInsertedAtTop.splice(idx, 1);
	}
}

function createStyleElement (options) {
	var style = document.createElement("style");

	options.attrs.type = "text/css";

	addAttrs(style, options.attrs);
	insertStyleElement(options, style);

	return style;
}

function createLinkElement (options) {
	var link = document.createElement("link");

	options.attrs.type = "text/css";
	options.attrs.rel = "stylesheet";

	addAttrs(link, options.attrs);
	insertStyleElement(options, link);

	return link;
}

function addAttrs (el, attrs) {
	Object.keys(attrs).forEach(function (key) {
		el.setAttribute(key, attrs[key]);
	});
}

function addStyle (obj, options) {
	var style, update, remove, result;

	// If a transform function was defined, run it on the css
	if (options.transform && obj.css) {
	    result = options.transform(obj.css);

	    if (result) {
	    	// If transform returns a value, use that instead of the original css.
	    	// This allows running runtime transformations on the css.
	    	obj.css = result;
	    } else {
	    	// If the transform function returns a falsy value, don't add this css.
	    	// This allows conditional loading of css
	    	return function() {
	    		// noop
	    	};
	    }
	}

	if (options.singleton) {
		var styleIndex = singletonCounter++;

		style = singleton || (singleton = createStyleElement(options));

		update = applyToSingletonTag.bind(null, style, styleIndex, false);
		remove = applyToSingletonTag.bind(null, style, styleIndex, true);

	} else if (
		obj.sourceMap &&
		typeof URL === "function" &&
		typeof URL.createObjectURL === "function" &&
		typeof URL.revokeObjectURL === "function" &&
		typeof Blob === "function" &&
		typeof btoa === "function"
	) {
		style = createLinkElement(options);
		update = updateLink.bind(null, style, options);
		remove = function () {
			removeStyleElement(style);

			if(style.href) URL.revokeObjectURL(style.href);
		};
	} else {
		style = createStyleElement(options);
		update = applyToTag.bind(null, style);
		remove = function () {
			removeStyleElement(style);
		};
	}

	update(obj);

	return function updateStyle (newObj) {
		if (newObj) {
			if (
				newObj.css === obj.css &&
				newObj.media === obj.media &&
				newObj.sourceMap === obj.sourceMap
			) {
				return;
			}

			update(obj = newObj);
		} else {
			remove();
		}
	};
}

var replaceText = (function () {
	var textStore = [];

	return function (index, replacement) {
		textStore[index] = replacement;

		return textStore.filter(Boolean).join('\n');
	};
})();

function applyToSingletonTag (style, index, remove, obj) {
	var css = remove ? "" : obj.css;

	if (style.styleSheet) {
		style.styleSheet.cssText = replaceText(index, css);
	} else {
		var cssNode = document.createTextNode(css);
		var childNodes = style.childNodes;

		if (childNodes[index]) style.removeChild(childNodes[index]);

		if (childNodes.length) {
			style.insertBefore(cssNode, childNodes[index]);
		} else {
			style.appendChild(cssNode);
		}
	}
}

function applyToTag (style, obj) {
	var css = obj.css;
	var media = obj.media;

	if(media) {
		style.setAttribute("media", media)
	}

	if(style.styleSheet) {
		style.styleSheet.cssText = css;
	} else {
		while(style.firstChild) {
			style.removeChild(style.firstChild);
		}

		style.appendChild(document.createTextNode(css));
	}
}

function updateLink (link, options, obj) {
	var css = obj.css;
	var sourceMap = obj.sourceMap;

	/*
		If convertToAbsoluteUrls isn't defined, but sourcemaps are enabled
		and there is no publicPath defined then lets turn convertToAbsoluteUrls
		on by default.  Otherwise default to the convertToAbsoluteUrls option
		directly
	*/
	var autoFixUrls = options.convertToAbsoluteUrls === undefined && sourceMap;

	if (options.convertToAbsoluteUrls || autoFixUrls) {
		css = fixUrls(css);
	}

	if (sourceMap) {
		// http://stackoverflow.com/a/26603875
		css += "\n/*# sourceMappingURL=data:application/json;base64," + btoa(unescape(encodeURIComponent(JSON.stringify(sourceMap)))) + " */";
	}

	var blob = new Blob([css], { type: "text/css" });

	var oldSrc = link.href;

	link.href = URL.createObjectURL(blob);

	if(oldSrc) URL.revokeObjectURL(oldSrc);
}


/***/ }),

/***/ 143:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 * 
 * @package     Voipmanager
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Philipp Schuele <p.schuele@metaways.de>
 * @copyright   Copyright (c) 2010 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 */
Ext.namespace('Tine.Voipmanager');
/**
 * Account Picker GridPanel
 * 
 * @namespace   Tine.Voipmanager
 * @class       Tine.Voipmanager.CallForwardPanel
 * @extends     Ext.Panel
 * 
 * <p>Call Forward Form Panel</p>
 * <p><pre>
 * </pre></p>
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Philipp Schuele <p.schuele@metaways.de>
 * @copyright   Copyright (c) 2010 Metaways Infosystems GmbH (http://www.metaways.de)
 * 
 * @param       {Object} config
 * @constructor
 * Create a new Tine.Voipmanager.CallForwardPanel
 */

Tine.Voipmanager.CallForwardPanel = Ext.extend(Ext.Panel, {
  /**
   * @cfg
   */
  border: false,
  frame: true,
  anchor: '100%',

  /**
   * @type Tine.Tinebase.data.Record
   */
  record: null,

  /**
   * @type Tine.widgets.dialog.EditDialog
   */
  editDialog: null,

  /**
   * @private
   */
  initComponent: function initComponent() {
    this.addEvents(
    /**
     * @event change
     * Fired when one of the input fields changed
     */
    'change');
    this.items = this.getFormItems();
    Tine.Voipmanager.CallForwardPanel.superclass.initComponent.call(this);
    this.on('afterrender', this.onAfterRender, this);
  },

  /**
   * returns dialog
   * 
   * NOTE: when this method gets called, all initalisation is done.
   */
  getFormItems: function getFormItems() {
    // we need to init translations because it could be that we call this from Phone app without Voipmanager
    var translations;

    if (!this.app) {
      translations = new Locale.Gettext();
      translations.textdomain('Voipmanager');
    } else {
      translations = this.app.i18n;
    }

    return [{
      title: translations._('Forward immediately'),
      autoHeight: true,
      xtype: 'fieldset',
      layout: 'form',
      defaults: {
        anchor: '100%'
      },
      items: [{
        name: 'cfi_mode',
        xtype: 'combo',
        fieldLabel: translations._('Mode'),
        typeAhead: true,
        triggerAction: 'all',
        lazyRender: true,
        allowBlank: false,
        editable: false,
        blurOnSelect: true,
        value: 'off',
        store: [['off', 'off'], ['number', 'number'], ['voicemail', 'voicemail']],
        listeners: {
          scope: this,
          select: function select(combo, record) {
            // disable number if != number
            this.editDialog.getForm().findField('cfi_number').setDisabled(record.data.field1 != 'number');
            this.onFieldChange();
          }
        }
      }, {
        name: 'cfi_number',
        fieldLabel: translations._('Number'),
        xtype: 'textfield',
        enableKeyEvents: true,
        listeners: {
          keyup: this.onFieldChange,
          scope: this
        }
      }]
    }, {
      title: translations._('Forward busy'),
      autoHeight: true,
      xtype: 'fieldset',
      layout: 'form',
      defaults: {
        anchor: '100%'
      },
      items: [{
        name: 'cfb_mode',
        xtype: 'combo',
        fieldLabel: translations._('Mode'),
        typeAhead: true,
        triggerAction: 'all',
        lazyRender: true,
        allowBlank: false,
        editable: false,
        blurOnSelect: true,
        value: 'off',
        store: [['off', 'off'], ['number', 'number'], ['voicemail', 'voicemail']],
        listeners: {
          scope: this,
          select: function select(combo, record) {
            this.editDialog.getForm().findField('cfb_number').setDisabled(record.data.field1 != 'number');
            this.onFieldChange();
          }
        }
      }, {
        name: 'cfb_number',
        fieldLabel: translations._('Number'),
        xtype: 'textfield',
        enableKeyEvents: true,
        listeners: {
          keyup: this.onFieldChange,
          scope: this
        }
      }]
    }, {
      title: translations._('Forward delayed'),
      autoHeight: true,
      xtype: 'fieldset',
      layout: 'form',
      defaults: {
        anchor: '100%'
      },
      items: [{
        name: 'cfd_mode',
        xtype: 'combo',
        fieldLabel: translations._('Mode'),
        typeAhead: true,
        triggerAction: 'all',
        lazyRender: true,
        allowBlank: false,
        editable: false,
        blurOnSelect: true,
        value: 'off',
        store: [['off', 'off'], ['number', 'number'], ['voicemail', 'voicemail']],
        listeners: {
          scope: this,
          select: function select(combo, record) {
            this.editDialog.getForm().findField('cfd_number').setDisabled(record.data.field1 != 'number');
            this.editDialog.getForm().findField('cfd_time').setDisabled(record.data.field1 == 'off');
            this.onFieldChange();
          }
        }
      }, {
        name: 'cfd_number',
        fieldLabel: translations._('Number'),
        xtype: 'textfield',
        enableKeyEvents: true,
        listeners: {
          keyup: this.onFieldChange,
          scope: this
        }
      }, {
        name: 'cfd_time',
        fieldLabel: translations._('Delay time'),
        xtype: 'numberfield',
        allowNegative: false,
        value: 30,
        enableKeyEvents: true,
        listeners: {
          keyup: this.onFieldChange,
          scope: this
        }
      }]
    }];
  },

  /**
   * disable some fields after render
   */
  onAfterRender: function onAfterRender() {
    if (this.record !== null) {
      this.disableFields();
    }
  },

  /**
   * 
   * @param {Object} record
   */
  onRecordLoad: function onRecordLoad(record) {
    this.record = record;

    if (this.rendered) {
      this.disableFields();
    }
  },

  /**
   * fire change event if field changes
   */
  onFieldChange: function onFieldChange() {
    this.fireEvent('change');
  },
  disableFields: function disableFields() {
    this.editDialog.getForm().findField('cfi_number').setDisabled(this.record.data.cfi_mode != 'number');
    this.editDialog.getForm().findField('cfb_number').setDisabled(this.record.data.cfb_mode != 'number');
    this.editDialog.getForm().findField('cfd_number').setDisabled(this.record.data.cfd_mode != 'number');
    this.editDialog.getForm().findField('cfd_time').setDisabled(this.record.data.cfd_mode == 'off');
  }
});

/***/ }),

/***/ 169:
/***/ (function(module, exports) {

module.exports = "\"data:image/svg+xml,%3C?xml version='1.0' encoding='utf-8'?%3E %3C!-- Generator: Adobe Illustrator 21.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0) --%3E %3Csvg version='1.1' id='Ebene_1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' x='0px' y='0px' viewBox='0 0 42.5 42.5' style='enable-background:new 0 0 42.5 42.5;' xml:space='preserve' width='42.5' height='42.5'%3E %3Cpath id='Icon_Phone' d='M35.3,29.4c0,0.4-0.1,0.8-0.2,1.4c-0.1,0.6-0.3,1-0.4,1.4c-0.3,0.7-1.1,1.4-2.5,2.1c-1.3,0.7-2.5,1-3.7,1 c-0.4,0-0.7,0-1.1-0.1s-0.7-0.1-1.2-0.3s-0.7-0.2-0.9-0.3c-0.2-0.1-0.6-0.2-1.1-0.4s-0.9-0.3-1-0.4c-1.3-0.5-2.5-1-3.5-1.7 c-1.7-1.1-3.5-2.5-5.3-4.3c-1.8-1.8-3.3-3.6-4.3-5.3c-0.6-1-1.2-2.2-1.7-3.5c0-0.1-0.2-0.4-0.4-1c-0.2-0.5-0.3-0.9-0.4-1.1 S7.4,16.5,7.3,16c-0.1-0.4-0.2-0.8-0.3-1.2C7,14.5,7,14.2,7,13.8c0-1.2,0.3-2.5,1-3.7c0.8-1.4,1.5-2.2,2.1-2.5 c0.3-0.1,0.8-0.3,1.4-0.4S12.6,7,13,7c0.2,0,0.3,0,0.4,0.1c0.2,0.1,0.6,0.6,1.1,1.5c0.1,0.3,0.3,0.6,0.6,1.1 c0.3,0.5,0.5,0.9,0.7,1.3c0.2,0.4,0.4,0.7,0.6,1.1c0,0.1,0.2,0.2,0.4,0.5c0.2,0.3,0.3,0.5,0.4,0.7s0.1,0.4,0.1,0.6 c0,0.3-0.2,0.6-0.6,1c-0.4,0.4-0.8,0.8-1.2,1.1s-0.9,0.7-1.2,1.1c-0.4,0.4-0.6,0.7-0.6,0.9c0,0.1,0,0.3,0.1,0.5 c0.1,0.2,0.1,0.3,0.2,0.4s0.1,0.3,0.3,0.5c0.1,0.2,0.2,0.4,0.2,0.4c1,1.8,2.2,3.4,3.5,4.7c1.3,1.3,2.9,2.5,4.7,3.5 c0,0,0.2,0.1,0.4,0.2c0.2,0.1,0.4,0.2,0.5,0.3s0.2,0.1,0.4,0.2c0.2,0.1,0.3,0.1,0.5,0.1c0.2,0,0.6-0.2,0.9-0.6 c0.4-0.4,0.7-0.8,1.1-1.2c0.3-0.4,0.7-0.9,1.1-1.2c0.4-0.4,0.7-0.6,1-0.6c0.2,0,0.4,0,0.6,0.1s0.4,0.2,0.7,0.4s0.4,0.3,0.5,0.4 c0.3,0.2,0.7,0.4,1.1,0.6c0.4,0.2,0.8,0.4,1.3,0.7c0.5,0.3,0.8,0.5,1.1,0.6c0.9,0.5,1.4,0.8,1.5,1.1C35.3,29.1,35.3,29.2,35.3,29.4z '/%3E %3C/svg%3E\""

/***/ }),

/***/ 1989:
/***/ (function(module, exports, __webpack_require__) {

/*
 * Tine 2.0
 * 
 * @package     Phone
 * @license     http://www.gnu.org/licenses/agpl.html AGPL3
 * @author      Lars Kneschke <l.kneschke@metaways.de>
 * @copyright   Copyright (c) 2008-2012 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 * TODO         refactor this!
 */
Ext.namespace('Tine.Phone');

__webpack_require__(311);
/**************************** dialer form / function *******************************/


Tine.Phone.Application = Ext.extend(Tine.Tinebase.Application, {
  /**
   * holds the users' phones
   * @type {Ext.data.JsonStore}
   */
  userPhonesStore: null,
  init: function init() {
    // create store (get from initial data)
    this.userPhonesStore = new Ext.data.JsonStore({
      fields: Tine.Voipmanager.Model.SnomPhone,
      // initial data from http request
      data: Tine.Phone.registry.get('Phones'),
      autoLoad: true,
      id: 'id'
    });
    new Tine.Phone.AddressbookGridPanelHook({
      app: this
    });
  }
});
/**
 * dial function
 * - opens the dialer window if multiple phones/lines are available
 * - directly calls dial json function if number is set and just 1 phone and line are available
 * 
 * @param string phone number to dial
 * 
 * @todo use window factory later
 * @todo what todo if no lines are available?
 */

Tine.Phone.dialPhoneNumber = function (number) {
  var phonesStore = Tine.Tinebase.appMgr.get('Phone').userPhonesStore;
  var lines = phonesStore.getAt(0) ? phonesStore.getAt(0).data.lines : []; // check if only one phone / one line exists and number is set

  if (phonesStore.getTotalCount() == 1 && lines.length == 1 && number) {
    // call Phone.dialNumber
    Ext.Ajax.request({
      url: 'index.php',
      params: {
        method: 'Phone.dialNumber',
        number: number,
        phoneId: phonesStore.getAt(0).id,
        lineId: lines[0].id
      },
      success: function success(_result, _request) {// success
      },
      failure: function failure(result, request) {// show error message?
      }
    });
  } else {
    // open dialer box (with phone and lines selection)
    var dialerPanel = new Tine.Phone.DialerPanel({
      number: number ? number : null
    });
    var dialer = Tine.WindowFactory.getWindow({
      title: 'Dial phone number',
      id: 'dialerWindow',
      modal: true,
      width: 400,
      height: 150,
      layout: 'fit',
      plain: true,
      bodyStyle: 'padding:5px;',
      closeAction: 'close',
      items: [dialerPanel]
    });
  }
};
/**
 * register special renderer for direction and destination
 */


Tine.widgets.grid.RendererManager.register('Phone', 'Call', 'direction', function (v) {
  var t = Tine.Tinebase.appMgr.get('Phone').i18n;

  switch (v) {
    case 'in':
      return '<img src="images/call-incoming.png" width="12" height="12" alt="contact" ext:qtip="' + Ext.util.Format.htmlEncode(t._('Incoming call')) + '"/>';
      break;

    case 'out':
      return '<img src="images/call-outgoing.png" width="12" height="12" alt="contact" ext:qtip="' + Ext.util.Format.htmlEncode(t._('Outgoing call')) + '"/>';
      break;
  }
});
Tine.widgets.grid.RendererManager.register('Phone', 'Call', 'destination', function (v) {
  if (v.toString().toLowerCase() == 'unknown') {
    var t = Tine.Tinebase.appMgr.get('Phone').i18n;
    return t._('unknown number');
  }

  return Ext.util.Format.htmlEncode(v);
});
Tine.widgets.grid.RendererManager.register('Phone', 'Call', 'line_id', function (v) {
  return v && v.hasOwnProperty('linenumber') ? v.linenumber : '';
});
Tine.widgets.grid.RendererManager.register('Phone', 'Call', 'contact_id', function (v) {
  return v && v.hasOwnProperty('n_fn') ? v.n_fn : '';
});
/***************************** utils ****************************************/

Ext.namespace('Tine.Phone.utils');
/**
 * checks if given argument is syntactically a callable/valid number
 * 
 * @todo: synchrosize this with the asterisk rules
 */

Tine.Phone.utils.isCallable = function (number) {
  return !number.toString().replace(/^\+|[ \-\/]/g, '').match(/[^0-9]/);
};

/***/ }),

/***/ 1990:
/***/ (function(module, exports) {

Ext.namespace('Tine.Phone');
Tine.Phone.PhoneTreePanel = Ext.extend(Ext.tree.TreePanel, {
  // private
  id: 'phone-tree',
  rootVisible: false,
  border: false,
  collapsible: true,
  baseCls: 'ux-arrowcollapse',
  // state stuff
  stateful: true,
  stateId: 'phone-phonetreepanel',
  stateEvents: ['collapse', 'expand', 'click'],

  /**
   * holds the users' phones
   * @type {Ext.data.JsonStore}
   */
  store: null,

  /**
   * last selected node
   * 
   * @type {Ext.tree.TreeNode} 
   */
  ctxNode: null,

  /**
   * initializes the component
   */
  initComponent: function initComponent() {
    Tine.Phone.PhoneTreePanel.superclass.initComponent.call(this, arguments);
    this.setRootNode(new Ext.tree.TreeNode({
      cls: 'treemain',
      allowDrag: false,
      allowDrop: true,
      id: 'phone-root',
      icon: false
    })); // create context menu

    var contextMenu = new Ext.menu.Menu({
      plugins: [{
        ptype: 'ux.itemregistry',
        key: 'Tinebase-MainContextMenu'
      }],
      items: [this.grid.action_editPhoneSettings],
      listeners: {
        scope: this,
        hide: function hide() {
          this.ctxNode = null;
        }
      }
    });
    this.on('contextmenu', function (node, event) {
      event.stopEvent();
      this.ctxNode = node;

      if (node.id != 'phone-root') {
        contextMenu.showAt(event.getXY());
      }
    }, this);
    this.on('click', function (node, event) {
      this.onNodeClick(node, event);
    }, this);
    this.store = this.app.userPhonesStore;
  },

  /**
   * is called on single click on an node of the phoneTreePanel
   * 
   * @param {Ext.tree.TreeNode} node
   * @param {} event
   */
  onNodeClick: function onNodeClick(node, event) {
    this.ctxNode = node;
    this.grid.store.load();
  },

  /**
   * returns the currently selected node
   * 
   * @return {Ext.tree.TreeNode}
   */
  getActiveNode: function getActiveNode() {
    return this.ctxNode || this.getSelectionModel().getSelectedNode();
  },

  /**
   * updates the phone tree panel after an crud action and on load
   */
  updateTree: function updateTree() {
    // remove all children first
    var rootNode = this.getRootNode();
    rootNode.eachChild(function (child) {
      this.removeChild(child);
    }); // add phones from store to tree menu

    this.store.each(function (record) {
      var label = record.data.description == '' ? record.data.macaddress : Ext.util.Format.ellipsis(Ext.util.Format.htmlEncode(record.data.description), 30);
      var node = new Ext.tree.TreeNode({
        id: record.id,
        record: record,
        text: label,
        iconCls: 'PhoneIconCls',
        qtip: Ext.util.Format.htmlEncode(record.data.description),
        leaf: true
      });
      rootNode.appendChild(node);
    }, this);
  },

  /**
   * @see Ext.Component
   */
  getState: function getState() {
    var root = this.getRootNode();
    var state = {
      selected: this.grid.ctxNode ? this.grid.ctxNode.id : null
    };
    return state;
  },
  // private
  initState: function initState() {
    if (Ext.state.Manager) {
      var id = this.getStateId();

      if (id) {
        var state = Ext.state.Manager.get(id);

        if (state) {
          if (this.fireEvent('beforestaterestore', this, state) !== false) {
            this.applyState(Ext.apply({}, state));
            this.fireEvent('staterestore', this, state);
          }
        } else {
          (function () {
            var root = this.getRootNode();

            if (root.firstChild) {
              root.firstChild.select();
            }
          }).defer(100, this);
        }
      }
    }
  },

  /**
   * applies state to cmp
   * 
   * @param {Object} state
   */
  applyState: function applyState(state) {
    (function () {
      var node = state.selected ? this.getNodeById(state.selected) : this.getRootNode().firstChild;

      if (node) {
        node.select();
      }
    }).defer(100, this);
  }
});

/***/ }),

/***/ 1991:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 * 
 * @package     Phone
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Cornelius Weiss <c.weiss@metaways.de>
 * @copyright   Copyright (c) 2009-2011 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 */
Ext.ns('Tine.Phone');
/**
 * @namespace   Tine.Phone
 * @class       Tine.Phone.AddressbookGridPanelHook
 * 
 * <p>Phone Addressbook Hook</p>
 * <p>
 * </p>
 * 
 * @author      Cornelius Weiss <c.weiss@metaways.de>
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * 
 * @constructor
 */

Tine.Phone.AddressbookGridPanelHook = function (config) {
  Tine.log.info('initialising phone addressbook hooks');
  Ext.apply(this, config); // NOTE: due to the action updater this action is bound the the adb grid only!

  this.phoneMenu = new Ext.menu.Menu({
    items: [],
    plugins: [{
      ptype: 'ux.itemregistry',
      key: 'Tinebase-MainContextMenu'
    }]
  });
  this.callContactAction = new Ext.Action({
    text: this.app.i18n._('Call contact'),
    iconCls: 'PhoneIconCls',
    disabled: this.useActionUpdater ? true : false,
    scope: this,
    actionUpdater: this.useActionUpdater ? this.updateAction : Ext.emptyFn,
    menu: this.phoneMenu,
    listeners: {
      scope: this,
      render: this.useActionUpdater ? this.onRender : Ext.emptyFn
    }
  });
  this.callContactBtn = Ext.apply(new Ext.SplitButton(this.callContactAction), {
    scale: 'medium',
    rowspan: 2,
    iconAlign: 'top',
    arrowAlign: 'right'
  }), // register in toolbar + contextmenu
  Ext.ux.ItemRegistry.registerItem(this.keyPrefix + '-Contact-GridPanel-ActionToolbar-leftbtngrp', this.callContactBtn, 30);
  Ext.ux.ItemRegistry.registerItem(this.keyPrefix + '-Contact-GridPanel-ContextMenu', this.callContactAction, 80);
};

Ext.apply(Tine.Phone.AddressbookGridPanelHook.prototype, {
  /**
   * do we use the grids action updater
   * 
   * @type Boolean
   */
  useActionUpdater: true,

  /**
   * contact to call
   * 
   * @type Tine.Addressbook.Model.Contact
   */
  contact: null,

  /**
   * @property app
   * @type Tine.Phone.Application
   * @private
   */
  app: null,

  /**
   * hook registry prefix
   * @type String
   */
  keyPrefix: 'Addressbook',

  /**
   * @property callContactAction
   * @type Ext.Action
   * @private
   */
  callContactAction: null,

  /**
   * @property callContactBtn
   * @type Ext.Button
   * @private
   */
  callContactBtn: null,

  /**
   * @property ContactGridPanel
   * @type Tine.Addressbook.ContactGridPanel
   * @private
   */
  ContactGridPanel: null,

  /**
   * @property phoneMenu
   * @type Ext.menu.Menu
   * @private
   */
  phoneMenu: null,

  /**
   * get addressbook contact grid panel
   */
  getContactGridPanel: function getContactGridPanel() {
    if (!this.ContactGridPanel) {
      this.ContactGridPanel = Tine.Tinebase.appMgr.get('Addressbook').getMainScreen().getCenterPanel();
    }

    return this.ContactGridPanel;
  },

  /**
   * calls a contact
   * @param {Button} btn 
   */
  onCallContact: function onCallContact(btn) {
    var number;
    var contact = this.contact ? this.contact : this.getContactGridPanel().grid.getSelectionModel().getSelected();

    if (!contact) {
      return;
    }

    if (!Ext.isEmpty(contact.get(btn.field))) {
      number = contact.get(btn.field);
    } else if (!Ext.isEmpty(contact.data.tel_work)) {
      number = contact.data.tel_work;
    } else if (!Ext.isEmpty(contact.data.tel_cell)) {
      number = contact.data.tel_cell;
    } else if (!Ext.isEmpty(contact.data.tel_cell_private)) {
      number = contact.data.tel_cell_private;
    } else if (!Ext.isEmpty(contact.data.tel_home)) {
      number = contact.data.tel_home;
    }

    Tine.Phone.dialPhoneNumber(number);
  },

  /**
   * add to action updater the first time we render
   */
  onRender: function onRender() {
    var actionUpdater = this.getContactGridPanel().actionUpdater,
        registeredActions = actionUpdater.actions;

    if (registeredActions.indexOf(this.callContactAction) < 0) {
      actionUpdater.addActions([this.callContactAction]);
    }
  },

  /**
   * updates call menu
   * 
   * @param {Ext.Action} action
   * @param {Object} grants grants sum of grants
   * @param {Object} records
   */
  updateAction: function updateAction(action, grants, records) {
    if (action.isHidden()) {
      return;
    }

    this.phoneMenu.removeAll();
    action.setDisabled(true);

    if (records.length == 1) {
      var contact = records[0];

      if (!contact) {
        return false;
      }

      if (!Ext.isEmpty(contact.data.tel_work)) {
        this.phoneMenu.add({
          text: this.app.i18n._('Work') + ' ' + contact.data.tel_work + '',
          scope: this,
          handler: this.onCallContact,
          field: 'tel_work'
        });
        action.setDisabled(false);
      }

      if (!Ext.isEmpty(contact.data.tel_home)) {
        this.phoneMenu.add({
          text: this.app.i18n._('Home') + ' ' + contact.data.tel_home + '',
          scope: this,
          handler: this.onCallContact,
          field: 'tel_home'
        });
        action.setDisabled(false);
      }

      if (!Ext.isEmpty(contact.data.tel_cell)) {
        this.phoneMenu.add({
          text: this.app.i18n._('Cell') + ' ' + contact.data.tel_cell + '',
          scope: this,
          handler: this.onCallContact,
          field: 'tel_cell'
        });
        action.setDisabled(false);
      }

      if (!Ext.isEmpty(contact.data.tel_cell_private)) {
        this.phoneMenu.add({
          text: this.app.i18n._('Cell private') + ' ' + contact.data.tel_cell_private + '',
          scope: this,
          handler: this.onCallContact,
          field: 'tel_cell_private'
        });
        action.setDisabled(false);
      }
    }
  },

  /**
   * set contact for action and update phoneMenu items
   * 
   * @param {Tine.Addressbook.Model.Contact} contact
   */
  setContactAndUpdateAction: function setContactAndUpdateAction(contact) {
    this.contact = contact;
    this.updateAction(this.callContactAction, null, [contact]);
  }
});

/***/ }),

/***/ 1992:
/***/ (function(module, exports, __webpack_require__) {

/*
 * Tine 2.0
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Alexander Stintzing <a.stintzing@metaways.de>
 * @copyright   Copyright (c) 2012-2019 Metaways Infosystems GmbH (http://www.metaways.de)
 */
Ext.ns('Tine.Phone');

__webpack_require__(312);
/**
 * @namespace   Tine.Phone
 * @class       Tine.Phone.CallEditDialog
 * @extends     Tine.widgets.dialog.EditDialog
 * 
 * <p>Call Compose Dialog</p>
 * <p></p>
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Alexander Stintzing <a.stintzing@metaways.de>
 * 
 * @param       {Object} config
 * @constructor
 * Create a new Tine.Phone.CallEditDialog
 */


Tine.Phone.CallGridPanel = Ext.extend(Tine.widgets.grid.GridPanel, {
  /**
   * the panel holds the phones available for the user
   * 
   * @type {Ext.tree.TreePanel}
   */
  phoneTreePanel: null,

  /**
   * 
   * @type {Ext.Action}
   */
  editPhoneSettingsAction: null,

  /**
   * initializes the component
   */
  initComponent: function initComponent() {
    Tine.Phone.CallGridPanel.superclass.initComponent.call(this);
    this.initPhoneTreePanel();
  },

  /**
   * @private
   */
  initActions: function initActions() {
    this.action_editPhoneSettings = new Ext.Action({
      text: this.app.i18n._('Edit phone settings'),
      iconCls: 'PhoneIconCls',
      handler: this.onEditPhoneSettings.createDelegate(this),
      scope: this,
      actionUpdater: function actionUpdater(action, grants, records) {
        if (this.phoneTreePanel.getActiveNode()) {
          this.action_editPhoneSettings.setDisabled(0);
        } else {
          this.action_editPhoneSettings.setDisabled(1);
        }
      }
    });
    this.action_dialNumber = new Ext.Action({
      text: this.app.i18n._('Dial number'),
      tooltip: this.app.i18n._('Initiate a new outgoing call'),
      handler: this.onDialNumber,
      iconCls: 'action_DialNumber',
      scope: this,
      actionUpdater: function actionUpdater(action, grants, records) {
        if (records.length != 1) {
          this.action_dialNumber.setDisabled(1);
        } else {
          this.action_dialNumber.setDisabled(0);
        }
      }
    }); // register actions in updater

    this.actionUpdater.addActions([this.action_editPhoneSettings, this.action_dialNumber]);
    this.getActionToolbar();
  },

  /**
   * row doubleclick handler
   * 
   * @param {} grid
   * @param {} row
   * @param {} e
   */
  onRowDblClick: function onRowDblClick(grid, row, e) {
    this.onDialNumber(grid, row, e);
  },

  /**
   * get action toolbar
   * 
   * @return {Ext.Toolbar}
   */
  getActionToolbar: function getActionToolbar() {
    if (!this.actionToolbar) {
      this.actionToolbar = new Ext.Toolbar({
        items: [{
          xtype: 'buttongroup',
          plugins: [{
            ptype: 'ux.itemregistry',
            key: this.app.appName + '-' + this.recordClass.prototype.modelName + '-GridPanel-ActionToolbar-leftbtngrp'
          }],
          items: [Ext.apply(new Ext.Button(this.action_editPhoneSettings), {
            scale: 'medium',
            rowspan: 2,
            iconAlign: 'top'
          }), Ext.apply(new Ext.Button(this.action_dialNumber), {
            scale: 'medium',
            rowspan: 2,
            iconAlign: 'top'
          })]
        }]
      });
    }

    if (this.filterToolbar && typeof this.filterToolbar.getQuickFilterField == 'function') {
      this.actionToolbar.add('->', this.filterToolbar.getQuickFilterField());
    }

    return this.actionToolbar;
  },

  /**
   * add custom items to context menu
   * 
   * @return {Array}
   */
  getContextMenuItems: function getContextMenuItems() {
    var items = ['-', this.action_dialNumber];
    return items;
  },

  /**
   * is called on dial a number
   */
  onDialNumber: function onDialNumber() {
    var record = this.grid.getSelectionModel().getSelected(),
        number = false;

    if (record) {
      if (record.get('resolved_destination') != '') {
        number = record.get('resolved_destination');
      } else {
        number = record.get('destination');
      }
    }

    Tine.Phone.dialPhoneNumber(number);
  },

  /**
   * initializes the phone tree panel
   */
  initPhoneTreePanel: function initPhoneTreePanel() {
    this.phoneTreePanel = new Tine.Phone.PhoneTreePanel({
      app: this.app,
      title: this.app.i18n._('Phones'),
      grid: this
    });
    var westPanel = this.app.getMainScreen().getWestPanel().getPortalColumn();
    westPanel.add(this.phoneTreePanel);
    this.phoneTreePanel.updateTree();
  },

  /**
   * called before store queries for data
   */
  onStoreBeforeload: function onStoreBeforeload(store, options) {
    Tine.Phone.CallGridPanel.superclass.onStoreBeforeload.apply(this, arguments);
    var node = this.phoneTreePanel.getActiveNode();

    if (node && node.hasOwnProperty('attributes')) {
      var r = node.attributes.record;
      if (!options.params) options.params = {};
      options.params.filter = [{
        field: 'phone_id',
        operator: 'AND',
        value: [{
          field: ':id',
          operator: 'equals',
          value: r.get('id')
        }]
      }];
    }
  },

  /**
   * is called on edit phone button click
   */
  onEditPhoneSettings: function onEditPhoneSettings() {
    var node = this.phoneTreePanel.getActiveNode();

    if (node) {
      var rp = Tine.Phone.myphoneBackend;

      rp.recordReader = function (response) {
        var record = new Tine.Phone.Model.MyPhone(Ext.decode(response.responseText));
        var recordId = record.get(record.idProperty);
        record.id = recordId ? recordId : 0;
        return record;
      };

      var popupWindow = Tine.Voipmanager.SnomPhoneEditDialog.openWindow({
        recordProxy: rp,
        record: node.attributes.record,
        appName: 'Phone',
        modelName: 'MyPhone'
      });
    } else {
      Ext.Msg.show({
        title: this.app.i18n._('No phone selected'),
        msg: this.app.i18n._('Please select the desired phone in the tree!'),
        icon: Ext.MessageBox.INFO,
        buttons: Ext.Msg.OK,
        scope: this
      });
    }
  }
});

/***/ }),

/***/ 1993:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 * 
 * @package     Phone
 * @license     http://www.gnu.org/licenses/agpl.html AGPL3
 * @author      Lars Kneschke <l.kneschke@metaways.de>
 * @copyright   Copyright (c) 2008-2013 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 */
Ext.namespace('Tine.Phone');
/**
 * dialer form
 * 
 * @todo use macaddress or description/name as display value?
 */

Tine.Phone.DialerPanel = Ext.extend(Ext.form.FormPanel, {
  id: 'dialerPanel',
  translation: null,
  // initial phone number
  number: null,
  // config settings
  defaults: {
    xtype: 'textfield',
    anchor: '100%',
    allowBlank: false
  },
  bodyStyle: 'padding:5px;',
  buttonAlign: 'right',
  phoneStore: null,
  linesStore: null,
  // private
  initComponent: function initComponent() {
    var me = this;
    this.translation = new Locale.Gettext();
    this.translation.textdomain('Phone'); // set stores

    this.phoneStore = Tine.Tinebase.appMgr.get('Phone').userPhonesStore; //this.setLineStore(this.phoneStore.getAt(0).id);

    this.setLineStore(null);
    /***************** form fields *****************/

    this.items = [new Tine.widgets.customfields.CustomfieldsCombo({
      fieldLabel: this.translation._('Phone'),
      store: this.phoneStore,
      mode: 'local',
      editable: false,
      stateful: true,
      stateEvents: ['select'],
      displayField: 'description',
      valueField: 'id',
      id: 'phoneId',
      name: 'phoneId',
      triggerAction: 'all',
      listeners: {
        scope: this,
        // reload lines combo on change
        select: function select(combo, newValue, oldValue) {
          //console.log('set line store for ' + newValue.data.id);
          this.setLineStore(newValue.data.id);
        }
      }
    }), {
      xtype: 'combo',
      fieldLabel: this.translation._('Line'),
      name: 'lineId',
      displayField: 'linenumber',
      valueField: 'id',
      mode: 'local',
      store: this.linesStore,
      triggerAction: 'all',
      disabled: this.linesStore.getCount() <= 1
    }, {
      fieldLabel: this.translation._('Number'),
      name: 'phoneNumber'
    }];
    /******************* action buttons ********************/
    // cancel action

    this.cancelAction = new Ext.Action({
      text: this.translation._('Cancel'),
      iconCls: 'action_cancel',
      handler: function handler() {
        me.ownerCt.ownerCt.close();
      }
    }); // dial action

    this.dialAction = new Ext.Action({
      scope: this,
      text: this.translation._('Dial'),
      iconCls: 'action_DialNumber',
      handler: function handler() {
        var form = this.getForm();

        if (form.isValid()) {
          Ext.Ajax.request({
            url: 'index.php',
            params: {
              method: 'Phone.dialNumber',
              number: form.findField('phoneNumber').getValue(),
              phoneId: form.findField('phoneId').getValue(),
              lineId: form.findField('lineId').getValue()
            },
            success: function success(_result, _request) {
              me.ownerCt.ownerCt.close();
            },
            failure: function failure(response, request) {
              var responseText = Ext.util.JSON.decode(response.responseText);
              Ext.Msg.show({
                title: this.translation._('Error'),
                msg: responseText.data.message ? responseText.data.message : this.translation._('Not possible to dial.'),
                icon: Ext.MessageBox.ERROR,
                buttons: Ext.Msg.OK
              });
            },
            scope: this
          });
        }
      }
    });
    this.buttons = [this.cancelAction, this.dialAction];
    /************** other initialisation ****************/

    this.initMyFields.defer(300, this);
    Tine.Phone.DialerPanel.superclass.initComponent.call(this);
  },

  /**
   * init form fields
   * 
   * @todo add prefered phone/line selections
   */
  initMyFields: function initMyFields() {
    // focus number field or set initial value
    if (this.number != null) {
      this.getForm().findField('phoneNumber').setValue(this.number);
    } else {
      this.getForm().findField('phoneNumber').focus();
    } // get combos


    var phoneCombo = this.getForm().findField('phoneId');
    var lineCombo = this.getForm().findField('lineId'); // select first combo values

    if (!phoneCombo.getState() && this.phoneStore.getAt(0)) {
      phoneCombo.setValue(this.phoneStore.getAt(0).id);
    } else {
      // update line store again (we need this, because it is changed when dlg is opened the second time)
      this.setLineStore(phoneCombo.getValue());
    }

    var firstLine = this.linesStore.getAt(0);

    if (firstLine) {
      this.getForm().findField('lineId').setValue(firstLine.id);
    }
  },

  /**
   * get values from phones store
   */
  setLineStore: function setLineStore(phoneId) {
    if (this.linesStore == null) {
      this.linesStore = new Ext.data.Store({});
    } else {
      // empty store
      this.linesStore.removeAll();
    }

    var form = this.getForm();

    if (phoneId == null) {
      if (form) {
        phoneId = form.findField('phoneId').getValue();
      } else if (this.phoneStore.getAt(0)) {
        // get first phone
        phoneId = this.phoneStore.getAt(0).id;
      } else {
        return;
      }
    }

    var phone = this.phoneStore.getById(phoneId);

    if (phone) {
      for (var i = 0; i < phone.data.lines.length; i++) {
        var lineRecord = new Tine.Voipmanager.Model.SnomLine(phone.data.lines[i], phone.data.lines[i].id);
        this.linesStore.add(lineRecord);
      }
    } // disable lineCombo if only 1 line available


    if (form) {
      var lineCombo = form.findField('lineId');
      var count = this.linesStore.getCount();
      lineCombo.setDisabled(count <= 1);

      if (count) {
        // set first line
        lineCombo.setValue(this.linesStore.getAt(0).id);
      }
    }
  }
});

/***/ }),

/***/ 1994:
/***/ (function(module, exports, __webpack_require__) {

// style-loader: Adds some css to the DOM by adding a <style> tag

// load the styles
var content = __webpack_require__(1995);
if(typeof content === 'string') content = [[module.i, content, '']];
// Prepare cssTransformation
var transform;

var options = {"hmr":true}
options.transform = transform
// add the styles to the DOM
var update = __webpack_require__(11)(content, options);
if(content.locals) module.exports = content.locals;
// Hot Module Replacement
if(false) {}

/***/ }),

/***/ 1995:
/***/ (function(module, exports, __webpack_require__) {

var escape = __webpack_require__(98);
exports = module.exports = __webpack_require__(10)(false);
// imports


// module
exports.push([module.i, "/**\n * Tine 2.0\n * \n * @package     Phone\n * @license     http://www.gnu.org/licenses/agpl.html AGPL3\n * @author      Lars Kneschke <l.kneschke@metaways.de>\n * @copyright   Copyright (c) 2008 Metaways Infosystems GmbH (http://www.metaways.de)\n * @version     $Id:Phone.css 4159 2008-09-02 14:15:05Z p.schuele@metaways.de $\n *\n */\n\n \n.PhoneIconCls {\n    background-image:url(" + escape(__webpack_require__(169)) + ") !important;\n}\n\n.action_DialNumber {\n    background-image:url(" + escape(__webpack_require__(1996)) + ") !important;\n}", ""]);

// exports


/***/ }),

/***/ 1996:
/***/ (function(module, exports) {

module.exports = "\"data:image/svg+xml,%3C?xml version='1.0' encoding='utf-8'?%3E %3C!-- Generator: Adobe Illustrator 21.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0) --%3E %3Csvg version='1.1' id='Ebene_1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' x='0px' y='0px' viewBox='0 0 42.5 42.5' style='enable-background:new 0 0 42.5 42.5;' xml:space='preserve' width='42.5' height='42.5'%3E %3Cpath d='M9.4,15.1c-0.2-0.2-0.4-0.5-0.7-0.9c-0.2-0.4-0.4-0.7-0.5-1C8,12.8,8,12,8.3,10.9c0.3-1,0.8-1.9,1.4-2.5 c0.2-0.2,0.4-0.4,0.6-0.5s0.5-0.3,0.7-0.5s0.5-0.3,0.6-0.3c0.1-0.1,0.4-0.2,0.8-0.4c0.4-0.2,0.6-0.3,0.7-0.3C14.2,6,15.1,5.6,16,5.4 C17.4,5.1,19.1,5,21.1,5s3.6,0.2,5.1,0.6c0.9,0.2,1.8,0.6,2.8,1c0.1,0,0.3,0.2,0.7,0.3c0.4,0.2,0.7,0.3,0.8,0.4 c0.1,0.1,0.4,0.2,0.7,0.4s0.5,0.3,0.8,0.5c0.2,0.2,0.4,0.3,0.6,0.5c0.7,0.7,1.1,1.5,1.5,2.5c0.3,1.1,0.4,1.9,0.2,2.4 c-0.1,0.3-0.3,0.6-0.5,0.9c-0.2,0.4-0.4,0.7-0.6,0.8c-0.1,0.1-0.2,0.2-0.3,0.2c-0.2,0.1-0.6,0-1.4-0.3c-0.2-0.1-0.5-0.1-0.9-0.3 c-0.4-0.1-0.7-0.2-1.1-0.3c-0.3-0.1-0.6-0.2-0.9-0.3c0,0-0.2,0-0.5-0.1s-0.5-0.1-0.6-0.2c-0.2-0.1-0.3-0.1-0.4-0.2 c-0.1-0.1-0.2-0.4-0.2-0.8c0-0.4,0-0.8,0.1-1.2c0.1-0.4,0.1-0.8,0.1-1.2c0-0.4-0.1-0.7-0.2-0.8c-0.1-0.1-0.2-0.1-0.3-0.2 c-0.1-0.1-0.2-0.1-0.3-0.1c-0.1,0-0.2-0.1-0.4-0.1c-0.2,0-0.3-0.1-0.3-0.1c-1.5-0.5-3-0.7-4.4-0.7c-1.4,0-2.8,0.2-4.3,0.6 c0,0-0.1,0-0.3,0.1s-0.3,0.1-0.4,0.1c-0.1,0-0.2,0.1-0.3,0.1c-0.1,0.1-0.2,0.1-0.3,0.2c-0.1,0.1-0.2,0.4-0.2,0.8 c0,0.4,0,0.8,0.1,1.2s0.1,0.8,0.1,1.2c0,0.4-0.1,0.7-0.2,0.8c-0.1,0.1-0.2,0.2-0.4,0.2s-0.4,0.1-0.6,0.1c-0.3,0-0.4,0.1-0.5,0.1 c-0.3,0.1-0.6,0.1-0.9,0.2s-0.7,0.2-1,0.3s-0.7,0.2-0.9,0.2c-0.7,0.2-1.2,0.3-1.4,0.2C9.6,15.3,9.5,15.2,9.4,15.1z M13.6,16.3 c-1.7,0-3,1.4-3,3s1.4,3,3,3s3-1.4,3-3S15.3,16.3,13.6,16.3z M28.7,16.3c-1.7,0-3,1.4-3,3s1.4,3,3,3c1.7,0,3-1.4,3-3 S30.4,16.3,28.7,16.3z M21.2,16.3c-1.7,0-3,1.4-3,3s1.4,3,3,3c1.7,0,3-1.4,3-3S22.8,16.3,21.2,16.3z M13.6,23.8c-1.7,0-3,1.4-3,3 c0,1.7,1.4,3,3,3s3-1.4,3-3C16.6,25.1,15.3,23.8,13.6,23.8z M28.7,23.8c-1.7,0-3,1.4-3,3c0,1.7,1.4,3,3,3c1.7,0,3-1.4,3-3 C31.7,25.1,30.4,23.8,28.7,23.8z M21.2,23.8c-1.7,0-3,1.4-3,3c0,1.7,1.4,3,3,3c1.7,0,3-1.4,3-3C24.2,25.1,22.8,23.8,21.2,23.8z M13.6,31c-1.7,0-3,1.4-3,3c0,1.7,1.4,3,3,3s3-1.4,3-3C16.6,32.4,15.3,31,13.6,31z M28.7,31c-1.7,0-3,1.4-3,3c0,1.7,1.4,3,3,3 c1.7,0,3-1.4,3-3C31.7,32.4,30.4,31,28.7,31z M21.2,31c-1.7,0-3,1.4-3,3c0,1.7,1.4,3,3,3c1.7,0,3-1.4,3-3C24.2,32.4,22.8,31,21.2,31 z'/%3E %3C/svg%3E\""

/***/ }),

/***/ 311:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 * 
 * @package     Voipmanager
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Thomas Wadewitz <t.wadewitz@metaways.de>
 * @copyright   Copyright (c) 2007-2008 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 */
Ext.ns('Tine.Voipmanager', 'Tine.Voipmanager.Model');
/*
 *  SNOM
 */

/**
 * @type {Array}
 * Voipmanager model fields
 */

Tine.Voipmanager.Model.SnomPhoneArray = Tine.Tinebase.Model.modlogFields.concat([{
  name: 'id'
}, {
  name: 'macaddress'
}, {
  name: 'description'
}, {
  name: 'location_id'
}, {
  name: 'template_id'
}, {
  name: 'settings_id'
}, {
  name: 'ipaddress'
}, {
  name: 'last_modified_time',
  type: 'date',
  dateFormat: Date.patterns.ISO8601Long
}, {
  name: 'current_software'
}, {
  name: 'current_model'
}, {
  name: 'settings_loaded_at',
  type: 'date',
  dateFormat: Date.patterns.ISO8601Long
}, {
  name: 'firmware_checked_at',
  type: 'date',
  dateFormat: Date.patterns.ISO8601Long
}, {
  name: 'location'
}, {
  name: 'template'
}, {
  name: 'http_client_info_sent'
}, {
  name: 'http_client_user'
}, {
  name: 'http_client_pass'
}, {
  name: 'setting_id'
}, {
  name: 'web_language'
}, {
  name: 'language'
}, {
  name: 'display_method'
}, {
  name: 'mwi_notification'
}, {
  name: 'mwi_dialtone'
}, {
  name: 'headset_device'
}, {
  name: 'message_led_other'
}, {
  name: 'global_missed_counter'
}, {
  name: 'pickup_indication'
}, {
  name: 'scroll_outgoing'
}, {
  name: 'show_local_line'
}, {
  name: 'show_call_status'
}, {
  name: 'call_waiting'
}, {
  name: 'web_language_w'
}, {
  name: 'language_w'
}, {
  name: 'display_method_w'
}, {
  name: 'call_waiting_w'
}, {
  name: 'mwi_notification_w'
}, {
  name: 'mwi_dialtone_w'
}, {
  name: 'headset_device_w'
}, {
  name: 'message_led_other_w'
}, {
  name: 'global_missed_counter_w'
}, {
  name: 'pickup_indication_w'
}, {
  name: 'scroll_outgoing_w'
}, {
  name: 'show_local_line_w'
}, {
  name: 'show_call_status_w'
}, {
  name: 'lines'
}, {
  name: 'rights'
}]);
/**
 * @type {Tine.Tinebase.data.Record}
 * Voipmanager record definition
 */

Tine.Voipmanager.Model.SnomPhone = Tine.Tinebase.data.Record.create(Tine.Voipmanager.Model.SnomPhoneArray, {
  appName: 'Voipmanager',
  modelName: 'SnomPhone',
  idProperty: 'id',
  titleProperty: 'description',
  // ngettext('Phone', 'Phones', n);
  recordName: 'SnomPhone',
  recordsName: 'SnomPhones',
  containerProperty: 'phone_id',
  // ngettext('phones list', 'phones lists', n);
  containerName: 'phones list',
  containersName: 'phones lists',
  getTitle: function getTitle() {
    return this.get('description') ? this.get('description') + ' ' + this.get('macaddress') : false;
  }
});

Tine.Voipmanager.Model.SnomPhone.getDefaultData = function () {
  return {};
};

Tine.Voipmanager.Model.SnomPhone.getFilterModel = function () {
  return [{
    label: i18n._('Quick Search'),
    field: 'query',
    operators: ['contains']
  }];
};

Tine.Voipmanager.Model.SnomLocationArray = Tine.Tinebase.Model.modlogFields.concat([{
  name: 'id'
}, {
  name: 'name'
}, {
  name: 'description'
}, {
  name: 'firmware_interval'
}, {
  name: 'update_policy'
}, {
  name: 'registrar'
}, {
  name: 'base_download_url'
}, {
  name: 'admin_mode'
}, {
  name: 'admin_mode_password'
}, {
  name: 'ntp_server'
}, {
  name: 'ntp_refresh'
}, {
  name: 'timezone'
}, {
  name: 'webserver_type'
}, {
  name: 'http_port'
}, {
  name: 'https_port'
}, {
  name: 'http_user'
}, {
  name: 'http_pass'
}, {
  name: 'tone_scheme'
}, {
  name: 'date_us_format'
}, {
  name: 'time_24_format'
}]);
/**
 * @type {Tine.Tinebase.data.Record}
 * Voipmanager record definition
 */

Tine.Voipmanager.Model.SnomLocation = Tine.Tinebase.data.Record.create(Tine.Voipmanager.Model.SnomLocationArray, {
  appName: 'Voipmanager',
  modelName: 'SnomLocation',
  idProperty: 'id',
  titleProperty: 'name',
  // ngettext('Location', 'Locations', n);
  recordName: 'SnomLocation',
  recordsName: 'SnomLocations',
  containerProperty: 'location_id',
  // ngettext('locations list', 'locations lists', n);
  containerName: 'locations list',
  containersName: 'locations lists',
  getTitle: function getTitle() {
    return this.get('name') ? this.get('name') : false;
  }
});

Tine.Voipmanager.Model.SnomLocation.getDefaultData = function () {
  return {};
};

Tine.Voipmanager.Model.SnomLocation.getFilterModel = function () {
  return [{
    label: i18n._('Quick Search'),
    field: 'query',
    operators: ['contains']
  }];
};

Tine.Voipmanager.Model.SnomTemplateArray = Tine.Tinebase.Model.modlogFields.concat([{
  name: 'id'
}, {
  name: 'name'
}, {
  name: 'description'
}, {
  name: 'keylayout_id'
}, {
  name: 'setting_id'
}, {
  name: 'software_id'
}]);
/**
 * @type {Tine.Tinebase.data.Record}
 * Voipmanager record definition
 */

Tine.Voipmanager.Model.SnomTemplate = Tine.Tinebase.data.Record.create(Tine.Voipmanager.Model.SnomTemplateArray, {
  appName: 'Voipmanager',
  modelName: 'SnomTemplate',
  idProperty: 'id',
  titleProperty: 'name',
  // ngettext('Template', 'Templates', n);
  recordName: 'SnomTemplate',
  recordsName: 'SnomTemplates',
  containerProperty: 'template_id',
  // ngettext('templates list', 'templates lists', n);
  containerName: 'templates list',
  containersName: 'templates lists',
  getTitle: function getTitle() {
    return this.get('name') ? this.get('name') : false;
  }
});

Tine.Voipmanager.Model.SnomTemplate.getDefaultData = function () {
  return {};
};

Tine.Voipmanager.Model.SnomTemplate.getFilterModel = function () {
  return [{
    label: i18n._('Quick Search'),
    field: 'query',
    operators: ['contains']
  }];
};

Tine.Voipmanager.Model.SnomSoftwareArray = Tine.Tinebase.Model.modlogFields.concat([{
  name: 'id'
}, {
  name: 'name'
}, {
  name: 'description'
}, {
  name: 'softwareimage_snom300'
}, {
  name: 'softwareimage_snom320'
}, {
  name: 'softwareimage_snom360'
}, {
  name: 'softwareimage_snom370'
}]);
/**
 * @type {Tine.Tinebase.data.Record}
 * Voipmanager record definition
 */

Tine.Voipmanager.Model.SnomSoftware = Tine.Tinebase.data.Record.create(Tine.Voipmanager.Model.SnomSoftwareArray, {
  appName: 'Voipmanager',
  modelName: 'SnomSoftware',
  idProperty: 'id',
  titleProperty: 'name',
  // ngettext('Software', 'Softwares', n);
  recordName: 'SnomSoftware',
  recordsName: 'SnomSoftwares',
  containerProperty: 'software_id',
  // ngettext('softwares list', 'softwares lists', n);
  containerName: 'softwares list',
  containersName: 'softwares lists',
  getTitle: function getTitle() {
    return this.get('name') ? this.get('name') : false;
  }
});

Tine.Voipmanager.Model.SnomSoftware.getDefaultData = function () {
  return {};
};

Tine.Voipmanager.Model.SnomSoftware.getFilterModel = function () {
  return [{
    label: i18n._('Quick Search'),
    field: 'query',
    operators: ['contains']
  }];
};

Tine.Voipmanager.Model.SnomSoftwareImageArray = Tine.Tinebase.Model.modlogFields.concat([{
  name: 'model'
}, {
  name: 'softwareimage'
}]);
/**
 * @type {Tine.Tinebase.data.Record}
 * Voipmanager record definition
 */

Tine.Voipmanager.Model.SnomSoftwareImage = Tine.Tinebase.data.Record.create(Tine.Voipmanager.Model.SnomSoftwareImageArray, {
  appName: 'Voipmanager',
  modelName: 'SnomSoftwareImage',
  idProperty: 'model',
  titleProperty: 'softwareimage',
  // ngettext('SoftwareImage', 'SoftwareImages', n);
  recordName: 'SnomSoftwareImage',
  recordsName: 'SnomSoftwareImages',
  containerProperty: 'softwareImage_model',
  // ngettext('softwareImages list', 'softwareImages lists', n);
  containerName: 'softwareImages list',
  containersName: 'softwareImages lists',
  getTitle: function getTitle() {
    return this.get('name') ? this.get('name') : false;
  }
});

Tine.Voipmanager.Model.SnomSoftwareImage.getDefaultData = function () {
  return {};
};

Tine.Voipmanager.Model.SnomLineArray = Tine.Tinebase.Model.modlogFields.concat([{
  name: 'asteriskline_id'
}, {
  name: 'id'
}, {
  name: 'idletext'
}, {
  name: 'lineactive',
  type: 'boolean'
}, {
  name: 'linenumber'
}, {
  name: 'snomphone_id'
}, {
  name: 'cfi_mode'
}, {
  name: 'cfi_number'
}, {
  name: 'cfb_mode'
}, {
  name: 'cfb_number'
}, {
  name: 'cfd_mode'
}, {
  name: 'cfd_number'
}, {
  name: 'cfd_time'
}]);
/**
 * @type {Tine.Tinebase.data.Record}
 * Voipmanager record definition
 */

Tine.Voipmanager.Model.SnomLine = Tine.Tinebase.data.Record.create(Tine.Voipmanager.Model.SnomLineArray, {
  appName: 'Voipmanager',
  modelName: 'SnomLine',
  idProperty: 'id',
  titleProperty: 'linenumber',
  // ngettext('Line', 'Lines', n);
  recordName: 'SnomLine',
  recordsName: 'SnomLines',
  containerProperty: 'line_id',
  // ngettext('lines list', 'lines lists', n);
  containerName: 'lines list',
  containersName: 'lines lists',
  getTitle: function getTitle() {
    return this.get('name') ? this.get('name') : false;
  }
});

Tine.Voipmanager.Model.SnomLine.getDefaultData = function () {
  return {};
};

Tine.Voipmanager.Model.SnomLine.getFilterModel = function () {
  return [{
    label: i18n._('Quick Search'),
    field: 'query',
    operators: ['contains']
  }];
};

Tine.Voipmanager.Model.SnomSettingArray = Tine.Tinebase.Model.modlogFields.concat([{
  name: 'id'
}, {
  name: 'name'
}, {
  name: 'description'
}, {
  name: 'web_language'
}, {
  name: 'language'
}, {
  name: 'display_method'
}, {
  name: 'mwi_notification'
}, {
  name: 'mwi_dialtone'
}, {
  name: 'headset_device'
}, {
  name: 'message_led_other'
}, {
  name: 'global_missed_counter'
}, {
  name: 'pickup_indication'
}, {
  name: 'scroll_outgoing'
}, {
  name: 'show_local_line'
}, {
  name: 'show_call_status'
}, {
  name: 'call_waiting'
}, {
  name: 'web_language_w'
}, {
  name: 'language_w'
}, {
  name: 'display_method_w'
}, {
  name: 'call_waiting_w'
}, {
  name: 'mwi_notification_w'
}, {
  name: 'mwi_dialtone_w'
}, {
  name: 'headset_device_w'
}, {
  name: 'message_led_other_w'
}, {
  name: 'global_missed_counter_w'
}, {
  name: 'pickup_indication_w'
}, {
  name: 'scroll_outgoing_w'
}, {
  name: 'show_local_line_w'
}, {
  name: 'show_call_status_w'
}]);
/**
 * @type {Tine.Tinebase.data.Record}
 * Voipmanager record definition
 */

Tine.Voipmanager.Model.SnomSetting = Tine.Tinebase.data.Record.create(Tine.Voipmanager.Model.SnomSettingArray, {
  appName: 'Voipmanager',
  modelName: 'SnomSetting',
  idProperty: 'id',
  titleProperty: 'name',
  // ngettext('Setting', 'Settings', n);
  recordName: 'SnomSetting',
  recordsName: 'SnomSettings',
  containerProperty: 'setting_id',
  // ngettext('setting list', 'settings lists', n);
  containerName: 'setting list',
  containersName: 'setting lists',
  getTitle: function getTitle() {
    return this.get('name') ? this.get('name') : false;
  }
});

Tine.Voipmanager.Model.SnomSetting.getDefaultData = function () {
  return {};
};

Tine.Voipmanager.Model.SnomSetting.getFilterModel = function () {
  return [{
    label: i18n._('Quick Search'),
    field: 'query',
    operators: ['contains']
  }];
};
/**
 * Model of a right
 */


Tine.Voipmanager.Model.SnomPhoneRight = Ext.data.Record.create([{
  name: 'id'
}, {
  name: 'account_id'
}, {
  name: 'account_type'
}, {
  name: 'account_name'
}]);
/*
 *  ASTERISK
 */

Tine.Voipmanager.Model.AsteriskSipPeerArray = Tine.Tinebase.Model.modlogFields.concat([{
  name: 'id'
}, {
  name: 'name'
}, {
  name: 'accountcode'
}, {
  name: 'amaflags'
}, {
  name: 'callgroup'
}, {
  name: 'callerid'
}, {
  name: 'canreinvite'
}, {
  name: 'context_id'
}, {
  name: 'context'
}, {
  name: 'defaultip'
}, {
  name: 'dtmfmode'
}, {
  name: 'fromuser'
}, {
  name: 'fromdomain'
}, {
  name: 'fullcontact'
}, {
  name: 'host'
}, {
  name: 'insecure'
}, {
  name: 'language'
}, {
  name: 'mailbox'
}, {
  name: 'md5secret'
}, {
  name: 'nat'
}, {
  name: 'deny'
}, {
  name: 'permit'
}, {
  name: 'mask'
}, {
  name: 'pickupgroup'
}, {
  name: 'port'
}, {
  name: 'qualify'
}, {
  name: 'restrictcid'
}, {
  name: 'rtptimeout'
}, {
  name: 'rtpholdtimeout'
}, {
  name: 'secret'
}, {
  name: 'type'
}, {
  name: 'defaultuser'
}, {
  name: 'disallow'
}, {
  name: 'allow'
}, {
  name: 'musiconhold'
}, {
  name: 'regseconds',
  type: 'date',
  dateFormat: Date.patterns.ISO8601Long
}, {
  name: 'ipaddr'
}, {
  name: 'regexten'
}, {
  name: 'cancallforward'
}, {
  name: 'setvar'
}, {
  name: 'notifyringing'
}, {
  name: 'useclientcode'
}, {
  name: 'authuser'
}, {
  name: 'call-limit'
}, {
  name: 'busy-level'
}, {
  name: 'cfi_mode'
}, {
  name: 'cfi_number'
}, {
  name: 'cfb_mode'
}, {
  name: 'cfb_number'
}, {
  name: 'cfd_mode'
}, {
  name: 'cfd_number'
}, {
  name: 'cfd_time'
}]);
/**
 * @type {Tine.Tinebase.data.Record}
 * Voipmanager record definition
 */

Tine.Voipmanager.Model.AsteriskSipPeer = Tine.Tinebase.data.Record.create(Tine.Voipmanager.Model.AsteriskSipPeerArray, {
  appName: 'Voipmanager',
  modelName: 'AsteriskSipPeer',
  idProperty: 'id',
  titleProperty: 'name',
  // ngettext('SipPeer', 'SipPeers', n);
  recordName: 'AsteriskSipPeer',
  recordsName: 'AsteriskSipPeers',
  containerProperty: 'sipPeer_id',
  // ngettext('sipPeers list', 'sipPeers lists', n);
  containerName: 'sipPeers list',
  containersName: 'sipPeers lists',
  getTitle: function getTitle() {
    return this.get('name') ? this.get('name') : false;
  }
});

Tine.Voipmanager.Model.AsteriskSipPeer.getDefaultData = function () {
  return {};
};

Tine.Voipmanager.Model.AsteriskSipPeer.getFilterModel = function () {
  if (!app) {
    var app = Tine.Tinebase.appMgr.get('Voipmanager');
  }

  return [{
    label: i18n._('Quick Search'),
    field: 'query',
    operators: ['contains']
  }, {
    label: app.i18n._('Name'),
    field: 'name'
  }];
};

Tine.Voipmanager.Model.AsteriskContextArray = Tine.Tinebase.Model.modlogFields.concat([{
  name: 'id'
}, {
  name: 'name'
}, {
  name: 'description'
}]);
/**
 * @type {Tine.Tinebase.data.Record}
 * Voipmanager record definition
 */

Tine.Voipmanager.Model.AsteriskContext = Tine.Tinebase.data.Record.create(Tine.Voipmanager.Model.AsteriskContextArray, {
  appName: 'Voipmanager',
  modelName: 'AsteriskContext',
  idProperty: 'id',
  titleProperty: 'name',
  // ngettext('Context', 'Contexts', n);
  recordName: 'AsteriskContext',
  recordsName: 'AsteriskContexts',
  containerProperty: 'context_id',
  // ngettext('contexts list', 'contexts lists', n);
  containerName: 'contexts list',
  containersName: 'contexts lists',
  getTitle: function getTitle() {
    return this.get('name') ? this.get('name') : false;
  }
});

Tine.Voipmanager.Model.AsteriskContext.getDefaultData = function () {
  return {};
};

Tine.Voipmanager.Model.AsteriskContext.getFilterModel = function () {
  return [{
    label: i18n._('Quick Search'),
    field: 'query',
    operators: ['contains']
  }];
};

Tine.Voipmanager.Model.AsteriskVoicemailArray = Tine.Tinebase.Model.modlogFields.concat([{
  name: 'id'
}, {
  name: 'context_id'
}, {
  name: 'context'
}, {
  name: 'mailbox'
}, {
  name: 'password'
}, {
  name: 'fullname'
}, {
  name: 'email'
}, {
  name: 'pager'
}, {
  name: 'tz'
}, {
  name: 'attach'
}, {
  name: 'saycid'
}, {
  name: 'dialout'
}, {
  name: 'callback'
}, {
  name: 'review'
}, {
  name: 'operator'
}, {
  name: 'envelope'
}, {
  name: 'sayduration'
}, {
  name: 'saydurationm'
}, {
  name: 'sendvoicemail'
}, {
  name: 'delete'
}, {
  name: 'nextaftercmd'
}, {
  name: 'forcename'
}, {
  name: 'forcegreetings'
}, {
  name: 'hidefromdir'
}]);
/**
 * @type {Tine.Tinebase.data.Record}
 * Voipmanager record definition
 */

Tine.Voipmanager.Model.AsteriskVoicemail = Tine.Tinebase.data.Record.create(Tine.Voipmanager.Model.AsteriskVoicemailArray, {
  appName: 'Voipmanager',
  modelName: 'AsteriskVoicemail',
  idProperty: 'id',
  titleProperty: 'mailbox',
  // ngettext('Voicemail', 'Voicemails', n);
  recordName: 'AsteriskVoicemail',
  recordsName: 'AsteriskVoicemails',
  containerProperty: 'voicemail_id',
  // ngettext('voicemails list', 'voicemails lists', n);
  containerName: 'voicemails list',
  containersName: 'voicemails lists',
  getTitle: function getTitle() {
    return this.get('mailbox') ? this.get('mailbox') : false;
  }
});

Tine.Voipmanager.Model.AsteriskVoicemail.getDefaultData = function () {
  return {};
};

Tine.Voipmanager.Model.AsteriskVoicemail.getFilterModel = function () {
  return [{
    label: i18n._('Quick Search'),
    field: 'query',
    operators: ['contains']
  }];
};

Tine.Voipmanager.Model.AsteriskMeetmeArray = Tine.Tinebase.Model.modlogFields.concat([{
  name: 'id'
}, {
  name: 'confno'
}, {
  name: 'pin'
}, {
  name: 'adminpin'
}]);
/**
 * @type {Tine.Tinebase.data.Record}
 * Voipmanager record definition
 */

Tine.Voipmanager.Model.AsteriskMeetme = Tine.Tinebase.data.Record.create(Tine.Voipmanager.Model.AsteriskMeetmeArray, {
  appName: 'Voipmanager',
  modelName: 'AsteriskMeetme',
  idProperty: 'id',
  titleProperty: 'confno',
  // ngettext('Meetme', 'Meetmes', n);
  recordName: 'AsteriskMeetme',
  recordsName: 'AsteriskMeetmes',
  containerProperty: 'meetme_id',
  // ngettext('meetmes list', 'meetmes lists', n);
  containerName: 'meetmes list',
  containersName: 'meetmes lists',
  getTitle: function getTitle() {
    return this.get('number') ? this.get('number') + ' ' + this.get('confno') : false;
  }
});

Tine.Voipmanager.Model.AsteriskMeetme.getDefaultData = function () {
  return {};
};

Tine.Voipmanager.Model.AsteriskMeetme.getFilterModel = function () {
  return [{
    label: i18n._('Quick Search'),
    field: 'query',
    operators: ['contains']
  }];
};

/***/ }),

/***/ 312:
/***/ (function(module, exports, __webpack_require__) {

/**
 * Tine 2.0
 * 
 * @package     Voipmanager
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Thomas Wadewitz <t.wadewitz@metaways.de>
 * @copyright   Copyright (c) 2007-2009 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 * TODO         perhaps we should load the settings only if settings tab is clicked
 * TODO         don't use json stores for lines/rights
 */
Ext.namespace('Tine.Voipmanager');

__webpack_require__(143);

__webpack_require__(313);
/**
 * Snom Phone Edit Dialog
 */


Tine.Voipmanager.SnomPhoneEditDialog = Ext.extend(Tine.widgets.dialog.EditDialog, {
  /**
   * @private
   */
  windowNamePrefix: 'SnomPhoneEditWindow_',
  appName: 'Voipmanager',
  recordClass: Tine.Voipmanager.Model.SnomPhone,
  recordProxy: null,
  evalGrants: false,

  /**
   * @property {Ext.data.JsonStore}
   */
  rightsStore: null,

  /**
   * @property {Ext.data.JsonStore}
   */
  linesStore: null,

  /**
   * @property {Tine.Voipmanager.LineGridPanel}
   */
  linesGrid: null,

  /**
   * max lines (depending on phone model)
   * 
   * @type Number
   */
  maxLines: 4,

  /**
   * writeable fields (from phone settings)
   * 
   * @type Object
   */
  writeableFields: null,

  /**
   * @property {Locale.Gettext}
   */
  i18n: null,

  /**
   * @private
   * 
   */
  initComponent: function initComponent() {
    this.recordProxy = this.recordProxy == null ? Tine.Voipmanager.SnomPhoneBackend : this.recordProxy; // why the hack is this a jsonStore???

    this.rightsStore = new Ext.data.JsonStore({
      root: 'results',
      totalProperty: 'totalcount',
      id: 'id',
      fields: Tine.Voipmanager.Model.SnomPhoneRight
    }); // why the hack is this a jsonStore???

    this.linesStore = new Ext.data.JsonStore({
      root: 'results',
      totalProperty: 'totalcount',
      id: 'id',
      fields: Tine.Voipmanager.Model.SnomLine
    });
    Tine.Voipmanager.SnomPhoneEditDialog.superclass.initComponent.call(this);
  },

  /**
   * record load (get rights and put them into the store)
   */
  onRecordLoad: function onRecordLoad() {
    var rights = this.record.get('rights') || [];
    this.rightsStore.loadData({
      results: rights
    }); // copy fields from asteriskline_id for lines grid

    var lines = this.record.get('lines') || [];
    var fields = ['cfi_mode', 'cfi_number', 'cfb_mode', 'cfb_number', 'cfd_mode', 'cfd_number', 'cfd_time'];

    for (var j = 0; j < lines.length; j++) {
      for (var i = 0; i < fields.length; i++) {
        lines[j][fields[i]] = lines[j].asteriskline_id[fields[i]];
      }
    }

    this.linesStore.loadData({
      results: lines
    });

    if (this.record.get('setting_id')) {
      this.getWriteableFields(this.record.get('setting_id'));
    }

    Tine.Voipmanager.SnomPhoneEditDialog.superclass.onRecordLoad.call(this);
  },

  /**
   * record update (push rights and lines into record property)
   */
  onRecordUpdate: function onRecordUpdate() {
    Tine.Voipmanager.SnomPhoneEditDialog.superclass.onRecordUpdate.call(this);
    this.record.set('rights', '');
    this.record.set('lines', '');
    var rights = [];
    this.rightsStore.each(function (_record) {
      rights.push(_record.data);
    });
    this.record.set('rights', rights); // save lines / copy fields to asteriskline_id

    var lines = [];
    var fields = ['cfi_mode', 'cfi_number', 'cfb_mode', 'cfb_number', 'cfd_mode', 'cfd_number', 'cfd_time'];
    this.linesStore.each(function (_record) {
      var data = _record.data;

      for (var i = 0; i < fields.length; i++) {
        data.asteriskline_id[fields[i]] = data[fields[i]];
      }

      lines.push(data);
    });
    this.record.set('lines', lines);
  },

  /**
   * 
   * @param {} setting_id
   */
  getWriteableFields: function getWriteableFields(setting_id) {
    Ext.Ajax.request({
      params: {
        method: 'Voipmanager.getSnomSetting',
        id: setting_id
      },
      success: function success(_result, _request) {
        _data = Ext.util.JSON.decode(_result.responseText);
        _writableFields = new Array('web_language', 'language', 'display_method', 'mwi_notification', 'mwi_dialtone', 'headset_device', 'message_led_other', 'global_missed_counter', 'pickup_indication', 'scroll_outgoing', 'show_local_line', 'show_call_status', 'call_waiting');
        this.writeableFields = new Object();

        var _settingsData = new Object();

        Ext.each(_writableFields, function (_item, _index, _all) {
          _rwField = _item.toString() + '_writable'; // update record

          if (_data[_rwField] == '0' || !this.record.get(_item)) {
            this.record.set(_item, _data[_item]);
          } // set writeable fields


          this.getForm().findField(_item).setDisabled(_data[_rwField] == '0');
          this.getForm().findField(_item).setValue(this.record.get(_item));
        }, this);
      },
      failure: function failure(result, request) {
        Ext.MessageBox.alert('Failed', 'No settings data found.');
      },
      scope: this
    });
  },

  /**
   * update settings on template change
   * 
   * @param {} _combo
   * @param {} _record
   * @param {} _index
   */
  onTemplateChange: function onTemplateChange(_combo, _record, _index) {
    var setting_id = false;

    if (_record.data && _record.data.setting_id) {
      setting_id = _record.data.setting_id;
    }

    if (!setting_id && this.getForm().findField('template_id').store.getById(this.getForm().findField('template_id').getValue())) {
      setting_id = this.getForm().findField('template_id').store.getById(this.getForm().findField('template_id').getValue()).data.setting_id;
    }

    if (setting_id) {
      this.getWriteableFields(setting_id);
    }
  },

  /**
   * returns dialog
   * 
   * NOTE: when this method gets called, all initalisation is done.
   */
  getFormItems: function getFormItems() {
    var callForwardPanel = new Tine.Voipmanager.CallForwardPanel({
      app: this.app,
      editDialog: this,
      flex: 1
    });
    this.linesGrid = new Tine.Voipmanager.LineGridPanel({
      store: this.linesStore,
      app: this.app,
      cfPanel: callForwardPanel,
      editDialog: this,
      flex: 1
    });
    this.linesPanel = new Ext.Panel({
      title: this.getTranslations()._('Lines'),
      layout: {
        type: 'hbox',
        align: 'stretch'
      },
      items: [this.linesGrid, callForwardPanel]
    });
    var items = this.recordProxy.appName == 'Voipmanager' ? [this.getPhonePanel(), this.linesPanel, this.getSettingsPanel(), this.getRightsPanel()] : [this.linesPanel, this.getSettingsPanel()];
    return {
      xtype: 'tabpanel',
      border: false,
      plain: true,
      activeTab: 0,
      deferredRender: false,
      items: items
    };
  },

  /**
   * returns general phone panel (first panel)
   * 
   * @return {Object}
   */
  getPhonePanel: function getPhonePanel() {
    return {
      title: this.app.i18n._('Phone'),
      layout: 'hfit',
      frame: true,
      border: false,
      items: [{
        xtype: 'columnform',
        formDefaults: {
          columnWidth: 0.5,
          anchor: '100%',
          labelSeparator: ''
        },
        items: [[{
          xtype: 'textfield',
          name: 'description',
          fieldLabel: this.getTranslations()._('Name'),
          allowBlank: false
        }, {
          xtype: 'combo',
          fieldLabel: this.getTranslations()._('Phone Model'),
          name: 'current_model',
          mode: 'local',
          displayField: 'model',
          valueField: 'id',
          triggerAction: 'all',
          editable: false,
          forceSelection: true,
          store: Tine.Voipmanager.Data.loadPhoneModelData(),
          allowBlank: false
        }], [{
          xtype: 'textfield',
          fieldLabel: this.getTranslations()._('MAC Address'),
          name: 'macaddress',
          maxLength: 12,
          allowBlank: false
        }, {
          xtype: 'reccombo',
          name: 'template_id',
          fieldLabel: this.getTranslations().n_('Template', 'Templates', 1),
          displayField: 'name',
          store: new Ext.data.Store({
            fields: Tine.Voipmanager.Model.SnomTemplate,
            proxy: Tine.Voipmanager.SnomTemplateBackend,
            reader: Tine.Voipmanager.SnomTemplateBackend.getReader(),
            remoteSort: true,
            sortInfo: {
              field: 'name',
              dir: 'ASC'
            }
          }),
          listeners: {
            scope: this,
            select: this.onTemplateChange
          },
          allowBlank: false
        }], [{
          xtype: 'reccombo',
          name: 'location_id',
          fieldLabel: this.getTranslations().n_('Location', 'Locations', 1),
          displayField: 'name',
          store: new Ext.data.Store({
            fields: Tine.Voipmanager.Model.SnomLocation,
            proxy: Tine.Voipmanager.SnomLocationBackend,
            reader: Tine.Voipmanager.SnomLocationBackend.getReader(),
            remoteSort: true,
            sortInfo: {
              field: 'name',
              dir: 'ASC'
            }
          }),
          allowBlank: false
        }]]
      }, {
        title: this.getTranslations()._('infos'),
        autoHeight: true,
        xtype: 'fieldset',
        checkboxToggle: false,
        items: [{
          xtype: 'columnform',
          border: false,
          formDefaults: {
            columnWidth: 0.5,
            anchor: '100%',
            labelSeparator: ''
          },
          items: [[{
            xtype: 'textfield',
            fieldLabel: this.getTranslations()._('Current IP Address'),
            name: 'ipaddress',
            maxLength: 20,
            anchor: '98%',
            readOnly: true
          }, {
            xtype: 'datetimefield',
            fieldLabel: this.getTranslations()._('Firmware last checked at'),
            name: 'firmware_checked_at',
            anchor: '100%',
            emptyText: 'never',
            hideTrigger: true,
            readOnly: true
          }], [{
            xtype: 'textfield',
            fieldLabel: this.getTranslations()._('Current Software Version'),
            name: 'current_software',
            maxLength: 20,
            anchor: '98%',
            readOnly: true
          }, {
            xtype: 'datetimefield',
            fieldLabel: this.getTranslations()._('Settings Loaded at'),
            name: 'settings_loaded_at',
            anchor: '100%',
            emptyText: 'never',
            hideTrigger: true,
            readOnly: true
          }]]
        }]
      }]
    };
  },

  /**
   * returns settings panel (second panel)
   * 
   * @return {Object}
   */
  getSettingsPanel: function getSettingsPanel() {
    return {
      title: this.getTranslations()._('Settings'),
      id: 'settingsBorderLayout',
      frame: true,
      border: false,
      xtype: 'columnform',
      formDefaults: {
        xtype: 'combo',
        anchor: '100%',
        labelSeparator: '',
        columnWidth: .333,
        mode: 'local',
        triggerAction: 'all',
        editable: false,
        forceSelection: true,
        value: null
      },
      items: [[{
        fieldLabel: this.getTranslations()._('web_language'),
        name: 'web_language',
        disabled: this.writeableFields ? this.writeableFields.web_language : true,
        store: [[null, this.getTranslations()._('- factory default -')], ['English', Locale.getTranslationData('Language', 'en')], ['Deutsch', Locale.getTranslationData('Language', 'de')], ['Espanol', Locale.getTranslationData('Language', 'es')], ['Francais', Locale.getTranslationData('Language', 'fr')], ['Italiano', Locale.getTranslationData('Language', 'it')], ['Nederlands', Locale.getTranslationData('Language', 'nl')], ['Portugues', Locale.getTranslationData('Language', 'pt')], ['Suomi', Locale.getTranslationData('Language', 'fi')], ['Svenska', Locale.getTranslationData('Language', 'sv')], ['Dansk', Locale.getTranslationData('Language', 'da')], ['Norsk', Locale.getTranslationData('Language', 'no')]]
      }, {
        fieldLabel: this.getTranslations()._('language'),
        name: 'language',
        disabled: this.writeableFields ? this.writeableFields.language : true,
        store: [[null, this.getTranslations()._('- factory default -')], ['English', Locale.getTranslationData('Language', 'en')], ['English(UK)', Locale.getTranslationData('Language', 'en_GB')], ['Deutsch', Locale.getTranslationData('Language', 'de')], ['Espanol', Locale.getTranslationData('Language', 'es')], ['Francais', Locale.getTranslationData('Language', 'fr')], ['Italiano', Locale.getTranslationData('Language', 'it')], ['Cestina', Locale.getTranslationData('Language', 'cs')], ['Nederlands', Locale.getTranslationData('Language', 'nl')], ['Polski', Locale.getTranslationData('Language', 'pl')], ['Portugues', Locale.getTranslationData('Language', 'pt')], ['Slovencina', Locale.getTranslationData('Language', 'sl')], ['Suomi', Locale.getTranslationData('Language', 'fi')], ['Svenska', Locale.getTranslationData('Language', 'sv')], ['Dansk', Locale.getTranslationData('Language', 'da')], ['Norsk', Locale.getTranslationData('Language', 'no')], ['Japanese', Locale.getTranslationData('Language', 'ja')], ['Chinese', Locale.getTranslationData('Language', 'zh')]]
      }, {
        fieldLabel: this.getTranslations()._('display_method'),
        name: 'display_method',
        disabled: this.writeableFields ? this.writeableFields.display_method : true,
        store: [[null, this.getTranslations()._('- factory default -')], ['full_contact', this.getTranslations()._('whole url')], ['display_name', this.getTranslations()._('name')], ['display_number', this.getTranslations()._('number')], ['display_name_number', this.getTranslations()._('name + number')], ['display_number_name', this.getTranslations()._('number + name')]]
      }], [{
        fieldLabel: this.getTranslations()._('call_waiting'),
        name: 'call_waiting',
        disabled: this.writeableFields ? this.writeableFields.call_waiting : true,
        store: [[null, this.getTranslations()._('- factory default -')], ['on', this.getTranslations()._('on')], ['visual', this.getTranslations()._('visual')], ['ringer', this.getTranslations()._('ringer')], ['off', this.getTranslations()._('off')]]
      }, {
        fieldLabel: this.getTranslations()._('mwi_notification'),
        name: 'mwi_notification',
        disabled: this.writeableFields ? this.writeableFields.mwi_notification : true,
        store: [[null, this.getTranslations()._('- factory default -')], ['silent', this.getTranslations()._('silent')], ['beep', this.getTranslations()._('beep')], ['reminder', this.getTranslations()._('reminder')]]
      }, {
        fieldLabel: this.getTranslations()._('mwi_dialtone'),
        name: 'mwi_dialtone',
        disabled: this.writeableFields ? this.writeableFields.mwi_dialtone : true,
        store: [[null, this.getTranslations()._('- factory default -')], ['normal', this.getTranslations()._('normal')], ['stutter', this.getTranslations()._('stutter')]]
      }], [{
        fieldLabel: this.getTranslations()._('headset_device'),
        name: 'headset_device',
        disabled: this.writeableFields ? this.writeableFields.headset_device : true,
        store: [[null, this.getTranslations()._('- factory default -')], ['none', this.getTranslations()._('none')], ['headset_rj', this.getTranslations()._('headset_rj')]]
      }, {
        fieldLabel: this.getTranslations()._('message_led_other'),
        name: 'message_led_other',
        disabled: this.writeableFields ? this.writeableFields.message_led_other : true,
        store: [[null, this.getTranslations()._('- factory default -')], ['1', this.getTranslations()._('on')], ['0', this.getTranslations()._('off')]]
      }, {
        fieldLabel: this.getTranslations()._('global_missed_counter'),
        name: 'global_missed_counter',
        disabled: this.writeableFields ? this.writeableFields.global_missed_counter : true,
        store: [[null, this.getTranslations()._('- factory default -')], ['1', this.getTranslations()._('on')], ['0', this.getTranslations()._('off')]]
      }], [{
        fieldLabel: this.getTranslations()._('scroll_outgoing'),
        name: 'scroll_outgoing',
        disabled: this.writeableFields ? this.writeableFields.scroll_outgoing : true,
        store: [[null, this.getTranslations()._('- factory default -')], ['1', this.getTranslations()._('on')], ['0', this.getTranslations()._('off')]]
      }, {
        fieldLabel: this.getTranslations()._('show_local_line'),
        name: 'show_local_line',
        disabled: this.writeableFields ? this.writeableFields.show_local_line : true,
        store: [[null, this.getTranslations()._('- factory default -')], ['1', this.getTranslations()._('on')], ['0', this.getTranslations()._('off')]]
      }, {
        fieldLabel: this.getTranslations()._('show_call_status'),
        name: 'show_call_status',
        disabled: this.writeableFields ? this.writeableFields.show_call_status : true,
        store: [[null, this.getTranslations()._('- factory default -')], ['1', this.getTranslations()._('on')], ['0', this.getTranslations()._('off')]]
      }], [{
        fieldLabel: this.getTranslations()._('Pickup indication'),
        name: 'pickup_indication',
        disabled: this.writeableFields ? this.writeableFields.pickup_indication : true,
        store: [[null, this.getTranslations()._('- factory default -')], ['1', this.getTranslations()._('on')], ['0', this.getTranslations()._('off')]]
      }]]
    };
  },

  /**
   * returns right panel (fourth panel)
   * 
   * @return {Object}
   */
  getRightsPanel: function getRightsPanel() {
    return {
      title: this.getTranslations()._('Users'),
      layout: 'fit',
      items: new Tine.widgets.account.PickerGridPanel({
        accountPickerType: 'both',
        store: this.rightsStore,
        hasAccountPrefix: true
      })
    };
  },

  /**
   * get translations
   * 
   * @return {Locale.Gettext}
   */
  getTranslations: function getTranslations() {
    if (this.i18n == null) {
      // we need to init translations because it could be that we call this from Phone app without Voipmanager
      if (!this.app) {
        this.i18n = new Locale.Gettext();
        this.i18n.textdomain('Voipmanager');
      } else {
        this.i18n = this.app.i18n;
      }
    }

    return this.i18n;
  }
});
/**
 * Snom Phone Edit Popup
 */

Tine.Voipmanager.SnomPhoneEditDialog.openWindow = function (config) {
  var id = config.record && config.record.id ? config.record.id : 0;
  var window = Tine.WindowFactory.getWindow({
    width: 800,
    height: 350,
    name: Tine.Voipmanager.SnomPhoneEditDialog.prototype.windowNamePrefix + id,
    contentPanelConstructor: 'Tine.Voipmanager.SnomPhoneEditDialog',
    contentPanelConstructorConfig: config
  });
  return window;
};

/***/ }),

/***/ 313:
/***/ (function(module, exports, __webpack_require__) {

/*
 * Tine 2.0
 * 
 * @package     Tinebase
 * @subpackage  widgets
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Philipp Schüle <p.schuele@metaways.de>
 * @copyright   Copyright (c) 2010-2011 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 */
Ext.namespace('Tine.Voipmanager');

__webpack_require__(143);
/**
 * Line Picker GridPanel
 * 
 * @namespace   Tine.Voipmanager
 * @class       Tine.Voipmanager.LineGridPanel
 * @extends     Tine.widgets.grid.PickerGridPanel
 * 
 * <p>Line Picker GridPanel</p>
 * <p><pre>
 * TODO         check max number of lines ?
 * </pre></p>
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Philipp Schuele <p.schuele@metaways.de>
 * @copyright   Copyright (c) 2010 Metaways Infosystems GmbH (http://www.metaways.de)
 * 
 * @param       {Object} config
 * @constructor
 * Create a new Tine.Voipmanager.LineGridPanel
 */


Tine.Voipmanager.LineGridPanel = Ext.extend(Tine.widgets.grid.PickerGridPanel, {
  /**
   * 
   * @type tinebase app 
   */
  app: null,

  /**
   * 
   * @type Tine.Voipmanager.CallForwardPanel
   */
  cfPanel: null,

  /**
   * Tine record
   * @type 
   */
  activeRecord: null,

  /**
   * @type Tine.widgets.dialog.EditDialog
   */
  editDialog: null,

  /**
   * 
   * @cfg
   */
  clicksToEdit: 2,
  autoExpandColumn: 'name',
  // needed to select the first row after render!
  deferRowRender: false,

  /**
   * @private
   */
  initComponent: function initComponent() {
    this.recordClass = Tine.Voipmanager.Model.SnomLine;
    this.searchRecordClass = Tine.Voipmanager.Model.AsteriskSipPeer;
    this.cfPanel.on('change', this.onFieldChange, this);
    this.cfPanel.setDisabled(true);
    Tine.Voipmanager.LineGridPanel.superclass.initComponent.call(this);
    this.on('afterrender', this.onAfterRender, this);
    this.store.on('load', this.onStoreLoad, this);
  },

  /**
   * select first row after render
   */
  onAfterRender: function onAfterRender() {
    if (this.store.getCount() > 0) {
      this.getSelectionModel().selectFirstRow();
    }
  },

  /**
   * select first row after render
   */
  onStoreLoad: function onStoreLoad(store, records, options) {
    if (this.rendered && records.length > 0) {
      var index = store.indexOf(records[0]),
          row = this.getView().getRow(index);
      Ext.fly(row).highlight();
      this.getSelectionModel().selectRow(index);
    }
  },

  /**
   * on call forward form field change: update store
   */
  onFieldChange: function onFieldChange() {
    this.editDialog.getForm().updateRecord(this.activeRecord);
    this.getView().refresh();
  },

  /**
   * Return CSS class to apply to rows depending upon record state
   * 
   * @param {} record
   * @param {Integer} index
   * @return {String}
   */
  getViewRowClass: function getViewRowClass(record, index) {
    var result = '';

    if (record.dirty) {
      result = 'voipmanager-row-changed';
    }

    return result;
  },

  /**
   * init actions and toolbars
   */
  initActionsAndToolbars: function initActionsAndToolbars() {
    Tine.Voipmanager.LineGridPanel.superclass.initActionsAndToolbars.call(this); // only allow to add new lines from Voipmanager

    if (this.editDialog.recordProxy.appName == 'Voipmanager') {
      this.searchCombo = this.getSearchCombo();
      this.comboPanel = new Ext.Panel({
        layout: 'hfit',
        border: false,
        items: this.searchCombo,
        columnWidth: 1
      });
      this.tbar = new Ext.Toolbar({
        items: [this.comboPanel],
        layout: 'column'
      });
    }
  },

  /**
   * Is called when a record gets selected in the picker combo
   * 
   * @param {Ext.form.ComboBox} picker
   * @param {Record} recordToAdd
   */
  onAddRecordFromCombo: function onAddRecordFromCombo(picker, recordToAdd) {
    if (!recordToAdd) {
      return;
    }

    var recordData = {
      asteriskline_id: recordToAdd.data,
      linenumber: this.store.getCount() + 1,
      lineactive: 1
    };
    var record = new Tine.Voipmanager.Model.SnomLine(recordData);
    var fields = ['cfi_mode', 'cfi_number', 'cfb_mode', 'cfb_number', 'cfd_mode', 'cfd_number', 'cfd_time'];

    for (var i = 0; i < fields.length; i++) {
      record.data[fields[i]] = recordToAdd.data[fields[i]];
    } // check if already in


    var found = false;
    this.store.each(function (line) {
      if (line.data.asteriskline_id.id == recordToAdd.data.id) {
        found = true;
      }

      if (line.get('linenumber') == record.get('linenumber')) {
        // use next linenumber
        // TODO should be improved, maybe server should decide which (free) linenumber should be used
        record.set('linenumber', line.get('linenumber') + 1);
      }
    }, this);

    if (!found) {
      // if not found -> add
      this.store.add([record]);
    }

    picker.reset();
  },

  /**
   * init selection model
   */
  initGrid: function initGrid() {
    Tine.Voipmanager.LineGridPanel.superclass.initGrid.call(this);
    this.selModel.on('selectionchange', this.onSelectionChange, this); // init view

    this.view = new Ext.grid.GridView({
      getRowClass: this.getViewRowClass,
      autoFill: true,
      forceFit: true
    });
  },

  /**
   * on selection change handler
   * @param {} sm
   */
  onSelectionChange: function onSelectionChange(sm) {
    var rowCount = sm.getCount();

    if (rowCount == 1) {
      var selectedRows = sm.getSelections();
      this.activeRecord = selectedRows[0];
      this.cfPanel.setDisabled(false); //this.cfPanel.getForm().loadRecord(this.activeRecord);

      this.editDialog.getForm().loadRecord(this.activeRecord);
      this.cfPanel.onRecordLoad(this.activeRecord);
    } else {
      //this.cfPanel.getForm().reset();
      this.cfPanel.setDisabled(true);
    } // only allow to remove lines from Voipmanager and if rowCount > 0


    this.actionRemove.setDisabled(this.editDialog.recordProxy.appName != 'Voipmanager' || rowCount == 0);
  },

  /**
   * @return Ext.grid.ColumnModel
   * @private
   */
  getColumnModel: function getColumnModel() {
    if (!this.colModel) {
      // we need to init translations because it could be that we call this from Phone app without Voipmanager
      var translations;

      if (!this.app) {
        translations = new Locale.Gettext();
        translations.textdomain('Voipmanager');
      } else {
        translations = this.app.i18n;
      }

      this.colModel = new Ext.grid.ColumnModel({
        defaults: {
          sortable: true
        },
        columns: [{
          id: 'linenumber',
          header: '',
          dataIndex: 'linenumber',
          width: 20
        }, {
          id: 'name',
          header: translations._('Line'),
          dataIndex: 'asteriskline_id',
          width: 120,
          renderer: this.nameRenderer
        }, {
          id: 'idletext',
          header: translations._('Idle Text'),
          dataIndex: 'idletext',
          width: 100,
          editor: new Ext.form.TextField({
            allowBlank: false,
            allowNegative: false,
            maxLength: 60
          })
        }]
      });
    }

    return this.colModel;
  },
  nameRenderer: function nameRenderer(value) {
    return value && value.name ? value.name : '';
  },
  initFilterPanel: function initFilterPanel() {}
});

/***/ }),

/***/ 35:
/***/ (function(module, exports) {


/**
 * When source maps are enabled, `style-loader` uses a link element with a data-uri to
 * embed the css on the page. This breaks all relative urls because now they are relative to a
 * bundle instead of the current page.
 *
 * One solution is to only use full urls, but that may be impossible.
 *
 * Instead, this function "fixes" the relative urls to be absolute according to the current page location.
 *
 * A rudimentary test suite is located at `test/fixUrls.js` and can be run via the `npm test` command.
 *
 */

module.exports = function (css) {
  // get current location
  var location = typeof window !== "undefined" && window.location;

  if (!location) {
    throw new Error("fixUrls requires window.location");
  }

	// blank or null?
	if (!css || typeof css !== "string") {
	  return css;
  }

  var baseUrl = location.protocol + "//" + location.host;
  var currentDir = baseUrl + location.pathname.replace(/\/[^\/]*$/, "/");

	// convert each url(...)
	/*
	This regular expression is just a way to recursively match brackets within
	a string.

	 /url\s*\(  = Match on the word "url" with any whitespace after it and then a parens
	   (  = Start a capturing group
	     (?:  = Start a non-capturing group
	         [^)(]  = Match anything that isn't a parentheses
	         |  = OR
	         \(  = Match a start parentheses
	             (?:  = Start another non-capturing groups
	                 [^)(]+  = Match anything that isn't a parentheses
	                 |  = OR
	                 \(  = Match a start parentheses
	                     [^)(]*  = Match anything that isn't a parentheses
	                 \)  = Match a end parentheses
	             )  = End Group
              *\) = Match anything and then a close parens
          )  = Close non-capturing group
          *  = Match anything
       )  = Close capturing group
	 \)  = Match a close parens

	 /gi  = Get all matches, not the first.  Be case insensitive.
	 */
	var fixedCss = css.replace(/url\s*\(((?:[^)(]|\((?:[^)(]+|\([^)(]*\))*\))*)\)/gi, function(fullMatch, origUrl) {
		// strip quotes (if they exist)
		var unquotedOrigUrl = origUrl
			.trim()
			.replace(/^"(.*)"$/, function(o, $1){ return $1; })
			.replace(/^'(.*)'$/, function(o, $1){ return $1; });

		// already a full url? no change
		if (/^(#|data:|http:\/\/|https:\/\/|file:\/\/\/)/i.test(unquotedOrigUrl)) {
		  return fullMatch;
		}

		// convert the url to a full url
		var newUrl;

		if (unquotedOrigUrl.indexOf("//") === 0) {
		  	//TODO: should we add protocol?
			newUrl = unquotedOrigUrl;
		} else if (unquotedOrigUrl.indexOf("/") === 0) {
			// path should be relative to the base url
			newUrl = baseUrl + unquotedOrigUrl; // already starts with '/'
		} else {
			// path should be relative to current directory
			newUrl = currentDir + unquotedOrigUrl.replace(/^\.\//, ""); // Strip leading './'
		}

		// send back the fixed url(...)
		return "url(" + JSON.stringify(newUrl) + ")";
	});

	// send back the fixed css
	return fixedCss;
};


/***/ }),

/***/ 89:
/***/ (function(module, exports, __webpack_require__) {

/* pkg: Phone FAT Client (js/Phone-FAT.js)*/
__webpack_require__(1989);
__webpack_require__(1990);
__webpack_require__(1991);
__webpack_require__(1992);
__webpack_require__(1993);
/* pkg: Phone FAT Client (css/Phone-FAT.css)*/
__webpack_require__(1994);


/***/ }),

/***/ 98:
/***/ (function(module, exports) {

module.exports = function escape(url) {
    if (typeof url !== 'string') {
        return url
    }
    // If url is already wrapped in quotes, remove them
    if (/^['"].*['"]$/.test(url)) {
        url = url.slice(1, -1);
    }
    // Should url be wrapped?
    // See https://drafts.csswg.org/css-values-3/#urls
    if (/["'() \t\n]/.test(url)) {
        return '"' + url.replace(/"/g, '\\"').replace(/\n/g, '\\n') + '"'
    }

    return url
}


/***/ })

}]);