(window["webpackJsonp"] = window["webpackJsonp"] || []).push([[19],{

/***/ 10:
/***/ (function(module, exports) {

/*
	MIT License http://www.opensource.org/licenses/mit-license.php
	Author Tobias Koppers @sokra
*/
// css base code, injected by the css-loader
module.exports = function(useSourceMap) {
	var list = [];

	// return the list of modules as css string
	list.toString = function toString() {
		return this.map(function (item) {
			var content = cssWithMappingToString(item, useSourceMap);
			if(item[2]) {
				return "@media " + item[2] + "{" + content + "}";
			} else {
				return content;
			}
		}).join("");
	};

	// import a list of modules into the list
	list.i = function(modules, mediaQuery) {
		if(typeof modules === "string")
			modules = [[null, modules, ""]];
		var alreadyImportedModules = {};
		for(var i = 0; i < this.length; i++) {
			var id = this[i][0];
			if(typeof id === "number")
				alreadyImportedModules[id] = true;
		}
		for(i = 0; i < modules.length; i++) {
			var item = modules[i];
			// skip already imported module
			// this implementation is not 100% perfect for weird media query combinations
			//  when a module is imported multiple times with different media queries.
			//  I hope this will never occur (Hey this way we have smaller bundles)
			if(typeof item[0] !== "number" || !alreadyImportedModules[item[0]]) {
				if(mediaQuery && !item[2]) {
					item[2] = mediaQuery;
				} else if(mediaQuery) {
					item[2] = "(" + item[2] + ") and (" + mediaQuery + ")";
				}
				list.push(item);
			}
		}
	};
	return list;
};

function cssWithMappingToString(item, useSourceMap) {
	var content = item[1] || '';
	var cssMapping = item[3];
	if (!cssMapping) {
		return content;
	}

	if (useSourceMap && typeof btoa === 'function') {
		var sourceMapping = toComment(cssMapping);
		var sourceURLs = cssMapping.sources.map(function (source) {
			return '/*# sourceURL=' + cssMapping.sourceRoot + source + ' */'
		});

		return [content].concat(sourceURLs).concat([sourceMapping]).join('\n');
	}

	return [content].join('\n');
}

// Adapted from convert-source-map (MIT)
function toComment(sourceMap) {
	// eslint-disable-next-line no-undef
	var base64 = btoa(unescape(encodeURIComponent(JSON.stringify(sourceMap))));
	var data = 'sourceMappingURL=data:application/json;charset=utf-8;base64,' + base64;

	return '/*# ' + data + ' */';
}


/***/ }),

/***/ 11:
/***/ (function(module, exports, __webpack_require__) {

/*
	MIT License http://www.opensource.org/licenses/mit-license.php
	Author Tobias Koppers @sokra
*/

var stylesInDom = {};

var	memoize = function (fn) {
	var memo;

	return function () {
		if (typeof memo === "undefined") memo = fn.apply(this, arguments);
		return memo;
	};
};

var isOldIE = memoize(function () {
	// Test for IE <= 9 as proposed by Browserhacks
	// @see http://browserhacks.com/#hack-e71d8692f65334173fee715c222cb805
	// Tests for existence of standard globals is to allow style-loader
	// to operate correctly into non-standard environments
	// @see https://github.com/webpack-contrib/style-loader/issues/177
	return window && document && document.all && !window.atob;
});

var getElement = (function (fn) {
	var memo = {};

	return function(selector) {
		if (typeof memo[selector] === "undefined") {
			var styleTarget = fn.call(this, selector);
			// Special case to return head of iframe instead of iframe itself
			if (styleTarget instanceof window.HTMLIFrameElement) {
				try {
					// This will throw an exception if access to iframe is blocked
					// due to cross-origin restrictions
					styleTarget = styleTarget.contentDocument.head;
				} catch(e) {
					styleTarget = null;
				}
			}
			memo[selector] = styleTarget;
		}
		return memo[selector]
	};
})(function (target) {
	return document.querySelector(target)
});

var singleton = null;
var	singletonCounter = 0;
var	stylesInsertedAtTop = [];

var	fixUrls = __webpack_require__(35);

module.exports = function(list, options) {
	if (typeof DEBUG !== "undefined" && DEBUG) {
		if (typeof document !== "object") throw new Error("The style-loader cannot be used in a non-browser environment");
	}

	options = options || {};

	options.attrs = typeof options.attrs === "object" ? options.attrs : {};

	// Force single-tag solution on IE6-9, which has a hard limit on the # of <style>
	// tags it will allow on a page
	if (!options.singleton && typeof options.singleton !== "boolean") options.singleton = isOldIE();

	// By default, add <style> tags to the <head> element
	if (!options.insertInto) options.insertInto = "head";

	// By default, add <style> tags to the bottom of the target
	if (!options.insertAt) options.insertAt = "bottom";

	var styles = listToStyles(list, options);

	addStylesToDom(styles, options);

	return function update (newList) {
		var mayRemove = [];

		for (var i = 0; i < styles.length; i++) {
			var item = styles[i];
			var domStyle = stylesInDom[item.id];

			domStyle.refs--;
			mayRemove.push(domStyle);
		}

		if(newList) {
			var newStyles = listToStyles(newList, options);
			addStylesToDom(newStyles, options);
		}

		for (var i = 0; i < mayRemove.length; i++) {
			var domStyle = mayRemove[i];

			if(domStyle.refs === 0) {
				for (var j = 0; j < domStyle.parts.length; j++) domStyle.parts[j]();

				delete stylesInDom[domStyle.id];
			}
		}
	};
};

function addStylesToDom (styles, options) {
	for (var i = 0; i < styles.length; i++) {
		var item = styles[i];
		var domStyle = stylesInDom[item.id];

		if(domStyle) {
			domStyle.refs++;

			for(var j = 0; j < domStyle.parts.length; j++) {
				domStyle.parts[j](item.parts[j]);
			}

			for(; j < item.parts.length; j++) {
				domStyle.parts.push(addStyle(item.parts[j], options));
			}
		} else {
			var parts = [];

			for(var j = 0; j < item.parts.length; j++) {
				parts.push(addStyle(item.parts[j], options));
			}

			stylesInDom[item.id] = {id: item.id, refs: 1, parts: parts};
		}
	}
}

function listToStyles (list, options) {
	var styles = [];
	var newStyles = {};

	for (var i = 0; i < list.length; i++) {
		var item = list[i];
		var id = options.base ? item[0] + options.base : item[0];
		var css = item[1];
		var media = item[2];
		var sourceMap = item[3];
		var part = {css: css, media: media, sourceMap: sourceMap};

		if(!newStyles[id]) styles.push(newStyles[id] = {id: id, parts: [part]});
		else newStyles[id].parts.push(part);
	}

	return styles;
}

function insertStyleElement (options, style) {
	var target = getElement(options.insertInto)

	if (!target) {
		throw new Error("Couldn't find a style target. This probably means that the value for the 'insertInto' parameter is invalid.");
	}

	var lastStyleElementInsertedAtTop = stylesInsertedAtTop[stylesInsertedAtTop.length - 1];

	if (options.insertAt === "top") {
		if (!lastStyleElementInsertedAtTop) {
			target.insertBefore(style, target.firstChild);
		} else if (lastStyleElementInsertedAtTop.nextSibling) {
			target.insertBefore(style, lastStyleElementInsertedAtTop.nextSibling);
		} else {
			target.appendChild(style);
		}
		stylesInsertedAtTop.push(style);
	} else if (options.insertAt === "bottom") {
		target.appendChild(style);
	} else if (typeof options.insertAt === "object" && options.insertAt.before) {
		var nextSibling = getElement(options.insertInto + " " + options.insertAt.before);
		target.insertBefore(style, nextSibling);
	} else {
		throw new Error("[Style Loader]\n\n Invalid value for parameter 'insertAt' ('options.insertAt') found.\n Must be 'top', 'bottom', or Object.\n (https://github.com/webpack-contrib/style-loader#insertat)\n");
	}
}

function removeStyleElement (style) {
	if (style.parentNode === null) return false;
	style.parentNode.removeChild(style);

	var idx = stylesInsertedAtTop.indexOf(style);
	if(idx >= 0) {
		stylesInsertedAtTop.splice(idx, 1);
	}
}

function createStyleElement (options) {
	var style = document.createElement("style");

	options.attrs.type = "text/css";

	addAttrs(style, options.attrs);
	insertStyleElement(options, style);

	return style;
}

function createLinkElement (options) {
	var link = document.createElement("link");

	options.attrs.type = "text/css";
	options.attrs.rel = "stylesheet";

	addAttrs(link, options.attrs);
	insertStyleElement(options, link);

	return link;
}

function addAttrs (el, attrs) {
	Object.keys(attrs).forEach(function (key) {
		el.setAttribute(key, attrs[key]);
	});
}

function addStyle (obj, options) {
	var style, update, remove, result;

	// If a transform function was defined, run it on the css
	if (options.transform && obj.css) {
	    result = options.transform(obj.css);

	    if (result) {
	    	// If transform returns a value, use that instead of the original css.
	    	// This allows running runtime transformations on the css.
	    	obj.css = result;
	    } else {
	    	// If the transform function returns a falsy value, don't add this css.
	    	// This allows conditional loading of css
	    	return function() {
	    		// noop
	    	};
	    }
	}

	if (options.singleton) {
		var styleIndex = singletonCounter++;

		style = singleton || (singleton = createStyleElement(options));

		update = applyToSingletonTag.bind(null, style, styleIndex, false);
		remove = applyToSingletonTag.bind(null, style, styleIndex, true);

	} else if (
		obj.sourceMap &&
		typeof URL === "function" &&
		typeof URL.createObjectURL === "function" &&
		typeof URL.revokeObjectURL === "function" &&
		typeof Blob === "function" &&
		typeof btoa === "function"
	) {
		style = createLinkElement(options);
		update = updateLink.bind(null, style, options);
		remove = function () {
			removeStyleElement(style);

			if(style.href) URL.revokeObjectURL(style.href);
		};
	} else {
		style = createStyleElement(options);
		update = applyToTag.bind(null, style);
		remove = function () {
			removeStyleElement(style);
		};
	}

	update(obj);

	return function updateStyle (newObj) {
		if (newObj) {
			if (
				newObj.css === obj.css &&
				newObj.media === obj.media &&
				newObj.sourceMap === obj.sourceMap
			) {
				return;
			}

			update(obj = newObj);
		} else {
			remove();
		}
	};
}

var replaceText = (function () {
	var textStore = [];

	return function (index, replacement) {
		textStore[index] = replacement;

		return textStore.filter(Boolean).join('\n');
	};
})();

function applyToSingletonTag (style, index, remove, obj) {
	var css = remove ? "" : obj.css;

	if (style.styleSheet) {
		style.styleSheet.cssText = replaceText(index, css);
	} else {
		var cssNode = document.createTextNode(css);
		var childNodes = style.childNodes;

		if (childNodes[index]) style.removeChild(childNodes[index]);

		if (childNodes.length) {
			style.insertBefore(cssNode, childNodes[index]);
		} else {
			style.appendChild(cssNode);
		}
	}
}

function applyToTag (style, obj) {
	var css = obj.css;
	var media = obj.media;

	if(media) {
		style.setAttribute("media", media)
	}

	if(style.styleSheet) {
		style.styleSheet.cssText = css;
	} else {
		while(style.firstChild) {
			style.removeChild(style.firstChild);
		}

		style.appendChild(document.createTextNode(css));
	}
}

function updateLink (link, options, obj) {
	var css = obj.css;
	var sourceMap = obj.sourceMap;

	/*
		If convertToAbsoluteUrls isn't defined, but sourcemaps are enabled
		and there is no publicPath defined then lets turn convertToAbsoluteUrls
		on by default.  Otherwise default to the convertToAbsoluteUrls option
		directly
	*/
	var autoFixUrls = options.convertToAbsoluteUrls === undefined && sourceMap;

	if (options.convertToAbsoluteUrls || autoFixUrls) {
		css = fixUrls(css);
	}

	if (sourceMap) {
		// http://stackoverflow.com/a/26603875
		css += "\n/*# sourceMappingURL=data:application/json;base64," + btoa(unescape(encodeURIComponent(JSON.stringify(sourceMap)))) + " */";
	}

	var blob = new Blob([css], { type: "text/css" });

	var oldSrc = link.href;

	link.href = URL.createObjectURL(blob);

	if(oldSrc) URL.revokeObjectURL(oldSrc);
}


/***/ }),

/***/ 2084:
/***/ (function(module, exports) {

/**
 * Tine 2.0
 * 
 * @package     SimpleFAQ
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Patrick Ryser <patrick.ryser@gmail.com>
 * @copyright   Copyright (c) 2007-2011 Metaways Infosystems GmbH (http://www.metaways.de)
 */
Ext.ns('Tine.SimpleFAQ', 'Tine.SimpleFAQ.Model');
/**
 * @namespace Tine.SimpleFAQ.Model
 * @class Tine.SimpleFAQ.Model.Faq
 * @extends Tine.Tinebase.data.Record
 *
 * Faq Record Definition
 */

Tine.SimpleFAQ.Model.Faq = Tine.Tinebase.data.Record.create(Tine.Tinebase.Model.genericFields.concat([{
  name: 'id',
  type: 'string'
}, {
  name: 'faqstatus_id',
  type: 'int'
}, {
  name: 'faqtype_id',
  type: 'int'
}, {
  name: 'question'
}, {
  name: 'answer'
}, {
  name: 'notes'
}, {
  name: 'tags'
}, {
  name: 'relations'
}, {
  name: 'attachments',
  omitDuplicateResolving: true
}]), {
  appName: 'SimpleFAQ',
  modelName: 'Faq',
  idProperty: 'id',
  titleProperty: 'question',
  // ngettext('FAQ', 'FAQs', n);
  recordName: 'FAQ',
  recordsName: 'FAQs',
  containerProperty: 'container_id',
  // ngettext('FAQ List', 'FAQ Lists', n); gettext('FAQ Lists');
  containerName: 'FAQ List',
  containersName: 'FAQ Lists'
});
/**
 * get default data for a new Faq
 *
 * @return {Object} default data
 */

Tine.SimpleFAQ.Model.Faq.getDefaultData = function () {
  var defaults = Tine.SimpleFAQ.registry.get('defaults');
  var app = Tine.Tinebase.appMgr.get('SimpleFAQ');
  var data = {
    faqstatus_id: defaults.faqstatus_id,
    faqtype_id: defaults.faqtype_id,
    container_id: app.getMainScreen().getWestPanel().getContainerTreePanel().getSelectedContainer('addGrant', defaults.container_id)
  };
  return data;
};
/**
 * @namespace Tine.Sales.Model
 *
 * get product filter
 *
 * @return {Array} filter objects
 * @static
 */


Tine.SimpleFAQ.Model.Faq.getFilterModel = function () {
  var app = Tine.Tinebase.appMgr.get("SimpleFAQ");
  return [{
    label: i18n._('Quick Search'),
    field: 'query',
    operators: ['contains']
  }, {
    filtertype: 'tine.widget.container.filtermodel',
    app: app,
    recordClass: Tine.SimpleFAQ.Model.Faq
  }, {
    filtertype: 'simplefaq.faqstatus',
    app: app
  }, {
    filtertype: 'simplefaq.faqtype',
    app: app
  }, {
    filtertype: 'tinebase.tag',
    app: app
  }];
};
/**
 * @namespace Tine.SimpleFAQ.Model
 * @class Tine.SimpleFAQ.Model.Settings
 * @extends Tine.Tinebase.data.Record
 *
 * Settings Record Definition
 * 
 */


Tine.SimpleFAQ.Model.Settings = Tine.Tinebase.data.Record.create([{
  name: 'id'
}, {
  name: 'defaults'
}, {
  name: 'faqstatuses'
}, {
  name: 'faqtypes'
}, {
  name: 'default_faqstatus_id',
  type: 'int'
}, {
  name: 'default_faqtype_id',
  type: 'int'
}], {
  appName: 'SimpleFAQ',
  modelName: 'Settings',
  idProperty: 'id',
  titleProperty: 'title',
  recordName: 'Settings',
  recordsName: 'Settings',
  containerProperty: 'container_id',
  containerName: 'Settings',
  containersName: 'Settings',
  getTitle: function getTitle() {
    return this.recordName;
  }
});

Tine.SimpleFAQ.Model.getRandomUnusedId = function (store) {
  var result;

  do {
    result = Tine.Tinebase.common.getRandomNumber(0, 21474836);
  } while (store.getById(result) != undefined);

  return result;
};

/***/ }),

/***/ 2085:
/***/ (function(module, exports) {

/**
 * Tine 2.0
 * 
 * @package     SimpleFAQ
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Patrick Ryser <patrick.ryser@gmail.com>
 * @copyright   Copyright (c) 2007-2011 Metaways Infosystems GmbH (http://www.metaways.de)
 */
Ext.ns('Tine', 'Tine.SimpleFAQ');
/**
 * @namespace   Tine.SimpleFAQ
 * @class       Tine.SimpleFAQ.Application
 * @extends     Tine.Tinebase.Application
 */

Tine.SimpleFAQ.Application = Ext.extend(Tine.Tinebase.Application, {
  getTitle: function getTitle() {
    return this.i18n.gettext('FAQ');
  },
  findQuestion: function findQuestion() {
    var app = Tine.Tinebase.appMgr.get('SimpleFAQ');
    var qWin = new Ext.Window({
      title: app.i18n.gettext('Find Question'),
      width: 500,
      height: 300,
      layout: 'form',
      labelAlign: 'top',
      bodyStyle: 'padding: 5px',
      modal: true,
      items: [{
        xtype: 'faqpickercombobox',
        fieldLabel: app.i18n.gettext('Search question'),
        listeners: {
          scope: this,
          'select': function select(combo, record) {
            if (record) {
              qWin.get(1).get(0).setValue(record.get('answer'));
            }
          }
        }
      }, {
        xtype: 'fieldset',
        title: app.i18n.gettext('Answer'),
        hideLabels: true,
        bodyStyle: 'padding: 5px',
        items: [{
          xtype: 'displayfield'
        }]
      }]
    }).show();
  }
});
/**
 * @namespace   Tine.SimpleFAQ
 * @class       Tine.SimpleFAQ.MainScreen
 * @extends     Tine.widgets.MainScreen
 *
 * The mainscreen of the SimpleFAQ App
 */

Tine.SimpleFAQ.MainScreen = Ext.extend(Tine.widgets.MainScreen, {
  activeContentType: 'Faq'
});

Tine.SimpleFAQ.FaqTreePanel = function (config) {
  Ext.apply(this, config);
  this.id = 'SimpleFAQTreePanel';
  this.recordClass = Tine.SimpleFAQ.Model.Faq;
  this.filterMode = 'filterToolbar';
  Tine.SimpleFAQ.FaqTreePanel.superclass.constructor.call(this);
};

Ext.extend(Tine.SimpleFAQ.FaqTreePanel, Tine.widgets.container.TreePanel);

Tine.SimpleFAQ.FaqFilterPanel = function (config) {
  Ext.apply(this, config);
  Tine.SimpleFAQ.FaqFilterPanel.superclass.constructor.call(this);
};

Ext.extend(Tine.SimpleFAQ.FaqFilterPanel, Tine.widgets.persistentfilter.PickerPanel, {
  filter: [{
    field: 'model',
    operator: 'equals',
    value: 'SimpleFAQ_Model_FaqFilter'
  }]
});
/**
 * @namespace Tine.SimpleFAQ
 * @class Tine.SimpleFAQ.faqBackend
 * @extends Tine.Tinebase.data.RecordProxy
 *
 * Faq Backend
 */

Tine.SimpleFAQ.faqBackend = new Tine.Tinebase.data.RecordProxy({
  appName: 'SimpleFAQ',
  modelName: 'Faq',
  recordClass: Tine.SimpleFAQ.Model.Faq
});
/**
 * @namespace Tine.SimpleFAQ
 * @class Tine.SimpleFAQ.settingsBackend
 * @extends Tine.Tinebase.data.RecordProxy
 *
 * Settings Backend
 */

Tine.SimpleFAQ.settingsBackend = new Tine.Tinebase.data.RecordProxy({
  appName: 'SimpleFAQ',
  modelName: 'Settings',
  recordClass: Tine.SimpleFAQ.Model.Settings
});

/***/ }),

/***/ 2086:
/***/ (function(module, exports) {

/**
 * Tine 2.0
 * 
 * @package     SimpleFAQ
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Patrick Ryser <patrick.ryser@gmail.com>
 * @copyright   Copyright (c) 2007-2011 Metaways Infosystems GmbH (http://www.metaways.de)
 */
Ext.ns('Tine.SimpleFAQ');
/**
 * the grid details panel
 */

Tine.SimpleFAQ.FaqGridDetailsPanel = Ext.extend(Tine.widgets.grid.DetailsPanel, {
  border: false,

  /**
   * inits this component
   */
  initComponent: function initComponent() {
    this.app = Tine.Tinebase.appMgr.get('SimpleFAQ');
    Tine.SimpleFAQ.FaqGridDetailsPanel.superclass.initComponent.call(this); //this.supr().initComponent.call(this);
  },

  /**
   * returns rendered tags with tag-text for grids
   *
   * @param {mixed} tags
   * @return {String} tags as colored text with qtips
   * 
   */
  tagsRenderer: function tagsRenderer(tags) {
    var result = '';

    if (tags) {
      for (var i = 0; i < tags.length; i += 1) {
        result += '<div style="float:left; margin:3px; font: 11px arial,tahoma,helvetica,sans-serif;"><div class="tb-grid-tags" style="background-color:' + tags[i].color + ';">&#160;</div> ' + Ext.util.Format.htmlEncode(tags[i].name) + '</div>';
      }
    }

    return result;
  },
  htmlRenderer: function htmlRenderer(text) {
    var result = '';

    if (text) {
      result += '<div style="float:left; margin:3px; font: 11px arial,tahoma,helvetica,sans-serif;">' + text + '</div>';
    }

    return result;
  },

  /**
  * faq status renderer
  *
  * @param   {Number} id
  * @param   {Store} store
  * @return  {String} label
  */
  dataRenderer: function dataRenderer(id, store, definitionsLabel) {
    record = store.getById(id);

    if (record) {
      return record.data[definitionsLabel];
    } else {
      return 'undefined';
    }
  },

  /**
   * default panel
   *
   * @return {Ext.ux.display.DisplayPanel}
   */
  getDefaultInfosPanel: function getDefaultInfosPanel() {
    if (!this.defaultInfosPanel) {
      this.defaultInfosPanel = new Ext.ux.display.DisplayPanel({
        layout: 'fit',
        border: false,
        items: [{
          layout: 'hbox',
          border: false,
          layoutConfig: {
            padding: 5,
            align: 'stretch'
          },
          defaults: {
            margins: '0 5 0 0'
          },
          items: [{
            layout: 'ux.display',
            width: 240,
            layoutConfig: {
              background: 'solid',
              declaration: this.app.i18n._('FAQ Infos'),
              align: 'stretch',
              padding: 5
            }
          }, {
            layout: 'ux.display',
            flex: 1,
            border: false
          }, {
            layout: 'fit',
            flex: 1,
            border: false
          }] //end of display fields

        }] //end of main panel

      });
    }

    return this.defaultInfosPanel;
  },

  /**
   * single record panel
   *
   * @return {Ext.ux.display.DisplayPanel}
   */
  getSingleRecordPanel: function getSingleRecordPanel() {
    if (!this.singleRecordPanel) {
      this.singleRecordPanel = new Ext.ux.display.DisplayPanel({
        layout: 'fit',
        border: false,
        items: [{
          layout: 'vbox',
          border: false,
          layoutConfig: {
            align: 'stretch'
          },
          items: [{
            layout: 'hbox',
            flex: 0,
            height: 16,
            border: false,
            layoutConfig: {
              align: 'stretch'
            },
            items: [{
              width: 240,
              xtype: 'ux.displayfield',
              cls: 'x-ux-display-header'
            }, {
              flex: 1,
              xtype: 'ux.displayfield',
              cls: 'x-ux-display-header',
              style: 'text-align: center;',
              html: this.app.i18n._('Question')
            }, {
              flex: 1,
              xtype: 'ux.displayfield',
              cls: 'x-ux-display-header',
              style: 'text-align: center;',
              html: this.app.i18n._('Answer')
            }, {
              width: 150,
              xtype: 'ux.displayfield',
              cls: 'x-ux-display-header',
              style: 'text-align: center;',
              html: this.app.i18n._('Tags')
            }] //end of title hbox items

          }, {
            //end of title hbox
            layout: 'hbox',
            flex: 1,
            border: false,
            layoutConfig: {
              padding: 5,
              align: 'stretch'
            },
            defaults: {
              margins: '0 5 0 0'
            },
            items: [{
              layout: 'ux.display',
              labelWidth: 85,
              width: 240,
              layoutConfig: {
                background: 'solid',
                declaration: this.app.i18n._('FAQ Infos'),
                align: 'stretch',
                padding: 5
              },
              items: [{
                xtype: 'ux.displayfield',
                name: 'creation_time',
                fieldLabel: this.app.i18n._('Creation Time'),
                renderer: Tine.Tinebase.common.dateRenderer
              }, {
                xtype: 'ux.displayfield',
                name: 'created_by',
                fieldLabel: this.app.i18n._('Created By'),
                renderer: Tine.Tinebase.common.usernameRenderer
              }, {
                xtype: 'ux.displayfield',
                name: 'faqstatus_id',
                fieldLabel: this.app.i18n._('FAQ Status'),
                renderer: this.dataRenderer.createDelegate(this, [Tine.SimpleFAQ.FaqStatus.getStore(), 'faqstatus'], true)
              }, {
                xtype: 'ux.displayfield',
                name: 'faqtype_id',
                fieldLabel: this.app.i18n._('FAQ Type'),
                renderer: this.dataRenderer.createDelegate(this, [Tine.SimpleFAQ.FaqType.getStore(), 'faqtype'], true)
              }]
            }, {
              flex: 1,
              layout: 'fit',
              border: false,
              items: [{
                cls: 'x-ux-display-background-border',
                xtype: 'ux.displayfield',
                name: 'question',
                htmlEncode: false,
                renderer: this.htmlRenderer
              }]
            }, {
              flex: 1,
              layout: 'fit',
              border: false,
              items: [{
                cls: 'x-ux-display-background-border',
                xtype: 'ux.displayfield',
                name: 'answer',
                emptyText: this.app.i18n._('No answer yet'),
                htmlEncode: false,
                renderer: this.htmlRenderer
              }]
            }, {
              width: 150,
              layout: 'fit',
              border: false,
              items: [{
                cls: 'x-ux-display-background-border',
                xtype: 'ux.displayfield',
                name: 'tags',
                htmlEncode: false,
                renderer: this.tagsRenderer
              }]
            }] //end of display fields

          } //end of content hbox
          ] //end of hbox

        }] //end of main panel

      });
    }

    return this.singleRecordPanel;
  },

  /**
   * get panel for multi selection aggregates/information
   *
   * @return {Ext.Panel}
   */
  getMultiRecordsPanel: function getMultiRecordsPanel() {
    return this.getDefaultInfosPanel();
  },

  /**
   * update lead details panel
   *
   * @param {Tine.Tinebase.data.Record} record
   * @param {Mixed} body
   */
  updateDetails: function updateDetails(record, body) {
    this.getSingleRecordPanel().loadRecord.defer(100, this.getSingleRecordPanel(), [record]);
  },

  /**
   * show default panel
   *
   * @param {Mixed} body
   */
  showDefault: function showDefault(body) {//this.getDefaultInfosPanel();
    //this.setPiechartStores.defer(500, this, [true]);
  },

  /**
   * show template for multiple rows
   *
   * @param {Ext.grid.RowSelectionModel} sm
   * @param {Mixed} body
   */
  showMulti: function showMulti(sm, body) {//this.getDefaultInfosPanel();
  }
});

/***/ }),

/***/ 2087:
/***/ (function(module, exports) {

/**
 * Tine 2.0
 * 
 * @package     SimpleFAQ
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Patrick Ryser <patrick.ryser@gmail.com>
 * @copyright   Copyright (c) 2007-2011 Metaways Infosystems GmbH (http://www.metaways.de)
 */
Ext.ns('Tine.SimpleFAQ');
/**
 * Create a new Tine.SimpleFAQ.SimpleFAQGridPanel
 */

Tine.SimpleFAQ.FaqGridPanel = Ext.extend(Tine.widgets.grid.GridPanel, {
  /**
   * record class
   * @cfg {Tine.SimpleFAQ.Model.Faq} recordClass
   */
  recordClass: Tine.SimpleFAQ.Model.Faq,

  /**
   * eval grants
   * @cfg {Boolean} evalGrants
   */
  evalGrants: true,

  /**
   * grid specific
   * @private
   */
  defaultSortInfo: {
    field: 'creation_time',
    direction: 'DESC'
  },
  gridConfig: {
    loadMask: true,
    enableDragDrop: true,
    ddGroup: 'containerDDGroup',
    autoExpandColumn: 'question'
  },

  /**
   * inits this cmp
   * @private
   */
  initComponent: function initComponent() {
    this.recordProxy = Tine.SimpleFAQ.faqBackend;
    this.gridConfig.cm = this.getColumnModel();
    this.defaultFilters = [{
      field: 'container_id',
      operator: 'equals',
      value: {
        path: Tine.Tinebase.container.getMyNodePath()
      }
    }];
    this.detailsPanel = new Tine.SimpleFAQ.FaqGridDetailsPanel({
      grid: this
    });
    Tine.SimpleFAQ.FaqGridPanel.superclass.initComponent.call(this);
  },

  /**
   * returns cm
   *
   * @return Ext.grid.ColumnModel
   * @private
   */
  getColumnModel: function getColumnModel() {
    return new Ext.grid.ColumnModel({
      defaults: {
        sortable: true,
        resizable: true
      },
      columns: [{
        id: 'id',
        header: this.app.i18n._('FAQ id'),
        width: 30,
        sortable: false,
        dataIndex: 'id',
        hidden: true
      }, {
        id: 'tags',
        header: this.app.i18n._('Tags'),
        width: 50,
        sortable: false,
        dataIndex: 'tags',
        renderer: Tine.Tinebase.common.tagsRenderer
      }, {
        id: 'faqstatus',
        header: this.app.i18n._("Status"),
        width: 30,
        dataIndex: 'faqstatus_id',
        renderer: Tine.SimpleFAQ.FaqStatus.Renderer
      }, {
        id: 'faqtype',
        header: this.app.i18n._("Type"),
        width: 30,
        dataIndex: 'faqtype_id',
        renderer: Tine.SimpleFAQ.FaqType.Renderer
      }, {
        id: 'question',
        header: this.app.i18n._("Question"),
        width: 150,
        dataIndex: 'question',
        renderer: function renderer(value) {
          return value;
        }
      }, {
        id: 'answer',
        header: this.app.i18n._("Answer"),
        width: 200,
        dataIndex: 'answer',
        renderer: function renderer(value) {
          return value;
        }
      }].concat(this.getModlogColumns())
    });
  },

  /**
  * return additional tb items
  * @private
  */
  getToolbarItems: function getToolbarItems() {
    return [];
  }
});

/***/ }),

/***/ 2088:
/***/ (function(module, exports) {

/**
 * Tine 2.0
 * 
 * @package     SimpleFAQ
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Patrick Ryser <patrick.ryser@gmail.com>
 * @copyright   Copyright (c) 2007-2011 Metaways Infosystems GmbH (http://www.metaways.de)
 */
Ext.ns('Tine.SimpleFAQ');
Tine.SimpleFAQ.FaqEditDialog = Ext.extend(Tine.widgets.dialog.EditDialog, {
  /**
   * @private
   */
  windowNamePrefix: 'FaqEditWindow_',
  appName: 'SimpleFAQ',
  recordClass: Tine.SimpleFAQ.Model.Faq,
  recordProxy: Tine.SimpleFAQ.faqBackend,
  showContainerSelector: true,
  displayNotes: true,

  /**
   * overwrite update toolbars function (we don't have record grants yet)
   * @private
   */
  updateToolbars: function updateToolbars() {},

  /**
   * executed when a record ist loaded
   * @private
   */
  onRecordLoad: function onRecordLoad() {
    if (!this.rendered) {
      this.onRecordLoad.defer(250, this);
      return;
    }

    Tine.SimpleFAQ.FaqEditDialog.superclass.onRecordLoad.apply(this, arguments);
  },

  /**
   * executed when a when a record ist updated
   * 
   */
  onRecordUpdate: function onRecordUpdate() {
    Tine.SimpleFAQ.FaqEditDialog.superclass.onRecordUpdate.apply(this, arguments);
  },

  /**
   * handling for the completed fields
   *
   */
  handlingCompletedData: function handlingCompletedData() {},

  /**
   * returns dialog
   *
   * NOTE: when this method gets called, all initalisation is done.
   *
   * @return {Object}
   * @private
   */
  getFormItems: function getFormItems() {
    return {
      xtype: 'tabpanel',
      border: false,
      plain: true,
      activeTab: 0,
      defaults: {
        hideMode: 'offsets'
      },
      items: [{
        title: this.app.i18n.n_('FAQ', 'FAQs', 1),
        autoScroll: true,
        border: true,
        frame: true,
        layout: 'border',
        id: 'editCenterPanel',
        items: [{
          region: 'center',
          xtype: 'columnform',
          labelAlign: 'top',
          formDefaults: {
            xtype: 'htmleditor',
            anchor: '100%',
            labelSeparator: '',
            columnWidth: .5,
            enableFont: false,
            enableFontSize: false,
            enableLinks: false
          },
          items: [[{
            columnWidth: 1,
            height: 100,
            fieldLabel: this.app.i18n._('Question'),
            emptyText: this.app.i18n._('Enter a question...'),
            name: 'question',
            allowBlank: false
          }, {
            columnWidth: 1,
            height: 150,
            fieldLabel: this.app.i18n._('Answer'),
            emptyText: this.app.i18n._('Enter a answer...'),
            name: 'answer'
          }], [{
            xtype: 'combo',
            mode: 'local',
            triggerAction: 'all',
            editable: false,
            valueField: 'id',
            fieldLabel: this.app.i18n._('Type'),
            id: 'faqtype',
            name: 'faqtype_id',
            store: Tine.SimpleFAQ.FaqType.getStore(),
            value: Tine.SimpleFAQ.FaqType.getStore().getAt(0).id,
            displayField: 'faqtype'
          }, {
            xtype: 'combo',
            mode: 'local',
            triggerAction: 'all',
            editable: false,
            valueField: 'id',
            fieldLabel: this.app.i18n._('Status'),
            id: 'faqstatus',
            name: 'faqstatus_id',
            store: Tine.SimpleFAQ.FaqStatus.getStore(),
            value: Tine.SimpleFAQ.FaqStatus.getStore().getAt(0).id,
            displayField: 'faqstatus'
          }]] //end of center panel items

        }, {
          layout: 'ux.multiaccordion',
          animate: true,
          region: 'east',
          width: 210,
          split: true,
          collapsible: true,
          collapseMode: 'mini',
          header: false,
          margins: '0 5 0 5',
          border: true,
          items: [new Tine.widgets.tags.TagPanel({
            app: 'SimpleFAQ',
            border: false,
            bodyStyle: 'border:1px solid #B5B8C8;'
          })]
        } // end of accordion panel (east)
        ] // end of editCenterPanel

      }, new Tine.widgets.activities.ActivitiesTabPanel({
        app: this.appName,
        record_id: this.record.id,
        record_model: this.appName + '_Model_' + this.recordClass.getMeta('modelName')
      })] //end of main tabpanel

    };
  }
});

Tine.SimpleFAQ.FaqEditDialog.openWindow = function (config) {
  var id = config.record && config.record.id ? config.record.id : 0;
  var window = Tine.WindowFactory.getWindow({
    width: 700,
    height: 450,
    name: Tine.SimpleFAQ.FaqEditDialog.prototype.windowNamePrefix + id,
    contentPanelConstructor: 'Tine.SimpleFAQ.FaqEditDialog',
    contentPanelConstructorConfig: config
  });
  return window;
};

/***/ }),

/***/ 2089:
/***/ (function(module, exports) {

/**
 * Tine 2.0
 * 
 * @package     SimpleFAQ
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Patrick Ryser <patrick.ryser@gmail.com>
 * @copyright   Copyright (c) 2007-2011 Metaways Infosystems GmbH (http://www.metaways.de)
 */
Ext.ns('Tine.SimpleFAQ');
/**
 * Create a new Tine.SimpleFAQ.AdminPanel
 */

Tine.SimpleFAQ.AdminPanel = Ext.extend(Tine.widgets.dialog.EditDialog, {
  appName: 'SimpleFAQ',
  recordClass: Tine.SimpleFAQ.Model.Settings,
  recordProxy: Tine.SimpleFAQ.settingsBackend,

  /**
   * overwrite update toolbars function (we don't have record grants yet)
   * @private
   */
  updateToolbars: function updateToolbars() {},

  /**
   * executed after record got updated from proxy
   *
   * @private
   */
  onRecordLoad: function onRecordLoad() {
    if (!this.record.get('default_faqstatus_id')) {
      this.record.set('default_faqstatus_id', this.record.data.defaults.faqstatus_id);
      this.record.set('default_faqtype_id', this.record.data.defaults.faqtype_id);
    }

    if (this.fireEvent('load', this) !== false) {
      this.getForm().loadRecord(this.record);
      this.updateToolbars(this.record, this.recordClass.getMeta('containerProperty'));
      this.loadMask.hide();
    }
  },

  /**
   * executed when a record was updated from form
   *
   * @private
   */
  onRecordUpdate: function onRecordUpdate() {
    Tine.SimpleFAQ.AdminPanel.superclass.onRecordUpdate.call(this);
    var defaults = {
      faqstatus_id: this.record.get('default_faqstatus_id'),
      faqtype_id: this.record.get('default_faqtype_id')
    };
    this.record.set('defaults', defaults);
    this.record.set('faqstatuses', this.getFromStore(this.faqstatusPanel.store));
    this.record.set('faqtypes', this.getFromStore(this.faqtypePanel.store));
  },

  /**
   * get values from store (as array)
   *
   * @param {Ext.data.JsonStore} store
   * @return {Array}
   */
  getFromStore: function getFromStore(store) {
    var result = [];
    store.each(function (record) {
      result.push(record.data);
    }, this);
    store.commitChanges();
    return result;
  },

  /**
   * returns dialog
   *
   * NOTE: when this method gets called, all initalisation is done
   *
   * @return {Object}
   * @private
   */
  getFormItems: function getFormItems() {
    this.faqstatusPanel = new Tine.SimpleFAQ.FaqStatus.GridPanel({
      title: this.app.i18n._('FAQ Status')
    });
    this.faqtypePanel = new Tine.SimpleFAQ.FaqType.GridPanel({
      title: this.app.i18n._('FAQ Type')
    });
    return {
      xtype: 'tabpanel',
      activeTab: 0,
      border: true,
      items: [{
        title: this.app.i18n._('Defaults'),
        autoScroll: true,
        border: false,
        frame: true,
        xtype: 'columnform',
        formDefaults: {
          xtype: 'combo',
          anchor: '90%',
          labelSeparator: '',
          columnWidth: 1,
          valueField: 'id',
          typeAhead: true,
          mode: 'local',
          triggerAction: 'all',
          editable: false,
          allowBlank: false,
          forceSelection: true
        },
        items: [[{
          fieldLabel: this.app.i18n._('FAQ Status'),
          name: 'default_faqstatus_id',
          store: Tine.SimpleFAQ.FaqStatus.getStore(),
          displayField: 'faqstatus',
          lazyInit: false,
          value: Tine.SimpleFAQ.FaqStatus.getStore().getAt(0).id
        }, {
          fieldLabel: this.app.i18n._('FAQ Type'),
          name: 'default_faqtype_id',
          store: Tine.SimpleFAQ.FaqType.getStore(),
          displayField: 'faqtype',
          lazyInit: false,
          value: Tine.SimpleFAQ.FaqType.getStore().getAt(0).id
        }]]
      }, this.faqstatusPanel, this.faqtypePanel]
    };
  }
});
/**
 * admin panel on update function
 *
 * TODO         update registry without reloading the mainscreen
 */

Tine.SimpleFAQ.AdminPanel.onUpdate = function () {
  // reload mainscreen to make sure registry gets updated
  Tine.Tinebase.common.reload();
};
/**
 * SimpleFAQ admin settings popup
 *
 * @param   {Object} config
 * @return  {Ext.ux.Window}
 */


Tine.SimpleFAQ.AdminPanel.openWindow = function (config) {
  var id = config.record && config.record.id ? config.record.id : 0;
  var window = Tine.WindowFactory.getWindow({
    width: 500,
    height: 400,
    name: Tine.SimpleFAQ.AdminPanel.prototype.windowNamePrefix + id,
    contentPanelConstructor: 'Tine.SimpleFAQ.AdminPanel',
    contentPanelConstructorConfig: config
  });
  return window;
};

Ext.ns('Tine.SimpleFAQ.Admin');
/**
 * @namespace   Tine.SimpleFAQ.Admin
 * @class       Tine.SimpleFAQ.Admin.QuickaddGridPanel
 * @extends     Tine.widgets.grid.QuickaddGridPanel
 *
 * admin config option quickadd grid panel
 */

Tine.SimpleFAQ.Admin.QuickaddGridPanel = Ext.extend(Tine.widgets.grid.QuickaddGridPanel, {
  /**
   * @private
   */
  initComponent: function initComponent() {
    this.app = this.app ? this.app : Tine.Tinebase.appMgr.get('SimpleFAQ');
    Tine.SimpleFAQ.Admin.QuickaddGridPanel.superclass.initComponent.call(this);
  }
});

/***/ }),

/***/ 2090:
/***/ (function(module, exports) {

/**
 * Tine 2.0
 * 
 * @package     SimpleFAQ
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Patrick Ryser <patrick.ryser@gmail.com>
 * @copyright   Copyright (c) 2007-2011 Metaways Infosystems GmbH (http://www.metaways.de)
 */
Ext.ns('Tine.SimpleFAQ', 'Tine.SimpleFAQ.FaqStatus');
/**
 * @namespace Tine.SimpleFAQ.FaqStatus
 * @class Tine.SimpleFAQ.FaqStatus.Model
 * @extends Ext.data.Record
 *
 * faq status model
 */

Tine.SimpleFAQ.FaqStatus.Model = Tine.Tinebase.data.Record.create([{
  name: 'id',
  type: 'int'
}, {
  name: 'faqstatus'
}], {
  appName: 'SimpleFAQ',
  modelName: 'FaqStatus',
  idProperty: 'id',
  // ngettext('FAQ Status', 'FAQ Status', n);
  titleProperty: 'faqstatus',
  recordName: 'FAQ Status',
  recordsName: 'FAQ Status'
});
/**
 * @namespace Tine.SimpleFAQ.FaqStatus
 *
 * get default data for a new faqstatus
 *
 * @return {Object} default data
 * @static
 */

Tine.SimpleFAQ.FaqStatus.Model.getDefaultData = function () {
  var data = {
    id: Tine.SimpleFAQ.Model.getRandomUnusedId(Ext.StoreMgr.get('SimpleFAQFaqStatusStore'))
  };
  return data;
};
/**
 * get faq status store
 * if available, load data from FaqStatus
 *
 * @return {Ext.data.JsonStore}
 */


Tine.SimpleFAQ.FaqStatus.getStore = function () {
  var store = Ext.StoreMgr.get('SimpleFAQFaqStatusStore');

  if (!store) {
    store = new Ext.data.JsonStore({
      fields: Tine.SimpleFAQ.FaqStatus.Model,
      baseParams: {
        method: 'SimpleFAQ.getFaqStatuses',
        sort: 'FaqStatus',
        dir: 'ASC'
      },
      root: 'results',
      totalProperty: 'totalcount',
      id: 'id',
      remoteSort: false
    });

    if (Tine.SimpleFAQ.registry.get('faqstatuses')) {
      store.loadData(Tine.SimpleFAQ.registry.get('faqstatuses'));
    }

    Ext.StoreMgr.add('SimpleFAQFaqStatusStore', store);
  }

  return store;
};
/**
 * faq status renderer
 *
 * @param   {Number} _faqstatusId
 * @return  {String} faqstatus
 */


Tine.SimpleFAQ.FaqStatus.Renderer = function (_faqstatusId) {
  store = Tine.SimpleFAQ.FaqStatus.getStore();
  record = store.getById(_faqstatusId);

  if (record) {
    return record.data.faqstatus;
  } else {
    return 'undefined';
  }
};
/**
 * @namespace   Tine.SimpleFAQ.FaqStatus
 * @class       Tine.SimpleFAQ.FaqStatus.GridPanel
 * @extends     Tine.SimpleFAQ.Admin.QuickaddGridPanel
 *
 * faq status grid panel
 */


Tine.SimpleFAQ.FaqStatus.GridPanel = Ext.extend(Tine.SimpleFAQ.Admin.QuickaddGridPanel, {
  /**
   * @private
   */
  autoExpandColumn: 'faqstatus',
  quickaddMandatory: 'faqstatus',

  /**
   * @private
   */
  initComponent: function initComponent() {
    this.app = this.app ? this.app : Tine.Tinebase.appMgr.get('SimpleFAQ');
    this.store = Tine.SimpleFAQ.FaqStatus.getStore();
    this.recordClass = Tine.SimpleFAQ.FaqStatus.Model;
    Tine.SimpleFAQ.FaqStatus.GridPanel.superclass.initComponent.call(this);
  },
  getColumnModel: function getColumnModel() {
    return new Ext.grid.ColumnModel([{
      id: 'faqstatus_id',
      header: 'Id',
      dataIndex: 'id',
      width: 20,
      hidden: true
    }, {
      id: 'faqstatus',
      header: 'Status',
      dataIndex: 'faqstatus',
      width: 150,
      hideable: false,
      sortable: false,
      editor: new Ext.form.TextField({
        allowBlank: false
      }),
      quickaddField: new Ext.form.TextField({
        emptyText: this.app.i18n._('Add a new FAQ Status...')
      })
    }]);
  }
});

/***/ }),

/***/ 2091:
/***/ (function(module, exports) {

/**
 * Tine 2.0
 * 
 * @package     SimpleFAQ
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Patrick Ryser <patrick.ryser@gmail.com>
 * @copyright   Copyright (c) 2007-2011 Metaways Infosystems GmbH (http://www.metaways.de)
 */
Ext.ns('Tine.SimpleFAQ');
/**
 * @namespace   Tine.SimpleFAQ
 * @class       Tine.SimpleFAQ.FaqStatusFilterModel
 * @extends     Tine.widgets.grid.FilterModel
 *
 */

Tine.SimpleFAQ.FaqStatusFilterModel = Ext.extend(Tine.widgets.grid.FilterModel, {
  field: 'faqstatus_id',
  defaultOperator: 'in',

  /**
   * @private
   */
  initComponent: function initComponent() {
    this.label = this.app.i18n._('FAQ Status');
    this.operators = ['in', 'notin']; //@todo pr: add this.defaultValue ....

    Tine.SimpleFAQ.FaqStatusFilterModel.superclass.initComponent.call(this);
  },

  /**
   * value renderer
   *
   * @param {Ext.data.Record} filter line
   * @param {Ext.Element} element to render to
   */
  valueRenderer: function valueRenderer(filter, el) {
    var value = new Tine.SimpleFAQ.FaqStatusFilterModelValueField({
      app: this.app,
      filter: filter,
      //@todo pr: add default value
      //value: filter.data.value ? filter.data.value : this.defaultValue,
      value: filter.data.value,
      renderTo: el
    });
    value.on('specialkey', function (field, e) {
      if (e.getKey() == e.ENTER) {
        this.onFiltertrigger();
      }
    }, this);
    value.on('select', this.onFiltertrigger, this);
    return value;
  }
});
Tine.widgets.grid.FilterToolbar.FILTERS['simplefaq.faqstatus'] = Tine.SimpleFAQ.FaqStatusFilterModel;
/**
 * @namespace   Tine.SimpleFAQ
 * @class       Tine.SimpleFAQ.FaqStatusFilterModelValueField
 * @extends     Ext.ux.form.LayerCombo
 * 
 */

Tine.SimpleFAQ.FaqStatusFilterModelValueField = Ext.extend(Ext.ux.form.LayerCombo, {
  hideButtons: false,
  formConfig: {
    labelAlign: 'left',
    labelWidth: 30
  },
  getFormValue: function getFormValue() {
    var ids = [];
    var statusStore = Tine.SimpleFAQ.FaqStatus.getStore();
    var formValues = this.getInnerForm().getForm().getValues();

    for (var id in formValues) {
      if (formValues[id] === 'on' && statusStore.getById(id)) {
        ids.push(id);
      }
    }

    return ids;
  },
  getItems: function getItems() {
    var items = [];
    Tine.SimpleFAQ.FaqStatus.getStore().each(function (status) {
      items.push({
        xtype: 'checkbox',
        boxLabel: status.get('faqstatus'),
        icon: status.get('status_icon'),
        name: status.get('id')
      });
    }, this);
    return items;
  },

  /**
   * @param {String} value
   * @return {Ext.form.Field} this
   */
  setValue: function setValue(value) {
    value = Ext.isArray(value) ? value : [value];
    var statusText = [];
    this.currentValue = [];
    Tine.SimpleFAQ.FaqStatus.getStore().each(function (status) {
      var id = status.get('id');
      var name = status.get('faqstatus');
      Ext.each(value, function (valueId) {
        if (valueId == id) {
          statusText.push(name);
          this.currentValue.push(id);
        }
      }, this);
    }, this);
    this.setRawValue(statusText.join(', '));
    return this;
  },

  /**
   * sets values to innerForm
   */
  setFormValue: function setFormValue(value) {
    this.getInnerForm().getForm().items.each(function (item) {
      item.setValue(value.indexOf(item.name) >= 0 ? 'on' : 'off');
    }, this);
  }
});

/***/ }),

/***/ 2092:
/***/ (function(module, exports) {

/**
 * Tine 2.0
 * 
 * @package     SimpleFAQ
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Patrick Ryser <patrick.ryser@gmail.com>
 * @copyright   Copyright (c) 2007-2011 Metaways Infosystems GmbH (http://www.metaways.de)
 */
Ext.ns('Tine.SimpleFAQ', 'Tine.SimpleFAQ.FaqType');
/**
 * @namespace Tine.SimpleFAQ.FaqType
 * @class Tine.SimpleFAQ.FaqType.Model
 * @extends Ext.data.Record
 *
 * faq type model
 */

Tine.SimpleFAQ.FaqType.Model = Tine.Tinebase.data.Record.create([{
  name: 'id',
  type: 'int'
}, {
  name: 'faqtype'
}], {
  appName: 'SimpleFAQ',
  modelName: 'FaqType',
  idProperty: 'id',
  // ngettext('FAQ Type', 'FAQ Types', n);
  titleProperty: 'faqtype',
  recordName: 'FAQ Type',
  recordsName: 'FAQ Type'
});
/**
 * @namespace Tine.SimpleFAQ.FaqType
 *
 * get default data for a new faqtype
 *
 * @return {Object} default data
 * @static
 */

Tine.SimpleFAQ.FaqType.Model.getDefaultData = function () {
  var data = {
    id: Tine.SimpleFAQ.Model.getRandomUnusedId(Ext.StoreMgr.get('SimpleFAQFaqTypeStore'))
  };
  return data;
};
/**
 * get faq type store
 * if available, load data from FaqType
 *
 * @return {Ext.data.JsonStore}
 */


Tine.SimpleFAQ.FaqType.getStore = function () {
  var store = Ext.StoreMgr.get('SimpleFAQFaqTypeStore');

  if (!store) {
    store = new Ext.data.JsonStore({
      fields: Tine.SimpleFAQ.FaqType.Model,
      baseParams: {
        method: 'SimpleFAQ.getFaqTypes',
        sort: 'FaqType',
        dir: 'ASC'
      },
      root: 'results',
      totalProperty: 'totalcount',
      id: 'id',
      remoteSort: false
    });

    if (Tine.SimpleFAQ.registry.get('faqtypes')) {
      store.loadData(Tine.SimpleFAQ.registry.get('faqtypes'));
    }

    Ext.StoreMgr.add('SimpleFAQFaqTypeStore', store);
  }

  return store;
};
/**
 * faq type renderer
 *
 * @param   {Number} _faqtypeId
 * @return  {String} faqtype
 */


Tine.SimpleFAQ.FaqType.Renderer = function (_faqtypeId) {
  store = Tine.SimpleFAQ.FaqType.getStore();
  record = store.getById(_faqtypeId);

  if (record) {
    return record.data.faqtype;
  } else {
    return 'undefined';
  }
};
/**
 * @namespace   Tine.SimpleFAQ.FaqType
 * @class       Tine.SimpleFAQ.FaqType.GridPanel
 * @extends     Tine.SimpleFAQ.Admin.QuickaddGridPanel
 *
 * faq type grid panel
 */


Tine.SimpleFAQ.FaqType.GridPanel = Ext.extend(Tine.SimpleFAQ.Admin.QuickaddGridPanel, {
  /**
   * @private
   */
  autoExpandColumn: 'faqtype',
  quickaddMandatory: 'faqtype',

  /**
   * @private
   */
  initComponent: function initComponent() {
    this.app = this.app ? this.app : Tine.Tinebase.appMgr.get('SimpleFAQ');
    this.store = Tine.SimpleFAQ.FaqType.getStore();
    this.recordClass = Tine.SimpleFAQ.FaqType.Model;
    Tine.SimpleFAQ.FaqType.GridPanel.superclass.initComponent.call(this);
  },
  getColumnModel: function getColumnModel() {
    return new Ext.grid.ColumnModel([{
      id: 'faqtype_id',
      header: 'Id',
      dataIndex: 'id',
      width: 20,
      hidden: true
    }, {
      id: 'faqtype',
      header: 'Type',
      dataIndex: 'faqtype',
      width: 150,
      hideable: false,
      sortable: false,
      editor: new Ext.form.TextField({
        allowBlank: false
      }),
      quickaddField: new Ext.form.TextField({
        emptyText: this.app.i18n._('Add a new FAQ Type...')
      })
    }]);
  }
});

/***/ }),

/***/ 2093:
/***/ (function(module, exports) {

/**
 * Tine 2.0
 * 
 * @package     SimpleFAQ
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Patrick Ryser <patrick.ryser@gmail.com>
 * @copyright   Copyright (c) 2007-2011 Metaways Infosystems GmbH (http://www.metaways.de)
 */
Ext.ns('Tine.SimpleFAQ');
/**
 * @namespace   Tine.SimpleFAQ
 * @class       Tine.SimpleFAQ.FaqTypeFilterModel
 * @extends     Tine.widgets.grid.FilterModel
 *
 */

Tine.SimpleFAQ.FaqTypeFilterModel = Ext.extend(Tine.widgets.grid.FilterModel, {
  field: 'faqtype_id',
  defaultOperator: 'in',

  /**
   * @private
   */
  initComponent: function initComponent() {
    this.label = this.app.i18n._('FAQ Type');
    this.operators = ['in', 'notin']; //@todo pr: add this.defaultValue ....

    Tine.SimpleFAQ.FaqTypeFilterModel.superclass.initComponent.call(this);
  },

  /**
   * value renderer
   *
   * @param {Ext.data.Record} filter line
   * @param {Ext.Element} element to render to
   */
  valueRenderer: function valueRenderer(filter, el) {
    var value = new Tine.SimpleFAQ.FaqTypeFilterModelValueField({
      app: this.app,
      filter: filter,
      //@todo pr: add default value
      //value: filter.data.value ? filter.data.value : this.defaultValue,
      value: filter.data.value,
      renderTo: el
    });
    value.on('specialkey', function (field, e) {
      if (e.getKey() == e.ENTER) {
        this.onFiltertrigger();
      }
    }, this);
    value.on('select', this.onFiltertrigger, this);
    return value;
  }
});
Tine.widgets.grid.FilterToolbar.FILTERS['simplefaq.faqtype'] = Tine.SimpleFAQ.FaqTypeFilterModel;
/**
 * @namespace   Tine.SimpleFAQ
 * @class       Tine.SimpleFAQ.FaqTypeFilterModelValueField
 * @extends     Ext.ux.form.LayerCombo
 * 
 */

Tine.SimpleFAQ.FaqTypeFilterModelValueField = Ext.extend(Ext.ux.form.LayerCombo, {
  hideButtons: false,
  formConfig: {
    labelAlign: 'left',
    labelWidth: 30
  },
  getFormValue: function getFormValue() {
    var ids = [];
    var typeStore = Tine.SimpleFAQ.FaqType.getStore();
    var formValues = this.getInnerForm().getForm().getValues();

    for (var id in formValues) {
      if (formValues[id] === 'on' && typeStore.getById(id)) {
        ids.push(id);
      }
    }

    return ids;
  },
  getItems: function getItems() {
    var items = [];
    Tine.SimpleFAQ.FaqType.getStore().each(function (type) {
      items.push({
        xtype: 'checkbox',
        boxLabel: type.get('faqtype'),
        icon: type.get('type_icon'),
        name: type.get('id')
      });
    }, this);
    return items;
  },

  /**
   * @param {String} value
   * @return {Ext.form.Field} this
   */
  setValue: function setValue(value) {
    value = Ext.isArray(value) ? value : [value];
    var typeText = [];
    this.currentValue = [];
    Tine.SimpleFAQ.FaqType.getStore().each(function (type) {
      var id = type.get('id');
      var name = type.get('faqtype');
      Ext.each(value, function (valueId) {
        if (valueId == id) {
          typeText.push(name);
          this.currentValue.push(id);
        }
      }, this);
    }, this);
    this.setRawValue(typeText.join(', '));
    return this;
  },

  /**
   * sets values to innerForm
   */
  setFormValue: function setFormValue(value) {
    this.getInnerForm().getForm().items.each(function (item) {
      item.setValue(value.indexOf(item.name) >= 0 ? 'on' : 'off');
    }, this);
  }
});

/***/ }),

/***/ 2094:
/***/ (function(module, exports) {

/*global Ext, Tine*/
Ext.ns('Tine.SimpleFAQ');
/**
 Tine.SimpleFAQ.SearchCombo use for search without switch to SimpleFAQ modul
 Example usage:
 this.actions_searchFAQ = new Ext.Action({
     requiredGrant: 'readGrant',
     text: this.app.i18n._('Search FAQ'),
     disabled: false,
     handler: Tine.Tinebase.appMgr.get('SimpleFAQ').findQuestion,
     iconCls: '.x-btn-large SimpleFAQIconCls',
     scope: this
 });
 */

/**
 * Lead selection combo box
 * 
 * @namespace   Tine.SimpleFAQ
 * @class       Tine.SimpleFAQ.SearchCombo
 * @extends     Tine.Tinebase.widgets.form.RecordPickerComboBox
 * 
 * @param       {Object} config
 * @constructor Create a new Tine.SimpleFAQ.SearchCombo
 */

Tine.SimpleFAQ.SearchCombo = Ext.extend(Tine.Tinebase.widgets.form.RecordPickerComboBox, {
  /**
   * @cfg
   */
  allowBlank: false,
  itemSelector: 'div.search-item',
  minListWidth: 650,
  resizable: true,
  //private
  initComponent: function initComponent() {
    this.recordClass = Tine.SimpleFAQ.Model.Faq;
    this.initTemplate();
    Tine.SimpleFAQ.SearchCombo.superclass.initComponent.call(this);
  },

  /**
   * init template
   * @private
   */
  initTemplate: function initTemplate() {
    if (!this.tpl) {
      this.tpl = new Ext.XTemplate('<tpl for="."><div class="search-item">', '<table cellspacing="0" cellpadding="2" border="0" style="font-size: 11px;" width="100%">', '<tr>', '<td valign="top" width="100%">{[this.encode(values.question)]}</td>', '</tr>', '</table>', '</div></tpl>', {
        encode: function encode(value) {
          return Ext.util.Format.htmlEncode(value);
        }
      });
    }
  }
});
Ext.reg('faqpickercombobox', Tine.SimpleFAQ.SearchCombo);
Tine.widgets.form.RecordPickerManager.register('SimpleFAQ', 'Faq', 'faqpickercombobox');

/***/ }),

/***/ 2095:
/***/ (function(module, exports, __webpack_require__) {

// style-loader: Adds some css to the DOM by adding a <style> tag

// load the styles
var content = __webpack_require__(2096);
if(typeof content === 'string') content = [[module.i, content, '']];
// Prepare cssTransformation
var transform;

var options = {"hmr":true}
options.transform = transform
// add the styles to the DOM
var update = __webpack_require__(11)(content, options);
if(content.locals) module.exports = content.locals;
// Hot Module Replacement
if(false) {}

/***/ }),

/***/ 2096:
/***/ (function(module, exports, __webpack_require__) {

var escape = __webpack_require__(98);
exports = module.exports = __webpack_require__(10)(false);
// imports


// module
exports.push([module.i, "/**\n * CSS override for SinmpleFAQ\n * \n * @package     SimpleFAQ\n * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3\n * @author      Patrick Ryser <patrick.ryser@gmail.com>\n * @copyright   Copyright (c) 2007-2011 Metaways Infosystems GmbH (http://www.metaways.de)\n */\n\n.SimpleFAQIconCls {\n    background-image: url(" + escape(__webpack_require__(286)) + ") !important;\n}\n", ""]);

// exports


/***/ }),

/***/ 286:
/***/ (function(module, exports) {

module.exports = "\"data:image/svg+xml,%3C?xml version='1.0' encoding='utf-8'?%3E %3C!-- Generator: Adobe Illustrator 21.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0) --%3E %3Csvg version='1.1' id='Ebene_1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' x='0px' y='0px' viewBox='0 0 42.5 42.5' style='enable-background:new 0 0 42.5 42.5;' xml:space='preserve' width='42.5' height='42.5'%3E %3Cpath d='M35.6,21c0-2.6-0.7-5.1-2-7.3s-3.1-4-5.3-5.3s-4.7-2-7.3-2s-5.1,0.7-7.3,2s-4,3.1-5.3,5.3s-2,4.7-2,7.3s0.7,5.1,2,7.3 s3.1,4,5.3,5.3s4.7,2,7.3,2s5.1-0.7,7.3-2s4-3.1,5.3-5.3S35.6,23.6,35.6,21z M38,21c0,3.1-0.8,5.9-2.3,8.5c-1.5,2.6-3.6,4.7-6.2,6.2 C26.9,37.2,24.1,38,21,38c-3.1,0-5.9-0.8-8.5-2.3c-2.6-1.5-4.7-3.6-6.2-6.2S4,24.1,4,21c0-3.1,0.8-5.9,2.3-8.5s3.6-4.7,6.2-6.2 S17.9,4,21,4c3.1,0,5.9,0.8,8.5,2.3s4.7,3.6,6.2,6.2C37.2,15.1,38,17.9,38,21z M22.7,26.2v2.9c0,0.2-0.1,0.3-0.2,0.4 c-0.1,0.1-0.2,0.2-0.4,0.2h-2.9c-0.2,0-0.3-0.1-0.4-0.2c-0.1-0.1-0.2-0.2-0.2-0.4v-2.9c0-0.2,0.1-0.3,0.2-0.4 c0.1-0.1,0.2-0.2,0.4-0.2h2.9c0.2,0,0.3,0.1,0.4,0.2C22.7,25.9,22.7,26,22.7,26.2z M27.3,17.3c0,0.6-0.1,1.1-0.3,1.6 s-0.5,0.9-0.8,1.2c-0.4,0.3-0.7,0.6-0.9,0.8c-0.3,0.2-0.6,0.4-1.1,0.6c-0.4,0.2-0.7,0.4-0.8,0.5c-0.2,0.1-0.3,0.3-0.5,0.4 c-0.1,0.2-0.2,0.3-0.2,0.5v0.6c0,0.2-0.1,0.3-0.2,0.4c-0.1,0.1-0.2,0.2-0.4,0.2h-2.9c-0.2,0-0.3-0.1-0.4-0.2 c-0.1-0.1-0.2-0.2-0.2-0.4v-1.2c0-0.4,0.1-0.8,0.2-1.2s0.3-0.6,0.4-0.9c0.2-0.2,0.4-0.4,0.7-0.6c0.3-0.2,0.6-0.4,0.7-0.5 s0.5-0.2,0.8-0.4c0.6-0.3,1.1-0.6,1.3-0.8c0.3-0.2,0.4-0.5,0.4-0.9c0-0.5-0.3-0.9-0.8-1.3c-0.5-0.4-1.1-0.5-1.7-0.5 c-0.7,0-1.2,0.2-1.7,0.5c-0.3,0.2-0.8,0.7-1.4,1.5c-0.1,0.1-0.3,0.2-0.4,0.2c-0.1,0-0.2,0-0.3-0.1L14.9,16c-0.1-0.1-0.2-0.2-0.2-0.4 c0-0.2,0-0.3,0.1-0.4c1.5-2.3,3.5-3.4,6.3-3.4c1.5,0,3,0.5,4.3,1.6S27.3,15.8,27.3,17.3z'/%3E %3C/svg%3E\""

/***/ }),

/***/ 35:
/***/ (function(module, exports) {


/**
 * When source maps are enabled, `style-loader` uses a link element with a data-uri to
 * embed the css on the page. This breaks all relative urls because now they are relative to a
 * bundle instead of the current page.
 *
 * One solution is to only use full urls, but that may be impossible.
 *
 * Instead, this function "fixes" the relative urls to be absolute according to the current page location.
 *
 * A rudimentary test suite is located at `test/fixUrls.js` and can be run via the `npm test` command.
 *
 */

module.exports = function (css) {
  // get current location
  var location = typeof window !== "undefined" && window.location;

  if (!location) {
    throw new Error("fixUrls requires window.location");
  }

	// blank or null?
	if (!css || typeof css !== "string") {
	  return css;
  }

  var baseUrl = location.protocol + "//" + location.host;
  var currentDir = baseUrl + location.pathname.replace(/\/[^\/]*$/, "/");

	// convert each url(...)
	/*
	This regular expression is just a way to recursively match brackets within
	a string.

	 /url\s*\(  = Match on the word "url" with any whitespace after it and then a parens
	   (  = Start a capturing group
	     (?:  = Start a non-capturing group
	         [^)(]  = Match anything that isn't a parentheses
	         |  = OR
	         \(  = Match a start parentheses
	             (?:  = Start another non-capturing groups
	                 [^)(]+  = Match anything that isn't a parentheses
	                 |  = OR
	                 \(  = Match a start parentheses
	                     [^)(]*  = Match anything that isn't a parentheses
	                 \)  = Match a end parentheses
	             )  = End Group
              *\) = Match anything and then a close parens
          )  = Close non-capturing group
          *  = Match anything
       )  = Close capturing group
	 \)  = Match a close parens

	 /gi  = Get all matches, not the first.  Be case insensitive.
	 */
	var fixedCss = css.replace(/url\s*\(((?:[^)(]|\((?:[^)(]+|\([^)(]*\))*\))*)\)/gi, function(fullMatch, origUrl) {
		// strip quotes (if they exist)
		var unquotedOrigUrl = origUrl
			.trim()
			.replace(/^"(.*)"$/, function(o, $1){ return $1; })
			.replace(/^'(.*)'$/, function(o, $1){ return $1; });

		// already a full url? no change
		if (/^(#|data:|http:\/\/|https:\/\/|file:\/\/\/)/i.test(unquotedOrigUrl)) {
		  return fullMatch;
		}

		// convert the url to a full url
		var newUrl;

		if (unquotedOrigUrl.indexOf("//") === 0) {
		  	//TODO: should we add protocol?
			newUrl = unquotedOrigUrl;
		} else if (unquotedOrigUrl.indexOf("/") === 0) {
			// path should be relative to the base url
			newUrl = baseUrl + unquotedOrigUrl; // already starts with '/'
		} else {
			// path should be relative to current directory
			newUrl = currentDir + unquotedOrigUrl.replace(/^\.\//, ""); // Strip leading './'
		}

		// send back the fixed url(...)
		return "url(" + JSON.stringify(newUrl) + ")";
	});

	// send back the fixed css
	return fixedCss;
};


/***/ }),

/***/ 93:
/***/ (function(module, exports, __webpack_require__) {

/* pkg: SimpleFAQ FAT Client (js/SimpleFAQ-FAT.js)*/
__webpack_require__(2084);
__webpack_require__(2085);
__webpack_require__(2086);
__webpack_require__(2087);
__webpack_require__(2088);
__webpack_require__(2089);
__webpack_require__(2090);
__webpack_require__(2091);
__webpack_require__(2092);
__webpack_require__(2093);
__webpack_require__(2094);
/* pkg: SimpleFAQ FAT Client (css/SimpleFAQ-FAT.css)*/
__webpack_require__(2095);


/***/ }),

/***/ 98:
/***/ (function(module, exports) {

module.exports = function escape(url) {
    if (typeof url !== 'string') {
        return url
    }
    // If url is already wrapped in quotes, remove them
    if (/^['"].*['"]$/.test(url)) {
        url = url.slice(1, -1);
    }
    // Should url be wrapped?
    // See https://drafts.csswg.org/css-values-3/#urls
    if (/["'() \t\n]/.test(url)) {
        return '"' + url.replace(/"/g, '\\"').replace(/\n/g, '\\n') + '"'
    }

    return url
}


/***/ })

}]);