(window["webpackJsonp"] = window["webpackJsonp"] || []).push([[13],{

/***/ 10:
/***/ (function(module, exports) {

/*
	MIT License http://www.opensource.org/licenses/mit-license.php
	Author Tobias Koppers @sokra
*/
// css base code, injected by the css-loader
module.exports = function(useSourceMap) {
	var list = [];

	// return the list of modules as css string
	list.toString = function toString() {
		return this.map(function (item) {
			var content = cssWithMappingToString(item, useSourceMap);
			if(item[2]) {
				return "@media " + item[2] + "{" + content + "}";
			} else {
				return content;
			}
		}).join("");
	};

	// import a list of modules into the list
	list.i = function(modules, mediaQuery) {
		if(typeof modules === "string")
			modules = [[null, modules, ""]];
		var alreadyImportedModules = {};
		for(var i = 0; i < this.length; i++) {
			var id = this[i][0];
			if(typeof id === "number")
				alreadyImportedModules[id] = true;
		}
		for(i = 0; i < modules.length; i++) {
			var item = modules[i];
			// skip already imported module
			// this implementation is not 100% perfect for weird media query combinations
			//  when a module is imported multiple times with different media queries.
			//  I hope this will never occur (Hey this way we have smaller bundles)
			if(typeof item[0] !== "number" || !alreadyImportedModules[item[0]]) {
				if(mediaQuery && !item[2]) {
					item[2] = mediaQuery;
				} else if(mediaQuery) {
					item[2] = "(" + item[2] + ") and (" + mediaQuery + ")";
				}
				list.push(item);
			}
		}
	};
	return list;
};

function cssWithMappingToString(item, useSourceMap) {
	var content = item[1] || '';
	var cssMapping = item[3];
	if (!cssMapping) {
		return content;
	}

	if (useSourceMap && typeof btoa === 'function') {
		var sourceMapping = toComment(cssMapping);
		var sourceURLs = cssMapping.sources.map(function (source) {
			return '/*# sourceURL=' + cssMapping.sourceRoot + source + ' */'
		});

		return [content].concat(sourceURLs).concat([sourceMapping]).join('\n');
	}

	return [content].join('\n');
}

// Adapted from convert-source-map (MIT)
function toComment(sourceMap) {
	// eslint-disable-next-line no-undef
	var base64 = btoa(unescape(encodeURIComponent(JSON.stringify(sourceMap))));
	var data = 'sourceMappingURL=data:application/json;charset=utf-8;base64,' + base64;

	return '/*# ' + data + ' */';
}


/***/ }),

/***/ 11:
/***/ (function(module, exports, __webpack_require__) {

/*
	MIT License http://www.opensource.org/licenses/mit-license.php
	Author Tobias Koppers @sokra
*/

var stylesInDom = {};

var	memoize = function (fn) {
	var memo;

	return function () {
		if (typeof memo === "undefined") memo = fn.apply(this, arguments);
		return memo;
	};
};

var isOldIE = memoize(function () {
	// Test for IE <= 9 as proposed by Browserhacks
	// @see http://browserhacks.com/#hack-e71d8692f65334173fee715c222cb805
	// Tests for existence of standard globals is to allow style-loader
	// to operate correctly into non-standard environments
	// @see https://github.com/webpack-contrib/style-loader/issues/177
	return window && document && document.all && !window.atob;
});

var getElement = (function (fn) {
	var memo = {};

	return function(selector) {
		if (typeof memo[selector] === "undefined") {
			var styleTarget = fn.call(this, selector);
			// Special case to return head of iframe instead of iframe itself
			if (styleTarget instanceof window.HTMLIFrameElement) {
				try {
					// This will throw an exception if access to iframe is blocked
					// due to cross-origin restrictions
					styleTarget = styleTarget.contentDocument.head;
				} catch(e) {
					styleTarget = null;
				}
			}
			memo[selector] = styleTarget;
		}
		return memo[selector]
	};
})(function (target) {
	return document.querySelector(target)
});

var singleton = null;
var	singletonCounter = 0;
var	stylesInsertedAtTop = [];

var	fixUrls = __webpack_require__(35);

module.exports = function(list, options) {
	if (typeof DEBUG !== "undefined" && DEBUG) {
		if (typeof document !== "object") throw new Error("The style-loader cannot be used in a non-browser environment");
	}

	options = options || {};

	options.attrs = typeof options.attrs === "object" ? options.attrs : {};

	// Force single-tag solution on IE6-9, which has a hard limit on the # of <style>
	// tags it will allow on a page
	if (!options.singleton && typeof options.singleton !== "boolean") options.singleton = isOldIE();

	// By default, add <style> tags to the <head> element
	if (!options.insertInto) options.insertInto = "head";

	// By default, add <style> tags to the bottom of the target
	if (!options.insertAt) options.insertAt = "bottom";

	var styles = listToStyles(list, options);

	addStylesToDom(styles, options);

	return function update (newList) {
		var mayRemove = [];

		for (var i = 0; i < styles.length; i++) {
			var item = styles[i];
			var domStyle = stylesInDom[item.id];

			domStyle.refs--;
			mayRemove.push(domStyle);
		}

		if(newList) {
			var newStyles = listToStyles(newList, options);
			addStylesToDom(newStyles, options);
		}

		for (var i = 0; i < mayRemove.length; i++) {
			var domStyle = mayRemove[i];

			if(domStyle.refs === 0) {
				for (var j = 0; j < domStyle.parts.length; j++) domStyle.parts[j]();

				delete stylesInDom[domStyle.id];
			}
		}
	};
};

function addStylesToDom (styles, options) {
	for (var i = 0; i < styles.length; i++) {
		var item = styles[i];
		var domStyle = stylesInDom[item.id];

		if(domStyle) {
			domStyle.refs++;

			for(var j = 0; j < domStyle.parts.length; j++) {
				domStyle.parts[j](item.parts[j]);
			}

			for(; j < item.parts.length; j++) {
				domStyle.parts.push(addStyle(item.parts[j], options));
			}
		} else {
			var parts = [];

			for(var j = 0; j < item.parts.length; j++) {
				parts.push(addStyle(item.parts[j], options));
			}

			stylesInDom[item.id] = {id: item.id, refs: 1, parts: parts};
		}
	}
}

function listToStyles (list, options) {
	var styles = [];
	var newStyles = {};

	for (var i = 0; i < list.length; i++) {
		var item = list[i];
		var id = options.base ? item[0] + options.base : item[0];
		var css = item[1];
		var media = item[2];
		var sourceMap = item[3];
		var part = {css: css, media: media, sourceMap: sourceMap};

		if(!newStyles[id]) styles.push(newStyles[id] = {id: id, parts: [part]});
		else newStyles[id].parts.push(part);
	}

	return styles;
}

function insertStyleElement (options, style) {
	var target = getElement(options.insertInto)

	if (!target) {
		throw new Error("Couldn't find a style target. This probably means that the value for the 'insertInto' parameter is invalid.");
	}

	var lastStyleElementInsertedAtTop = stylesInsertedAtTop[stylesInsertedAtTop.length - 1];

	if (options.insertAt === "top") {
		if (!lastStyleElementInsertedAtTop) {
			target.insertBefore(style, target.firstChild);
		} else if (lastStyleElementInsertedAtTop.nextSibling) {
			target.insertBefore(style, lastStyleElementInsertedAtTop.nextSibling);
		} else {
			target.appendChild(style);
		}
		stylesInsertedAtTop.push(style);
	} else if (options.insertAt === "bottom") {
		target.appendChild(style);
	} else if (typeof options.insertAt === "object" && options.insertAt.before) {
		var nextSibling = getElement(options.insertInto + " " + options.insertAt.before);
		target.insertBefore(style, nextSibling);
	} else {
		throw new Error("[Style Loader]\n\n Invalid value for parameter 'insertAt' ('options.insertAt') found.\n Must be 'top', 'bottom', or Object.\n (https://github.com/webpack-contrib/style-loader#insertat)\n");
	}
}

function removeStyleElement (style) {
	if (style.parentNode === null) return false;
	style.parentNode.removeChild(style);

	var idx = stylesInsertedAtTop.indexOf(style);
	if(idx >= 0) {
		stylesInsertedAtTop.splice(idx, 1);
	}
}

function createStyleElement (options) {
	var style = document.createElement("style");

	options.attrs.type = "text/css";

	addAttrs(style, options.attrs);
	insertStyleElement(options, style);

	return style;
}

function createLinkElement (options) {
	var link = document.createElement("link");

	options.attrs.type = "text/css";
	options.attrs.rel = "stylesheet";

	addAttrs(link, options.attrs);
	insertStyleElement(options, link);

	return link;
}

function addAttrs (el, attrs) {
	Object.keys(attrs).forEach(function (key) {
		el.setAttribute(key, attrs[key]);
	});
}

function addStyle (obj, options) {
	var style, update, remove, result;

	// If a transform function was defined, run it on the css
	if (options.transform && obj.css) {
	    result = options.transform(obj.css);

	    if (result) {
	    	// If transform returns a value, use that instead of the original css.
	    	// This allows running runtime transformations on the css.
	    	obj.css = result;
	    } else {
	    	// If the transform function returns a falsy value, don't add this css.
	    	// This allows conditional loading of css
	    	return function() {
	    		// noop
	    	};
	    }
	}

	if (options.singleton) {
		var styleIndex = singletonCounter++;

		style = singleton || (singleton = createStyleElement(options));

		update = applyToSingletonTag.bind(null, style, styleIndex, false);
		remove = applyToSingletonTag.bind(null, style, styleIndex, true);

	} else if (
		obj.sourceMap &&
		typeof URL === "function" &&
		typeof URL.createObjectURL === "function" &&
		typeof URL.revokeObjectURL === "function" &&
		typeof Blob === "function" &&
		typeof btoa === "function"
	) {
		style = createLinkElement(options);
		update = updateLink.bind(null, style, options);
		remove = function () {
			removeStyleElement(style);

			if(style.href) URL.revokeObjectURL(style.href);
		};
	} else {
		style = createStyleElement(options);
		update = applyToTag.bind(null, style);
		remove = function () {
			removeStyleElement(style);
		};
	}

	update(obj);

	return function updateStyle (newObj) {
		if (newObj) {
			if (
				newObj.css === obj.css &&
				newObj.media === obj.media &&
				newObj.sourceMap === obj.sourceMap
			) {
				return;
			}

			update(obj = newObj);
		} else {
			remove();
		}
	};
}

var replaceText = (function () {
	var textStore = [];

	return function (index, replacement) {
		textStore[index] = replacement;

		return textStore.filter(Boolean).join('\n');
	};
})();

function applyToSingletonTag (style, index, remove, obj) {
	var css = remove ? "" : obj.css;

	if (style.styleSheet) {
		style.styleSheet.cssText = replaceText(index, css);
	} else {
		var cssNode = document.createTextNode(css);
		var childNodes = style.childNodes;

		if (childNodes[index]) style.removeChild(childNodes[index]);

		if (childNodes.length) {
			style.insertBefore(cssNode, childNodes[index]);
		} else {
			style.appendChild(cssNode);
		}
	}
}

function applyToTag (style, obj) {
	var css = obj.css;
	var media = obj.media;

	if(media) {
		style.setAttribute("media", media)
	}

	if(style.styleSheet) {
		style.styleSheet.cssText = css;
	} else {
		while(style.firstChild) {
			style.removeChild(style.firstChild);
		}

		style.appendChild(document.createTextNode(css));
	}
}

function updateLink (link, options, obj) {
	var css = obj.css;
	var sourceMap = obj.sourceMap;

	/*
		If convertToAbsoluteUrls isn't defined, but sourcemaps are enabled
		and there is no publicPath defined then lets turn convertToAbsoluteUrls
		on by default.  Otherwise default to the convertToAbsoluteUrls option
		directly
	*/
	var autoFixUrls = options.convertToAbsoluteUrls === undefined && sourceMap;

	if (options.convertToAbsoluteUrls || autoFixUrls) {
		css = fixUrls(css);
	}

	if (sourceMap) {
		// http://stackoverflow.com/a/26603875
		css += "\n/*# sourceMappingURL=data:application/json;base64," + btoa(unescape(encodeURIComponent(JSON.stringify(sourceMap)))) + " */";
	}

	var blob = new Blob([css], { type: "text/css" });

	var oldSrc = link.href;

	link.href = URL.createObjectURL(blob);

	if(oldSrc) URL.revokeObjectURL(oldSrc);
}


/***/ }),

/***/ 1979:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Stefanie Stamer <s.stamer@metaways.de>
 * @copyright   Copyright (c) 2007-2016 Metaways Infosystems GmbH (http://www.metaways.de)
 */
Ext.ns('Tine.Inventory');
/**
 * @namespace   Tine.Inventory
 * @class       Tine.Inventory.InventoryItemEditDialog
 * @extends     Tine.widgets.dialog.EditDialog
 * 
 * <p>InventoryItem Compose Dialog</p>
 * <p></p>
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Stefanie Stamer <s.stamer@metaways.de>
 * @copyright   Copyright (c) 2012-2013 Metaways Infosystems GmbH (http://www.metaways.de)
 * 
 * @param       {Object} config
 * @constructor
 * Create a new Tine.Inventory.InventoryItemEditDialog
 */

Tine.Inventory.InventoryItemEditDialog = Ext.extend(Tine.widgets.dialog.EditDialog, {
  /**
   * @private
   */
  windowHeight: 470,
  windowWidth: 800,
  displayNotes: true,

  /**
   * check validity of activ number field
   */
  isValid: function isValid() {
    var form = this.getForm();
    var isValid = true;

    if (form.findField('total_number').getValue() < form.findField('active_number').getValue()) {
      var invalidString = String.format(this.app.i18n._('The active number must be less than or equal total number.'));
      form.findField('active_number').markInvalid(invalidString);
      isValid = false;
    }

    return isValid && Tine.Inventory.InventoryItemEditDialog.superclass.isValid.apply(this, arguments);
  },

  /**
   * returns dialog
   * 
   * NOTE: when this method gets called, all initalisation is done.
   * 
   * @return {Object}
   * @private
   */
  getFormItems: function getFormItems() {
    return {
      xtype: 'tabpanel',
      border: false,
      plain: true,
      activeTab: 0,
      defaults: {
        hideMode: 'offsets'
      },
      items: [{
        //Start first tab
        title: this.app.i18n._('General'),
        border: false,
        frame: true,
        layout: 'border',
        items: [{
          region: 'center',
          layout: 'hfit',
          border: false,
          items: [{
            region: 'center',
            xtype: 'columnform',
            labelAlign: 'top',
            formDefaults: {
              xtype: 'textfield',
              anchor: '100%',
              labelSeparator: '',
              columnWidth: .333,
              disabled: this.useMultiple ? true : false
            },
            // Start first line
            items: [[{
              columnWidth: 1,
              xtype: 'tw-uidtriggerfield',
              fieldLabel: this.app.i18n._('ID'),
              name: 'inventory_id',
              maxLength: 100,
              allowBlank: false
            }], [{
              columnWidth: 1,
              xtype: 'tine.widget.field.AutoCompleteField',
              recordClass: this.recordClass,
              fieldLabel: this.app.i18n._('Name'),
              name: 'name',
              maxLength: 100,
              allowBlank: false
            }]]
          }, {
            //Start second line
            layout: 'hbox',
            items: [{
              flex: 1,
              xtype: 'columnform',
              autoHeight: true,
              style: 'padding-right: 5px;',
              items: [[{
                xtype: 'textarea',
                columnWidth: 1,
                name: 'description',
                fieldLabel: this.app.i18n._('Description'),
                grow: false,
                preventScrollbars: false,
                height: 150,
                emptyText: this.app.i18n._('Enter description')
              }]]
            }, new Ext.ux.form.ImageField({
              name: 'image',
              width: 160,
              height: 150,
              style: {
                'margin-top': '17px'
              }
            })]
          }, {
            //Start third line
            xtype: 'columnform',
            labelAlign: 'top',
            formDefaults: {
              xtype: 'textfield',
              anchor: '100%',
              labelSeparator: '',
              columnWidth: .333,
              disabled: this.useMultiple ? true : false
            },
            items: [[{
              columnWidth: 1,
              xtype: 'tine.widget.field.AutoCompleteField',
              recordClass: this.recordClass,
              fieldLabel: this.app.i18n._('Location'),
              name: 'location',
              maxLength: 255
            }], [{
              xtype: 'extuxclearabledatefield',
              columnWidth: 0.333,
              fieldLabel: this.app.i18n._('Added'),
              name: 'added_date'
            }, {
              xtype: 'datefield',
              name: 'warranty',
              fieldLabel: this.app.i18n._('Warranty'),
              columnWidth: 0.333
            }, {
              xtype: 'extuxclearabledatefield',
              columnWidth: 0.333,
              fieldLabel: this.app.i18n._('Removed'),
              name: 'removed_date'
            }], [{
              xtype: 'numberfield',
              columnWidth: 0.333,
              fieldLabel: this.app.i18n._('Total number'),
              name: 'total_number',
              value: 1,
              minValue: 1
            }, {
              xtype: 'numberfield',
              columnWidth: 0.333,
              fieldLabel: this.app.i18n._('Available number'),
              name: 'active_number',
              value: 1,
              minValue: 0
            }, new Tine.Tinebase.widgets.keyfield.ComboBox({
              app: 'Inventory',
              keyFieldName: 'inventoryStatus',
              fieldLabel: this.app.i18n._('Status'),
              name: 'status',
              columnWidth: 0.333
            })]]
          }]
        }, {
          //Start side
          layout: 'ux.multiaccordion',
          animate: true,
          region: 'east',
          width: 210,
          split: true,
          collapsible: true,
          collapseMode: 'mini',
          header: false,
          margins: '0 5 0 5',
          border: true,
          items: [new Tine.widgets.tags.TagPanel({
            app: 'Inventory',
            border: false,
            bodyStyle: 'border:1px solid #B5B8C8;'
          })]
        }]
      }, {
        //Start second tab
        title: this.app.i18n._('Accounting'),
        autoScroll: true,
        border: false,
        frame: true,
        layout: 'border',
        items: [{
          region: 'center',
          xtype: 'columnform',
          labelAlign: 'top',
          formDefaults: {
            xtype: 'textfield',
            anchor: '100%',
            labelSeparator: '',
            columnWidth: 1,
            disabled: this.useMultiple ? true : false
          },
          items: [[{
            xtype: 'extuxmoneyfield',
            name: 'price',
            fieldLabel: this.app.i18n._('Price'),
            columnWidth: 0.5
          }, Tine.hasOwnProperty('Sales') && Tine.Tinebase.common.hasRight('view', 'Sales', 'costcenter') ? Tine.widgets.form.RecordPickerManager.get('Sales', 'CostCenter', {
            name: 'costcenter',
            allowBlank: true,
            fieldLabel: this.app.i18n._('Cost center'),
            columnWidth: 0.5
          }) : {
            xtype: 'textfield',
            name: 'costcenter',
            disabled: true,
            hidden: true,
            columnWidth: 0.5
          }], [{
            xtype: 'textfield',
            name: 'invoice',
            fieldLabel: this.app.i18n._('Invoice'),
            columnWidth: 0.5
          }, {
            xtype: 'datefield',
            name: 'invoice_date',
            fieldLabel: this.app.i18n._('Invoice date'),
            columnWidth: 0.5
          }], [{
            xtype: 'checkbox',
            hideLabel: true,
            boxLabel: this.app.i18n._('Depreciate'),
            name: 'deprecated_status'
          }]]
        }]
      }, new Tine.widgets.activities.ActivitiesTabPanel({
        app: this.appName,
        record_id: this.record.id,
        record_model: this.appName + '_Model_' + this.recordClass.getMeta('modelName')
      })]
    };
  },

  /**
   * vaidates on multiple edit
   * 
   * @return {Boolean}
   */
  isMultipleValid: function isMultipleValid() {
    return true;
  }
});

/***/ }),

/***/ 1980:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 * 
 * @package     Inventory
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Michael Spahn <m.spahn@metaways.de>
 * @copyright   Copyright (c) 2012 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 */
Ext.ns('Tine.Inventory');
/**
 * Inventory grid panel
 * 
 * @namespace   Tine.Inventory
 * @class       Tine.Inventory.InventoryGridPanel
 * @extends     Tine.widgets.grid.GridPanel
 * 
 * <p>Inventory Grid Panel</p>
 * <p><pre>
 * </pre></p>
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Michael Spahn <m.spahn@metaways.de>
 * 
 * @param       {Object} config
 * @constructor
 * Create a new Tine.Inventory.InventoryItemGridPanel
 */

Tine.Inventory.InventoryItemGridPanel = Ext.extend(Tine.widgets.grid.GridPanel, {
  multipleEdit: true,
  copyEditAction: true
});

/***/ }),

/***/ 1981:
/***/ (function(module, exports, __webpack_require__) {

// style-loader: Adds some css to the DOM by adding a <style> tag

// load the styles
var content = __webpack_require__(1982);
if(typeof content === 'string') content = [[module.i, content, '']];
// Prepare cssTransformation
var transform;

var options = {"hmr":true}
options.transform = transform
// add the styles to the DOM
var update = __webpack_require__(11)(content, options);
if(content.locals) module.exports = content.locals;
// Hot Module Replacement
if(false) {}

/***/ }),

/***/ 1982:
/***/ (function(module, exports, __webpack_require__) {

var escape = __webpack_require__(98);
exports = module.exports = __webpack_require__(10)(false);
// imports


// module
exports.push([module.i, "/**\n * Tine 2.0\n * \n * @package     Inventory\n * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3\n * @author      Philipp Schüle <p.schuele@metaways.de>\n * @copyright   Copyright (c) 2007-2011 Metaways Infosystems GmbH (http://www.metaways.de)\n *\n */\n\n.InventoryIconCls {\n    background-image: url(" + escape(__webpack_require__(1983)) + ") !important;\n}\n\n\n.t-contenttype-inventoryitem .action_add {\n    background-image: url(" + escape(__webpack_require__(1984)) + ") !important;\n}\n\n.t-contenttype-inventoryitem .action_edit {\n    background-image: url(" + escape(__webpack_require__(1985)) + ") !important;\n}\n\n.t-contenttype-inventoryitem .action_delete {\n    background-image: url(" + escape(__webpack_require__(1986)) + ") !important;\n}\n\n.t-contenttype-inventoryitem .action_export {\n    background-image: url(" + escape(__webpack_require__(1987)) + ") !important;\n}\n\n.t-contenttype-inventoryitem .action_import {\n    background-image: url(" + escape(__webpack_require__(1988)) + ") !important;\n}", ""]);

// exports


/***/ }),

/***/ 1983:
/***/ (function(module, exports) {

module.exports = "\"data:image/svg+xml,%3C?xml version='1.0' encoding='utf-8'?%3E %3C!-- Generator: Adobe Illustrator 21.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0) --%3E %3Csvg version='1.1' id='Ebene_1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' x='0px' y='0px' viewBox='0 0 42.5 42.5' style='enable-background:new 0 0 42.5 42.5;' xml:space='preserve' width='42.5' height='42.5'%3E %3Cpath d='M7.9,20.6H9v3.8c0,0.7,0.4,1.9,2.8,1.9H13c0,0,0,0,0,0c0,0,0,0,0,0h6.7v7.4h-7.9c-0.3,0-0.6,0.3-0.6,0.6s0.3,0.6,0.6,0.6 h0.6v0.1c-0.2-0.1-0.4-0.1-0.6-0.1c-0.9,0-1.7,0.8-1.7,1.7c0,0.9,0.8,1.7,1.7,1.7s1.7-0.8,1.7-1.7c0-0.1,0-0.3,0-0.4 c0-0.1,0-0.1,0-0.2v-1.1h6.7c0,0,0.1,0,0.1,0v1.1c0,0.1,0,0.1,0,0.2c0,0.1,0,0.2,0,0.4c0,0.9,0.8,1.7,1.7,1.7c0.9,0,1.7-0.8,1.7-1.7 c0-0.9-0.6-1.6-1.5-1.7h0.4c0,0,0.1,0,0.1,0h6.1v1.1c0,0.1,0,0.1,0,0.2c0,0.1,0,0.2,0,0.4c0,0.9,0.8,1.7,1.7,1.7s1.7-0.8,1.7-1.7 s-0.8-1.7-1.7-1.7c-0.2,0-0.4,0-0.6,0.1v-0.1h0.6c0.3,0,0.6-0.3,0.6-0.6s-0.3-0.6-0.6-0.6h-7.3v-7.4h6.7c0,0,0,0,0,0c0,0,0,0,0,0 h1.1c0.7,0,2.8,0,2.8-2.3v-3.4h1.1c0.3,0,0.6-0.3,0.6-0.6v-1.7c0-0.3-0.3-0.6-0.6-0.6h-3.4c-0.3,0-0.6,0.3-0.6,0.6v1.7 c0,0.3,0.3,0.6,0.6,0.6h1.1V24c0,0.5,0,1-1.2,1.1c0.1-0.2,0.1-0.4,0.1-0.6v-0.5c0-1-0.8-1.8-1.8-1.8h-6.7v-5.7H27 c1.6,0,2.9-1.3,2.9-2.9V8.2c0-2.2-1.8-4-4-4h-9c-2.2,0-4,1.8-4,4v5.5c0,1.6,1.3,2.9,2.9,2.9h3.9v5.7H13c-1,0-1.8,0.8-1.8,1.8v0.5 c0,0.2,0,0.4,0.1,0.6c-1.2-0.1-1.2-0.6-1.2-0.8v-3.8h1.1c0.3,0,0.6-0.3,0.6-0.6v-1.7c0-0.3-0.3-0.6-0.6-0.6H7.9 c-0.3,0-0.6,0.3-0.6,0.6v1.7C7.3,20.4,7.6,20.6,7.9,20.6z M21.5,34.9L21.5,34.9l0.4-0.1C21.7,34.8,21.6,34.9,21.5,34.9z'/%3E %3C/svg%3E\""

/***/ }),

/***/ 1984:
/***/ (function(module, exports) {

module.exports = "\"data:image/svg+xml,%3C?xml version='1.0' encoding='utf-8'?%3E %3C!-- Generator: Adobe Illustrator 21.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0) --%3E %3Csvg version='1.1' id='Ebene_1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' x='0px' y='0px' viewBox='0 0 42.5 42.5' style='enable-background:new 0 0 42.5 42.5;' xml:space='preserve' width='42.5' height='42.5'%3E %3Cpath d='M27.4,15.5c-0.1-0.1-0.2-0.3-0.2-0.4v-1.2c0-0.2,0.1-0.3,0.2-0.4s0.3-0.2,0.4-0.2h4.3V9c0-0.2,0.1-0.3,0.2-0.4 s0.3-0.2,0.4-0.2h1.2c0.2,0,0.3,0.1,0.4,0.2s0.2,0.3,0.2,0.4v4.3h4.3c0.2,0,0.3,0.1,0.4,0.2s0.2,0.3,0.2,0.4v1.2 c0,0.2-0.1,0.3-0.2,0.4s-0.3,0.2-0.4,0.2h-4.3v4.3c0,0.2-0.1,0.3-0.2,0.4s-0.3,0.2-0.4,0.2h-1.2c-0.2,0-0.3-0.1-0.4-0.2 s-0.2-0.3-0.2-0.4v-4.3h-4.3C27.7,15.7,27.5,15.6,27.4,15.5z M2,19.9v-1.7c0-0.3,0.3-0.6,0.6-0.6H6c0.3,0,0.6,0.3,0.6,0.6v1.7 c0,0.3-0.3,0.6-0.6,0.6H4.8v3.8c0,0.2,0,0.7,1.2,0.8C6,24.8,6,24.6,6,24.4v-0.5c0-1,0.8-1.8,1.8-1.8h6.7v-5.7h-3.9 c-1.6,0-2.9-1.3-2.9-2.9V8c0-2.2,1.8-4,4-4h9c2.2,0,4,1.8,4,4v5.5c0,1.6-1.3,2.9-2.9,2.9h-3.9v5.7h6.7c1,0,1.8,0.8,1.8,1.8v0.5 c0,0.2,0,0.4-0.1,0.6c1.2-0.1,1.2-0.6,1.2-1.1v-3.4h-1.1c-0.3,0-0.6-0.3-0.6-0.6v-1.7c0-0.3,0.3-0.6,0.6-0.6h3.4 c0.3,0,0.6,0.3,0.6,0.6v1.7c0,0.3-0.3,0.6-0.6,0.6h-1.1v3.4c0,2.3-2.1,2.3-2.8,2.3h-1.1c0,0,0,0,0,0c0,0,0,0,0,0h-6.7v7.4h7.3 c0.3,0,0.6,0.3,0.6,0.6c0,0.3-0.3,0.6-0.6,0.6h-0.6v0.1c0.2-0.1,0.4-0.1,0.6-0.1c0.9,0,1.7,0.8,1.7,1.7S26.2,38,25.2,38 c-0.9,0-1.7-0.8-1.7-1.7c0-0.1,0-0.2,0-0.4c0-0.1,0-0.1,0-0.2v-1.1h-6.1c0,0-0.1,0-0.1,0h-0.4c0.9,0.1,1.5,0.8,1.5,1.7 c0,0.9-0.8,1.7-1.7,1.7c-0.9,0-1.7-0.8-1.7-1.7c0-0.1,0-0.2,0-0.4c0-0.1,0-0.1,0-0.2v-1.1c0,0-0.1,0-0.1,0H8.2v1.1 c0,0.1,0,0.1,0,0.2c0,0.1,0,0.3,0,0.4c0,0.9-0.8,1.7-1.7,1.7c-0.9,0-1.7-0.8-1.7-1.7c0-0.9,0.8-1.7,1.7-1.7c0.2,0,0.4,0,0.6,0.1 v-0.1H6.5C6.2,34.6,6,34.4,6,34c0-0.3,0.3-0.6,0.6-0.6h7.9v-7.4H7.7c0,0,0,0,0,0s0,0,0,0H6.5c-2.5,0-2.8-1.2-2.8-1.9v-3.8H2.6 C2.3,20.4,2,20.2,2,19.9z M16.5,34.6h-0.4v0.1C16.3,34.7,16.4,34.6,16.5,34.6z'/%3E %3C/svg%3E\""

/***/ }),

/***/ 1985:
/***/ (function(module, exports) {

module.exports = "\"data:image/svg+xml,%3C?xml version='1.0' encoding='utf-8'?%3E %3C!-- Generator: Adobe Illustrator 21.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0) --%3E %3Csvg version='1.1' id='Ebene_1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' x='0px' y='0px' viewBox='0 0 42.5 42.5' style='enable-background:new 0 0 42.5 42.5;' xml:space='preserve' width='42.5' height='42.5'%3E %3Cpath d='M25.7,30.3l2-1.8l-2.3-2.6l-2,1.8l0,0.9l1.6,0.1l-0.1,1.6L25.7,30.3z M33.4,19c-0.2-0.2-0.3-0.2-0.5,0l-6,5.4 c-0.2,0.2-0.2,0.4,0,0.5c0.2,0.2,0.3,0.2,0.5,0l6-5.4C33.5,19.4,33.5,19.2,33.4,19z M33.2,16.7l4.4,4.9L26.2,31.9l-4.7-0.2l0.2-4.7 L33.2,16.7z M40.3,19.2l-1.6,1.4l-4.4-4.9l1.6-1.4c0.3-0.3,0.7-0.4,1.1-0.4c0.4,0,0.8,0.2,1.1,0.5l2.3,2.6c0.3,0.3,0.4,0.7,0.4,1.1 C40.8,18.6,40.6,18.9,40.3,19.2z M17.9,22.1v-5.7h3.9c1.6,0,2.9-1.3,2.9-2.9V8c0-2.2-1.8-4-4-4h-9c-2.2,0-4,1.8-4,4v5.5 c0,1.6,1.3,2.9,2.9,2.9h3.9v5.7H7.7c-1,0-1.8,0.8-1.8,1.8v0.5c0,0.2,0,0.4,0.1,0.6c-1.2-0.1-1.2-0.6-1.2-0.8v-3.8H6 c0.3,0,0.6-0.3,0.6-0.6v-1.7c0-0.3-0.3-0.6-0.6-0.6H2.6c-0.3,0-0.6,0.3-0.6,0.6v1.7c0,0.3,0.3,0.6,0.6,0.6h1.1v3.8 c0,0.7,0.4,1.9,2.8,1.9h1.1c0,0,0,0,0,0s0,0,0,0h6.7v7.4H6.5C6.2,33.5,6,33.7,6,34c0,0.3,0.3,0.6,0.6,0.6h0.6v0.1 c-0.2-0.1-0.4-0.1-0.6-0.1c-0.9,0-1.7,0.8-1.7,1.7S5.6,38,6.5,38c0.9,0,1.7-0.8,1.7-1.7c0-0.1,0-0.3,0-0.4c0-0.1,0-0.1,0-0.2v-1.1 h6.7c0,0,0.1,0,0.1,0v1.1c0,0.1,0,0.1,0,0.2c0,0.1,0,0.2,0,0.4c0,0.9,0.8,1.7,1.7,1.7c0.9,0,1.7-0.8,1.7-1.7c0-0.9-0.6-1.6-1.5-1.7 h0.4c0,0,0.1,0,0.1,0h6.1v1.1c0,0.1,0,0.1,0,0.2c0,0.1,0,0.2,0,0.4c0,0.9,0.8,1.7,1.7,1.7c0.9,0,1.7-0.8,1.7-1.7 c0-0.9-0.8-1.7-1.7-1.7c-0.2,0-0.4,0-0.6,0.1v-0.1h0.6c0.3,0,0.6-0.3,0.6-0.6c0-0.3-0.3-0.6-0.6-0.6h-7.3v-7.4h2.7l4.4-4H17.9z M16.2,34.7L16.2,34.7l0.4-0.1C16.4,34.6,16.3,34.7,16.2,34.7z'/%3E %3C/svg%3E\""

/***/ }),

/***/ 1986:
/***/ (function(module, exports) {

module.exports = "\"data:image/svg+xml,%3C?xml version='1.0' encoding='utf-8'?%3E %3C!-- Generator: Adobe Illustrator 21.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0) --%3E %3Csvg version='1.1' id='Ebene_1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' x='0px' y='0px' viewBox='0 0 42.5 42.5' style='enable-background:new 0 0 42.5 42.5;' xml:space='preserve' width='42.5' height='42.5'%3E %3Cpath d='M37.5,27.3l-0.9,0.9c-0.1,0.1-0.3,0.2-0.4,0.2c-0.2,0-0.3-0.1-0.5-0.2l-3.8-3.8L28,28.3c-0.1,0.1-0.3,0.2-0.5,0.2 s-0.3-0.1-0.4-0.2l-0.9-0.9c-0.1-0.1-0.2-0.3-0.2-0.4c0-0.2,0.1-0.3,0.2-0.5l3.8-3.8l-3.8-3.8c-0.1-0.1-0.2-0.3-0.2-0.5 s0.1-0.3,0.2-0.4l0.9-0.9c0.1-0.1,0.3-0.2,0.4-0.2s0.3,0.1,0.5,0.2l3.8,3.8l3.8-3.8c0.1-0.1,0.3-0.2,0.5-0.2c0.2,0,0.3,0.1,0.4,0.2 l0.9,0.9c0.1,0.1,0.2,0.3,0.2,0.4s-0.1,0.3-0.2,0.5l-3.8,3.8l3.8,3.8c0.1,0.1,0.2,0.3,0.2,0.5C37.7,27.1,37.6,27.2,37.5,27.3z M19.9,22.1v-5.7h3.9c1.6,0,2.9-1.3,2.9-2.9V8c0-2.2-1.8-4-4-4h-9c-2.2,0-4,1.8-4,4v5.5c0,1.6,1.3,2.9,2.9,2.9h3.9v5.7H9.7 c-1,0-1.8,0.8-1.8,1.8v0.5c0,0.2,0,0.4,0.1,0.6c-1.2-0.1-1.2-0.6-1.2-0.8v-3.8H8c0.3,0,0.6-0.3,0.6-0.6v-1.7c0-0.3-0.3-0.6-0.6-0.6 H4.6c-0.3,0-0.6,0.3-0.6,0.6v1.7c0,0.3,0.3,0.6,0.6,0.6h1.1v3.8c0,0.7,0.4,1.9,2.8,1.9h1.1c0,0,0,0,0,0s0,0,0,0h6.7v7.4H8.5 C8.2,33.5,8,33.7,8,34c0,0.3,0.3,0.6,0.6,0.6h0.6v0.1c-0.2-0.1-0.4-0.1-0.6-0.1c-0.9,0-1.7,0.8-1.7,1.7S7.6,38,8.5,38 c0.9,0,1.7-0.8,1.7-1.7c0-0.1,0-0.3,0-0.4c0-0.1,0-0.1,0-0.2v-1.1h6.7c0,0,0.1,0,0.1,0v1.1c0,0.1,0,0.1,0,0.2c0,0.1,0,0.2,0,0.4 c0,0.9,0.8,1.7,1.7,1.7c0.9,0,1.7-0.8,1.7-1.7c0-0.9-0.6-1.6-1.5-1.7h0.4c0,0,0.1,0,0.1,0h6.1v1.1c0,0.1,0,0.1,0,0.2 c0,0.1,0,0.2,0,0.4c0,0.9,0.8,1.7,1.7,1.7c0.9,0,1.7-0.8,1.7-1.7c0-0.9-0.8-1.7-1.7-1.7c-0.2,0-0.4,0-0.6,0.1v-0.1h0.6 c0.3,0,0.6-0.3,0.6-0.6c0-0.3-0.3-0.6-0.6-0.6h-7.3v-7.4h2.7l4.4-4H19.9z M18.2,34.7L18.2,34.7l0.4-0.1 C18.4,34.6,18.3,34.7,18.2,34.7z'/%3E %3C/svg%3E\""

/***/ }),

/***/ 1987:
/***/ (function(module, exports) {

module.exports = "\"data:image/svg+xml,%3C?xml version='1.0' encoding='utf-8'?%3E %3C!-- Generator: Adobe Illustrator 21.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0) --%3E %3Csvg version='1.1' id='Ebene_1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' x='0px' y='0px' viewBox='0 0 42.5 42.5' style='enable-background:new 0 0 42.5 42.5;' xml:space='preserve' width='42.5' height='42.5'%3E %3Cpath d='M25.5,22.2v1.7c0,0.5,0,1-1.2,1.1c0.1-0.2,0.1-0.4,0.1-0.6v-0.5c0-1-0.8-1.8-1.8-1.8h-6.7v-5.7h3.9c1.6,0,2.9-1.3,2.9-2.9V8 c0-2.2-1.8-4-4-4h-9c-2.2,0-4,1.8-4,4v5.5c0,1.6,1.3,2.9,2.9,2.9h3.9v5.7H5.7c-1,0-1.8,0.8-1.8,1.8v0.5c0,0.2,0,0.4,0.1,0.6 c-1.2-0.1-1.2-0.6-1.2-0.8v-3.8H4c0.3,0,0.6-0.3,0.6-0.6v-1.7c0-0.3-0.3-0.6-0.6-0.6H0.6c-0.3,0-0.6,0.3-0.6,0.6v1.7 c0,0.3,0.3,0.6,0.6,0.6h1.1v3.8c0,0.7,0.4,1.9,2.8,1.9h1.1c0,0,0,0,0,0s0,0,0,0h6.7v7.4H4.5C4.2,33.5,4,33.7,4,34 c0,0.3,0.3,0.6,0.6,0.6h0.6v0.1c-0.2-0.1-0.4-0.1-0.6-0.1c-0.9,0-1.7,0.8-1.7,1.7c0,0.9,0.8,1.7,1.7,1.7c0.9,0,1.7-0.8,1.7-1.7 c0-0.1,0-0.3,0-0.4c0-0.1,0-0.1,0-0.2v-1.1h6.7c0,0,0.1,0,0.1,0v1.1c0,0.1,0,0.1,0,0.2c0,0.1,0,0.2,0,0.4c0,0.9,0.8,1.7,1.7,1.7 c0.9,0,1.7-0.8,1.7-1.7c0-0.9-0.6-1.6-1.5-1.7h0.4c0,0,0.1,0,0.1,0h6.1v1.1c0,0.1,0,0.1,0,0.2c0,0.1,0,0.2,0,0.4 c0,0.9,0.8,1.7,1.7,1.7c0.9,0,1.7-0.8,1.7-1.7s-0.8-1.7-1.7-1.7c-0.2,0-0.4,0-0.6,0.1v-0.1h0.6c0.3,0,0.6-0.3,0.6-0.6 c0-0.3-0.3-0.6-0.6-0.6h-7.3v-7.4h6.7c0,0,0,0,0,0c0,0,0,0,0,0h1.1c0.7,0,2.8,0,2.8-2.3v-1.7 M14.2,34.7L14.2,34.7l0.4-0.1 C14.4,34.6,14.3,34.7,14.2,34.7z M42.5,19.1c0,0.3-0.1,0.5-0.3,0.7L37,25c-0.2,0.2-0.4,0.3-0.7,0.3c-0.3,0-0.5-0.1-0.7-0.3L35,24.4 c-0.2-0.2-0.3-0.4-0.3-0.7s0.1-0.5,0.3-0.7l2.3-2.3H22.2c-0.3,0-0.5-0.1-0.7-0.3s-0.3-0.4-0.3-0.7v-1c0-0.3,0.1-0.5,0.3-0.7 s0.4-0.3,0.7-0.3h15.2L35,15.2c-0.2-0.2-0.3-0.4-0.3-0.7s0.1-0.5,0.3-0.7l0.6-0.6c0.2-0.2,0.4-0.3,0.7-0.3c0.3,0,0.5,0.1,0.7,0.3 l5.2,5.2C42.4,18.5,42.5,18.8,42.5,19.1z'/%3E %3C/svg%3E\""

/***/ }),

/***/ 1988:
/***/ (function(module, exports) {

module.exports = "\"data:image/svg+xml,%3C?xml version='1.0' encoding='utf-8'?%3E %3C!-- Generator: Adobe Illustrator 21.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0) --%3E %3Csvg version='1.1' id='Ebene_1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' x='0px' y='0px' viewBox='0 0 42.5 42.5' style='enable-background:new 0 0 42.5 42.5;' xml:space='preserve' width='42.5' height='42.5'%3E %3Cpath d='M21,26.1c0.2,0,0.5,0,0.5,0c0,0-0.3,0-0.3,0h5.3v7.4h-7.3c-0.3,0-0.6,0.3-0.6,0.6c0,0.3,0.3,0.6,0.6,0.6h0.6v0.1 c-0.2-0.1-0.4-0.1-0.6-0.1c-0.9,0-1.7,0.8-1.7,1.7s0.8,1.7,1.7,1.7c0.9,0,1.7-0.8,1.7-1.7c0-0.1,0-0.2,0-0.4c0-0.1,0-0.1,0-0.2v-1.1 H27c0,0,0.1,0,0.1,0h0.4c-0.9,0.1-1.5,0.8-1.5,1.7c0,0.9,0.8,1.7,1.7,1.7c0.9,0,1.7-0.8,1.7-1.7c0-0.1,0-0.2,0-0.4 c0-0.1,0-0.1,0-0.2v-1.1c0,0,0.1,0,0.1,0h6.7v1.1c0,0.1,0,0.1,0,0.2c0,0.1,0,0.3,0,0.4c0,0.9,0.8,1.7,1.7,1.7c0.9,0,1.7-0.8,1.7-1.7 c0-0.9-0.8-1.7-1.7-1.7c-0.2,0-0.4,0-0.6,0.1v-0.1h0.6c0.3,0,0.6-0.3,0.6-0.6c0-0.3-0.3-0.6-0.6-0.6h-7.9v-7.4h6.7c0,0,0,0,0,0 s0,0,0,0h1.1c2.5,0,2.8-1.2,2.8-1.9v-3.8h1.1c0.3,0,0.6-0.3,0.6-0.6v-1.7c0-0.3-0.3-0.6-0.6-0.6h-3.4c-0.3,0-0.6,0.3-0.6,0.6v1.7 c0,0.3,0.3,0.6,0.6,0.6h1.1v3.8c0,0.2,0,0.7-1.2,0.8c0.1-0.2,0.1-0.4,0.1-0.6v-0.5c0-1-0.8-1.8-1.8-1.8h-6.7v-5.7h3.9 c1.6,0,2.9-1.3,2.9-2.9V8c0-2.2-1.8-4-4-4h-9c-2.2,0-4,1.8-4,4v5.5c0,1.6,1.3,2.9,2.9,2.9h3.9v5.7h-5.3c-1,0-1.8,0.8-1.8,1.8v0.5 c0,0.2,0,0.4,0.1,0.6C19.8,25.8,20.6,26.1,21,26.1z M29.9,34.7L29.9,34.7l0.4-0.1C30.2,34.6,30,34.7,29.9,34.7z M19.8,19.1 c0,0.3-0.1,0.5-0.3,0.7L14.3,25c-0.2,0.2-0.4,0.3-0.7,0.3c-0.3,0-0.5-0.1-0.7-0.3l-0.6-0.6c-0.2-0.2-0.3-0.4-0.3-0.7 s0.1-0.5,0.3-0.7l2.3-2.3H1c-0.3,0-0.5-0.1-0.7-0.3s-0.3-0.4-0.3-0.7v-1c0-0.3,0.1-0.5,0.3-0.7s0.4-0.3,0.7-0.3h13.6l-2.3-2.3 C12.1,15,12,14.8,12,14.5s0.1-0.5,0.3-0.7l0.6-0.6c0.2-0.2,0.4-0.3,0.7-0.3c0.3,0,0.5,0.1,0.7,0.3l5.2,5.2 C19.7,18.5,19.8,18.8,19.8,19.1z'/%3E %3C/svg%3E\""

/***/ }),

/***/ 35:
/***/ (function(module, exports) {


/**
 * When source maps are enabled, `style-loader` uses a link element with a data-uri to
 * embed the css on the page. This breaks all relative urls because now they are relative to a
 * bundle instead of the current page.
 *
 * One solution is to only use full urls, but that may be impossible.
 *
 * Instead, this function "fixes" the relative urls to be absolute according to the current page location.
 *
 * A rudimentary test suite is located at `test/fixUrls.js` and can be run via the `npm test` command.
 *
 */

module.exports = function (css) {
  // get current location
  var location = typeof window !== "undefined" && window.location;

  if (!location) {
    throw new Error("fixUrls requires window.location");
  }

	// blank or null?
	if (!css || typeof css !== "string") {
	  return css;
  }

  var baseUrl = location.protocol + "//" + location.host;
  var currentDir = baseUrl + location.pathname.replace(/\/[^\/]*$/, "/");

	// convert each url(...)
	/*
	This regular expression is just a way to recursively match brackets within
	a string.

	 /url\s*\(  = Match on the word "url" with any whitespace after it and then a parens
	   (  = Start a capturing group
	     (?:  = Start a non-capturing group
	         [^)(]  = Match anything that isn't a parentheses
	         |  = OR
	         \(  = Match a start parentheses
	             (?:  = Start another non-capturing groups
	                 [^)(]+  = Match anything that isn't a parentheses
	                 |  = OR
	                 \(  = Match a start parentheses
	                     [^)(]*  = Match anything that isn't a parentheses
	                 \)  = Match a end parentheses
	             )  = End Group
              *\) = Match anything and then a close parens
          )  = Close non-capturing group
          *  = Match anything
       )  = Close capturing group
	 \)  = Match a close parens

	 /gi  = Get all matches, not the first.  Be case insensitive.
	 */
	var fixedCss = css.replace(/url\s*\(((?:[^)(]|\((?:[^)(]+|\([^)(]*\))*\))*)\)/gi, function(fullMatch, origUrl) {
		// strip quotes (if they exist)
		var unquotedOrigUrl = origUrl
			.trim()
			.replace(/^"(.*)"$/, function(o, $1){ return $1; })
			.replace(/^'(.*)'$/, function(o, $1){ return $1; });

		// already a full url? no change
		if (/^(#|data:|http:\/\/|https:\/\/|file:\/\/\/)/i.test(unquotedOrigUrl)) {
		  return fullMatch;
		}

		// convert the url to a full url
		var newUrl;

		if (unquotedOrigUrl.indexOf("//") === 0) {
		  	//TODO: should we add protocol?
			newUrl = unquotedOrigUrl;
		} else if (unquotedOrigUrl.indexOf("/") === 0) {
			// path should be relative to the base url
			newUrl = baseUrl + unquotedOrigUrl; // already starts with '/'
		} else {
			// path should be relative to current directory
			newUrl = currentDir + unquotedOrigUrl.replace(/^\.\//, ""); // Strip leading './'
		}

		// send back the fixed url(...)
		return "url(" + JSON.stringify(newUrl) + ")";
	});

	// send back the fixed css
	return fixedCss;
};


/***/ }),

/***/ 88:
/***/ (function(module, exports, __webpack_require__) {

/* pkg: Inventory FAT Client (js/Inventory-FAT.js)*/
__webpack_require__(1979);
__webpack_require__(1980);
/* pkg: Inventory FAT Client (css/Inventory-FAT.css)*/
__webpack_require__(1981);


/***/ }),

/***/ 98:
/***/ (function(module, exports) {

module.exports = function escape(url) {
    if (typeof url !== 'string') {
        return url
    }
    // If url is already wrapped in quotes, remove them
    if (/^['"].*['"]$/.test(url)) {
        url = url.slice(1, -1);
    }
    // Should url be wrapped?
    // See https://drafts.csswg.org/css-values-3/#urls
    if (/["'() \t\n]/.test(url)) {
        return '"' + url.replace(/"/g, '\\"').replace(/\n/g, '\\n') + '"'
    }

    return url
}


/***/ })

}]);