(window["webpackJsonp"] = window["webpackJsonp"] || []).push([[28],{

/***/ 182:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 *
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Cornelius Weiß <c.weiss@metaways.de>
 * @copyright   Copyright (c) 2020 Metaways Infosystems GmbH (http://www.metaways.de)
 */
Ext.ns('Tine.Tinebase.widgets.file.LocationTypePlugin');

Tine.Tinebase.widgets.file.LocationTypePlugin.Abstract = function (plugin) {
  Ext.apply(this, plugin);
};

Tine.Tinebase.widgets.file.LocationTypePlugin.Abstract.prototype = {
  /**
   * @cfg {String} locationType
   * locationType name
   */
  locationType: '',

  /**
   * @cfg {String} name
   * _translated_ name of this locationType (required)
   */
  name: '',

  /**
   * @cfg {String} iconCls
   * iconCls for place selection
   */
  iconCls: '',

  /**
   * @param area one of pluginPanel|targetForm|optionsForm
   * @return {Promise<void>}
   */
  getSelectionDialogArea: async function getSelectionDialogArea(area, cmp) {},

  /**
   * @return {Array}
   */
  getFileList: function getFileList() {},

  /**
   * manage state of apply button
   * use buttonApply.setDisabled({Boolean}) to manage state
   * @param {Ext.Action} buttonApply
   */
  manageButtonApply: function manageButtonApply(buttonApply) {},

  /**
   * called before dialog closes, return false to suppress selection
   * @return {Promise<void>}
   */
  validateSelection: async function validateSelection() {},

  /**
   * get string representation of given location
   *
   * @param {Object} location
   * @return {String} string representation of location
   */
  getLocationName: function getLocationName(location) {}
};

/***/ }),

/***/ 2606:
/***/ (function(module, exports, __webpack_require__) {

/*
 * Tine 2.0
 *
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Cornelius Weiß <c.weiss@metaways.de>
 * @copyright   Copyright (c) 2020 Metaways Infosystems GmbH (http://www.metaways.de)
 */
__webpack_require__(182);

__webpack_require__(499);

Ext.ns('Tine.Tinebase.widgets.file.LocationTypePlugin');

Tine.Tinebase.widgets.file.LocationTypePlugin.Upload = function (config) {
  Ext.apply(this, config);
  this.name = i18n._('My Device');
};

Ext.extend(Tine.Tinebase.widgets.file.LocationTypePlugin.Upload, Tine.Tinebase.widgets.file.LocationTypePlugin.Abstract, {
  locationType: 'upload',
  iconCls: 'action_upload',

  /**
   * @cfg {String} uploadMode select|upload
   */
  uploadMode: 'select',
  getSelectionDialogArea: async function getSelectionDialogArea(area, cmp) {
    if (!this.selectionDialogInitialised) {
      this.cmp = cmp;

      if (this.uploadMode === 'select') {
        this.pluginPanel = new Tine.widgets.form.FileSelectionArea(Ext.apply({
          text: i18n._('Select or drop file to upload')
        }, _.get(this, 'cmp.pluginConfig.' + this.plugin, {})));
        this.pluginPanel.on('fileSelected', this.onFilesSelected, this);
      } else {
        // use fileUploadGrid here, have nice uploadIcon in Background ;-)
        throw new Error('implement me');
      }

      this.selectionDialogInitialised = true;
    }

    return _.get(this, area);
  },
  getFileList: function getFileList() {
    if (this.uploadMode === 'select') {
      return this.pluginPanel.fileList;
    } else {
      // @todo return tempfiles
      throw new Error('implement me');
    }
  },
  onFilesSelected: function onFilesSelected(fileList, event) {
    if (this.uploadMode === 'select') {
      this.cmp.onButtonApply();
    }
  },
  manageButtonApply: function manageButtonApply(buttonApply) {
    if (this.uploadMode === 'select') {
      buttonApply.setDisabled(true);
    }
  }
});

/***/ })

}]);