(window["webpackJsonp"] = window["webpackJsonp"] || []).push([[24],{

/***/ 137:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXPORTS
__webpack_require__.d(__webpack_exports__, "default", function() { return /* binding */ addStylesClient; });

// CONCATENATED MODULE: ./node_modules/vue-style-loader/lib/listToStyles.js
/**
 * Translates the list format produced by css-loader into something
 * easier to manipulate.
 */
function listToStyles (parentId, list) {
  var styles = []
  var newStyles = {}
  for (var i = 0; i < list.length; i++) {
    var item = list[i]
    var id = item[0]
    var css = item[1]
    var media = item[2]
    var sourceMap = item[3]
    var part = {
      id: parentId + ':' + i,
      css: css,
      media: media,
      sourceMap: sourceMap
    }
    if (!newStyles[id]) {
      styles.push(newStyles[id] = { id: id, parts: [part] })
    } else {
      newStyles[id].parts.push(part)
    }
  }
  return styles
}

// CONCATENATED MODULE: ./node_modules/vue-style-loader/lib/addStylesClient.js
/*
  MIT License http://www.opensource.org/licenses/mit-license.php
  Author Tobias Koppers @sokra
  Modified by Evan You @yyx990803
*/



var hasDocument = typeof document !== 'undefined'

if (typeof DEBUG !== 'undefined' && DEBUG) {
  if (!hasDocument) {
    throw new Error(
    'vue-style-loader cannot be used in a non-browser environment. ' +
    "Use { target: 'node' } in your Webpack config to indicate a server-rendering environment."
  ) }
}

/*
type StyleObject = {
  id: number;
  parts: Array<StyleObjectPart>
}

type StyleObjectPart = {
  css: string;
  media: string;
  sourceMap: ?string
}
*/

var stylesInDom = {/*
  [id: number]: {
    id: number,
    refs: number,
    parts: Array<(obj?: StyleObjectPart) => void>
  }
*/}

var head = hasDocument && (document.head || document.getElementsByTagName('head')[0])
var singletonElement = null
var singletonCounter = 0
var isProduction = false
var noop = function () {}
var options = null
var ssrIdKey = 'data-vue-ssr-id'

// Force single-tag solution on IE6-9, which has a hard limit on the # of <style>
// tags it will allow on a page
var isOldIE = typeof navigator !== 'undefined' && /msie [6-9]\b/.test(navigator.userAgent.toLowerCase())

function addStylesClient (parentId, list, _isProduction, _options) {
  isProduction = _isProduction

  options = _options || {}

  var styles = listToStyles(parentId, list)
  addStylesToDom(styles)

  return function update (newList) {
    var mayRemove = []
    for (var i = 0; i < styles.length; i++) {
      var item = styles[i]
      var domStyle = stylesInDom[item.id]
      domStyle.refs--
      mayRemove.push(domStyle)
    }
    if (newList) {
      styles = listToStyles(parentId, newList)
      addStylesToDom(styles)
    } else {
      styles = []
    }
    for (var i = 0; i < mayRemove.length; i++) {
      var domStyle = mayRemove[i]
      if (domStyle.refs === 0) {
        for (var j = 0; j < domStyle.parts.length; j++) {
          domStyle.parts[j]()
        }
        delete stylesInDom[domStyle.id]
      }
    }
  }
}

function addStylesToDom (styles /* Array<StyleObject> */) {
  for (var i = 0; i < styles.length; i++) {
    var item = styles[i]
    var domStyle = stylesInDom[item.id]
    if (domStyle) {
      domStyle.refs++
      for (var j = 0; j < domStyle.parts.length; j++) {
        domStyle.parts[j](item.parts[j])
      }
      for (; j < item.parts.length; j++) {
        domStyle.parts.push(addStyle(item.parts[j]))
      }
      if (domStyle.parts.length > item.parts.length) {
        domStyle.parts.length = item.parts.length
      }
    } else {
      var parts = []
      for (var j = 0; j < item.parts.length; j++) {
        parts.push(addStyle(item.parts[j]))
      }
      stylesInDom[item.id] = { id: item.id, refs: 1, parts: parts }
    }
  }
}

function createStyleElement () {
  var styleElement = document.createElement('style')
  styleElement.type = 'text/css'
  head.appendChild(styleElement)
  return styleElement
}

function addStyle (obj /* StyleObjectPart */) {
  var update, remove
  var styleElement = document.querySelector('style[' + ssrIdKey + '~="' + obj.id + '"]')

  if (styleElement) {
    if (isProduction) {
      // has SSR styles and in production mode.
      // simply do nothing.
      return noop
    } else {
      // has SSR styles but in dev mode.
      // for some reason Chrome can't handle source map in server-rendered
      // style tags - source maps in <style> only works if the style tag is
      // created and inserted dynamically. So we remove the server rendered
      // styles and inject new ones.
      styleElement.parentNode.removeChild(styleElement)
    }
  }

  if (isOldIE) {
    // use singleton mode for IE9.
    var styleIndex = singletonCounter++
    styleElement = singletonElement || (singletonElement = createStyleElement())
    update = applyToSingletonTag.bind(null, styleElement, styleIndex, false)
    remove = applyToSingletonTag.bind(null, styleElement, styleIndex, true)
  } else {
    // use multi-style-tag mode in all other cases
    styleElement = createStyleElement()
    update = applyToTag.bind(null, styleElement)
    remove = function () {
      styleElement.parentNode.removeChild(styleElement)
    }
  }

  update(obj)

  return function updateStyle (newObj /* StyleObjectPart */) {
    if (newObj) {
      if (newObj.css === obj.css &&
          newObj.media === obj.media &&
          newObj.sourceMap === obj.sourceMap) {
        return
      }
      update(obj = newObj)
    } else {
      remove()
    }
  }
}

var replaceText = (function () {
  var textStore = []

  return function (index, replacement) {
    textStore[index] = replacement
    return textStore.filter(Boolean).join('\n')
  }
})()

function applyToSingletonTag (styleElement, index, remove, obj) {
  var css = remove ? '' : obj.css

  if (styleElement.styleSheet) {
    styleElement.styleSheet.cssText = replaceText(index, css)
  } else {
    var cssNode = document.createTextNode(css)
    var childNodes = styleElement.childNodes
    if (childNodes[index]) styleElement.removeChild(childNodes[index])
    if (childNodes.length) {
      styleElement.insertBefore(cssNode, childNodes[index])
    } else {
      styleElement.appendChild(cssNode)
    }
  }
}

function applyToTag (styleElement, obj) {
  var css = obj.css
  var media = obj.media
  var sourceMap = obj.sourceMap

  if (media) {
    styleElement.setAttribute('media', media)
  }
  if (options.ssrId) {
    styleElement.setAttribute(ssrIdKey, obj.id)
  }

  if (sourceMap) {
    // https://developer.chrome.com/devtools/docs/javascript-debugging
    // this makes source maps inside style tags work properly in Chrome
    css += '\n/*# sourceURL=' + sourceMap.sources[0] + ' */'
    // http://stackoverflow.com/a/26603875
    css += '\n/*# sourceMappingURL=data:application/json;base64,' + btoa(unescape(encodeURIComponent(JSON.stringify(sourceMap)))) + ' */'
  }

  if (styleElement.styleSheet) {
    styleElement.styleSheet.cssText = css
  } else {
    while (styleElement.firstChild) {
      styleElement.removeChild(styleElement.firstChild)
    }
    styleElement.appendChild(document.createTextNode(css))
  }
}


/***/ }),

/***/ 2160:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var _vue_style_loader_index_js_css_loader_index_js_vue_loader_lib_loaders_stylePostLoader_js_sass_loader_dist_cjs_js_vue_loader_lib_index_js_vue_loader_options_Saturation_vue_vue_type_style_index_0_lang_scss___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(311);
/* harmony import */ var _vue_style_loader_index_js_css_loader_index_js_vue_loader_lib_loaders_stylePostLoader_js_sass_loader_dist_cjs_js_vue_loader_lib_index_js_vue_loader_options_Saturation_vue_vue_type_style_index_0_lang_scss___WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_vue_style_loader_index_js_css_loader_index_js_vue_loader_lib_loaders_stylePostLoader_js_sass_loader_dist_cjs_js_vue_loader_lib_index_js_vue_loader_options_Saturation_vue_vue_type_style_index_0_lang_scss___WEBPACK_IMPORTED_MODULE_0__);
/* unused harmony reexport * */
 /* unused harmony default export */ var _unused_webpack_default_export = (_vue_style_loader_index_js_css_loader_index_js_vue_loader_lib_loaders_stylePostLoader_js_sass_loader_dist_cjs_js_vue_loader_lib_index_js_vue_loader_options_Saturation_vue_vue_type_style_index_0_lang_scss___WEBPACK_IMPORTED_MODULE_0___default.a); 

/***/ }),

/***/ 2161:
/***/ (function(module, exports, __webpack_require__) {

exports = module.exports = __webpack_require__(16)(false);
// imports


// module
exports.push([module.i, ".saturation{position:relative;cursor:pointer}.saturation .slide{position:absolute;left:100px;top:0;width:10px;height:10px;border-radius:50%;border:1px solid #fff;box-shadow:0 0 1px 1px rgba(0,0,0,.3);pointer-events:none}", ""]);

// exports


/***/ }),

/***/ 2162:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var _vue_style_loader_index_js_css_loader_index_js_vue_loader_lib_loaders_stylePostLoader_js_sass_loader_dist_cjs_js_vue_loader_lib_index_js_vue_loader_options_Hue_vue_vue_type_style_index_0_lang_scss___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(312);
/* harmony import */ var _vue_style_loader_index_js_css_loader_index_js_vue_loader_lib_loaders_stylePostLoader_js_sass_loader_dist_cjs_js_vue_loader_lib_index_js_vue_loader_options_Hue_vue_vue_type_style_index_0_lang_scss___WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_vue_style_loader_index_js_css_loader_index_js_vue_loader_lib_loaders_stylePostLoader_js_sass_loader_dist_cjs_js_vue_loader_lib_index_js_vue_loader_options_Hue_vue_vue_type_style_index_0_lang_scss___WEBPACK_IMPORTED_MODULE_0__);
/* unused harmony reexport * */
 /* unused harmony default export */ var _unused_webpack_default_export = (_vue_style_loader_index_js_css_loader_index_js_vue_loader_lib_loaders_stylePostLoader_js_sass_loader_dist_cjs_js_vue_loader_lib_index_js_vue_loader_options_Hue_vue_vue_type_style_index_0_lang_scss___WEBPACK_IMPORTED_MODULE_0___default.a); 

/***/ }),

/***/ 2163:
/***/ (function(module, exports, __webpack_require__) {

exports = module.exports = __webpack_require__(16)(false);
// imports


// module
exports.push([module.i, ".hue{position:relative;margin-left:8px;cursor:pointer}.hue .slide{position:absolute;left:0;top:100px;width:100%;height:4px;background:#fff;box-shadow:0 0 1px 0 rgba(0,0,0,.3);pointer-events:none}", ""]);

// exports


/***/ }),

/***/ 2164:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var _vue_style_loader_index_js_css_loader_index_js_vue_loader_lib_loaders_stylePostLoader_js_sass_loader_dist_cjs_js_vue_loader_lib_index_js_vue_loader_options_Alpha_vue_vue_type_style_index_0_lang_scss___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(313);
/* harmony import */ var _vue_style_loader_index_js_css_loader_index_js_vue_loader_lib_loaders_stylePostLoader_js_sass_loader_dist_cjs_js_vue_loader_lib_index_js_vue_loader_options_Alpha_vue_vue_type_style_index_0_lang_scss___WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_vue_style_loader_index_js_css_loader_index_js_vue_loader_lib_loaders_stylePostLoader_js_sass_loader_dist_cjs_js_vue_loader_lib_index_js_vue_loader_options_Alpha_vue_vue_type_style_index_0_lang_scss___WEBPACK_IMPORTED_MODULE_0__);
/* unused harmony reexport * */
 /* unused harmony default export */ var _unused_webpack_default_export = (_vue_style_loader_index_js_css_loader_index_js_vue_loader_lib_loaders_stylePostLoader_js_sass_loader_dist_cjs_js_vue_loader_lib_index_js_vue_loader_options_Alpha_vue_vue_type_style_index_0_lang_scss___WEBPACK_IMPORTED_MODULE_0___default.a); 

/***/ }),

/***/ 2165:
/***/ (function(module, exports, __webpack_require__) {

exports = module.exports = __webpack_require__(16)(false);
// imports


// module
exports.push([module.i, ".color-alpha{position:relative;margin-left:8px;cursor:pointer}.color-alpha .slide{position:absolute;left:0;top:100px;width:100%;height:4px;background:#fff;box-shadow:0 0 1px 0 rgba(0,0,0,.3);pointer-events:none}", ""]);

// exports


/***/ }),

/***/ 2166:
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAAXNSR0IArs4c6QAAAlBJREFUOBGNkk2IUlEUx+99vufXQvCjEA11YWgk7TTLZhwVLTfSRmY1QbOoTdMqad0iiGB20cpVUAt3SVHCJDJG40IXBVGLIIOB8hM/QPy+/a/xYqK38MJ99757zu9/zj3nUrLmiEajdkEQni6Xy6hKpfqB/eNCofCMrsOHQiEPgPfwtdhsNkYpJe12m0LolkpJIJFI7DkcDm+9Xv/o9/vPw+dwsVhYnE4nc7lc1G63016vx8bj8TlRSWA6nd6cz+cXAoHAGYD3sDdarVam1+vpaDRaITgjjLHTigKArkK9ifXhbDYjBoOBSZL0F261Wqzb7VKtVvtBUQCwi4N88kjD4ZAg+ioyT53DGo3mJwLs/VcD3PkyrnAwmUwks9n8YDAYuPBvxGQASL/fp8imiwJeKZVK3/4R4DAicliLIt4pFosvsH9Vq9Wu4b5GCHC4j+hb5XL5C09JWOWFTzAY3MJyAAHJ7XbfRo9fclsmk2maTKY8IhJRFAna+QTwJ27jYyUQDofj6O1bPBLJ6/Xu5vP5N3/MhMC2gxrcReTvEGio1er7eFRR2S7EYrE40nsNWPB4PLu5XO6dbIxEIjuo+COkfAyfTZ1OF4dIHyJnZR8RkZ/zH5/PdyObzR7KhmQyud3pdFYw2rVRqVSOYePTIvvwVYDyKThUT8KpVGq70WjsI/Iv+HC4zp2VhoiiEP625ZFOp683m819iLZxtlGtVuuyTWmlePcM9x9A6DNWikd0EYJtdGPz6OjoqxJ08ox3oQzYgKtcwgwi7Q5athbMhX4DL0sglf8ys78AAAAASUVORK5CYII="

/***/ }),

/***/ 2167:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var _vue_style_loader_index_js_css_loader_index_js_vue_loader_lib_loaders_stylePostLoader_js_sass_loader_dist_cjs_js_vue_loader_lib_index_js_vue_loader_options_Sucker_vue_vue_type_style_index_0_lang_scss___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(314);
/* harmony import */ var _vue_style_loader_index_js_css_loader_index_js_vue_loader_lib_loaders_stylePostLoader_js_sass_loader_dist_cjs_js_vue_loader_lib_index_js_vue_loader_options_Sucker_vue_vue_type_style_index_0_lang_scss___WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_vue_style_loader_index_js_css_loader_index_js_vue_loader_lib_loaders_stylePostLoader_js_sass_loader_dist_cjs_js_vue_loader_lib_index_js_vue_loader_options_Sucker_vue_vue_type_style_index_0_lang_scss___WEBPACK_IMPORTED_MODULE_0__);
/* unused harmony reexport * */
 /* unused harmony default export */ var _unused_webpack_default_export = (_vue_style_loader_index_js_css_loader_index_js_vue_loader_lib_loaders_stylePostLoader_js_sass_loader_dist_cjs_js_vue_loader_lib_index_js_vue_loader_options_Sucker_vue_vue_type_style_index_0_lang_scss___WEBPACK_IMPORTED_MODULE_0___default.a); 

/***/ }),

/***/ 2168:
/***/ (function(module, exports, __webpack_require__) {

exports = module.exports = __webpack_require__(16)(false);
// imports


// module
exports.push([module.i, ".sucker{width:30px;fill:#9099a4;background:#2e333a;cursor:pointer;transition:all .3s}.sucker:hover,.sucker.active{fill:#1593ff}", ""]);

// exports


/***/ }),

/***/ 2169:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var _vue_style_loader_index_js_css_loader_index_js_vue_loader_lib_loaders_stylePostLoader_js_sass_loader_dist_cjs_js_vue_loader_lib_index_js_vue_loader_options_Box_vue_vue_type_style_index_0_lang_scss___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(315);
/* harmony import */ var _vue_style_loader_index_js_css_loader_index_js_vue_loader_lib_loaders_stylePostLoader_js_sass_loader_dist_cjs_js_vue_loader_lib_index_js_vue_loader_options_Box_vue_vue_type_style_index_0_lang_scss___WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_vue_style_loader_index_js_css_loader_index_js_vue_loader_lib_loaders_stylePostLoader_js_sass_loader_dist_cjs_js_vue_loader_lib_index_js_vue_loader_options_Box_vue_vue_type_style_index_0_lang_scss___WEBPACK_IMPORTED_MODULE_0__);
/* unused harmony reexport * */
 /* unused harmony default export */ var _unused_webpack_default_export = (_vue_style_loader_index_js_css_loader_index_js_vue_loader_lib_loaders_stylePostLoader_js_sass_loader_dist_cjs_js_vue_loader_lib_index_js_vue_loader_options_Box_vue_vue_type_style_index_0_lang_scss___WEBPACK_IMPORTED_MODULE_0___default.a); 

/***/ }),

/***/ 2170:
/***/ (function(module, exports, __webpack_require__) {

exports = module.exports = __webpack_require__(16)(false);
// imports


// module
exports.push([module.i, ".color-type{display:flex;margin-top:8px;font-size:12px}.color-type .name{width:60px;height:30px;float:left;display:flex;justify-content:center;align-items:center;color:#999;background:#252930}.color-type .value{flex:1;height:30px;min-width:100px;padding:0 12px;border:0;color:#fff;background:#2e333a;box-sizing:border-box}", ""]);

// exports


/***/ }),

/***/ 2171:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var _vue_style_loader_index_js_css_loader_index_js_vue_loader_lib_loaders_stylePostLoader_js_sass_loader_dist_cjs_js_vue_loader_lib_index_js_vue_loader_options_Colors_vue_vue_type_style_index_0_lang_scss___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(316);
/* harmony import */ var _vue_style_loader_index_js_css_loader_index_js_vue_loader_lib_loaders_stylePostLoader_js_sass_loader_dist_cjs_js_vue_loader_lib_index_js_vue_loader_options_Colors_vue_vue_type_style_index_0_lang_scss___WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_vue_style_loader_index_js_css_loader_index_js_vue_loader_lib_loaders_stylePostLoader_js_sass_loader_dist_cjs_js_vue_loader_lib_index_js_vue_loader_options_Colors_vue_vue_type_style_index_0_lang_scss___WEBPACK_IMPORTED_MODULE_0__);
/* unused harmony reexport * */
 /* unused harmony default export */ var _unused_webpack_default_export = (_vue_style_loader_index_js_css_loader_index_js_vue_loader_lib_loaders_stylePostLoader_js_sass_loader_dist_cjs_js_vue_loader_lib_index_js_vue_loader_options_Colors_vue_vue_type_style_index_0_lang_scss___WEBPACK_IMPORTED_MODULE_0___default.a); 

/***/ }),

/***/ 2172:
/***/ (function(module, exports, __webpack_require__) {

exports = module.exports = __webpack_require__(16)(false);
// imports


// module
exports.push([module.i, ".colors{padding:0;margin:0}.colors.history{margin-top:10px;border-top:1px solid #2e333a}.colors .item{position:relative;width:16px;height:16px;margin:10px 0 0 10px;border-radius:3px;box-sizing:border-box;vertical-align:top;display:inline-block;transition:all .1s;cursor:pointer}.colors .item:nth-child(8n+1){margin-left:0}.colors .item:hover{transform:scale(1.4)}.colors .item .alpha{height:100%;border-radius:4px}.colors .item .color{position:absolute;left:0;top:0;width:100%;height:100%;border-radius:3px}", ""]);

// exports


/***/ }),

/***/ 2173:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var _vue_style_loader_index_js_css_loader_index_js_vue_loader_lib_loaders_stylePostLoader_js_sass_loader_dist_cjs_js_vue_loader_lib_index_js_vue_loader_options_Index_vue_vue_type_style_index_0_lang_scss___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(317);
/* harmony import */ var _vue_style_loader_index_js_css_loader_index_js_vue_loader_lib_loaders_stylePostLoader_js_sass_loader_dist_cjs_js_vue_loader_lib_index_js_vue_loader_options_Index_vue_vue_type_style_index_0_lang_scss___WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_vue_style_loader_index_js_css_loader_index_js_vue_loader_lib_loaders_stylePostLoader_js_sass_loader_dist_cjs_js_vue_loader_lib_index_js_vue_loader_options_Index_vue_vue_type_style_index_0_lang_scss___WEBPACK_IMPORTED_MODULE_0__);
/* unused harmony reexport * */
 /* unused harmony default export */ var _unused_webpack_default_export = (_vue_style_loader_index_js_css_loader_index_js_vue_loader_lib_loaders_stylePostLoader_js_sass_loader_dist_cjs_js_vue_loader_lib_index_js_vue_loader_options_Index_vue_vue_type_style_index_0_lang_scss___WEBPACK_IMPORTED_MODULE_0___default.a); 

/***/ }),

/***/ 2174:
/***/ (function(module, exports, __webpack_require__) {

exports = module.exports = __webpack_require__(16)(false);
// imports


// module
exports.push([module.i, ".hu-color-picker{padding:10px;background:#1d2024;border-radius:4px;box-shadow:0 0 16px 0 rgba(0,0,0,.16);z-index:1}.hu-color-picker.light{background:#f7f8f9}.hu-color-picker.light .color-show .sucker{background:#eceef0}.hu-color-picker.light .color-type .name{background:#e7e8e9}.hu-color-picker.light .color-type .value{color:#666;background:#eceef0}.hu-color-picker.light .colors.history{border-top:1px solid #eee}.hu-color-picker canvas{vertical-align:top}.hu-color-picker .color-set{display:flex}.hu-color-picker .color-show{margin-top:8px;display:flex}", ""]);

// exports


/***/ }),

/***/ 2175:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var _node_modules_style_loader_index_js_node_modules_css_loader_index_js_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_vue_loader_lib_index_js_vue_loader_options_ColorPickerApp_vue_vue_type_style_index_0_lang_css___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(318);
/* harmony import */ var _node_modules_style_loader_index_js_node_modules_css_loader_index_js_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_vue_loader_lib_index_js_vue_loader_options_ColorPickerApp_vue_vue_type_style_index_0_lang_css___WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_index_js_node_modules_css_loader_index_js_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_vue_loader_lib_index_js_vue_loader_options_ColorPickerApp_vue_vue_type_style_index_0_lang_css___WEBPACK_IMPORTED_MODULE_0__);
/* unused harmony reexport * */
 /* unused harmony default export */ var _unused_webpack_default_export = (_node_modules_style_loader_index_js_node_modules_css_loader_index_js_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_vue_loader_lib_index_js_vue_loader_options_ColorPickerApp_vue_vue_type_style_index_0_lang_css___WEBPACK_IMPORTED_MODULE_0___default.a); 

/***/ }),

/***/ 2176:
/***/ (function(module, exports, __webpack_require__) {

exports = module.exports = __webpack_require__(16)(false);
// imports


// module
exports.push([module.i, "\ndiv.color-alpha {\n  display: none;\n}\nul.colors {\n  display: none;\n}\n", ""]);

// exports


/***/ }),

/***/ 2632:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// CONCATENATED MODULE: ./node_modules/vue-loader/lib/loaders/templateLoader.js??vue-loader-options!./node_modules/vue-loader/lib??vue-loader-options!./ux/form/ColorPickerApp.vue?vue&type=template&id=5ac4797d&
var render = function() {
  var _vm = this
  var _h = _vm.$createElement
  var _c = _vm._self._c || _h
  return _c(
    "div",
    [
      _c("color-picker", {
        attrs: { theme: "light", color: _vm.color, "colors-default": [] },
        on: { changeColor: _vm.changeColor }
      })
    ],
    1
  )
}
var staticRenderFns = []
render._withStripped = true


// CONCATENATED MODULE: ./ux/form/ColorPickerApp.vue?vue&type=template&id=5ac4797d&

// CONCATENATED MODULE: ./node_modules/vue-loader/lib/loaders/templateLoader.js??vue-loader-options!./node_modules/vue-loader/lib??vue-loader-options!./node_modules/@caohenghu/vue-colorpicker/src/color/Index.vue?vue&type=template&id=6143a4c2&
var Indexvue_type_template_id_6143a4c2_render = function() {
  var _vm = this
  var _h = _vm.$createElement
  var _c = _vm._self._c || _h
  return _c(
    "div",
    {
      staticClass: "hu-color-picker",
      class: { light: _vm.isLightTheme },
      style: { width: _vm.totalWidth + "px" }
    },
    [
      _c(
        "div",
        { staticClass: "color-set" },
        [
          _c("Saturation", {
            ref: "saturation",
            attrs: { color: _vm.rgbString, hsv: _vm.hsv, size: _vm.hueHeight },
            on: { selectSaturation: _vm.selectSaturation }
          }),
          _vm._v(" "),
          _c("Hue", {
            ref: "hue",
            attrs: { hsv: _vm.hsv, width: _vm.hueWidth, height: _vm.hueHeight },
            on: { selectHue: _vm.selectHue }
          }),
          _vm._v(" "),
          _c("Alpha", {
            ref: "alpha",
            attrs: {
              color: _vm.rgbString,
              rgba: _vm.rgba,
              width: _vm.hueWidth,
              height: _vm.hueHeight
            },
            on: { selectAlpha: _vm.selectAlpha }
          })
        ],
        1
      ),
      _vm._v(" "),
      _c(
        "div",
        {
          staticClass: "color-show",
          style: { height: _vm.previewHeight + "px" }
        },
        [
          _c("Preview", {
            attrs: {
              color: _vm.rgbaString,
              width: _vm.previewWidth,
              height: _vm.previewHeight
            }
          }),
          _vm._v(" "),
          !_vm.suckerHide
            ? _c("Sucker", {
                attrs: {
                  "sucker-canvas": _vm.suckerCanvas,
                  "sucker-area": _vm.suckerArea
                },
                on: {
                  openSucker: _vm.openSucker,
                  selectSucker: _vm.selectSucker
                }
              })
            : _vm._e()
        ],
        1
      ),
      _vm._v(" "),
      _c("Box", {
        attrs: { name: "HEX", color: _vm.modelHex },
        on: { inputColor: _vm.inputHex }
      }),
      _vm._v(" "),
      _c("Box", {
        attrs: { name: "RGBA", color: _vm.modelRgba },
        on: { inputColor: _vm.inputRgba }
      }),
      _vm._v(" "),
      _c("Colors", {
        attrs: {
          color: _vm.rgbaString,
          "colors-default": _vm.colorsDefault,
          "colors-history-key": _vm.colorsHistoryKey
        },
        on: { selectColor: _vm.selectColor }
      })
    ],
    1
  )
}
var Indexvue_type_template_id_6143a4c2_staticRenderFns = []
Indexvue_type_template_id_6143a4c2_render._withStripped = true


// CONCATENATED MODULE: ./node_modules/@caohenghu/vue-colorpicker/src/color/Index.vue?vue&type=template&id=6143a4c2&

// CONCATENATED MODULE: ./node_modules/@caohenghu/vue-colorpicker/src/color/mixin.js
/* harmony default export */ var mixin = ({
    methods: {
        setColorValue(color) {
            let rgba = { r: 0, g: 0, b: 0, a: 1 }
            if (/#/.test(color)) {
                rgba = this.hex2rgb(color)
            } else if (/rgb/.test(color)) {
                rgba = this.rgb2rgba(color)
            } else if (typeof color === 'string') {
                rgba = this.rgb2rgba(`rgba(${color})`)
            } else if (Object.prototype.toString.call(color) === '[object Object]') {
                rgba = color
            }
            const { r, g, b, a } = rgba
            const { h, s, v } = this.rgb2hsv(rgba)
            return { r, g, b, a: a === undefined ? 1 : a, h, s, v }
        },
        createAlphaSquare(size) {
            const canvas = document.createElement('canvas')
            const ctx = canvas.getContext('2d')
            const doubleSize = size * 2
            canvas.width = doubleSize
            canvas.height = doubleSize

            ctx.fillStyle = '#ffffff'
            ctx.fillRect(0, 0, doubleSize, doubleSize)
            ctx.fillStyle = '#ccd5db'
            ctx.fillRect(0, 0, size, size)
            ctx.fillRect(size, size, size, size)

            return canvas
        },
        createLinearGradient(direction, ctx, width, height, color1, color2) {
            // l 横向 p 纵向
            const isL = direction === 'l'
            const gradient = ctx.createLinearGradient(0, 0, isL ? width : 0, isL ? 0 : height)
            gradient.addColorStop(0.01, color1)
            gradient.addColorStop(0.99, color2)
            ctx.fillStyle = gradient
            ctx.fillRect(0, 0, width, height)
        },
        rgb2hex({ r, g, b }, toUpper) {
            const change = val => ('0' + Number(val).toString(16)).slice(-2)
            const color = `#${change(r)}${change(g)}${change(b)}`
            return toUpper ? color.toUpperCase() : color
        },
        hex2rgb(hex) {
            hex = hex.slice(1)
            const change = val => parseInt(val, 16) || 0 // 避免NaN的情况
            return {
                r: change(hex.slice(0, 2)),
                g: change(hex.slice(2, 4)),
                b: change(hex.slice(4, 6))
            }
        },
        rgb2rgba(rgba) {
            if (typeof rgba === 'string') {
                rgba = (/rgba?\((.*?)\)/.exec(rgba) || ['', '0,0,0,1'])[1].split(',')
                return {
                    r: Number(rgba[0]) || 0,
                    g: Number(rgba[1]) || 0,
                    b: Number(rgba[2]) || 0,
                    a: Number(rgba[3] ? rgba[3] : 1) // 避免为0的情况
                }
            } else {
                return rgba
            }
        },
        rgb2hsv({ r, g, b }) {
            r = r / 255
            g = g / 255
            b = b / 255
            const max = Math.max(r, g, b)
            const min = Math.min(r, g, b)
            const delta = max - min
            let h = 0
            if (max === min) {
                h = 0
            } else if (max === r) {
                if (g >= b) {
                    h = (60 * (g - b)) / delta
                } else {
                    h = (60 * (g - b)) / delta + 360
                }
            } else if (max === g) {
                h = (60 * (b - r)) / delta + 120
            } else if (max === b) {
                h = (60 * (r - g)) / delta + 240
            }
            h = Math.floor(h)
            let s = parseFloat((max === 0 ? 0 : 1 - min / max).toFixed(2))
            let v = parseFloat(max.toFixed(2))
            return { h, s, v }
        }
    }
});

// CONCATENATED MODULE: ./node_modules/vue-loader/lib/loaders/templateLoader.js??vue-loader-options!./node_modules/vue-loader/lib??vue-loader-options!./node_modules/@caohenghu/vue-colorpicker/src/color/Saturation.vue?vue&type=template&id=3268aa12&
var Saturationvue_type_template_id_3268aa12_render = function() {
  var _vm = this
  var _h = _vm.$createElement
  var _c = _vm._self._c || _h
  return _c(
    "div",
    {
      staticClass: "saturation",
      on: {
        mousedown: function($event) {
          $event.preventDefault()
          $event.stopPropagation()
          return _vm.selectSaturation($event)
        }
      }
    },
    [
      _c("canvas", { ref: "canvasSaturation" }),
      _vm._v(" "),
      _c("div", { staticClass: "slide", style: _vm.slideSaturationStyle })
    ]
  )
}
var Saturationvue_type_template_id_3268aa12_staticRenderFns = []
Saturationvue_type_template_id_3268aa12_render._withStripped = true


// CONCATENATED MODULE: ./node_modules/@caohenghu/vue-colorpicker/src/color/Saturation.vue?vue&type=template&id=3268aa12&

// CONCATENATED MODULE: ./node_modules/vue-loader/lib??vue-loader-options!./node_modules/@caohenghu/vue-colorpicker/src/color/Saturation.vue?vue&type=script&lang=js&
//
//
//
//
//
//
//
//
//
//
//
//
//


/* harmony default export */ var Saturationvue_type_script_lang_js_ = ({
    mixins: [mixin],
    props: {
        color: {
            type: String,
            default: '#000000'
        },
        hsv: {
            type: Object,
            default: null
        },
        size: {
            type: Number,
            default: 152
        }
    },
    data() {
        return {
            slideSaturationStyle: {}
        }
    },
    // 不能监听，否则自己改变自己时，颜色也会发生变化
    // watch: {
    //     color() {
    //         this.renderColor()
    //     }
    // },
    mounted() {
        this.renderColor()
        this.renderSlide()
    },
    methods: {
        renderColor() {
            const canvas = this.$refs.canvasSaturation
            const size = this.size
            const ctx = canvas.getContext('2d')
            canvas.width = size
            canvas.height = size

            ctx.fillStyle = this.color
            ctx.fillRect(0, 0, size, size)

            this.createLinearGradient('l', ctx, size, size, '#FFFFFF', 'rgba(255,255,255,0)')
            this.createLinearGradient('p', ctx, size, size, 'rgba(0,0,0,0)', '#000000')
        },
        renderSlide() {
            this.slideSaturationStyle = {
                left: this.hsv.s * this.size - 5 + 'px',
                top: (1 - this.hsv.v) * this.size - 5 + 'px'
            }
        },
        selectSaturation(e) {
            const { top: saturationTop, left: saturationLeft } = this.$el.getBoundingClientRect()
            const ctx = e.target.getContext('2d')

            const mousemove = e => {
                let x = e.clientX - saturationLeft
                let y = e.clientY - saturationTop

                if (x < 0) {
                    x = 0
                }
                if (y < 0) {
                    y = 0
                }
                if (x > this.size) {
                    x = this.size
                }
                if (y > this.size) {
                    y = this.size
                }

                // 不通过监听数据变化来修改dom，否则当颜色为#ffffff时，slide会跑到左下角
                this.slideSaturationStyle = {
                    left: x - 5 + 'px',
                    top: y - 5 + 'px'
                }
                // 如果用最大值，选择的像素会是空的，空的默认是黑色
                const imgData = ctx.getImageData(Math.min(x, this.size - 1), Math.min(y, this.size - 1), 1, 1)
                const [r, g, b] = imgData.data
                this.$emit('selectSaturation', { r, g, b })
            }

            mousemove(e)

            const mouseup = () => {
                document.removeEventListener('mousemove', mousemove)
                document.removeEventListener('mouseup', mouseup)
            }

            document.addEventListener('mousemove', mousemove)
            document.addEventListener('mouseup', mouseup)
        }
    }
});

// CONCATENATED MODULE: ./node_modules/@caohenghu/vue-colorpicker/src/color/Saturation.vue?vue&type=script&lang=js&
 /* harmony default export */ var color_Saturationvue_type_script_lang_js_ = (Saturationvue_type_script_lang_js_); 
// EXTERNAL MODULE: ./node_modules/@caohenghu/vue-colorpicker/src/color/Saturation.vue?vue&type=style&index=0&lang=scss&
var Saturationvue_type_style_index_0_lang_scss_ = __webpack_require__(2160);

// EXTERNAL MODULE: ./node_modules/vue-loader/lib/runtime/componentNormalizer.js
var componentNormalizer = __webpack_require__(28);

// CONCATENATED MODULE: ./node_modules/@caohenghu/vue-colorpicker/src/color/Saturation.vue






/* normalize component */

var component = Object(componentNormalizer["a" /* default */])(
  color_Saturationvue_type_script_lang_js_,
  Saturationvue_type_template_id_3268aa12_render,
  Saturationvue_type_template_id_3268aa12_staticRenderFns,
  false,
  null,
  null,
  null
  
)

/* hot reload */
if (false) { var api; }
component.options.__file = "node_modules/@caohenghu/vue-colorpicker/src/color/Saturation.vue"
/* harmony default export */ var Saturation = (component.exports);
// CONCATENATED MODULE: ./node_modules/vue-loader/lib/loaders/templateLoader.js??vue-loader-options!./node_modules/vue-loader/lib??vue-loader-options!./node_modules/@caohenghu/vue-colorpicker/src/color/Hue.vue?vue&type=template&id=af8f7830&
var Huevue_type_template_id_af8f7830_render = function() {
  var _vm = this
  var _h = _vm.$createElement
  var _c = _vm._self._c || _h
  return _c(
    "div",
    {
      staticClass: "hue",
      on: {
        mousedown: function($event) {
          $event.preventDefault()
          $event.stopPropagation()
          return _vm.selectHue($event)
        }
      }
    },
    [
      _c("canvas", { ref: "canvasHue" }),
      _vm._v(" "),
      _c("div", { staticClass: "slide", style: _vm.slideHueStyle })
    ]
  )
}
var Huevue_type_template_id_af8f7830_staticRenderFns = []
Huevue_type_template_id_af8f7830_render._withStripped = true


// CONCATENATED MODULE: ./node_modules/@caohenghu/vue-colorpicker/src/color/Hue.vue?vue&type=template&id=af8f7830&

// CONCATENATED MODULE: ./node_modules/vue-loader/lib??vue-loader-options!./node_modules/@caohenghu/vue-colorpicker/src/color/Hue.vue?vue&type=script&lang=js&
//
//
//
//
//
//
//
//
//
//
//
//
//

/* harmony default export */ var Huevue_type_script_lang_js_ = ({
    props: {
        hsv: {
            type: Object,
            default: null
        },
        width: {
            type: Number,
            default: 15
        },
        height: {
            type: Number,
            default: 152
        }
    },
    data() {
        return {
            slideHueStyle: {}
        }
    },
    // 不能监听，否则操作saturation时，这里的slide会抖动
    // watch: {
    //     'hsv.h'() {
    //         this.renderSlide()
    //     }
    // },
    mounted() {
        this.renderColor()
        this.renderSlide()
    },
    methods: {
        renderColor() {
            const canvas = this.$refs.canvasHue
            const width = this.width
            const height = this.height
            const ctx = canvas.getContext('2d')
            canvas.width = width
            canvas.height = height

            const gradient = ctx.createLinearGradient(0, 0, 0, height)
            gradient.addColorStop(0, '#FF0000') // 红
            gradient.addColorStop(0.17 * 1, '#FF00FF') // 紫
            gradient.addColorStop(0.17 * 2, '#0000FF') // 蓝
            gradient.addColorStop(0.17 * 3, '#00FFFF') // 青
            gradient.addColorStop(0.17 * 4, '#00FF00') // 绿
            gradient.addColorStop(0.17 * 5, '#FFFF00') // 黄
            gradient.addColorStop(1, '#FF0000') // 红
            ctx.fillStyle = gradient
            ctx.fillRect(0, 0, width, height)
        },
        renderSlide() {
            this.slideHueStyle = {
                top: (1 - this.hsv.h / 360) * this.height - 2 + 'px'
            }
        },
        selectHue(e) {
            const { top: hueTop } = this.$el.getBoundingClientRect()
            const ctx = e.target.getContext('2d')

            const mousemove = e => {
                let y = e.clientY - hueTop

                if (y < 0) {
                    y = 0
                }
                if (y > this.height) {
                    y = this.height
                }

                this.slideHueStyle = {
                    top: y - 2 + 'px'
                }
                // 如果用最大值，选择的像素会是空的，空的默认是黑色
                const imgData = ctx.getImageData(0, Math.min(y, this.height - 1), 1, 1)
                const [r, g, b] = imgData.data
                this.$emit('selectHue', { r, g, b })
            }

            mousemove(e)

            const mouseup = () => {
                document.removeEventListener('mousemove', mousemove)
                document.removeEventListener('mouseup', mouseup)
            }

            document.addEventListener('mousemove', mousemove)
            document.addEventListener('mouseup', mouseup)
        }
    }
});

// CONCATENATED MODULE: ./node_modules/@caohenghu/vue-colorpicker/src/color/Hue.vue?vue&type=script&lang=js&
 /* harmony default export */ var color_Huevue_type_script_lang_js_ = (Huevue_type_script_lang_js_); 
// EXTERNAL MODULE: ./node_modules/@caohenghu/vue-colorpicker/src/color/Hue.vue?vue&type=style&index=0&lang=scss&
var Huevue_type_style_index_0_lang_scss_ = __webpack_require__(2162);

// CONCATENATED MODULE: ./node_modules/@caohenghu/vue-colorpicker/src/color/Hue.vue






/* normalize component */

var Hue_component = Object(componentNormalizer["a" /* default */])(
  color_Huevue_type_script_lang_js_,
  Huevue_type_template_id_af8f7830_render,
  Huevue_type_template_id_af8f7830_staticRenderFns,
  false,
  null,
  null,
  null
  
)

/* hot reload */
if (false) { var Hue_api; }
Hue_component.options.__file = "node_modules/@caohenghu/vue-colorpicker/src/color/Hue.vue"
/* harmony default export */ var Hue = (Hue_component.exports);
// CONCATENATED MODULE: ./node_modules/vue-loader/lib/loaders/templateLoader.js??vue-loader-options!./node_modules/vue-loader/lib??vue-loader-options!./node_modules/@caohenghu/vue-colorpicker/src/color/Alpha.vue?vue&type=template&id=6e03074e&
var Alphavue_type_template_id_6e03074e_render = function() {
  var _vm = this
  var _h = _vm.$createElement
  var _c = _vm._self._c || _h
  return _c(
    "div",
    {
      staticClass: "color-alpha",
      on: {
        mousedown: function($event) {
          $event.preventDefault()
          $event.stopPropagation()
          return _vm.selectAlpha($event)
        }
      }
    },
    [
      _c("canvas", { ref: "canvasAlpha" }),
      _vm._v(" "),
      _c("div", { staticClass: "slide", style: _vm.slideAlphaStyle })
    ]
  )
}
var Alphavue_type_template_id_6e03074e_staticRenderFns = []
Alphavue_type_template_id_6e03074e_render._withStripped = true


// CONCATENATED MODULE: ./node_modules/@caohenghu/vue-colorpicker/src/color/Alpha.vue?vue&type=template&id=6e03074e&

// CONCATENATED MODULE: ./node_modules/vue-loader/lib??vue-loader-options!./node_modules/@caohenghu/vue-colorpicker/src/color/Alpha.vue?vue&type=script&lang=js&
//
//
//
//
//
//
//
//
//
//
//
//
//


/* harmony default export */ var Alphavue_type_script_lang_js_ = ({
    mixins: [mixin],
    props: {
        color: {
            type: String,
            default: '#000000'
        },
        rgba: {
            type: Object,
            default: null
        },
        width: {
            type: Number,
            default: 15
        },
        height: {
            type: Number,
            default: 152
        }
    },
    data() {
        return {
            slideAlphaStyle: {},
            alphaSize: 5
        }
    },
    watch: {
        color() {
            this.renderColor()
        },
        'rgba.a'() {
            this.renderSlide()
        }
    },
    mounted() {
        this.renderColor()
        this.renderSlide()
    },
    methods: {
        renderColor() {
            const canvas = this.$refs.canvasAlpha
            const width = this.width
            const height = this.height
            const size = this.alphaSize
            const canvasSquare = this.createAlphaSquare(size)

            const ctx = canvas.getContext('2d')
            canvas.width = width
            canvas.height = height

            ctx.fillStyle = ctx.createPattern(canvasSquare, 'repeat')
            ctx.fillRect(0, 0, width, height)

            this.createLinearGradient('p', ctx, width, height, 'rgba(255,255,255,0)', this.color)
        },
        renderSlide() {
            this.slideAlphaStyle = {
                top: this.rgba.a * this.height - 2 + 'px'
            }
        },
        selectAlpha(e) {
            const { top: hueTop } = this.$el.getBoundingClientRect()

            const mousemove = e => {
                let y = e.clientY - hueTop

                if (y < 0) {
                    y = 0
                }
                if (y > this.height) {
                    y = this.height
                }

                let a = parseFloat((y / this.height).toFixed(2))
                this.$emit('selectAlpha', a)
            }

            mousemove(e)

            const mouseup = () => {
                document.removeEventListener('mousemove', mousemove)
                document.removeEventListener('mouseup', mouseup)
            }

            document.addEventListener('mousemove', mousemove)
            document.addEventListener('mouseup', mouseup)
        }
    }
});

// CONCATENATED MODULE: ./node_modules/@caohenghu/vue-colorpicker/src/color/Alpha.vue?vue&type=script&lang=js&
 /* harmony default export */ var color_Alphavue_type_script_lang_js_ = (Alphavue_type_script_lang_js_); 
// EXTERNAL MODULE: ./node_modules/@caohenghu/vue-colorpicker/src/color/Alpha.vue?vue&type=style&index=0&lang=scss&
var Alphavue_type_style_index_0_lang_scss_ = __webpack_require__(2164);

// CONCATENATED MODULE: ./node_modules/@caohenghu/vue-colorpicker/src/color/Alpha.vue






/* normalize component */

var Alpha_component = Object(componentNormalizer["a" /* default */])(
  color_Alphavue_type_script_lang_js_,
  Alphavue_type_template_id_6e03074e_render,
  Alphavue_type_template_id_6e03074e_staticRenderFns,
  false,
  null,
  null,
  null
  
)

/* hot reload */
if (false) { var Alpha_api; }
Alpha_component.options.__file = "node_modules/@caohenghu/vue-colorpicker/src/color/Alpha.vue"
/* harmony default export */ var Alpha = (Alpha_component.exports);
// CONCATENATED MODULE: ./node_modules/vue-loader/lib/loaders/templateLoader.js??vue-loader-options!./node_modules/vue-loader/lib??vue-loader-options!./node_modules/@caohenghu/vue-colorpicker/src/color/Preview.vue?vue&type=template&id=7e508290&
var Previewvue_type_template_id_7e508290_render = function() {
  var _vm = this
  var _h = _vm.$createElement
  var _c = _vm._self._c || _h
  return _c("canvas")
}
var Previewvue_type_template_id_7e508290_staticRenderFns = []
Previewvue_type_template_id_7e508290_render._withStripped = true


// CONCATENATED MODULE: ./node_modules/@caohenghu/vue-colorpicker/src/color/Preview.vue?vue&type=template&id=7e508290&

// CONCATENATED MODULE: ./node_modules/vue-loader/lib??vue-loader-options!./node_modules/@caohenghu/vue-colorpicker/src/color/Preview.vue?vue&type=script&lang=js&
//
//
//
//


/* harmony default export */ var Previewvue_type_script_lang_js_ = ({
    mixins: [mixin],
    props: {
        color: {
            type: String,
            default: '#000000'
        },
        width: {
            type: Number,
            default: 100
        },
        height: {
            type: Number,
            default: 30
        }
    },
    data() {
        return {
            alphaSize: 5
        }
    },
    watch: {
        color() {
            this.renderColor()
        }
    },
    mounted() {
        this.renderColor()
    },
    methods: {
        renderColor() {
            const canvas = this.$el
            const width = this.width
            const height = this.height
            const size = this.alphaSize
            const canvasSquare = this.createAlphaSquare(size)

            const ctx = canvas.getContext('2d')
            canvas.width = width
            canvas.height = height

            ctx.fillStyle = ctx.createPattern(canvasSquare, 'repeat')
            ctx.fillRect(0, 0, width, height)

            ctx.fillStyle = this.color
            ctx.fillRect(0, 0, width, height)
        }
    }
});

// CONCATENATED MODULE: ./node_modules/@caohenghu/vue-colorpicker/src/color/Preview.vue?vue&type=script&lang=js&
 /* harmony default export */ var color_Previewvue_type_script_lang_js_ = (Previewvue_type_script_lang_js_); 
// CONCATENATED MODULE: ./node_modules/@caohenghu/vue-colorpicker/src/color/Preview.vue





/* normalize component */

var Preview_component = Object(componentNormalizer["a" /* default */])(
  color_Previewvue_type_script_lang_js_,
  Previewvue_type_template_id_7e508290_render,
  Previewvue_type_template_id_7e508290_staticRenderFns,
  false,
  null,
  null,
  null
  
)

/* hot reload */
if (false) { var Preview_api; }
Preview_component.options.__file = "node_modules/@caohenghu/vue-colorpicker/src/color/Preview.vue"
/* harmony default export */ var Preview = (Preview_component.exports);
// CONCATENATED MODULE: ./node_modules/vue-loader/lib/loaders/templateLoader.js??vue-loader-options!./node_modules/vue-loader/lib??vue-loader-options!./node_modules/@caohenghu/vue-colorpicker/src/color/Sucker.vue?vue&type=template&id=18a41437&
var Suckervue_type_template_id_18a41437_render = function() {
  var _vm = this
  var _h = _vm.$createElement
  var _c = _vm._self._c || _h
  return _c("div", [
    !_vm.isSucking
      ? _c(
          "svg",
          {
            staticClass: "sucker",
            class: { active: _vm.isOpenSucker },
            attrs: {
              xmlns: "http://www.w3.org/2000/svg",
              viewBox: "-12 -12 48 48"
            },
            on: { click: _vm.openSucker }
          },
          [
            _c("path", {
              attrs: {
                d:
                  "M13.1,8.2l5.6,5.6c0.4,0.4,0.5,1.1,0.1,1.5s-1.1,0.5-1.5,0.1c0,0-0.1,0-0.1-0.1l-1.4-1.4l-7.7,7.7C7.9,21.9,7.6,22,7.3,22H3.1C2.5,22,2,21.5,2,20.9l0,0v-4.2c0-0.3,0.1-0.6,0.3-0.8l5.8-5.8C8.5,9.7,9.2,9.6,9.7,10s0.5,1.1,0.1,1.5c0,0,0,0.1-0.1,0.1l-5.5,5.5v2.7h2.7l7.4-7.4L8.7,6.8c-0.5-0.4-0.5-1-0.1-1.5s1.1-0.5,1.5-0.1c0,0,0.1,0,0.1,0.1l1.4,1.4l3.5-3.5c1.6-1.6,4.1-1.6,5.8-0.1c1.6,1.6,1.6,4.1,0.1,5.8L20.9,9l-3.6,3.6c-0.4,0.4-1.1,0.5-1.5,0.1"
              }
            })
          ]
        )
      : _vm._e(),
    _vm._v(" "),
    _vm.isSucking
      ? _c(
          "svg",
          {
            staticClass: "sucker",
            attrs: {
              viewBox: "-16 -16 68 68",
              xmlns: "http://www.w3.org/2000/svg",
              stroke: "#9099a4"
            }
          },
          [
            _c("g", { attrs: { fill: "none", "fill-rule": "evenodd" } }, [
              _c(
                "g",
                { attrs: { transform: "translate(1 1)", "stroke-width": "4" } },
                [
                  _c("circle", {
                    attrs: {
                      "stroke-opacity": ".5",
                      cx: "18",
                      cy: "18",
                      r: "18"
                    }
                  }),
                  _vm._v(" "),
                  _c(
                    "path",
                    { attrs: { d: "M36 18c0-9.94-8.06-18-18-18" } },
                    [
                      _c("animateTransform", {
                        attrs: {
                          attributeName: "transform",
                          type: "rotate",
                          from: "0 18 18",
                          to: "360 18 18",
                          dur: "1s",
                          repeatCount: "indefinite"
                        }
                      })
                    ],
                    1
                  )
                ]
              )
            ])
          ]
        )
      : _vm._e()
  ])
}
var Suckervue_type_template_id_18a41437_staticRenderFns = []
Suckervue_type_template_id_18a41437_render._withStripped = true


// CONCATENATED MODULE: ./node_modules/@caohenghu/vue-colorpicker/src/color/Sucker.vue?vue&type=template&id=18a41437&

// EXTERNAL MODULE: ./node_modules/@caohenghu/vue-colorpicker/src/img/sucker.png
var sucker = __webpack_require__(2166);
var sucker_default = /*#__PURE__*/__webpack_require__.n(sucker);

// CONCATENATED MODULE: ./node_modules/vue-loader/lib??vue-loader-options!./node_modules/@caohenghu/vue-colorpicker/src/color/Sucker.vue?vue&type=script&lang=js&
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//


/* harmony default export */ var Suckervue_type_script_lang_js_ = ({
    props: {
        suckerCanvas: {
            type: null, // HTMLCanvasElement
            default: null
        },
        suckerArea: {
            type: Array,
            default: () => []
        }
    },
    data() {
        return {
            isOpenSucker: false, // 是否处于吸管状态
            suckerPreview: null, // 吸管旁边的预览颜色dom
            isSucking: false // 是否处于吸管等待状态
        }
    },
    watch: {
        suckerCanvas(newVal) {
            this.isSucking = false
            this.suckColor(newVal)
            newVal.style.cursor = `url(${sucker_default.a}) 0 32, default`
        }
    },
    methods: {
        openSucker() {
            if (!this.isOpenSucker) {
                this.isOpenSucker = true
                this.isSucking = true
                this.$emit('openSucker', true)
                document.addEventListener('keydown', this.keydownHandler)
            } else {
                // 和按下esc键的处理逻辑一样
                this.keydownHandler({ keyCode: 27 })
            }
        },
        keydownHandler(e) {
            // esc
            if (e.keyCode === 27) {
                this.isOpenSucker = false
                this.isSucking = false
                this.$emit('openSucker', false)
                document.removeEventListener('keydown', this.keydownHandler)
                document.removeEventListener('mousemove', this.mousemoveHandler)
                document.removeEventListener('mouseup', this.mousemoveHandler)
                if (this.suckerPreview) {
                    document.body.removeChild(this.suckerPreview)
                    this.suckerPreview = null
                }
            }
        },
        mousemoveHandler(e) {
            const { clientX, clientY } = e
            const { top: domTop, left: domLeft, width, height } = this.suckerCanvas.getBoundingClientRect()
            const x = clientX - domLeft
            const y = clientY - domTop
            const ctx = this.suckerCanvas.getContext('2d')
            const imgData = ctx.getImageData(Math.min(x, width - 1), Math.min(y, height - 1), 1, 1)
            let [r, g, b, a] = imgData.data
            a = parseFloat((a / 255).toFixed(2))
            const style = this.suckerPreview.style
            Object.assign(style, {
                position: 'absolute',
                left: clientX + 20 + 'px',
                top: clientY - 36 + 'px',
                width: '24px',
                height: '24px',
                borderRadius: '50%',
                border: '2px solid #fff',
                boxShadow: '0 0 8px 0 rgba(0, 0, 0, 0.16)',
                background: `rgba(${r}, ${g}, ${b}, ${a})`,
                zIndex: 95 // 吸管的小圆圈预览色的层级不能超过颜色选择器
            })
            if (
                clientX >= this.suckerArea[0] &&
                clientY >= this.suckerArea[1] &&
                clientX <= this.suckerArea[2] &&
                clientY <= this.suckerArea[3]
            ) {
                style.display = ''
            } else {
                style.display = 'none'
            }
        },
        suckColor(dom) {
            if (dom && dom.tagName !== 'CANVAS') {
                return
            }

            this.suckerPreview = document.createElement('div')
            document.body.appendChild(this.suckerPreview)

            document.addEventListener('mousemove', this.mousemoveHandler)
            document.addEventListener('mouseup', this.mousemoveHandler)

            dom.addEventListener('click', e => {
                const { clientX, clientY } = e
                const { top, left, width, height } = dom.getBoundingClientRect()
                const x = clientX - left
                const y = clientY - top
                const ctx = dom.getContext('2d')
                const imgData = ctx.getImageData(Math.min(x, width - 1), Math.min(y, height - 1), 1, 1)
                let [r, g, b, a] = imgData.data
                a = parseFloat((a / 255).toFixed(2))
                this.$emit('selectSucker', { r, g, b, a })
            })
        }
    }
});

// CONCATENATED MODULE: ./node_modules/@caohenghu/vue-colorpicker/src/color/Sucker.vue?vue&type=script&lang=js&
 /* harmony default export */ var color_Suckervue_type_script_lang_js_ = (Suckervue_type_script_lang_js_); 
// EXTERNAL MODULE: ./node_modules/@caohenghu/vue-colorpicker/src/color/Sucker.vue?vue&type=style&index=0&lang=scss&
var Suckervue_type_style_index_0_lang_scss_ = __webpack_require__(2167);

// CONCATENATED MODULE: ./node_modules/@caohenghu/vue-colorpicker/src/color/Sucker.vue






/* normalize component */

var Sucker_component = Object(componentNormalizer["a" /* default */])(
  color_Suckervue_type_script_lang_js_,
  Suckervue_type_template_id_18a41437_render,
  Suckervue_type_template_id_18a41437_staticRenderFns,
  false,
  null,
  null,
  null
  
)

/* hot reload */
if (false) { var Sucker_api; }
Sucker_component.options.__file = "node_modules/@caohenghu/vue-colorpicker/src/color/Sucker.vue"
/* harmony default export */ var Sucker = (Sucker_component.exports);
// CONCATENATED MODULE: ./node_modules/vue-loader/lib/loaders/templateLoader.js??vue-loader-options!./node_modules/vue-loader/lib??vue-loader-options!./node_modules/@caohenghu/vue-colorpicker/src/color/Box.vue?vue&type=template&id=61a18b3b&
var Boxvue_type_template_id_61a18b3b_render = function() {
  var _vm = this
  var _h = _vm.$createElement
  var _c = _vm._self._c || _h
  return _c("div", { staticClass: "color-type" }, [
    _c("span", { staticClass: "name" }, [
      _vm._v("\n        " + _vm._s(_vm.name) + "\n    ")
    ]),
    _vm._v(" "),
    _c("input", {
      directives: [
        {
          name: "model",
          rawName: "v-model",
          value: _vm.modelColor,
          expression: "modelColor"
        }
      ],
      staticClass: "value",
      domProps: { value: _vm.modelColor },
      on: {
        input: function($event) {
          if ($event.target.composing) {
            return
          }
          _vm.modelColor = $event.target.value
        }
      }
    })
  ])
}
var Boxvue_type_template_id_61a18b3b_staticRenderFns = []
Boxvue_type_template_id_61a18b3b_render._withStripped = true


// CONCATENATED MODULE: ./node_modules/@caohenghu/vue-colorpicker/src/color/Box.vue?vue&type=template&id=61a18b3b&

// CONCATENATED MODULE: ./node_modules/vue-loader/lib??vue-loader-options!./node_modules/@caohenghu/vue-colorpicker/src/color/Box.vue?vue&type=script&lang=js&
//
//
//
//
//
//
//
//
//
//
//
//

/* harmony default export */ var Boxvue_type_script_lang_js_ = ({
    props: {
        name: {
            type: String,
            default: ''
        },
        color: {
            type: String,
            default: ''
        }
    },
    computed: {
        modelColor: {
            get() {
                return this.color
            },
            set(val) {
                this.$emit('inputColor', val)
            }
        }
    }
});

// CONCATENATED MODULE: ./node_modules/@caohenghu/vue-colorpicker/src/color/Box.vue?vue&type=script&lang=js&
 /* harmony default export */ var color_Boxvue_type_script_lang_js_ = (Boxvue_type_script_lang_js_); 
// EXTERNAL MODULE: ./node_modules/@caohenghu/vue-colorpicker/src/color/Box.vue?vue&type=style&index=0&lang=scss&
var Boxvue_type_style_index_0_lang_scss_ = __webpack_require__(2169);

// CONCATENATED MODULE: ./node_modules/@caohenghu/vue-colorpicker/src/color/Box.vue






/* normalize component */

var Box_component = Object(componentNormalizer["a" /* default */])(
  color_Boxvue_type_script_lang_js_,
  Boxvue_type_template_id_61a18b3b_render,
  Boxvue_type_template_id_61a18b3b_staticRenderFns,
  false,
  null,
  null,
  null
  
)

/* hot reload */
if (false) { var Box_api; }
Box_component.options.__file = "node_modules/@caohenghu/vue-colorpicker/src/color/Box.vue"
/* harmony default export */ var Box = (Box_component.exports);
// CONCATENATED MODULE: ./node_modules/vue-loader/lib/loaders/templateLoader.js??vue-loader-options!./node_modules/vue-loader/lib??vue-loader-options!./node_modules/@caohenghu/vue-colorpicker/src/color/Colors.vue?vue&type=template&id=2999fea0&
var Colorsvue_type_template_id_2999fea0_render = function() {
  var _vm = this
  var _h = _vm.$createElement
  var _c = _vm._self._c || _h
  return _c("div", [
    _c(
      "ul",
      { staticClass: "colors" },
      _vm._l(_vm.colorsDefault, function(item) {
        return _c(
          "li",
          {
            key: item,
            staticClass: "item",
            on: {
              click: function($event) {
                return _vm.selectColor(item)
              }
            }
          },
          [
            _c("div", {
              staticClass: "alpha",
              style: { background: "url(" + _vm.imgAlphaBase64 + ")" }
            }),
            _vm._v(" "),
            _c("div", { staticClass: "color", style: { background: item } })
          ]
        )
      }),
      0
    ),
    _vm._v(" "),
    _vm.colorsHistory.length
      ? _c(
          "ul",
          { staticClass: "colors history" },
          _vm._l(_vm.colorsHistory, function(item) {
            return _c(
              "li",
              {
                key: item,
                staticClass: "item",
                on: {
                  click: function($event) {
                    return _vm.selectColor(item)
                  }
                }
              },
              [
                _c("div", {
                  staticClass: "alpha",
                  style: { background: "url(" + _vm.imgAlphaBase64 + ")" }
                }),
                _vm._v(" "),
                _c("div", { staticClass: "color", style: { background: item } })
              ]
            )
          }),
          0
        )
      : _vm._e()
  ])
}
var Colorsvue_type_template_id_2999fea0_staticRenderFns = []
Colorsvue_type_template_id_2999fea0_render._withStripped = true


// CONCATENATED MODULE: ./node_modules/@caohenghu/vue-colorpicker/src/color/Colors.vue?vue&type=template&id=2999fea0&

// CONCATENATED MODULE: ./node_modules/vue-loader/lib??vue-loader-options!./node_modules/@caohenghu/vue-colorpicker/src/color/Colors.vue?vue&type=script&lang=js&
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//


/* harmony default export */ var Colorsvue_type_script_lang_js_ = ({
    mixins: [mixin],
    props: {
        color: {
            type: String,
            default: '#000000'
        },
        colorsDefault: {
            type: Array,
            default: () => []
        },
        colorsHistoryKey: {
            type: String,
            default: ''
        }
    },
    data() {
        return {
            imgAlphaBase64: '',
            colorsHistory: JSON.parse(localStorage.getItem(this.colorsHistoryKey)) || []
        }
    },
    created() {
        this.imgAlphaBase64 = this.createAlphaSquare(4).toDataURL()
    },
    destroyed() {
        this.setColorsHistory(this.color)
    },
    methods: {
        selectColor(color) {
            this.$emit('selectColor', color)
        },
        setColorsHistory(color) {
            if (!color) {
                return
            }
            const colors = this.colorsHistory
            const index = colors.indexOf(color)
            if (index >= 0) {
                colors.splice(index, 1)
            }
            if (colors.length >= 8) {
                colors.length = 7
            }
            colors.unshift(color)
            this.colorsHistory = colors
            localStorage.setItem(this.colorsHistoryKey, JSON.stringify(colors))
        }
    }
});

// CONCATENATED MODULE: ./node_modules/@caohenghu/vue-colorpicker/src/color/Colors.vue?vue&type=script&lang=js&
 /* harmony default export */ var color_Colorsvue_type_script_lang_js_ = (Colorsvue_type_script_lang_js_); 
// EXTERNAL MODULE: ./node_modules/@caohenghu/vue-colorpicker/src/color/Colors.vue?vue&type=style&index=0&lang=scss&
var Colorsvue_type_style_index_0_lang_scss_ = __webpack_require__(2171);

// CONCATENATED MODULE: ./node_modules/@caohenghu/vue-colorpicker/src/color/Colors.vue






/* normalize component */

var Colors_component = Object(componentNormalizer["a" /* default */])(
  color_Colorsvue_type_script_lang_js_,
  Colorsvue_type_template_id_2999fea0_render,
  Colorsvue_type_template_id_2999fea0_staticRenderFns,
  false,
  null,
  null,
  null
  
)

/* hot reload */
if (false) { var Colors_api; }
Colors_component.options.__file = "node_modules/@caohenghu/vue-colorpicker/src/color/Colors.vue"
/* harmony default export */ var Colors = (Colors_component.exports);
// CONCATENATED MODULE: ./node_modules/vue-loader/lib??vue-loader-options!./node_modules/@caohenghu/vue-colorpicker/src/color/Index.vue?vue&type=script&lang=js&
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//









/* harmony default export */ var Indexvue_type_script_lang_js_ = ({
    components: {
        Saturation: Saturation,
        Hue: Hue,
        Alpha: Alpha,
        Preview: Preview,
        Sucker: Sucker,
        Box: Box,
        Colors: Colors
    },
    mixins: [mixin],
    props: {
        color: {
            type: String,
            default: '#000000'
        },
        theme: {
            type: String,
            default: 'dark'
        },
        suckerHide: {
            type: Boolean,
            default: true
        },
        suckerCanvas: {
            type: null, // HTMLCanvasElement
            default: null
        },
        suckerArea: {
            type: Array,
            default: () => []
        },
        colorsDefault: {
            type: Array,
            default: () => [
                '#000000', '#FFFFFF', '#FF1900', '#F47365', '#FFB243', '#FFE623', '#6EFF2A', '#1BC7B1',
                '#00BEFF', '#2E81FF', '#5D61FF', '#FF89CF', '#FC3CAD', '#BF3DCE', '#8E00A7', 'rgba(0,0,0,0)'
            ]
        },
        colorsHistoryKey: {
            type: String,
            default: 'vue-colorpicker-history'
        }
    },
    data() {
        return {
            hueWidth: 15,
            hueHeight: 152,
            previewHeight: 30,
            modelRgba: '',
            modelHex: '',
            r: 0,
            g: 0,
            b: 0,
            a: 1,
            h: 0,
            s: 0,
            v: 0
        }
    },
    computed: {
        isLightTheme() {
            return this.theme === 'light'
        },
        totalWidth() {
            return this.hueHeight + (this.hueWidth + 8) * 2
        },
        previewWidth() {
            return this.totalWidth - (this.suckerHide ? 0 : this.previewHeight)
        },
        rgba() {
            return {
                r: this.r,
                g: this.g,
                b: this.b,
                a: this.a
            }
        },
        hsv() {
            return {
                h: this.h,
                s: this.s,
                v: this.v
            }
        },
        rgbString() {
            return `rgb(${this.r}, ${this.g}, ${this.b})`
        },
        rgbaStringShort() {
            return `${this.r}, ${this.g}, ${this.b}, ${this.a}`
        },
        rgbaString() {
            return `rgba(${this.rgbaStringShort})`
        },
        hexString() {
            return this.rgb2hex(this.rgba, true)
        }
    },
    created() {
        Object.assign(this, this.setColorValue(this.color))
        this.setText()

        // 避免初始化时，也会触发changeColor事件
        this.$watch('rgba', () => {
            this.$emit('changeColor', {
                rgba: this.rgba,
                hsv: this.hsv,
                hex: this.modelHex
            })
        })
    },
    methods: {
        selectSaturation(color) {
            const { r, g, b, h, s, v } = this.setColorValue(color)
            Object.assign(this, { r, g, b, h, s, v })
            this.setText()
        },
        selectHue(color) {
            const { r, g, b, h, s, v } = this.setColorValue(color)
            Object.assign(this, { r, g, b, h, s, v })
            this.setText()
            this.$nextTick(() => {
                this.$refs.saturation.renderColor()
                this.$refs.saturation.renderSlide()
            })
        },
        selectAlpha(a) {
            this.a = a
            this.setText()
        },
        inputHex(color) {
            const { r, g, b, a, h, s, v } = this.setColorValue(color)
            Object.assign(this, { r, g, b, a, h, s, v })
            this.modelHex = color
            this.modelRgba = this.rgbaStringShort
            this.$nextTick(() => {
                this.$refs.saturation.renderColor()
                this.$refs.saturation.renderSlide()
                this.$refs.hue.renderSlide()
            })
        },
        inputRgba(color) {
            const { r, g, b, a, h, s, v } = this.setColorValue(color)
            Object.assign(this, { r, g, b, a, h, s, v })
            this.modelHex = this.hexString
            this.modelRgba = color
            this.$nextTick(() => {
                this.$refs.saturation.renderColor()
                this.$refs.saturation.renderSlide()
                this.$refs.hue.renderSlide()
            })
        },
        setText() {
            this.modelHex = this.hexString
            this.modelRgba = this.rgbaStringShort
        },
        openSucker(isOpen) {
            this.$emit('openSucker', isOpen)
        },
        selectSucker(color) {
            const { r, g, b, a, h, s, v } = this.setColorValue(color)
            Object.assign(this, { r, g, b, a, h, s, v })
            this.setText()
            this.$nextTick(() => {
                this.$refs.saturation.renderColor()
                this.$refs.saturation.renderSlide()
                this.$refs.hue.renderSlide()
            })
        },
        selectColor(color) {
            const { r, g, b, a, h, s, v } = this.setColorValue(color)
            Object.assign(this, { r, g, b, a, h, s, v })
            this.setText()
            this.$nextTick(() => {
                this.$refs.saturation.renderColor()
                this.$refs.saturation.renderSlide()
                this.$refs.hue.renderSlide()
            })
        }
    }
});

// CONCATENATED MODULE: ./node_modules/@caohenghu/vue-colorpicker/src/color/Index.vue?vue&type=script&lang=js&
 /* harmony default export */ var color_Indexvue_type_script_lang_js_ = (Indexvue_type_script_lang_js_); 
// EXTERNAL MODULE: ./node_modules/@caohenghu/vue-colorpicker/src/color/Index.vue?vue&type=style&index=0&lang=scss&
var Indexvue_type_style_index_0_lang_scss_ = __webpack_require__(2173);

// CONCATENATED MODULE: ./node_modules/@caohenghu/vue-colorpicker/src/color/Index.vue






/* normalize component */

var Index_component = Object(componentNormalizer["a" /* default */])(
  color_Indexvue_type_script_lang_js_,
  Indexvue_type_template_id_6143a4c2_render,
  Indexvue_type_template_id_6143a4c2_staticRenderFns,
  false,
  null,
  null,
  null
  
)

/* hot reload */
if (false) { var Index_api; }
Index_component.options.__file = "node_modules/@caohenghu/vue-colorpicker/src/color/Index.vue"
/* harmony default export */ var Index = (Index_component.exports);
// CONCATENATED MODULE: ./node_modules/@caohenghu/vue-colorpicker/src/index.js

/* harmony default export */ var src = (Index);

// CONCATENATED MODULE: ./node_modules/babel-loader/lib??ref--3!./node_modules/vue-loader/lib??vue-loader-options!./ux/form/ColorPickerApp.vue?vue&type=script&lang=js&
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
// Make available for translation in ColorPalette
// _('Select Color')

/* harmony default export */ var ColorPickerAppvue_type_script_lang_js_ = ({
  name: 'ColorPickerApp',
  components: {
    colorPicker: src
  },
  props: ['initialColor'],

  data() {
    return {
      color: '#90C0FF'
    };
  },

  methods: {
    changeColor(color) {
      this.color = color.hex;
    },

    getColor() {
      return this.color;
    }

  },

  beforeMount() {
    if (this.initialColor) {
      this.color = '#' + this.initialColor;
    }
  }

});
// CONCATENATED MODULE: ./ux/form/ColorPickerApp.vue?vue&type=script&lang=js&
 /* harmony default export */ var form_ColorPickerAppvue_type_script_lang_js_ = (ColorPickerAppvue_type_script_lang_js_); 
// EXTERNAL MODULE: ./ux/form/ColorPickerApp.vue?vue&type=style&index=0&lang=css&
var ColorPickerAppvue_type_style_index_0_lang_css_ = __webpack_require__(2175);

// CONCATENATED MODULE: ./ux/form/ColorPickerApp.vue






/* normalize component */

var ColorPickerApp_component = Object(componentNormalizer["a" /* default */])(
  form_ColorPickerAppvue_type_script_lang_js_,
  render,
  staticRenderFns,
  false,
  null,
  null,
  null
  
)

/* hot reload */
if (false) { var ColorPickerApp_api; }
ColorPickerApp_component.options.__file = "ux/form/ColorPickerApp.vue"
/* harmony default export */ var ColorPickerApp = __webpack_exports__["default"] = (ColorPickerApp_component.exports);

/***/ }),

/***/ 28:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return normalizeComponent; });
/* globals __VUE_SSR_CONTEXT__ */

// IMPORTANT: Do NOT use ES2015 features in this file (except for modules).
// This module is a runtime utility for cleaner component module output and will
// be included in the final webpack user bundle.

function normalizeComponent (
  scriptExports,
  render,
  staticRenderFns,
  functionalTemplate,
  injectStyles,
  scopeId,
  moduleIdentifier, /* server only */
  shadowMode /* vue-cli only */
) {
  // Vue.extend constructor export interop
  var options = typeof scriptExports === 'function'
    ? scriptExports.options
    : scriptExports

  // render functions
  if (render) {
    options.render = render
    options.staticRenderFns = staticRenderFns
    options._compiled = true
  }

  // functional template
  if (functionalTemplate) {
    options.functional = true
  }

  // scopedId
  if (scopeId) {
    options._scopeId = 'data-v-' + scopeId
  }

  var hook
  if (moduleIdentifier) { // server build
    hook = function (context) {
      // 2.3 injection
      context =
        context || // cached call
        (this.$vnode && this.$vnode.ssrContext) || // stateful
        (this.parent && this.parent.$vnode && this.parent.$vnode.ssrContext) // functional
      // 2.2 with runInNewContext: true
      if (!context && typeof __VUE_SSR_CONTEXT__ !== 'undefined') {
        context = __VUE_SSR_CONTEXT__
      }
      // inject component styles
      if (injectStyles) {
        injectStyles.call(this, context)
      }
      // register component module identifier for async chunk inferrence
      if (context && context._registeredComponents) {
        context._registeredComponents.add(moduleIdentifier)
      }
    }
    // used by ssr in case component is cached and beforeCreate
    // never gets called
    options._ssrRegister = hook
  } else if (injectStyles) {
    hook = shadowMode
      ? function () {
        injectStyles.call(
          this,
          (options.functional ? this.parent : this).$root.$options.shadowRoot
        )
      }
      : injectStyles
  }

  if (hook) {
    if (options.functional) {
      // for template-only hot-reload because in that case the render fn doesn't
      // go through the normalizer
      options._injectStyles = hook
      // register for functional component in vue file
      var originalRender = options.render
      options.render = function renderWithStyleInjection (h, context) {
        hook.call(context)
        return originalRender(h, context)
      }
    } else {
      // inject component registration as beforeCreate hook
      var existing = options.beforeCreate
      options.beforeCreate = existing
        ? [].concat(existing, hook)
        : [hook]
    }
  }

  return {
    exports: scriptExports,
    options: options
  }
}


/***/ }),

/***/ 311:
/***/ (function(module, exports, __webpack_require__) {

// style-loader: Adds some css to the DOM by adding a <style> tag

// load the styles
var content = __webpack_require__(2161);
if(typeof content === 'string') content = [[module.i, content, '']];
if(content.locals) module.exports = content.locals;
// add the styles to the DOM
var add = __webpack_require__(137).default
var update = add("4084eb96", content, false, {});
// Hot Module Replacement
if(false) {}

/***/ }),

/***/ 312:
/***/ (function(module, exports, __webpack_require__) {

// style-loader: Adds some css to the DOM by adding a <style> tag

// load the styles
var content = __webpack_require__(2163);
if(typeof content === 'string') content = [[module.i, content, '']];
if(content.locals) module.exports = content.locals;
// add the styles to the DOM
var add = __webpack_require__(137).default
var update = add("62df3b84", content, false, {});
// Hot Module Replacement
if(false) {}

/***/ }),

/***/ 313:
/***/ (function(module, exports, __webpack_require__) {

// style-loader: Adds some css to the DOM by adding a <style> tag

// load the styles
var content = __webpack_require__(2165);
if(typeof content === 'string') content = [[module.i, content, '']];
if(content.locals) module.exports = content.locals;
// add the styles to the DOM
var add = __webpack_require__(137).default
var update = add("12bbbb10", content, false, {});
// Hot Module Replacement
if(false) {}

/***/ }),

/***/ 314:
/***/ (function(module, exports, __webpack_require__) {

// style-loader: Adds some css to the DOM by adding a <style> tag

// load the styles
var content = __webpack_require__(2168);
if(typeof content === 'string') content = [[module.i, content, '']];
if(content.locals) module.exports = content.locals;
// add the styles to the DOM
var add = __webpack_require__(137).default
var update = add("6e860136", content, false, {});
// Hot Module Replacement
if(false) {}

/***/ }),

/***/ 315:
/***/ (function(module, exports, __webpack_require__) {

// style-loader: Adds some css to the DOM by adding a <style> tag

// load the styles
var content = __webpack_require__(2170);
if(typeof content === 'string') content = [[module.i, content, '']];
if(content.locals) module.exports = content.locals;
// add the styles to the DOM
var add = __webpack_require__(137).default
var update = add("e804b92c", content, false, {});
// Hot Module Replacement
if(false) {}

/***/ }),

/***/ 316:
/***/ (function(module, exports, __webpack_require__) {

// style-loader: Adds some css to the DOM by adding a <style> tag

// load the styles
var content = __webpack_require__(2172);
if(typeof content === 'string') content = [[module.i, content, '']];
if(content.locals) module.exports = content.locals;
// add the styles to the DOM
var add = __webpack_require__(137).default
var update = add("35e9fed6", content, false, {});
// Hot Module Replacement
if(false) {}

/***/ }),

/***/ 317:
/***/ (function(module, exports, __webpack_require__) {

// style-loader: Adds some css to the DOM by adding a <style> tag

// load the styles
var content = __webpack_require__(2174);
if(typeof content === 'string') content = [[module.i, content, '']];
if(content.locals) module.exports = content.locals;
// add the styles to the DOM
var add = __webpack_require__(137).default
var update = add("2f8613f8", content, false, {});
// Hot Module Replacement
if(false) {}

/***/ }),

/***/ 318:
/***/ (function(module, exports, __webpack_require__) {

// style-loader: Adds some css to the DOM by adding a <style> tag

// load the styles
var content = __webpack_require__(2176);
if(typeof content === 'string') content = [[module.i, content, '']];
// Prepare cssTransformation
var transform;

var options = {"hmr":true}
options.transform = transform
// add the styles to the DOM
var update = __webpack_require__(17)(content, options);
if(content.locals) module.exports = content.locals;
// Hot Module Replacement
if(false) {}

/***/ })

}]);