(window["webpackJsonp"] = window["webpackJsonp"] || []).push([[1],{

/***/ 100:
/***/ (function(module, exports) {

module.exports = function escape(url) {
    if (typeof url !== 'string') {
        return url
    }
    // If url is already wrapped in quotes, remove them
    if (/^['"].*['"]$/.test(url)) {
        url = url.slice(1, -1);
    }
    // Should url be wrapped?
    // See https://drafts.csswg.org/css-values-3/#urls
    if (/["'() \t\n]/.test(url)) {
        return '"' + url.replace(/"/g, '\\"').replace(/\n/g, '\\n') + '"'
    }

    return url
}


/***/ }),

/***/ 126:
/***/ (function(module, exports) {

module.exports = "\"data:image/svg+xml,%3C?xml version='1.0' encoding='utf-8'?%3E %3C!-- Generator: Adobe Illustrator 21.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0) --%3E %3Csvg version='1.1' id='Ebene_1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' x='0px' y='0px' viewBox='0 0 42.5 42.5' style='enable-background:new 0 0 42.5 42.5;' xml:space='preserve' width='42.5' height='42.5'%3E %3Cpath d='M14.2,20.9c-2,0.1-3.7,0.9-5,2.4H6.7c-1,0-1.9-0.3-2.6-0.8C3.4,22.1,3,21.3,3,20.3c0-4.4,0.8-6.7,2.3-6.7 c0.1,0,0.3,0.1,0.8,0.4c0.5,0.3,1.1,0.5,1.8,0.8c0.8,0.3,1.5,0.4,2.2,0.4c0.8,0,1.7-0.1,2.5-0.4c-0.1,0.5-0.1,0.9-0.1,1.2 C12.7,17.8,13.2,19.4,14.2,20.9z M34.7,33.1c0,1.5-0.5,2.7-1.4,3.6c-0.9,0.9-2.1,1.3-3.7,1.3H13.2c-1.5,0-2.7-0.4-3.7-1.3 c-0.9-0.9-1.4-2.1-1.4-3.6c0-0.7,0-1.3,0.1-2s0.1-1.3,0.3-2.1c0.1-0.7,0.3-1.4,0.5-2s0.5-1.2,0.8-1.8c0.3-0.6,0.7-1.1,1.2-1.5 c0.4-0.4,1-0.8,1.6-1s1.3-0.4,2.1-0.4c0.1,0,0.4,0.1,0.8,0.4c0.4,0.3,0.9,0.6,1.4,0.9s1.2,0.6,2,0.9c0.8,0.3,1.7,0.4,2.5,0.4 s1.7-0.1,2.5-0.4c0.8-0.3,1.5-0.6,2-0.9c0.5-0.3,1-0.6,1.4-0.9s0.7-0.4,0.8-0.4c0.8,0,1.5,0.1,2.1,0.4s1.2,0.6,1.6,1 c0.4,0.4,0.8,0.9,1.2,1.5c0.3,0.6,0.6,1.2,0.8,1.8c0.2,0.6,0.4,1.3,0.5,2c0.1,0.7,0.2,1.4,0.3,2.1S34.7,32.5,34.7,33.1z M15.1,8.8 c0,1.3-0.5,2.5-1.4,3.4s-2.1,1.4-3.4,1.4s-2.5-0.5-3.4-1.4s-1.4-2.1-1.4-3.4s0.5-2.5,1.4-3.4S8.9,4,10.2,4s2.5,0.5,3.4,1.4 S15.1,7.5,15.1,8.8z M27.8,16.1c0,1.8-0.6,3.3-1.9,4.5c-1.3,1.3-2.8,1.9-4.5,1.9c-1.8,0-3.3-0.6-4.5-1.9c-1.3-1.3-1.9-2.8-1.9-4.5 s0.6-3.3,1.9-4.5s2.8-1.9,4.5-1.9c1.8,0,3.3,0.6,4.5,1.9C27.2,12.8,27.8,14.3,27.8,16.1z M39.8,20.3c0,1-0.4,1.7-1.1,2.2 c-0.7,0.5-1.6,0.8-2.6,0.8h-2.5c-1.3-1.5-3-2.4-5-2.4c1-1.5,1.5-3.1,1.5-4.8c0-0.4,0-0.8-0.1-1.2c0.8,0.3,1.7,0.4,2.5,0.4 c0.7,0,1.5-0.1,2.2-0.4c0.8-0.3,1.4-0.5,1.8-0.8c0.5-0.3,0.7-0.4,0.8-0.4C39,13.7,39.8,15.9,39.8,20.3z M37.4,8.8 c0,1.3-0.5,2.5-1.4,3.4c-0.9,0.9-2.1,1.4-3.4,1.4c-1.3,0-2.5-0.5-3.4-1.4c-0.9-0.9-1.4-2.1-1.4-3.4s0.5-2.5,1.4-3.4 C30.1,4.5,31.2,4,32.6,4C33.9,4,35,4.5,36,5.4C36.9,6.4,37.4,7.5,37.4,8.8z'/%3E %3C/svg%3E\""

/***/ }),

/***/ 149:
/***/ (function(module, exports) {

module.exports = "\"data:image/svg+xml,%3C?xml version='1.0' encoding='utf-8'?%3E %3C!-- Generator: Adobe Illustrator 21.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0) --%3E %3Csvg version='1.1' id='Ebene_1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' x='0px' y='0px' viewBox='0 0 42.5 42.5' style='enable-background:new 0 0 42.5 42.5;' xml:space='preserve' width='42.5' height='42.5'%3E %3Cpath d='M21.2,4c-2.3,0-4.3,0.8-6,2.5s-2.5,3.7-2.5,6s0.8,4.3,2.5,6s3.7,2.5,6,2.5s4.3-0.8,6-2.5s2.5-3.7,2.5-6s-0.8-4.3-2.5-6 S23.5,4,21.2,4z M30.6,38c1.3,0,2.4-0.5,3.3-1.6s1.4-2.3,1.4-3.8c0-3.5-0.6-6.3-1.7-8.3s-2.8-3.1-5-3.2c-2.1,1.9-4.6,2.8-7.4,2.8 s-5.3-0.9-7.4-2.8c-2.2,0.1-3.8,1.2-5,3.2S7,29,7,32.5c0,1.5,0.5,2.8,1.4,3.8s2,1.6,3.3,1.6H30.6z'/%3E %3C/svg%3E\""

/***/ }),

/***/ 16:
/***/ (function(module, exports) {

/*
	MIT License http://www.opensource.org/licenses/mit-license.php
	Author Tobias Koppers @sokra
*/
// css base code, injected by the css-loader
module.exports = function(useSourceMap) {
	var list = [];

	// return the list of modules as css string
	list.toString = function toString() {
		return this.map(function (item) {
			var content = cssWithMappingToString(item, useSourceMap);
			if(item[2]) {
				return "@media " + item[2] + "{" + content + "}";
			} else {
				return content;
			}
		}).join("");
	};

	// import a list of modules into the list
	list.i = function(modules, mediaQuery) {
		if(typeof modules === "string")
			modules = [[null, modules, ""]];
		var alreadyImportedModules = {};
		for(var i = 0; i < this.length; i++) {
			var id = this[i][0];
			if(typeof id === "number")
				alreadyImportedModules[id] = true;
		}
		for(i = 0; i < modules.length; i++) {
			var item = modules[i];
			// skip already imported module
			// this implementation is not 100% perfect for weird media query combinations
			//  when a module is imported multiple times with different media queries.
			//  I hope this will never occur (Hey this way we have smaller bundles)
			if(typeof item[0] !== "number" || !alreadyImportedModules[item[0]]) {
				if(mediaQuery && !item[2]) {
					item[2] = mediaQuery;
				} else if(mediaQuery) {
					item[2] = "(" + item[2] + ") and (" + mediaQuery + ")";
				}
				list.push(item);
			}
		}
	};
	return list;
};

function cssWithMappingToString(item, useSourceMap) {
	var content = item[1] || '';
	var cssMapping = item[3];
	if (!cssMapping) {
		return content;
	}

	if (useSourceMap && typeof btoa === 'function') {
		var sourceMapping = toComment(cssMapping);
		var sourceURLs = cssMapping.sources.map(function (source) {
			return '/*# sourceURL=' + cssMapping.sourceRoot + source + ' */'
		});

		return [content].concat(sourceURLs).concat([sourceMapping]).join('\n');
	}

	return [content].join('\n');
}

// Adapted from convert-source-map (MIT)
function toComment(sourceMap) {
	// eslint-disable-next-line no-undef
	var base64 = btoa(unescape(encodeURIComponent(JSON.stringify(sourceMap))));
	var data = 'sourceMappingURL=data:application/json;charset=utf-8;base64,' + base64;

	return '/*# ' + data + ' */';
}


/***/ }),

/***/ 1643:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Cornelius Weiss <c.weiss@metaways.de>
 * @copyright   Copyright (c) 2007-2011 Metaways Infosystems GmbH (http://www.metaways.de)
 */

/*global Ext, Tine*/
Ext.ns('Tine.Addressbook.Model'); // TODO: move this into model definition and replace uscases (?) with getter fn

Tine.Addressbook.Model.ContactArray = Tine.Tinebase.Model.genericFields.concat([{
  name: 'id',
  omitDuplicateResolving: true
}, {
  name: 'tid',
  omitDuplicateResolving: true
}, {
  name: 'private',
  omitDuplicateResolving: true
}, {
  name: 'cat_id',
  omitDuplicateResolving: true
}, {
  name: 'color',
  label: 'Color',
  group: 'Color'
}, {
  name: 'n_family',
  label: 'Last Name',
  group: 'Name'
}, //_('Last Name') _('Name')
{
  name: 'n_given',
  label: 'First Name',
  group: 'Name'
}, //_('First Name')
{
  name: 'n_middle',
  label: 'Middle Name',
  group: 'Name'
}, //_('Middle Name')
{
  name: 'n_prefix',
  label: 'Title',
  group: 'Name'
}, //_('Title')
{
  name: 'n_suffix',
  label: 'Suffix',
  group: 'Name'
}, //_('Suffix')
{
  name: 'n_short',
  label: 'Short Name',
  group: 'Name'
}, //_('Short Name')
{
  name: 'n_fn',
  label: 'Display Name',
  group: 'Name',
  omitDuplicateResolving: true
}, //_('Display Name')
{
  name: 'n_fileas',
  group: 'Name',
  omitDuplicateResolving: true,
  sortType: Ext.data.SortTypes.asUCString
}, {
  name: 'bday',
  label: 'Birthday',
  type: 'date',
  dateFormat: Date.patterns.ISO8601Long
}, //_('Birthday')
{
  name: 'org_name',
  label: 'Company',
  group: 'Company'
}, //_('Company')
{
  name: 'org_unit',
  label: 'Unit',
  group: 'Company'
}, //_('Unit')
{
  name: 'salutation',
  label: 'Salutation',
  group: 'Name'
}, //_('Salutation')
{
  name: 'title',
  label: 'Job Title',
  group: 'Company'
}, //_('Job Title')
{
  name: 'role',
  label: 'Job Role',
  group: 'Company'
}, //_('Job Role')
{
  name: 'assistent',
  group: 'Company',
  omitDuplicateResolving: true
}, {
  name: 'room',
  label: 'Room',
  group: 'Company'
}, //_('Room')
{
  name: 'adr_one_street',
  label: 'Street (Company Address)',
  group: 'Company Address'
}, //_('Street (Company Address)')  _('Company Address')
{
  name: 'adr_one_street2',
  label: 'Street 2 (Company Address)',
  group: 'Company Address'
}, //_('Street 2 (Company Address)')
{
  name: 'adr_one_locality',
  label: 'City (Company Address)',
  group: 'Company Address'
}, //_('City (Company Address)')
{
  name: 'adr_one_region',
  label: 'Region (Company Address)',
  group: 'Company Address'
}, //_('Region (Company Address)')
{
  name: 'adr_one_postalcode',
  label: 'Postal Code (Company Address)',
  group: 'Company Address'
}, //_('Postal Code (Company Address)')
{
  name: 'adr_one_countryname',
  label: 'Country (Company Address)',
  group: 'Company Address'
}, //_('Country (Company Address)')
{
  name: 'adr_one_lon',
  label: 'Longitude (Company Address)',
  group: 'Company Address',
  omitDuplicateResolving: true
}, //_('Longitude (Company Address)')
{
  name: 'adr_one_lat',
  label: 'Latitude (Company Address)',
  group: 'Company Address',
  omitDuplicateResolving: true
}, //_('Latitude (Company Address)')
{
  name: 'language',
  label: 'Language',
  group: 'Company Communication'
}, //_('Language')
{
  name: 'label',
  omitDuplicateResolving: true
}, {
  name: 'adr_two_street',
  label: 'Street (Private Address)',
  group: 'Private Address'
}, //_('Street (Private Address)')  _('Private Address')
{
  name: 'adr_two_street2',
  label: 'Street 2 (Private Address)',
  group: 'Private Address'
}, //_('Street 2 (Private Address)')
{
  name: 'adr_two_locality',
  label: 'City (Private Address)',
  group: 'Private Address'
}, //_('City (Private Address)')
{
  name: 'adr_two_region',
  label: 'Region (Private Address)',
  group: 'Private Address'
}, //_('Region (Private Address)')
{
  name: 'adr_two_postalcode',
  label: 'Postal Code (Private Address)',
  group: 'Private Address'
}, //_('Postal Code (Private Address)')
{
  name: 'adr_two_countryname',
  label: 'Country (Private Address)',
  group: 'Private Address'
}, //_('Country (Private Address)')
{
  name: 'adr_two_lon',
  group: 'Private Address',
  omitDuplicateResolving: true
}, {
  name: 'adr_two_lat',
  group: 'Private Address',
  omitDuplicateResolving: true
}, {
  name: 'preferred_address',
  group: 'Preferred Address',
  omitDuplicateResolving: true
}, //_('Preferred Address')
{
  name: 'tel_work',
  label: 'Phone',
  group: 'Company Communication'
}, //_('Phone') _('Company Communication')
{
  name: 'tel_cell',
  label: 'Mobile',
  group: 'Company Communication'
}, //_('Mobile')
{
  name: 'tel_fax',
  label: 'Fax',
  group: 'Company Communication'
}, //_('Fax')
{
  name: 'tel_assistent',
  group: 'contact_infos',
  omitDuplicateResolving: true
}, {
  name: 'tel_car',
  group: 'contact_infos',
  omitDuplicateResolving: true
}, {
  name: 'tel_pager',
  group: 'contact_infos',
  omitDuplicateResolving: true
}, {
  name: 'tel_home',
  label: 'Phone (private)',
  group: 'Private Communication'
}, //_('Phone (private)') _('Private Communication')
{
  name: 'tel_fax_home',
  label: 'Fax (private)',
  group: 'Private Communication'
}, //_('Fax (private)')
{
  name: 'tel_cell_private',
  label: 'Mobile (private)',
  group: 'Private Communication'
}, //_('Mobile (private)')
{
  name: 'tel_other',
  group: 'contact_infos',
  omitDuplicateResolving: true
}, {
  name: 'tel_prefer',
  group: 'contact_infos',
  omitDuplicateResolving: true
}, {
  name: 'email',
  label: 'E-Mail',
  group: 'Company Communication'
}, //_('E-Mail')
{
  name: 'email_home',
  label: 'E-Mail (private)',
  group: 'Private Communication'
}, //_('E-Mail (private)')
{
  name: 'url',
  label: 'Web',
  group: 'Company Communication'
}, //_('Web')
{
  name: 'url_home',
  label: 'Web (private)',
  group: 'Private Communication'
}, //_('Web (private)')
{
  name: 'freebusy_uri',
  omitDuplicateResolving: true
}, {
  name: 'calendar_uri',
  omitDuplicateResolving: true
}, {
  name: 'note',
  label: 'Description'
}, //_('Description')
{
  name: 'tz',
  omitDuplicateResolving: true
}, {
  name: 'pubkey',
  omitDuplicateResolving: true
}, {
  name: 'jpegphoto',
  omitDuplicateResolving: true
}, {
  name: 'account_id',
  omitDuplicateResolving: true
}, {
  name: 'tags'
}, {
  name: 'notes',
  omitDuplicateResolving: true
}, {
  name: 'relations',
  omitDuplicateResolving: true
}, {
  name: 'customfields',
  omitDuplicateResolving: true
}, {
  name: 'attachments',
  omitDuplicateResolving: true
}, {
  name: 'paths',
  omitDuplicateResolving: true
}, {
  name: 'type',
  omitDuplicateResolving: true
}, {
  name: 'memberroles',
  omitDuplicateResolving: true
}, {
  name: 'industry',
  omitDuplicateResolving: true
}, {
  name: 'groups',
  label: 'Groups'
} //_('Groups')
]);
/**
 * @namespace   Tine.Addressbook.Model
 * @class       Tine.Addressbook.Model.Contact
 * @extends     Tine.Tinebase.data.Record
 * @constructor
 * Model of a contact<br>
 * 
 * @author      Cornelius Weiss <c.weiss@metaways.de>
 */

Tine.Addressbook.Model.Contact = Tine.Tinebase.data.Record.create(Tine.Addressbook.Model.ContactArray, {
  appName: 'Addressbook',
  modelName: 'Contact',
  idProperty: 'id',
  titleProperty: 'n_fileas',
  // ngettext('Contact', 'Contacts', n); gettext('Contacts');
  recordName: 'Contact',
  recordsName: 'Contacts',
  containerProperty: 'container_id',
  // ngettext('Addressbook', 'Addressbooks', n); gettext('Addressbooks');
  containerName: 'Addressbook',
  containersName: 'Addressbooks',
  copyOmitFields: ['account_id', 'type', 'relations', 'n_short'],

  /**
   * returns true if record has an email address
   * @return {Boolean}
   */
  hasEmail: function hasEmail() {
    return this.get('email') || this.get('email_home');
  },

  /**
   * returns true preferred email if available
   * @return {String}
   */
  getPreferredEmail: function getPreferredEmail(preferred) {
    var preferred = preferred || 'email',
        other = preferred == 'email' ? 'email_home' : 'email';
    return this.get(preferred) || this.get(other);
  },
  getTitle: function getTitle() {
    var result = this.get('n_fn');
    var tinebaseApp = new Tine.Tinebase.Application({
      appName: 'Tinebase'
    });

    if (tinebaseApp.featureEnabled('featureShowAccountEmail')) {
      var email = this.getPreferredEmail();

      if (email) {
        result += ' (' + email + ')';
      }
    }

    return result;
  }
});
/**
 * get filtermodel of contact model
 * 
 * @namespace Tine.Addressbook.Model
 * @static
 * @return {Array} filterModel definition
 */

Tine.Addressbook.Model.Contact.getFilterModel = function () {
  var app = Tine.Tinebase.appMgr.get('Addressbook');
  var typeStore = [['contact', app.i18n._('Contact')], ['user', app.i18n._('User Account')]];
  var filters = [{
    label: i18n._('Quick Search'),
    field: 'query',
    operators: ['contains']
  }, {
    filtertype: 'tine.widget.container.filtermodel',
    app: app,
    recordClass: Tine.Addressbook.Model.Contact
  }, {
    filtertype: 'foreignrecord',
    linkType: 'foreignId',
    app: app,
    foreignRecordClass: Tine.Addressbook.Model.List,
    multipleForeignRecords: true,
    ownField: 'list'
  }, {
    filtertype: 'foreignrecord',
    linkType: 'foreignId',
    app: app,
    foreignRecordClass: Tine.Addressbook.Model.ListRole,
    multipleForeignRecords: true,
    ownField: 'list_role_id'
  }, {
    label: app.i18n._('Title'),
    field: 'n_prefix'
  }, {
    label: app.i18n._('First Name'),
    field: 'n_given'
  }, {
    label: app.i18n._('Last Name'),
    field: 'n_family'
  }, {
    label: app.i18n._('Middle Name'),
    field: 'n_middle'
  }, {
    label: app.i18n._('Short Name'),
    field: 'n_short'
  }, {
    label: app.i18n._('Company'),
    field: 'org_name'
  }, {
    label: app.i18n._('Unit'),
    field: 'org_unit'
  }, {
    label: app.i18n._('Phone'),
    field: 'telephone',
    operators: ['contains']
  }, {
    label: app.i18n._('Job Title'),
    field: 'title'
  }, {
    label: app.i18n._('Description'),
    field: 'note',
    valueType: 'fulltext'
  }, {
    label: app.i18n._('E-Mail'),
    field: 'email_query',
    operators: ['contains']
  }, {
    filtertype: 'tinebase.tag',
    app: app
  }, //        {label: app.i18n._('Job Role'),                                                 field: 'role'},
  //        {label: app.i18n._('Birthday'),    field: 'bday', valueType: 'date'},
  {
    label: app.i18n._('Street') + ' (' + app.i18n._('Company Address') + ')',
    field: 'adr_one_street',
    defaultOperator: 'equals'
  }, {
    label: app.i18n._('Region') + ' (' + app.i18n._('Company Address') + ')',
    field: 'adr_one_region',
    defaultOperator: 'equals'
  }, {
    label: app.i18n._('Postal Code') + ' (' + app.i18n._('Company Address') + ')',
    field: 'adr_one_postalcode',
    defaultOperator: 'equals'
  }, {
    label: app.i18n._('City') + '  (' + app.i18n._('Company Address') + ')',
    field: 'adr_one_locality'
  }, {
    label: app.i18n._('Country') + '  (' + app.i18n._('Company Address') + ')',
    field: 'adr_one_countryname',
    valueType: 'country'
  }, {
    label: app.i18n._('Street') + ' (' + app.i18n._('Private Address') + ')',
    field: 'adr_two_street',
    defaultOperator: 'equals'
  }, {
    label: app.i18n._('Region') + ' (' + app.i18n._('Private Address') + ')',
    field: 'adr_two_region',
    defaultOperator: 'equals'
  }, {
    label: app.i18n._('Postal Code') + ' (' + app.i18n._('Private Address') + ')',
    field: 'adr_two_postalcode',
    defaultOperator: 'equals'
  }, {
    label: app.i18n._('City') + ' (' + app.i18n._('Private Address') + ')',
    field: 'adr_two_locality'
  }, {
    label: app.i18n._('Country') + '  (' + app.i18n._('Private Address') + ')',
    field: 'adr_two_countryname',
    valueType: 'country'
  }, {
    label: app.i18n._('Type'),
    defaultValue: 'contact',
    valueType: 'combo',
    field: 'type',
    store: typeStore
  }, {
    label: i18n._('Last Modified Time'),
    field: 'last_modified_time',
    valueType: 'date'
  }, {
    label: i18n._('Last Modified By'),
    field: 'last_modified_by',
    valueType: 'user'
  }, {
    label: i18n._('Creation Time'),
    field: 'creation_time',
    valueType: 'date'
  }, {
    label: i18n._('Created By'),
    field: 'created_by',
    valueType: 'user'
  }, {
    label: app.i18n._('Salutation'),
    field: 'salutation',
    filtertype: 'tine.widget.keyfield.filter',
    app: app,
    keyfieldName: 'contactSalutation',
    defaultOperator: 'in'
  }];

  if (Tine.Tinebase.appMgr.get('Addressbook').featureEnabled('featureIndustry')) {
    filters.push({
      filtertype: 'foreignrecord',
      app: app,
      foreignRecordClass: Tine.Addressbook.Model.Industry,
      ownField: 'industry'
    });
  }

  return filters;
};
/**
 * default contact backend
 */


Tine.Addressbook.contactBackend = new Tine.Tinebase.data.RecordProxy({
  appName: 'Addressbook',
  modelName: 'Contact',
  recordClass: Tine.Addressbook.Model.Contact
});
/**
 * email address model
 */

Tine.Addressbook.Model.EmailAddress = Tine.Tinebase.data.Record.create([{
  name: 'n_fileas'
}, {
  name: 'emails'
}, {
  name: 'email'
}, {
  name: 'email_home'
}], {
  appName: 'Addressbook',
  modelName: 'EmailAddress',
  titleProperty: 'name',
  // ngettext('Email Address', 'Email Addresses', n); gettext('Email Addresses');
  recordName: 'Email Address',
  recordsName: 'Email Addresses',
  containerProperty: 'container_id',
  // ngettext('Addressbook', 'Addressbooks', n); gettext('Addressbooks');
  containerName: 'Addressbook',
  containersName: 'Addressbooks',
  copyOmitFields: ['group_id'],
  getPreferredEmail: function getPreferredEmail(preferred) {
    var emails = this.get("emails");

    if (!this.get("email") && !this.get("email_home")) {
      return this.get("emails");
    } else {
      var preferred = preferred || 'email',
          other = preferred == 'email' ? 'email_home' : 'email';
      return this.get(preferred) || this.get(other);
    }
  }
});
/**
 * get filtermodel of emailaddress model
 * 
 * @namespace Tine.Addressbook.Model
 * @static
 * @return {Array} filterModel definition
 */

Tine.Addressbook.Model.EmailAddress.getFilterModel = function () {
  return [{
    label: i18n._('Quick search'),
    field: 'query',
    operators: ['contains']
  }];
};
/**
 * Industry model
 */


Tine.Addressbook.Model.Industry = Tine.Tinebase.data.Record.create([{
  name: 'id'
}, {
  name: 'name'
}, {
  name: 'description'
}], {
  appName: 'Addressbook',
  modelName: 'Industry',
  titleProperty: 'name',
  // ngettext('Industry', 'Industries', n); gettext('Industries');
  recordName: 'Industry',
  recordsName: 'Industries'
});
/**
 * get filtermodel of Industry model
 *
 * @namespace Tine.Addressbook.Model
 * @static
 * @return {Array} filterModel definition
 */

Tine.Addressbook.Model.Industry.getFilterModel = function () {
  return [{
    label: i18n._('Quick search'),
    field: 'query',
    operators: ['contains']
  }];
};
/**
 * Structure (fake) model
 */


Tine.Addressbook.Model.Structure = Tine.Tinebase.data.Record.create([{
  name: 'id'
}, {
  name: 'name'
}, {
  name: 'description'
}], {
  appName: 'Addressbook',
  modelName: 'Structure',
  titleProperty: 'name',
  // ngettext('Structure', 'Structures', n); gettext('Structures');
  recordName: 'Structure',
  recordsName: 'Structures'
});

/***/ }),

/***/ 1644:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 *
 * @package     Addressbook
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Stefanie Stamer <s.stamer@metaways.de>
 * @copyright   Copyright (c) 2016 Metaways Infosystems GmbH (http://www.metaways.de)
 */

/*global Ext, Tine*/
Ext.ns('Tine.Addressbook');
/**
 * @namespace   Tine.Addressbook
 * @class       Tine.Addressbook.ListRoleEditDialog
 * @extends     Tine.widgets.dialog.EditDialog
 * Addressbook Edit Dialog <br>
 *
 * @author      Philipp Schüle <p.schuele@metaways.de>
 */

Tine.Addressbook.IndustryEditDialog = Ext.extend(Tine.widgets.dialog.SimpleRecordEditDialog, {
  windowNamePrefix: 'IndustryEditWindow_',
  appName: 'Addressbook',
  recordClass: Tine.Addressbook.Model.Industry
});
/**
 * Opens a new contact edit dialog window
 *
 * @return {Ext.ux.Window}
 */

Tine.Addressbook.IndustryEditDialog.openWindow = function (config) {
  var id = config.record && config.record.id ? config.record.id : 0;
  var window = Tine.WindowFactory.getWindow({
    width: 400,
    height: 300,
    name: Tine.Addressbook.IndustryEditDialog.prototype.windowNamePrefix + id,
    contentPanelConstructor: 'Tine.Addressbook.IndustryEditDialog',
    contentPanelConstructorConfig: config
  });
  return window;
};

/***/ }),

/***/ 1645:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 * Addressbook industry combo box
 * 
 * @package     Addressbook
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Philipp Schüle <p.schuele@metaways.de>
 * @copyright   Copyright (c) 2016 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 */
Ext.ns('Tine.Addressbook');
/**
 * Contract selection combo box
 * 
 * @namespace   Tine.Addressbook
 * @class       Tine.Addressbook.IndustrySearchCombo
 * @extends     Ext.form.ComboBox
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Philipp Schüle <p.schuele@metaways.de>log
 * @copyright   Copyright (c) 2016 Metaways Infosystems GmbH (http://www.metaways.de)
 * 
 * @param       {Object} config
 * @constructor
 * Create a new Tine.Addressbook.IndustrySearchCombo
 */

Tine.Addressbook.IndustrySearchCombo = Ext.extend(Tine.Tinebase.widgets.form.RecordPickerComboBox, {
  initComponent: function initComponent() {
    this.recordClass = Tine.Addressbook.Model.Industry;
    Tine.Addressbook.IndustrySearchCombo.superclass.initComponent.call(this);
    this.displayField = 'name';
    this.sortBy = 'name';
  }
});
Tine.widgets.form.RecordPickerManager.register('Addressbook', 'Industry', Tine.Addressbook.IndustrySearchCombo);

/***/ }),

/***/ 1646:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 * 
 * @package     Addressbook
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Alexander Stintzing <a.stintzing@metaways.de>
 * @copyright   Copyright (c) 2013 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 */
Ext.ns('Tine.Addressbook');
/**
 * @namespace   Tine.Addressbook
 * @class       Tine.Addressbook.GenericContactGridPanelHook
 * 
 * Hook prototype for other applications to hook into the addressbook contact grid context menu<br>
 * 
 * @author      Alexander Stintzing <a.stintzing@metaways.de>
 */

Tine.Addressbook.GenericContactGridPanelHook = function (config) {
  Tine.log.info('initialising addressbook hook');
  Ext.apply(this, config);
  this.recordClass = Tine[this.app.name].Model[this.modelName];
  var text = this.recordClass.getMeta('recordName');
  this.addRecordAction = new Ext.Action({
    actionType: 'add',
    requiredGrant: 'readGrant',
    text: this.app.i18n._(text),
    iconCls: this.app.getIconCls(),
    scope: this,
    handler: this.onUpdateRecord,
    allowMultiple: true,
    listeners: {
      scope: this,
      render: this.onRender
    }
  });
  this.newRecordAction = new Ext.Action({
    actionType: 'new',
    requiredGrant: 'readGrant',
    text: this.app.i18n._(text),
    iconCls: this.app.getIconCls(),
    scope: this,
    handler: this.onAddRecord,
    allowMultiple: true,
    listeners: {
      scope: this,
      render: this.onRender
    }
  });
  Ext.ux.ItemRegistry.registerItem('Addressbook-Contact-GridPanel-ContextMenu-Add', this.addRecordAction, 100);
  Ext.ux.ItemRegistry.registerItem('Addressbook-Contact-GridPanel-ContextMenu-New', this.newRecordAction, 100);
};

Ext.apply(Tine.Addressbook.GenericContactGridPanelHook.prototype, {
  /**
   * The hooking application
   * 
   * @type Tine.Tinebase.Application
   */
  app: null,

  /**
   * The hooking model name of the
   * 
   * @type 
   */
  modelName: null,

  /**
   * The Addressbook Contact Grid to hook into
   * 
   * @type {Tine.Addressbook.ContactGridPanel}
   */
  contactGridPanel: null,

  /**
   * get addressbook contact grid panel
   */
  getContactGridPanel: function getContactGridPanel() {
    if (!this.contactGridPanel) {
      this.contactGridPanel = Tine.Tinebase.appMgr.get('Addressbook').getMainScreen().getCenterPanel();
    }

    return this.contactGridPanel;
  },

  /**
   * add selected contacts to a new record
   * 
   * @param {Button} btn 
   */
  onAddRecord: function onAddRecord(btn) {
    var ms = this.app.getMainScreen(),
        cp = ms.getCenterPanel(),
        filter = this.getFilter(ms);

    if (!filter) {
      var addRelations = this.getSelectionsAsArray();
    } else {
      var addRelations = true;
    }

    cp.onEditInNewWindow.call(cp, 'add', null, [{
      ptype: 'addrelations_edit_dialog',
      selectionFilter: filter,
      addRelations: addRelations,
      callingApp: 'Addressbook',
      callingModel: 'Contact'
    }]);
  },

  /**
   * adds selected contacts to an existing record
   */
  onUpdateRecord: function onUpdateRecord() {
    var ms = this.app.getMainScreen(),
        cp = ms.getCenterPanel(),
        filter = this.getFilter(ms),
        sm = this.getContactGridPanel().selectionModel;

    if (!filter) {
      var addRelations = this.getSelectionsAsArray(),
          count = this.getSelectionsAsArray().length;
    } else {
      var addRelations = true,
          count = sm.store.totalLength;
    }

    var cn = 'AddTo' + this.modelName + 'Panel';
    Tine[this.app.name][cn].openWindow({
      count: count,
      selectionFilter: filter,
      addRelations: addRelations,
      callingApp: 'Addressbook',
      callingModel: 'Contact'
    });
  },

  /**
   * returns the current filter if is filter selection
   * @param {Tine.widgets.MainScreen}
   * @return {Object}
   */
  getFilter: function getFilter(ms) {
    var sm = this.getContactGridPanel().selectionModel,
        filter = null;

    if (sm.isFilterSelect) {
      var filter = sm.getSelectionFilter();
    }

    return filter;
  },

  /**
   * returns selected contacts
   * @returns {Array}
   */
  getSelectionsAsArray: function getSelectionsAsArray() {
    var contacts = this.getContactGridPanel().grid.getSelectionModel().getSelections(),
        cont = [];
    Ext.each(contacts, function (contact) {
      if (contact.data) cont.push(contact.data);
    });
    return cont;
  },

  /**
   * add to action updater the first time we render
   */
  onRender: function onRender() {
    var actionUpdater = this.getContactGridPanel().actionUpdater,
        registeredActions = actionUpdater.actions;

    if (registeredActions.indexOf(this.addRecordAction) < 0) {
      actionUpdater.addActions([this.addRecordAction]);
    }

    if (registeredActions.indexOf(this.newRecordAction) < 0) {
      actionUpdater.addActions([this.newRecordAction]);
    }
  }
});

/***/ }),

/***/ 1647:
/***/ (function(module, exports, __webpack_require__) {

/*
 * Tine 2.0
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Cornelius Weiss <c.weiss@metaways.de>
 * @copyright   Copyright (c) 2007-2017 Metaways Infosystems GmbH (http://www.metaways.de)
 */
Ext.ns('Tine.Addressbook');

__webpack_require__(1648);

__webpack_require__(1649);

__webpack_require__(1650);
/**
 * @namespace   Tine.Addressbook
 * @class       Tine.Addressbook.Application
 * @extends     Tine.Tinebase.Application
 * Addressbook Application Object <br>
 * 
 * @author      Cornelius Weiss <c.weiss@metaways.de>
 */


Tine.Addressbook.Application = Ext.extend(Tine.Tinebase.Application, {
  /**
   * auto hook text i18n._('New Contact')
   */
  addButtonText: 'New Contact',

  /**
   * Get translated application title of the calendar application
   * 
   * @return {String}
   */
  getTitle: function getTitle() {
    return this.i18n.ngettext('Addressbook', 'Addressbooks', 1);
  },

  /** 
   * Overide get main screen to allow for feature gating
   *
   **/
  getMainScreen: function getMainScreen() {
    var mainscreen = Tine.Addressbook.Application.superclass.getMainScreen.call(this);

    if (!Tine.Tinebase.appMgr.get('Addressbook').featureEnabled('featureListView') && !Tine.Tinebase.appMgr.get('Addressbook').featureEnabled('featureResources')) {
      mainscreen.useModuleTreePanel = false;
    }

    return mainscreen;
  },
  registerCoreData: function registerCoreData() {
    Tine.CoreData.Manager.registerGrid('adb_lists', Tine.Addressbook.ListGridPanel, {
      app: this,
      initialLoadAfterRender: false
    });
    Tine.CoreData.Manager.registerGrid('adb_industries', Tine.widgets.grid.GridPanel, {
      recordClass: Tine.Addressbook.Model.Industry,
      app: this,
      initialLoadAfterRender: false,
      // TODO move this to a generic place
      gridConfig: {
        autoExpandColumn: 'name',
        columns: [{
          id: 'id',
          header: this.i18n._("ID"),
          width: 150,
          sortable: true,
          dataIndex: 'id',
          hidden: true
        }, {
          id: 'name',
          header: this.i18n._("Name"),
          width: 300,
          sortable: true,
          dataIndex: 'name'
        }, {
          id: 'description',
          header: this.i18n._("Description"),
          width: 300,
          sortable: true,
          dataIndex: 'description',
          hidden: true
        }]
      }
    });
  }
});
/**
 * @namespace   Tine.Addressbook
 * @class       Tine.Addressbook.MainScreen
 * @extends     Tine.widgets.MainScreen
 * MainScreen of the Addressbook Application <br>
 * 
 * @author      Cornelius Weiss <c.weiss@metaways.de>
 */

Tine.Addressbook.MainScreen = Ext.extend(Tine.widgets.MainScreen, {
  activeContentType: 'Contact',
  contentTypes: [{
    model: 'Contact',
    requiredRight: null,
    singularContainerMode: false
  }],
  initComponent: function initComponent() {
    var app = Tine.Tinebase.appMgr.get('Addressbook');

    if (app.featureEnabled('featureListView')) {
      this.contentTypes.push({
        model: 'List',
        requiredRight: null,
        singularContainerMode: false
      });
    }

    if (app.featureEnabled('featureStructurePanel')) {
      this.contentTypes.push({
        contentType: 'structure',
        app: app,
        text: app.i18n._('Structure'),
        // _('Structure')
        iconCls: 'AddressbookStructure',
        xtype: 'addressbook.structurepanel'
      });
    } // only show if calendar is available and user has manage_resources right


    if (app.featureEnabled('featureResources') && Tine.Tinebase.common.hasRight('run', 'Calendar') && Tine.Tinebase.common.hasRight('manage', 'Calendar', 'resources')) {
      var cal = Tine.Tinebase.appMgr.get('Calendar');
      this.contentTypes.push({
        contentType: 'resource',
        app: cal,
        text: cal.i18n._('Resources'),
        iconCls: 'CalendarResource',
        xtype: 'calendar.resourcegridpanel',
        ownActionToolbar: false,
        singularContainerMode: true
      });
    }

    Tine.Addressbook.MainScreen.superclass.initComponent.call(this);
  }
});

Tine.Addressbook.ContactTreePanel = function (config) {
  Ext.apply(this, config);
  this.id = 'Addressbook_Contact_Tree';
  this.filterMode = 'filterToolbar';
  this.recordClass = Tine.Addressbook.Model.Contact;
  Tine.Addressbook.ContactTreePanel.superclass.constructor.call(this);
};

Ext.extend(Tine.Addressbook.ContactTreePanel, Tine.widgets.container.TreePanel);

Tine.Addressbook.ListTreePanel = function (config) {
  Ext.apply(this, config);
  this.id = 'Addressbook_List_Tree';
  this.filterMode = 'filterToolbar';
  this.recordClass = Tine.Addressbook.Model.List;
  Tine.Addressbook.ListTreePanel.superclass.constructor.call(this);
};

Ext.extend(Tine.Addressbook.ListTreePanel, Tine.widgets.container.TreePanel);
Tine.Addressbook.handleRequestException = Tine.Tinebase.ExceptionHandler.handleRequestException;

Tine.Addressbook.ContactFilterPanel = function (config) {
  Ext.apply(this, config);
  Tine.Addressbook.ContactFilterPanel.superclass.constructor.call(this);
};

Ext.extend(Tine.Addressbook.ContactFilterPanel, Tine.widgets.persistentfilter.PickerPanel, {
  filter: [{
    field: 'model',
    operator: 'equals',
    value: 'Addressbook_Model_ContactFilter'
  }]
});

Tine.Addressbook.ListFilterPanel = function (config) {
  Ext.apply(this, config);
  Tine.Addressbook.ListFilterPanel.superclass.constructor.call(this);
};

Ext.extend(Tine.Addressbook.ListFilterPanel, Tine.widgets.persistentfilter.PickerPanel, {
  filter: [{
    field: 'model',
    operator: 'equals',
    value: 'Addressbook_Model_ListFilter'
  }]
}); // register Contact related renderers -> needed e.g. for duplicate resolve dlg as Contact is no mcv2 app yet

Tine.Tinebase.appMgr.isInitialised('Addressbook').then(() => {
  _.each(Tine.Addressbook.ContactGridPanel.getBaseColumns(Tine.Tinebase.appMgr.get('Addressbook').i18n), col => {
    if (col.renderer) {
      Tine.widgets.grid.RendererManager.register('Addressbook', 'Contact', col.dataIndex, col.renderer);
    }
  });
}); // register grants for calendar containers

Tine.widgets.container.GrantsManager.register('Addressbook_Model_Contact', function (container) {
  var _ = window.lodash,
      me = this,
      grants = Tine.widgets.container.GrantsManager.defaultGrants(container);
  grants.push('privateData');
  return grants;
}); // register grants for calendar containers

Tine.widgets.container.GrantsManager.register('Addressbook_Model_List', function (container) {
  var _ = window.lodash,
      me = this,
      grants = Tine.widgets.container.GrantsManager.defaultGrants(container);
  grants.push('privateData');
  return grants;
});
Ext.override(Tine.widgets.container.GrantsGrid, {
  privateDataGrantTitle: i18n._('Private'),
  // i18n._('Private')
  privateDataGrantDescription: i18n._('The grant to access contacts private information') // i18n._('The grant to access contacts private information')

});

/***/ }),

/***/ 1648:
/***/ (function(module, exports, __webpack_require__) {

/*
 * Tine 2.0
 *
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Cornelius Weiß <c.weiss@metaways.de>
 * @copyright   Copyright (c) 2017 Metaways Infosystems GmbH (http://www.metaways.de)
 */
Ext.ns('Tine.Addressbook'); // @TODO: implement selection model
// @TODO: enable edit&delete btns // have action updater
// @TODO: show relation type - resove all relation types e.g. SITE -> Standort

Tine.Addressbook.StructurePanel = Ext.extend(Tine.widgets.grid.GridPanel, {
  /**
   * @property {cytoscape} cy
   */
  cy: null,
  // private
  recordClass: Tine.Tinebase.Model.Path,
  border: false,
  layout: 'border',
  usePagingToolbar: false,
  autoRefreshInterval: null,
  listenMessageBus: false,
  initComponent: function initComponent() {
    var me = this;
    this.app = Tine.Tinebase.appMgr.get('Addressbook');
    this.recordProxy = new Tine.Tinebase.data.RecordProxy({
      recordClass: this.recordClass
    });
    this.detailsPanel = new Ext.Container({
      layout: 'card',
      activeItem: 0,
      border: false,
      items: [new Ext.ux.display.DisplayPanel({
        id: 'none',
        border: false,
        layout: 'hbox',
        defaults: {
          margins: '0 5 0 0'
        },
        layoutConfig: {
          padding: '5',
          align: 'stretch'
        },
        items: [{
          cls: 'x-ux-display',
          layout: 'ux.display',
          flex: 1,
          layoutConfig: {
            background: 'solid',
            declaration: this.app.i18n._('Select record to see its details')
          }
        }, {
          flex: 1,
          border: false,
          layout: 'ux.display',
          layoutConfig: {
            background: 'border'
          },
          html: ['<p>', this.app.i18n._('This module visualises hierarchically depended relations between records of different types.'), '</p>', '<p>', this.app.i18n._('Hierarchically depended relations are created automatically for some data types like users and groups, but can also be created manually via the corresponding relation types.'), '</p>'].join('')
        }]
      })],
      doBind: function doBind() {}
    });
    Tine.Addressbook.StructurePanel.superclass.initComponent.call(this);
  },
  onDestroy: function onDestroy() {
    _.each(this.postalSubscriptions, subscription => {
      subscription.unsubscribe();
    });

    return this.supr().onDestroy.call(this);
  },
  initGrid: function initGrid() {
    var me = this,
        view = {};
    this.cyPanel = new Ext.Panel({
      // ref: '../cyPanel',
      tbar: [this.refresh = new Ext.Toolbar.Button({
        tooltip: Ext.PagingToolbar.prototype.refreshText,
        overflowText: Ext.PagingToolbar.prototype.refreshText,
        iconCls: 'x-tbar-loading',
        handler: this.doRefresh,
        scope: this
      }), '-'],
      layout: 'fit',
      border: false,
      getStore: function getStore() {
        return me.store;
      },
      getView: function getView() {
        return view;
      },
      getSelectionModel: function getSelectionModel() {
        return {
          getSelections: function getSelections() {
            return this.selectedNode;
          }
        };
      }
    }); // abstract code needs this name

    this.grid = this.cyPanel;
  },
  initActions: function initActions() {
    Tine.Addressbook.StructurePanel.superclass.initActions.apply(this, arguments);
    this.action_addInNewWindow.hide();
    this.action_editInNewWindow.hide();
    this.action_deleteRecord.hide();
    this.actions_print.hide();
  },
  // NOTE: not yet, reloading(relayout) resets viewport
  initMessageBus: function initMessageBus() {
    this.postalSubscriptions = [];
    this.postalSubscriptions.push(postal.subscribe({
      channel: "recordchange",
      topic: '*.*.update',
      callback: this.onRecordChanges.createDelegate(this)
    }));
  },

  /**
   * bus notified about record changes
   */
  onRecordChanges: function onRecordChanges(data, e) {
    var me = this,
        _ = window.lodash,
        appName = e.topic.split('.')[0],
        modelName = e.topic.split('.')[1],
        model = [appName, 'Model', modelName].join('_'),
        id = data.id;

    if (me.cy) {
      var eles = me.cy.filter('[id="' + id + '"]').filter('[model="' + model + '"]');

      if (eles.length) {
        me.doRefresh();
      }
    }
  },
  doRefresh: function doRefresh() {
    this.store.reload();
  },
  onRender: function onRender() {
    var me = this;
    me.isReady = Promise.all([me.cyPanel.afterIsRendered(), new Promise(function (resolve, reject) {
      __webpack_require__.e(/* require.ensure | Tinebase/js/cytoscape */ 32).then((function () {
        resolve(__webpack_require__(548));
      }).bind(null, __webpack_require__)).catch(__webpack_require__.oe);
    })]).then(function (values) {
      me.renderCy(values[1]);
    });
    Tine.Addressbook.StructurePanel.superclass.onRender.apply(this, arguments);
  },
  renderCy: function renderCy(cytoscape) {
    // init cy
    var me = this,
        _ = window.lodash; //,
    // elements = values[0];

    me.cy = cytoscape({
      container: me.cyPanel.body.dom,
      elements: [],
      boxSelectionEnabled: false,
      autounselectify: true,
      style: [{
        selector: 'node',
        css: {
          'shape': 'rectangle',
          'height': 20,
          'width': function width(ele) {
            return 20 + _.get(ele.data('recordData'), 'tags', []).length * 18;
          },
          'background-position-x': 0,
          'background-position-y': 0,
          'border-color': '#ffffff',
          'background-opacity': 0,
          'border-width': 3,
          'border-opacity': 0,
          'background-color': '#ffffff',
          'label': 'data(name)',
          'background-image': me.createImage,
          'background-fit': 'contain',
          'overlay-padding': '20'
        }
      }, {
        selector: 'node:selected',
        css: {
          'overlay-color': 'blue',
          'overlay-opacity': '0.2',
          'overlay-padding': '20'
        }
      }, {
        selector: 'edge',
        css: {
          // 'label': 'data(type)',
          'curve-style': 'bezier',
          'target-arrow-shape': 'triangle',
          'width': 4,
          'line-color': '#ddd',
          'target-arrow-color': '#ddd'
        }
      }]
    });
    me.cy.on('tap', _.bind(me.onTap, me));
  },

  /**
   * called before store queries for data
   */
  onStoreBeforeload: function onStoreBeforeload(store, options) {
    Tine.Addressbook.StructurePanel.superclass.onStoreBeforeload.apply(this, arguments); // filter = [{field: 'shadow_path', operator: 'contains', value: '{SITE}'}]

    var me = this;
    me.refresh.disable();
    me.showLoadMask();
  },

  /**
   * called after a new set of Records has been loaded
   *
   * @param  {Ext.data.Store} this.store
   * @param  {Array}          loaded records
   * @param  {Array}          load options
   * @return {Void}
   */
  onStoreLoad: function onStoreLoad(store, records, options) {
    Tine.Addressbook.StructurePanel.superclass.onStoreLoad.apply(this, arguments);
    var me = this,
        _ = window.lodash,
        elements = me.computeElements(records);
    me.resolveRecords(elements).then(me.isReady).then(function () {
      var cy = me.cy;
      cy.startBatch();
      cy.remove('*');
      cy.add(elements);
      cy.endBatch();
      cy.layout(me.getLayoutOpts()).run();
      me.refresh.enable();
      me.hideLoadMask();
    });
  },
  getLayoutOpts: function getLayoutOpts() {
    return {
      name: 'breadthfirst',
      directed: true,
      padding: 10
    };
  },
  onTap: function onTap(evt) {
    var evtTarget = evt.target; // for some reason cy internal selection model does not work :-(
    // -> might have to do with autounselectify opton :-)

    if (this.selectedNode) {
      this.selectedNode.style({
        'overlay-opacity': '0'
      });
    }

    if (evtTarget === this.cy) {
      this.detailsPanel.layout.setActiveItem(0);
      return;
    }

    if (evtTarget.isNode()) {
      var node = evtTarget,
          model = node.data('model'),
          id = node.data('id');
      this.selectedNode = node;
      this.selectedNode.style({
        'overlay-opacity': '0.2'
      }); // update detailsPanel

      var recordClass = Tine.Tinebase.data.RecordMgr.get(model),
          recordData = node.data('recordData'),
          record = new recordClass(recordData, node.data('id'));
      this.updateDetails(record); // @TODO later: update actions

      if (recordData && Ext.isDate(this.onTapLastTime) && this.onTapLastTime.getElapsed() < 500) {
        this.editRecord(record);
      }

      this.onTapLastTime = new Date();
    }
  },

  /**
   * NOTE: this is bullshit! The logic for opening a EditDialog is contained in the center panel
   *       but we don't want to fetch the centerpanel - we don't even know where to find it in some cases!
   *       -> let openWindow method deal with records!
   *       -> we have the same problem in the relations genericPickerGridPanel!
   * @param record
   */
  editRecord: function editRecord(record) {
    var _ = window.lodash,
        appName = record.appName,
        modelName = record.modelName,
        openMethod = _.get(Tine, appName + '.' + modelName + 'EditDialog.openWindow');

    if (openMethod) {
      openMethod({
        record: record,
        listeners: {
          scope: this,
          'update': this.doRefresh
        }
      });
    }
  },
  updateDetails: function updateDetails(record) {
    var key = record.appName + '.' + record.modelName,
        detailsPanel = this.detailsPanel.get(key);

    if (!detailsPanel) {
      switch (key) {
        case 'Addressbook.Contact':
          var dp = new Tine.Addressbook.ContactGridDetailsPanel({
            i18n: Tine.Tinebase.appMgr.get('Addressbook').i18n
          }),
              detailsPanel = dp.getSingleRecordPanel();
          break;

        default:
          detailsPanel = new Ext.Panel({
            id: key,
            loadRecord: Ext.emptyFn,
            border: false,
            layout: 'fit',
            padding: 5,
            items: [{
              cls: 'x-ux-display',
              layout: 'ux.display',
              layoutConfig: {
                background: 'solid'
              }
            }]
          });
          break;
      }

      this.detailsPanel.items.add(key, detailsPanel);
    }

    this.detailsPanel.layout.setActiveItem(key);
    detailsPanel.loadRecord(record);
  },
  resolveRecords: function resolveRecords(elements) {
    var _ = window.lodash,
        me = this,
        promises = [];

    _.each(_.groupBy(elements.nodes, 'data.model'), function (data, modelName) {
      var ids = _.map(data, 'data.id'),
          method = _.get(Tine, modelName.replace(/_.*$/, '') + '.search' + modelName.replace(/^.*_/, '') + 's');

      promises.push(method([{
        field: 'id',
        operator: 'in',
        value: ids
      }], {}).then(function (response) {
        _.each(response.results, function (recordData) {
          _.set(_.find(data, function (o) {
            return _.get(o, 'data.id') == recordData.id;
          }), 'data.recordData', recordData);
        });
      }).catch(function (error) {}));
    });

    return Promise.all(promises);
  },
  // els & edges
  computeElements: function computeElements(paths) {
    var _ = window.lodash,
        me = this,
        elements = {
      nodes: [],
      edges: []
    },
        processed = [];

    _.each(paths, function (path) {
      var pathData = path.data,
          names = String(pathData.path).replace(/^\//, '').split('/'),
          ids = String(pathData.shadow_path).replace(/^\//, '').split('/'),
          lastId = false,
          type = '';

      _.each(names, function (name) {
        var parts = ids.shift().match(/\{(.+)\}([^{]+)(?:\{(.*)\})?/),
            model = parts[1],
            id = parts[2],
            elId; // @TODO: map list-role to edgetype?

        if (model == 'Addressbook_Model_ListRole') return;
        name = name.replace(/{.*}$/, '');

        if (lastId) {
          // edge
          elId = lastId + id + type;

          if (processed.indexOf(elId) < 0) {
            elements.edges.push({
              data: {
                id: elId,
                source: lastId,
                target: id,
                type: type
              }
            });
            processed.push(elId);
          }
        } // node


        elId = model + id;

        if (processed.indexOf(elId) < 0) {
          elements.nodes.push({
            data: {
              id: id,
              name: name,
              model: model
            }
          });
          processed.push(elId);
        }

        lastId = id;
        type = parts[3];
      });
    });

    return elements;
  },
  createImage: function createImage(ele) {
    var _ = window.lodash,
        tags = _.get(ele.data('recordData'), 'tags', []),
        recordImage = _.get(ele.data('recordData'), 'jpegphoto'),
        iconCls = '.' + ele.data('model').replace('_Model_', ''),
        url = function url(data) {
      return data;
    },
        cssRule = Ext.util.CSS.getRule(iconCls) || Ext.util.CSS.getRule('.ApplicationIconCls'),
        iconData = cssRule.style.backgroundImage,
        iconImage = new Image(),
        canvas = document.createElement('canvas'),
        ctx = canvas.getContext('2d');

    canvas.width = 20 + tags.length * 18;
    canvas.height = 18;
    iconImage.src = eval(iconData);
    ctx.drawImage(iconImage, 0, 0, 18, 18);
    ctx.strokeStyle = "#000000";

    _.each(tags, function (tag, idx) {
      ctx.fillStyle = tag.color;
      ctx.beginPath();
      ctx.arc(20 + 9 + idx * 18, 8, 7, 0, Math.PI * 2, true);
      ctx.closePath();
      ctx.fill();
      ctx.stroke();
    });

    return 'url("' + canvas.toDataURL() + '")';
  },
  showLoadMask: function showLoadMask() {
    var me = this;
    return me.afterIsRendered().then(function () {
      if (!me.loadMask) {
        me.loadMask = new Ext.LoadMask(me.getEl(), {
          msg: me.app.i18n._("Loading Structure data...")
        });
      }

      me.loadMask.show.defer(100, me.loadMask);
    });
  },
  hideLoadMask: function hideLoadMask() {
    this.loadMask.hide.defer(100, this.loadMask);
    return Promise.resolve();
  }
});
Ext.reg('addressbook.structurepanel', Tine.Addressbook.StructurePanel);
Tine.Addressbook.StructureWestPanel = Ext.extend(Tine.widgets.mainscreen.WestPanel, {
  recordClass: Tine.Tinebase.Model.Path,
  hasContainerTreePanel: false,
  hasFavoritesPanel: true
});

/***/ }),

/***/ 1649:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 *
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Cornelius Weiss <c.weiss@metaways.de>
 * @copyright   Copyright (c) 2018 Metaways Infosystems GmbH (http://www.metaways.de)
 */

/**
 * Model of a grant
 */
Tine.Addressbook.Model.ContactPersonalGrants = Tine.Tinebase.data.Record.create([{
  name: 'id'
}, {
  name: 'account_id'
}, {
  name: 'account_type'
}, {
  name: 'account_name'
}, {
  name: 'readGrant',
  type: 'boolean'
}, {
  name: 'addGrant',
  type: 'boolean'
}, {
  name: 'editGrant',
  type: 'boolean'
}, {
  name: 'deleteGrant',
  type: 'boolean'
}, {
  name: 'privateGrant',
  type: 'boolean'
}, {
  name: 'exportGrant',
  type: 'boolean'
}, {
  name: 'syncGrant',
  type: 'boolean'
}, {
  name: 'adminGrant',
  type: 'boolean'
}, {
  name: 'freebusyGrant',
  type: 'boolean'
}, {
  name: 'downloadGrant',
  type: 'boolean'
}, {
  name: 'publishGrant',
  type: 'boolean'
}, {
  name: 'privateDataGrant',
  type: 'boolean'
}], {
  appName: 'Addressbook',
  modelName: 'ContactPersonalGrants',
  idProperty: 'id',
  titleProperty: 'account_name',
  // ngettext('Contact Personal Grant', 'Contact Personal Grants', n); gettext('Contact Personal Grant');
  recordName: 'Contact Personal Grant',
  recordsName: 'Contact Personal Grants'
}); // register grants for calendar containers

Tine.widgets.container.GrantsManager.register('Addressbook_Model_Contact', function (container) {
  var _ = window.lodash,
      me = this,
      grantsModelName = _.get(container, 'xprops.Tinebase.Container.GrantsModel', 'Tinebase_Model_Grants');

  if (grantsModelName == 'Addressbook_Model_ContactPersonalGrants') {
    var grants = Tine.widgets.container.GrantsManager.defaultGrants(container);
    grants.push('privateDataGrant');
    return grants;
  } else {
    var grants = Tine.widgets.container.GrantsManager.defaultGrants(container);
    return grants;
  }
});

/***/ }),

/***/ 1650:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 *
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Cornelius Weiss <c.weiss@metaways.de>
 * @copyright   Copyright (c) 2018 Metaways Infosystems GmbH (http://www.metaways.de)
 */

/**
 * Model of a grant
 */
Tine.Addressbook.Model.ListPersonalGrants = Tine.Tinebase.data.Record.create([{
  name: 'id'
}, {
  name: 'account_id'
}, {
  name: 'account_type'
}, {
  name: 'account_name'
}, {
  name: 'readGrant',
  type: 'boolean'
}, {
  name: 'addGrant',
  type: 'boolean'
}, {
  name: 'editGrant',
  type: 'boolean'
}, {
  name: 'deleteGrant',
  type: 'boolean'
}, {
  name: 'privateGrant',
  type: 'boolean'
}, {
  name: 'exportGrant',
  type: 'boolean'
}, {
  name: 'syncGrant',
  type: 'boolean'
}, {
  name: 'adminGrant',
  type: 'boolean'
}, {
  name: 'freebusyGrant',
  type: 'boolean'
}, {
  name: 'downloadGrant',
  type: 'boolean'
}, {
  name: 'publishGrant',
  type: 'boolean'
}, {
  name: 'privateDataGrant',
  type: 'boolean'
}], {
  appName: 'Addressbook',
  modelName: 'ListPersonalGrants',
  idProperty: 'id',
  titleProperty: 'account_name',
  // ngettext('List Personal Grant', 'List Personal Grants', n); gettext('List Personal Grant');
  recordName: 'List Personal Grant',
  recordsName: 'List Personal Grants'
}); // register grants for calendar containers

Tine.widgets.container.GrantsManager.register('Addressbook_Model_List', function (container) {
  var _ = window.lodash,
      me = this,
      grantsModelName = _.get(container, 'xprops.Tinebase.Container.GrantsModel', 'Tinebase_Model_Grants');

  if (grantsModelName == 'Addressbook_Model_ListPersonalGrants') {
    var grants = Tine.widgets.container.GrantsManager.defaultGrants(container);
    grants.push('privateDataGrant');
    return grants;
  } else {
    var grants = Tine.widgets.container.GrantsManager.defaultGrants(container);
    return grants;
  }
});

/***/ }),

/***/ 1651:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 *
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Michael Spahn <m.spahn@metaways.de>
 * @copyright   Copyright (c) 2017 Metaways Infosystems GmbH (http://www.metaways.de)
 */
Ext.ns('Tine.Addressbook');
/**
 * Render given addresss
 *
 * You need to pass the record and a config to use this renderer.
 * The config contains a mapping, which fields from the record should have which place in the template.
 * Undefined fields won't be rendered, this keeps it well reusable for all address like purposes.
 *
 * @namespace   Tine.Addressbook
 * @author      Michael Spahn <m.spahn@metaways.de>
 * @singleton
 */

Tine.Addressbook.addressRenderer = function (v, metadata, record, store, a, b, config) {
  var template = new Ext.XTemplate('<tpl for="." class="address">' + '<tpl if="street">{street} <br /></tpl>' + '<tpl if="street2">{street2} <br /></tpl>' + '<tpl if="postalcode">{postalcode}</tpl> <tpl if="locality">{locality}</tpl><br />' + '<tpl if="region">{region} <br /></tpl>' + '<tpl if="country">{country}</tpl>' + '</tpl>');
  template.compile();

  if (!record) {
    return template.applyTemplate({
      street: '',
      street2: '',
      postalcode: '',
      locality: '',
      region: '',
      country: ''
    });
  }

  var local = Ext.apply({}, config);
  var keys = Object.keys(local); // According to config, resolve the given fields from record

  keys.forEach(function (key) {
    var value = null;

    if (!record.data) {
      value = window.lodash.get(record, local[key]);
    } else {
      value = window.lodash.get(record.data, local[key]);
    }

    local[key] = Tine.Tinebase.EncodingHelper.encode(value); // Country code to country name
    // @todo: Wouldn't it be cool, if this could be managed by the modelconfig as well?

    if (key === 'country') {
      var countryRenderer = Tine.widgets.grid.RendererManager.get("Addressbook", "Addressbook_Model_Contact", "country", "displayPanel");
      local[key] = countryRenderer(local[key]);
    }
  });
  return template.applyTemplate(local);
};

Tine.widgets.grid.RendererManager.register('Addressbook', 'Addressbook_Model_Contact', 'addressblock', Tine.Addressbook.addressRenderer, 'displayPanel');

/***/ }),

/***/ 1652:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 *
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Michael Spahn <m.spahn@metaways.de>
 * @copyright   Copyright (c) 2017 Metaways Infosystems GmbH (http://www.metaways.de)
 */
Ext.ns('Tine.Addressbook');
/**
 * Render country name by it's iso code
 *
 * @namespace   Tine.Addressbook
 * @author      Michael Spahn <m.spahn@metaways.de>
 * @singleton
 */

Tine.Addressbook.countryRenderer = function (v) {
  return Locale.getTranslationData('CountryList', v);
};

Tine.widgets.grid.RendererManager.register('Addressbook', 'Addressbook_Model_Contact', 'country', Tine.Addressbook.countryRenderer, 'displayPanel');

/***/ }),

/***/ 1653:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 *
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Michael Spahn <m.spahn@metaways.de>
 * @copyright   Copyright (c) 2017 Metaways Infosystems GmbH (http://www.metaways.de)
 */
Ext.ns('Tine.Addressbook');
/**
 * Render given MailAddresss
 *
 * @namespace   Tine.Addressbook
 * @author      Michael Spahn <m.spahn@metaways.de>
 * @singleton
 */

Tine.Addressbook.mailAddressRenderer = function (email) {
  if (!email) {
    return '';
  }

  email = Tine.Tinebase.EncodingHelper.encode(email);
  var link = this.felamimail === true ? '#' : 'mailto:' + email;
  var id = Ext.id() + ':' + email;
  return '<a href="' + link + '" class="tinebase-email-link" id="' + id + '">' + Ext.util.Format.ellipsis(email, 18) + '</a>';
};

Tine.widgets.grid.RendererManager.register('Addressbook', 'Addressbook_Model_Contact', 'email', Tine.Addressbook.mailAddressRenderer, 'displayPanel');

/***/ }),

/***/ 1654:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 *
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Michael Spahn <m.spahn@metaways.de>
 * @copyright   Copyright (c) 2017 Metaways Infosystems GmbH (http://www.metaways.de)
 */
Ext.ns('Tine.Addressbook');
/**
 * Render given image
 *
 * @namespace   Tine.Addressbook
 * @author      Michael Spahn <m.spahn@metaways.de>
 * @singleton
 */

Tine.Addressbook.imageRenderer = function (jpegphoto, metadata, record) {
  function getImageUrl(url, width, height, contact) {
    var _ = window.lodash,
        mtime = _.get(contact, 'data.last_modified_time') || _.get(contact, 'data.creation_time') || null;

    if (url.match(/&/)) {
      url = Ext.ux.util.ImageURL.prototype.parseURL(url);
      url.width = width;
      url.height = height;
      url.ratiomode = 0;
      url.mtime = Ext.isDate(mtime) ? mtime.getTime() : new Date().getTime();
    }

    return url;
  }

  var url = getImageUrl(jpegphoto, 90, 113, record);
  return '<img src="' + url + '" />';
};

Tine.widgets.grid.RendererManager.register('Addressbook', 'Addressbook_Model_Contact', 'image', Tine.Addressbook.imageRenderer, 'displayPanel');

/***/ }),

/***/ 1655:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 *
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Michael Spahn <m.spahn@metaways.de>
 * @copyright   Copyright (c) 2017 Metaways Infosystems GmbH (http://www.metaways.de)
 */
Ext.ns('Tine.Addressbook');
/**
 * Render given URL as html
 *
 * @namespace   Tine.Addressbook
 * @author      Michael Spahn <m.spahn@metaways.de>
 * @singleton
 */

Tine.Addressbook.urlRenderer = function (url) {
  return '<a href=' + Tine.Tinebase.EncodingHelper.encode(url, 'href') + ' target="_blank">' + Tine.Tinebase.EncodingHelper.encode(url, 'shorttext') + '</a>';
};

Tine.widgets.grid.RendererManager.register('Addressbook', 'Addressbook_Model_Contact', 'url', Tine.Addressbook.urlRenderer, 'displayPanel');

/***/ }),

/***/ 1656:
/***/ (function(module, exports) {

/**
 * Tine 2.0
 *
 * @package     Addressbook
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Philipp Schuele <p.schuele@metaways.de>
 * @copyright   Copyright (c) 2007-2017 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 * TODO         add preference for sending mails with felamimail or mailto?
 */
Ext.ns('Tine.Addressbook');
/**
 * the details panel (shows contact details)
 *
 * @namespace   Tine.Addressbook
 * @class       Tine.Addressbook.ContactGridDetailsPanel
 * @extends     Tine.widgets.grid.DetailsPanel
 */

Tine.Addressbook.ContactGridDetailsPanel = Ext.extend(Tine.widgets.grid.DetailsPanel, {
  il8n: null,
  felamimail: false,
  recordClass: Tine.Addressbook.Model.Contact,
  getSingleRecordPanel: function getSingleRecordPanel() {
    var me = this;

    if (!this.singleRecordPanel) {
      this.singleRecordPanel = new Tine.widgets.display.RecordDisplayPanel({
        recordClass: this.recordClass,
        getBodyItems: function getBodyItems() {
          return [{
            layout: 'hbox',
            flex: 1,
            border: false,
            layoutConfig: {
              padding: '0',
              align: 'stretch'
            },
            defaults: {
              margins: '0 5 0 0'
            },
            items: [{
              width: 90,
              layout: 'ux.display',
              layoutConfig: {
                background: 'solid'
              },
              items: [{
                xtype: 'ux.displayfield',
                name: 'jpegphoto',
                cls: 'preview-panel-image',
                anchor: '100% 100%',
                hideLabel: true,
                htmlEncode: false,
                renderer: Tine.widgets.grid.RendererManager.get('Addressbook', 'Addressbook_Model_Contact', 'image', 'displayPanel').createDelegate(me)
              }]
            }, {
              flex: 1,
              layout: 'ux.display',
              labelWidth: 60,
              layoutConfig: {
                background: 'solid'
              },
              items: [{
                layout: 'hbox',
                border: false,
                anchor: '100% 100%',
                layoutConfig: {
                  align: 'stretch'
                },
                items: [{
                  layout: 'ux.display',
                  layoutConfig: {
                    background: 'inner',
                    labelLWidth: 100,
                    declaration: this.app.i18n._('Business')
                  },
                  labelAlign: 'top',
                  border: false,
                  flex: 1,
                  items: [{
                    xtype: 'ux.displayfield',
                    name: 'org_name',
                    hideLabel: true,
                    htmlEncode: false,
                    renderer: function renderer(value) {
                      return '<b>' + Tine.Tinebase.EncodingHelper.encode(value) + '</b>';
                    }
                  }, {
                    xtype: 'ux.displayfield',
                    name: 'dtstart',
                    hideLabel: true,
                    htmlEncode: false,
                    renderer: Tine.widgets.grid.RendererManager.get('Addressbook', 'Addressbook_Model_Contact', 'addressblock', 'displayPanel').createDelegate(me, {
                      'street': 'adr_one_street',
                      'street2': 'adr_one_street2',
                      'postalcode': 'adr_one_postalcode',
                      'locality': 'adr_one_locality',
                      'region': 'adr_one_region',
                      'country': 'adr_one_countryname'
                    }, true)
                  }]
                }, {
                  layout: 'ux.display',
                  layoutConfig: {
                    background: 'inner'
                  },
                  labelWidth: 50,
                  flex: 1,
                  border: false,
                  items: [{
                    xtype: 'ux.displayfield',
                    name: 'tel_work',
                    fieldLabel: this.app.i18n._('Phone')
                  }, {
                    xtype: 'ux.displayfield',
                    name: 'tel_cell',
                    fieldLabel: this.app.i18n._('Mobile')
                  }, {
                    xtype: 'ux.displayfield',
                    name: 'tel_fax',
                    fieldLabel: this.app.i18n._('Fax')
                  }, {
                    xtype: 'ux.displayfield',
                    name: 'email',
                    fieldLabel: this.app.i18n._('E-Mail'),
                    htmlEncode: false,
                    renderer: Tine.widgets.grid.RendererManager.get('Addressbook', 'Addressbook_Model_Contact', 'email', 'displayPanel').createDelegate(me)
                  }, {
                    xtype: 'ux.displayfield',
                    name: 'url',
                    fieldLabel: this.app.i18n._('Web'),
                    htmlEncode: false,
                    renderer: Tine.widgets.grid.RendererManager.get('Addressbook', 'Addressbook_Model_Contact', 'url', 'displayPanel').createDelegate(me)
                  }]
                }]
              }]
            }, {
              flex: 1,
              layout: 'ux.display',
              labelWidth: 60,
              layoutConfig: {
                background: 'solid'
              },
              items: [{
                layout: 'hbox',
                border: false,
                anchor: '100% 100%',
                layoutConfig: {
                  align: 'stretch'
                },
                items: [{
                  layout: 'ux.display',
                  layoutConfig: {
                    background: 'inner',
                    labelLWidth: 100,
                    declaration: this.app.i18n._('Private')
                  },
                  labelAlign: 'top',
                  border: false,
                  flex: 1,
                  // @todo: this field doesn't actually require a certain field, there should be two methods for RenderManager:
                  //  + get()
                  //  + getBlock() // block actually doesn't specify a certain field and only an record, the field declaration should come from the modelconfig later
                  items: [{
                    xtype: 'ux.displayfield',
                    name: 'attendee',
                    hideLabel: true,
                    htmlEncode: false,
                    renderer: Tine.widgets.grid.RendererManager.get('Addressbook', 'Addressbook_Model_Contact', 'addressblock', 'displayPanel').createDelegate(me, {
                      'street': 'adr_two_street',
                      'street2': 'adr_two_street2',
                      'postalcode': 'adr_two_postalcode',
                      'locality': 'adr_two_locality',
                      'region': 'adr_two_region',
                      'country': 'adr_two_countryname'
                    }, true)
                  }]
                }, {
                  layout: 'ux.display',
                  layoutConfig: {
                    background: 'inner'
                  },
                  labelWidth: 50,
                  flex: 1,
                  border: false,
                  items: [{
                    xtype: 'ux.displayfield',
                    name: 'tel_home',
                    fieldLabel: this.app.i18n._('Phone')
                  }, {
                    xtype: 'ux.displayfield',
                    name: 'tel_cell_private',
                    fieldLabel: this.app.i18n._('Mobile')
                  }, {
                    xtype: 'ux.displayfield',
                    name: 'tel_fax_home',
                    fieldLabel: this.app.i18n._('Fax')
                  }, {
                    xtype: 'ux.displayfield',
                    name: 'email_home',
                    fieldLabel: this.app.i18n._('E-Mail'),
                    htmlEncode: false,
                    renderer: Tine.widgets.grid.RendererManager.get('Addressbook', 'Addressbook_Model_Contact', 'email', 'displayPanel').createDelegate(me)
                  }]
                }]
              }]
            }, {
              flex: 1,
              layout: 'fit',
              border: false,
              items: [{
                cls: 'x-ux-display-background-border',
                xtype: 'ux.displaytextarea',
                name: 'note'
              }]
            }]
          }];
        }
      });
    }

    return this.singleRecordPanel;
  },

  /**
   * add on click event after render
   */
  afterRender: function afterRender() {
    Tine.Addressbook.ContactGridDetailsPanel.superclass.afterRender.apply(this, arguments);

    if (this.felamimail === true) {
      this.body.on('click', this.onClick, this);
    }
  },
  onClick: function onClick(e) {}
});

/***/ }),

/***/ 1657:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Cornelius Weiss <c.weiss@metaways.de>
 * @copyright   Copyright (c) 2010 Metaways Infosystems GmbH (http://www.metaways.de)
 */
Ext.ns('Tine.Calendar');
/**
 * @namespace   Tine.Calendar
 * @class       Tine.Addressbook.ContactFilterModel
 * @extends     Tine.widgets.grid.FilterModel
 * 
 * @author      Cornelius Weiss <c.weiss@metaways.de>
 */

Tine.Addressbook.ContactFilterModel = Ext.extend(Tine.widgets.grid.FilterModel, {
  /**
   * @property Tine.Tinebase.Application app
   */
  app: null,
  field: 'contact_id',
  defaultOperator: 'equals',

  /**
   * @private
   */
  initComponent: function initComponent() {
    Tine.Addressbook.ContactFilterModel.superclass.initComponent.call(this);
    this.app = Tine.Tinebase.appMgr.get('Addressbook');
    this.operators = ['equals'
    /*, 'notin'*/
    ];
    this.label = this.label || this.app.i18n._('Contact');
  },

  /**
   * value renderer
   * 
   * @param {Ext.data.Record} filter line
   * @param {Ext.Element} element to render to 
   */
  valueRenderer: function valueRenderer(filter, el) {
    var value = new Tine.Addressbook.SearchCombo({
      app: this.app,
      filter: filter,
      listWidth: 400,
      listAlign: 'tr-br?',
      value: filter.data.value ? filter.data.value : this.defaultValue,
      renderTo: el,
      getValue: function getValue() {
        return this.selectedRecord.id;
      },
      onSelect: function onSelect(record) {
        this.setValue(record);
        this.collapse();
        this.fireEvent('select', this, record);

        if (this.blurOnSelect) {
          this.fireEvent('blur', this);
        }
      },
      setValue: function setValue(value) {
        this.selectedRecord = value;
        var displayValue = Tine.Calendar.AttendeeGridPanel.prototype.renderAttenderUserName.call(this, value);
        Tine.Addressbook.SearchCombo.superclass.setValue.call(this, displayValue);
      }
    });
    value.on('select', this.onFiltertrigger, this);
    return value;
  }
});
Tine.widgets.grid.FilterToolbar.FILTERS['addressbook.contact'] = Tine.Addressbook.ContactFilterModel;

/***/ }),

/***/ 1658:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 *
 * @package     Addressbook
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Cornelius Weiss <c.weiss@metaways.de>
 * @copyright   Copyright (c) 2009-2012 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 */

/*global Ext, Tine*/
Ext.ns('Tine.Addressbook');
/**
 * @namespace   Tine.Addressbook
 * @class       Tine.Addressbook.ContactEditDialog
 * @extends     Tine.widgets.dialog.EditDialog
 * Addressbook Edit Dialog <br>
 *
 * @author      Cornelius Weiss <c.weiss@metaways.de>
 */

Tine.Addressbook.ContactEditDialog = Ext.extend(Tine.widgets.dialog.EditDialog, {
  /**
   * parse address button
   * @type Ext.Button
   */
  parseAddressButton: null,
  windowNamePrefix: 'ContactEditWindow_',
  appName: 'Addressbook',
  recordClass: Tine.Addressbook.Model.Contact,
  showContainerSelector: true,
  multipleEdit: true,
  displayNotes: true,
  preferredAddressBusinessCheckbox: null,
  preferredAddressPrivateCheckbox: null,
  getFormItems: function getFormItems() {
    if (Tine.Tinebase.configManager.get('mapPanel') && Tine.widgets.MapPanel) {
      this.mapPanel = new Tine.Addressbook.MapPanel({
        pos: 30,
        layout: 'fit',
        title: this.app.i18n._('Map'),
        disabled: (Ext.isEmpty(this.record.get('adr_one_lon')) || Ext.isEmpty(this.record.get('adr_one_lat'))) && (Ext.isEmpty(this.record.get('adr_two_lon')) || Ext.isEmpty(this.record.get('adr_two_lat')))
      });
      Tine.widgets.dialog.MultipleEditDialogPlugin.prototype.registerSkipItem(this.mapPanel);
    } else {
      this.mapPanel = new Ext.Panel({
        layout: 'fit',
        title: this.app.i18n._('Map'),
        disabled: true,
        html: ''
      });
    }

    var allLanguages = Locale.getTranslationList('Language');
    this.preferredAddressBusinessCheckbox = new Ext.form.Checkbox({
      checked: this.record.get('preferred_address') === "0",
      hideLabel: false,
      fieldLabel: this.app.i18n._('Preferred Address'),
      listeners: {
        'check': function check(checkbox, value) {
          if (value) {
            this.preferredAddressPrivateCheckbox.setValue(false);
            this.record.set('preferred_address', 0);
          }
        },
        scope: this
      }
    });
    this.preferredAddressPrivateCheckbox = new Ext.form.Checkbox({
      checked: this.record.get('preferred_address') === "1",
      hideLabel: false,
      fieldLabel: this.app.i18n._('Preferred Address'),
      listeners: {
        'check': function check(checkbox, value) {
          if (value) {
            this.preferredAddressBusinessCheckbox.setValue(false);
            this.record.set('preferred_address', 1);
          }
        },
        scope: this
      }
    });

    if (Tine.Tinebase.common.hasRight('run', 'Calendar', null) && Tine.Tinebase.appMgr.get('Addressbook').featureEnabled('featureContactEventList') && this.record.id !== 0) {
      this.contactEventPanel = new Tine.Calendar.ContactEventsGridPanel({
        editDialog: this,
        hasFavoritesPanel: false
      });
    } else {
      this.contactEventPanel = null;
    }

    var contactNorthPanel = {
      xtype: 'fieldset',
      region: 'north',
      autoHeight: true,
      title: this.app.i18n._('Personal Information'),
      items: [{
        xtype: 'panel',
        layout: 'hbox',
        align: 'stretch',
        plugins: [{
          ptype: 'ux.itemregistry',
          key: 'Tine.Addressbook.editDialog.northPanel'
        }],
        items: [{
          flex: 1,
          xtype: 'columnform',
          autoHeight: true,
          style: 'padding-right: 5px;',
          items: [[new Tine.Tinebase.widgets.keyfield.ComboBox({
            fieldLabel: this.app.i18n._('Salutation'),
            name: 'salutation',
            app: 'Addressbook',
            keyFieldName: 'contactSalutation',
            value: '',
            columnWidth: 0.35,
            listeners: {
              scope: this,
              'select': function select(combo, record, index) {
                var jpegphoto = this.getForm().findField('jpegphoto'); // set new empty photo depending on chosen salutation only if user doesn't have own image

                jpegphoto.setDefaultImage(record.json.image || 'images/icon-set/icon_undefined_contact.svg');
              }
            }
          }), {
            columnWidth: Tine.Tinebase.appMgr.get('Addressbook').featureEnabled('featureShortName') ? 0.35 : 0.65,
            fieldLabel: this.app.i18n._('Title'),
            name: 'n_prefix',
            maxLength: 64
          }, {
            // This was Phil's idea...
            columnWidth: Tine.Tinebase.appMgr.get('Addressbook').featureEnabled('featureShortName') ? 0.30 : 0.001,
            fieldLabel: this.app.i18n._('Short Name'),
            name: 'n_short',
            maxLength: 10,
            hidden: !Tine.Tinebase.appMgr.get('Addressbook').featureEnabled('featureShortName')
          }], [{
            columnWidth: 0.35,
            fieldLabel: this.app.i18n._('First Name'),
            name: 'n_given',
            maxLength: 64
          }, {
            columnWidth: 0.30,
            fieldLabel: this.app.i18n._('Middle Name'),
            name: 'n_middle',
            maxLength: 64
          }, {
            columnWidth: 0.35,
            fieldLabel: this.app.i18n._('Last Name'),
            name: 'n_family',
            maxLength: 255
          }], [{
            columnWidth: 0.65,
            xtype: 'tine.widget.field.AutoCompleteField',
            recordClass: this.recordClass,
            fieldLabel: this.app.i18n._('Company'),
            name: 'org_name',
            maxLength: 255
          }, {
            columnWidth: 0.35,
            fieldLabel: this.app.i18n._('Unit'),
            xtype: 'tine.widget.field.AutoCompleteField',
            recordClass: this.recordClass,
            name: 'org_unit',
            maxLength: 64
          }]]
        }, new Ext.ux.form.ImageField({
          name: 'jpegphoto',
          width: 90,
          height: 120,
          border: true,
          borderColor: this.record.get('color'),
          getExtraContextActions: () => {
            return [{
              text: i18n._('Color'),
              iconCls: 'action_changecolor',
              scope: this,
              menu: new Ext.menu.ColorMenu({
                scope: this,
                listeners: {
                  show: function show(cmp) {
                    const colorPalette = cmp.items.get(0);
                    colorPalette.suspendEvents();
                    colorPalette.select(this.record.get('color'));
                    colorPalette.resumeEvents();
                  },
                  select: function select(p, color) {
                    let oldColor = p.scope.record.get('color');
                    p.scope.record.set('color', color);
                    let elem = p.scope.find('name', 'jpegphoto')[0].el;
                    elem.applyStyles({
                      border: '2px solid #' + color
                    });

                    if (!oldColor) {
                      let w = parseInt(elem.getStyle('width')),
                          h = parseInt(elem.getStyle('height'));
                      elem.applyStyles({
                        width: w - 2 + 'px',
                        height: h - 2 + 'px'
                      });
                    }
                  },
                  scope: this
                }
              })
            }];
          }
        })]
      }, {
        xtype: 'columnform',
        items: [[!Tine.Tinebase.appMgr.get('Addressbook').featureEnabled('featureIndustry') ? {
          columnWidth: 0.64,
          xtype: 'combo',
          fieldLabel: this.app.i18n._('Display Name'),
          name: 'n_fn',
          disabled: true
        } : new Tine.Addressbook.IndustrySearchCombo({
          fieldLabel: this.app.i18n._('Industry'),
          columnWidth: 0.64,
          name: 'industry'
        }), {
          columnWidth: 0.36,
          fieldLabel: this.app.i18n._('Job Title'),
          name: 'title',
          maxLength: 64
        }, {
          width: 110,
          xtype: 'extuxclearabledatefield',
          fieldLabel: this.app.i18n._('Birthday (private)'),
          name: 'bday',
          requiredGrant: 'privateDataGrant'
        }]]
      }]
    };
    var contactCenterPanel = {
      xtype: 'fieldset',
      region: 'center',
      title: this.app.i18n._('Contact Information'),
      autoScroll: true,
      plugins: [{
        ptype: 'ux.itemregistry',
        key: 'Tine.Addressbook.editDialog.centerPanel'
      }],
      items: [{
        xtype: 'columnform',
        items: [[{
          fieldLabel: this.app.i18n._('Phone'),
          labelIcon: 'images/icon-set/icon_phone.svg',
          name: 'tel_work',
          maxLength: 40
        }, {
          fieldLabel: this.app.i18n._('Mobile'),
          labelIcon: 'images/icon-set/icon_mobile.svg',
          name: 'tel_cell',
          maxLength: 40
        }, {
          fieldLabel: this.app.i18n._('Fax'),
          labelIcon: 'images/icon-set/icon_print.svg',
          name: 'tel_fax',
          maxLength: 40
        }], [{
          fieldLabel: this.app.i18n._('Phone (private)'),
          labelIcon: 'images/icon-set/icon_phone.svg',
          name: 'tel_home',
          maxLength: 40,
          requiredGrant: 'privateDataGrant'
        }, {
          fieldLabel: this.app.i18n._('Mobile (private)'),
          labelIcon: 'images/icon-set/icon_mobile.svg',
          name: 'tel_cell_private',
          maxLength: 40,
          requiredGrant: 'privateDataGrant'
        }, {
          fieldLabel: this.app.i18n._('Fax (private)'),
          labelIcon: 'images/icon-set/icon_print.svg',
          name: 'tel_fax_home',
          maxLength: 40,
          requiredGrant: 'privateDataGrant'
        }], [{
          fieldLabel: this.app.i18n._('E-Mail'),
          labelIcon: 'images/icon-set/icon_email.svg',
          name: 'email',
          vtype: 'email',
          maxLength: 64,
          disabled: this.checkDisableEmailField()
        }, {
          fieldLabel: this.app.i18n._('E-Mail (private)'),
          labelIcon: 'images/icon-set/icon_email.svg',
          name: 'email_home',
          vtype: 'email',
          maxLength: 64,
          requiredGrant: 'privateDataGrant'
        }, {
          xtype: 'mirrortextfield',
          fieldLabel: this.app.i18n._('Web'),
          labelIcon: 'images/icon-set/icon_globe.svg',
          name: 'url',
          maxLength: 128,
          listeners: {
            scope: this,
            focus: function focus(field) {
              if (!field.getValue()) {
                field.setValue('http://www.');
                field.selectText.defer(100, field, [7, 11]);
              }
            },
            blur: function blur(field) {
              if (field.getValue() === 'http://www.') {
                field.setValue(null);
                field.validate();
              }

              if (field.getValue().indexOf('http://http://') == 0 || field.getValue().indexOf('http://https://') == 0) {
                field.setValue(field.getValue().substr(7));
                field.validate();
              }

              if (field.getValue().indexOf('http://www.http://') == 0 || field.getValue().indexOf('http://www.https://') == 0) {
                field.setValue(field.getValue().substr(11));
                field.validate();
              }
            }
          }
        }, {
          fieldLabel: this.app.i18n._('Language'),
          name: 'language',
          xtype: 'combo',
          mode: 'local',
          allowBlank: true,
          editable: true,
          forceSelection: true,
          store: Object.entries(allLanguages)
        }]]
      }]
    };
    this.postalAddressesTabPanel = Ext.create({
      xtype: 'tabpanel',
      region: 'south',
      border: false,
      deferredRender: false,
      height: 160,
      split: true,
      activeTab: 0,
      defaults: {
        frame: true
      },
      plugins: [{
        ptype: 'ux.itemregistry',
        key: 'Tine.Addressbook.editDialog.southPanel'
      }],
      items: [{
        title: this.app.i18n._('Company Address'),
        xtype: 'columnform',
        items: [[{
          fieldLabel: this.app.i18n._('Street'),
          name: 'adr_one_street',
          xtype: 'tine.widget.field.AutoCompleteField',
          recordClass: this.recordClass,
          maxLength: 64
        }, {
          fieldLabel: this.app.i18n._('Street 2'),
          name: 'adr_one_street2',
          maxLength: 64
        }, {
          fieldLabel: this.app.i18n._('Region'),
          name: 'adr_one_region',
          xtype: 'tine.widget.field.AutoCompleteField',
          recordClass: this.recordClass,
          maxLength: 64
        }], [{
          fieldLabel: this.app.i18n._('Postal Code'),
          name: 'adr_one_postalcode',
          maxLength: 64
        }, {
          fieldLabel: this.app.i18n._('City'),
          name: 'adr_one_locality',
          xtype: 'tine.widget.field.AutoCompleteField',
          recordClass: this.recordClass,
          maxLength: 64
        }, {
          xtype: 'widget-countrycombo',
          fieldLabel: this.app.i18n._('Country'),
          name: 'adr_one_countryname',
          maxLength: 64
        }], [this.preferredAddressBusinessCheckbox]]
      }, {
        title: this.app.i18n._('Private Address'),
        xtype: 'columnform',
        items: [[{
          fieldLabel: this.app.i18n._('Street'),
          name: 'adr_two_street',
          xtype: 'tine.widget.field.AutoCompleteField',
          recordClass: this.recordClass,
          maxLength: 64,
          requiredGrant: 'privateDataGrant'
        }, {
          fieldLabel: this.app.i18n._('Street 2'),
          name: 'adr_two_street2',
          maxLength: 64,
          requiredGrant: 'privateDataGrant'
        }, {
          fieldLabel: this.app.i18n._('Region'),
          name: 'adr_two_region',
          xtype: 'tine.widget.field.AutoCompleteField',
          recordClass: this.recordClass,
          maxLength: 64,
          requiredGrant: 'privateDataGrant'
        }], [{
          fieldLabel: this.app.i18n._('Postal Code'),
          name: 'adr_two_postalcode',
          maxLength: 64,
          requiredGrant: 'privateDataGrant'
        }, {
          fieldLabel: this.app.i18n._('City'),
          name: 'adr_two_locality',
          xtype: 'tine.widget.field.AutoCompleteField',
          recordClass: this.recordClass,
          maxLength: 64,
          requiredGrant: 'privateDataGrant'
        }, {
          xtype: 'widget-countrycombo',
          fieldLabel: this.app.i18n._('Country'),
          name: 'adr_two_countryname',
          maxLength: 64,
          requiredGrant: 'privateDataGrant'
        }], [this.preferredAddressPrivateCheckbox]]
      }]
    }); // activities and tags

    var contactEastPanel = {
      region: 'east',
      layout: 'ux.multiaccordion',
      animate: true,
      width: 210,
      split: true,
      collapsible: true,
      collapseMode: 'mini',
      header: false,
      margins: '0 5 0 5',
      border: true,
      plugins: [{
        ptype: 'ux.itemregistry',
        key: 'Tine.Addressbook.editDialog.eastPanel'
      }],
      items: [new Ext.Panel({
        // @todo generalise!
        title: this.app.i18n._('Description'),
        iconCls: 'descriptionIcon',
        layout: 'form',
        labelAlign: 'top',
        border: false,
        items: [{
          style: 'margin-top: -4px; border 0px;',
          labelSeparator: '',
          xtype: 'textarea',
          name: 'note',
          hideLabel: true,
          grow: false,
          preventScrollbars: false,
          anchor: '100% 100%',
          emptyText: this.app.i18n._('Enter description'),
          requiredGrant: 'editGrant'
        }]
      }), new Ext.Panel({
        title: this.app.i18n._('Groups'),
        iconCls: 'tinebase-accounttype-group',
        layout: 'fit',
        border: false,
        bodyStyle: 'border:1px solid #B5B8C8;',
        items: [this.groupsPanel]
      }), new Tine.widgets.tags.TagPanel({
        app: 'Addressbook',
        border: false,
        bodyStyle: 'border:1px solid #B5B8C8;'
      })]
    };
    var contactTab = {
      title: this.app.i18n.n_('Contact', 'Contacts', 1),
      border: false,
      frame: true,
      layout: 'border',
      items: [{
        region: 'center',
        layout: 'border',
        items: [contactNorthPanel, contactCenterPanel, this.postalAddressesTabPanel]
      }, contactEastPanel]
    };
    var tabs = [contactTab, this.mapPanel, new Tine.widgets.activities.ActivitiesTabPanel({
      app: this.appName,
      record_id: this.record && !this.copyRecord ? this.record.id : '',
      record_model: this.appName + '_Model_' + this.recordClass.getMeta('modelName')
    })];

    if (this.contactEventPanel) {
      tabs.push(this.contactEventPanel);
    }

    return {
      xtype: 'tabpanel',
      border: false,
      plain: true,
      activeTab: 0,
      plugins: [{
        ptype: 'ux.itemregistry',
        key: 'Tine.Addressbook.editDialog.mainTabPanel'
      }, {
        ptype: 'ux.tabpanelkeyplugin'
      }],
      defaults: {
        hideMode: 'offsets'
      },
      items: tabs
    };
  },

  /**
   * init component
   */
  initComponent: function initComponent() {
    this.initToolbar();
    this.groupsPanel = new Tine.Addressbook.contactListsGridPanel({
      initialLoadAfterRender: false,
      frame: false
    });
    Tine.Addressbook.ContactEditDialog.superclass.initComponent.apply(this, arguments);
  },

  /**
   * initToolbar
   */
  initToolbar: function initToolbar() {
    this.parseAddressButton = new Ext.Action({
      text: Tine.Tinebase.appMgr.get('Addressbook').i18n._('Parse address'),
      handler: this.onParseAddress,
      iconCls: 'action_parseAddress',
      disabled: false,
      scope: this,
      enableToggle: true
    });
    this.printButton = new Ext.Action({
      text: Tine.Tinebase.appMgr.get('Addressbook').i18n._('Print contact'),
      handler: this.onPrint,
      iconCls: 'action_print',
      disabled: false,
      scope: this
    });
    this.tbarItems = this.tbarItems || [];
    this.tbarItems = this.tbarItems.concat([this.parseAddressButton, this.printButton]);
  },
  onPrint: function onPrint(printMode) {
    this.onRecordUpdate();
    var renderer = new Tine.Addressbook.Printer.ContactRenderer();
    renderer.print(this);
  },

  /**
   * parse address handler
   *
   * opens message box where user can paste address
   *
   * @param {Ext.Button} button
   */
  onParseAddress: function onParseAddress(button) {
    if (button.pressed) {
      Ext.Msg.prompt(this.app.i18n._('Paste address'), this.app.i18n._('Please paste an address or a URI to a vcard that should be parsed:'), function (btn, text) {
        if (btn == 'ok') {
          this.parseAddress(text);
        } else if (btn == 'cancel') {
          button.toggle();
        }
      }, this, 100);
    } else {
      button.setText(this.app.i18n._('Parse address'));
      this.tokenModePlugin.endTokenMode();
    }
  },

  /**
   * send address to server + fills record/form with parsed data + adds unrecognizedTokens to description box
   *
   * @param {String} address
   */
  parseAddress: function parseAddress(address) {
    Tine.log.debug('parsing address ... ');
    Tine.Addressbook.parseAddressData(address, function (result, response) {
      Tine.log.debug('parsed address:');
      Tine.log.debug(result);

      if (result.hasOwnProperty('exceptions')) {
        Ext.Msg.alert(this.app.i18n._('Failed to parse address!'), this.app.i18n._('The address could not be read.'));
      } else {
        // only set the fields that could be detected
        Ext.iterate(result.contact, function (key, value) {
          if (value && !this.record.get(key)) {
            this.record.set(key, value);
          }
        }, this);
        var oldNote = this.record.get('note') ? this.record.get('note') : '';

        if (result.hasOwnProperty('unrecognizedTokens')) {
          this.record.set('note', result.unrecognizedTokens.join(' ') + oldNote);
        }

        this.onRecordLoad();
        this.parseAddressButton.setText(this.app.i18n._('End token mode'));
        this.tokenModePlugin.startTokenMode();
      }
    }, this);
  },

  /**
   * checkDisableEmailField
   */
  checkDisableEmailField: function checkDisableEmailField() {
    if (this.record.get('email')) {
      if (Tine.Tinebase.registry.get('primarydomain') && Tine.Tinebase.registry.get('primarydomain') !== '' && this.record.get('type') === 'user') {
        return true;
      }
    }

    return false;
  },

  /**
   * onRecordLoad
   */
  onRecordLoad: function onRecordLoad() {
    // NOTE: it comes again and again till
    if (this.rendered) {
      var container = this.record.get('container_id'); // handle default container
      // TODO should be generalized

      if (!this.record.id && !Ext.isObject(container)) {
        container = this.app.getMainScreen().getWestPanel().getContainerTreePanel().getSelectedContainer('addGrant', Tine.Addressbook.registry.get('defaultAddressbook'));
        this.record.set('container_id', container);
      }

      if (this.mapPanel instanceof Tine.Addressbook.MapPanel) {
        this.mapPanel.onRecordLoad(this.record);
      }
    }

    if (this.record.id) {
      this.groupsPanel.store.loadData(this.record.get('groups'));
      const preferredAddress = +this.record.get('preferred_address');

      if (this.postalAddressesTabPanel.items.get(preferredAddress)) {
        this.postalAddressesTabPanel.setActiveTab(preferredAddress);
      }
    }

    this.supr().onRecordLoad.apply(this, arguments);

    if (Tine.Tinebase.registry.get('currentAccount').contact_id == this.record.id) {
      this.enableOwnPrivateFields();
    }
  },

  /**
   * Enable fields we have no privateData grant for, when this is the users own contact (special case).
   */
  enableOwnPrivateFields: function enableOwnPrivateFields() {
    this.getForm().findField('bday').setDisabled(false);
    this.getForm().findField('email_home').setDisabled(false);
    this.getForm().findField('tel_cell_private').setDisabled(false);
    this.getForm().findField('tel_home').setDisabled(false);
    this.getForm().findField('tel_fax_home').setDisabled(false);
    this.getForm().findField('adr_two_countryname').setDisabled(false);
    this.getForm().findField('adr_two_locality').setDisabled(false);
    this.getForm().findField('adr_two_postalcode').setDisabled(false);
    this.getForm().findField('adr_two_region').setDisabled(false);
    this.getForm().findField('adr_two_street').setDisabled(false);
    this.getForm().findField('adr_two_street2').setDisabled(false);
  }
});
/**
 * Opens a new contact edit dialog window
 *
 * @return {Ext.ux.Window}
 */

Tine.Addressbook.ContactEditDialog.openWindow = function (config) {
  var id = config.record && config.record.id ? config.record.id : 0;
  var window = Tine.WindowFactory.getWindow({
    width: 800,
    height: 610,
    name: Tine.Addressbook.ContactEditDialog.prototype.windowNamePrefix + id,
    contentPanelConstructor: 'Tine.Addressbook.ContactEditDialog',
    contentPanelConstructorConfig: config
  });
  return window;
};

/***/ }),

/***/ 1659:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 * 
 * @package     Addressbook
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Frederic Heihoff <heihoff@sh-systems.eu>
 * @copyright   Copyright (c) 2007-2011 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 */
Ext.ns('Tine.Addressbook');
/**
 * List grid panel
 * 
 * @namespace   Tine.Addressbook
 * @class       Tine.Addressbook.ListGridPanel
 * @extends     Tine.widgets.grid.GridPanel
 * 
 * <p>List Grid Panel</p>
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Frederic Heihoff <heihoff@sh-systems.eu>
 * @copyright   Copyright (c) 2007-2011 Metaways Infosystems GmbH (http://www.metaways.de)
 * 
 * @param       {Object} config
 * @constructor
 * Create a new Tine.Addressbook.ListGridPanel
 */

Tine.Addressbook.ListGridPanel = Ext.extend(Tine.widgets.grid.GridPanel, {
  /**
   * record class
   * @cfg {Tine.Addressbook.Model.List} recordClass
   */
  recordClass: 'Addressbook.List',

  /**
   * grid specific
   * @private
   */
  defaultSortInfo: {
    field: 'name',
    direction: 'ASC'
  },
  copyEditAction: true,
  felamimail: false,
  multipleEdit: false,
  duplicateResolvable: false,

  /**
   * @cfg {Bool} hasDetailsPanel 
   */
  hasDetailsPanel: false,

  /**
   * inits this cmp
   * @private
   */
  initComponent: function initComponent() {
    this.recordProxy = Tine.Addressbook.listBackend; // check if felamimail is installed and user has run right and wants to use felamimail in adb

    if (Tine.Felamimail && Tine.Tinebase.common.hasRight('run', 'Felamimail') && Tine.Felamimail.registry.get('preferences').get('useInAdb')) {
      this.felamimail = Tine.Felamimail.registry.get('preferences').get('useInAdb') == 1;
    }

    this.gridConfig.cm = this.getColumnModel();
    this.filterToolbar = this.filterToolbar || this.getFilterToolbar();

    if (this.hasDetailsPanel) {
      this.detailsPanel = this.getDetailsPanel();
    }

    this.plugins = this.plugins || [];
    this.plugins.push(this.filterToolbar);
    Tine.Addressbook.ListGridPanel.superclass.initComponent.call(this);
  },
  // prevent default from modelConfig
  initGenericColumnModel: Ext.emptyFn,

  /**
   * returns column model
   * 
   * @return Ext.grid.ColumnModel
   * @private
   */
  getColumnModel: function getColumnModel() {
    return new Ext.grid.ColumnModel({
      defaults: {
        sortable: true,
        hidden: true,
        resizable: true
      },
      columns: this.getColumns()
    });
  },

  /**
   * returns array with columns
   * 
   * @return {Array}
   */
  getColumns: function getColumns() {
    return [{
      id: 'type',
      header: this.app.i18n._('Type'),
      dataIndex: 'type',
      width: 30,
      renderer: Tine.Addressbook.ListGridPanel.listTypeRenderer,
      hidden: false
    }, {
      id: 'tags',
      header: this.app.i18n._('Tags'),
      dataIndex: 'tags',
      width: 50,
      renderer: Tine.Tinebase.common.tagsRenderer,
      sortable: false,
      hidden: false
    }, {
      id: 'name',
      header: this.app.i18n._('Name'),
      dataIndex: 'name',
      width: 30,
      hidden: false
    }, {
      id: 'email',
      header: this.app.i18n._('E-Mail'),
      dataIndex: 'email',
      width: 40,
      hidden: false
    }, {
      id: 'list_type',
      header: this.app.i18n._('List type'),
      dataIndex: 'list_type',
      width: 30,
      renderer: Tine.Tinebase.widgets.keyfield.Renderer.get('Addressbook', 'listType'),
      hidden: false
    }, // TODO do we still need it? discuss!
    {
      id: 'emails',
      header: this.app.i18n._('Member E-Mails'),
      dataIndex: 'emails',
      hidden: false,
      renderer: function renderer(value) {
        if (!value) {
          return '';
        } // TODO should be fixed on server side
        // remove leading comma


        return value.replace(/^,/, '');
      }
    }].concat(this.getModlogColumns().concat(this.getCustomfieldColumns()));
  },

  /**
   * @private
   */
  initActions: function initActions() {
    Tine.Addressbook.ListGridPanel.superclass.initActions.call(this);
  },

  /**
   * returns details panel
   * 
   * @private
   * @return {Tine.Addressbook.ListGridDetailsPanel}
   */
  getDetailsPanel: function getDetailsPanel() {
    return new Tine.Addressbook.ListGridDetailsPanel({
      gridpanel: this,
      il8n: this.app.i18n
    });
  }
});
/**
 * list type renderer
 *
 * @private
 * @return {String} HTML
 */

Tine.Addressbook.ListGridPanel.listTypeRenderer = function (data, cell, record) {
  var i18n = Tine.Tinebase.appMgr.get('Addressbook').i18n,
      type = record.get && record.get('type') || record.type,
      cssClass = 'tine-grid-row-action-icon ' + (type == 'group' ? 'renderer_typeGroupIcon' : 'renderer_typeListIcon'),
      qtipText = Tine.Tinebase.common.doubleEncode(type == 'group' ? i18n._('System Group') : i18n._('Group'));
  return '<div ext:qtip="' + qtipText + '" style="background-position:0px;" class="' + cssClass + '">&#160</div>';
};

/***/ }),

/***/ 1660:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 * 
 * @package     Addressbook
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Philipp Schüle <p.schuele@metaways.de>
 * @copyright   Copyright (c) 2016 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 */
Ext.ns('Tine.Addressbook');
/**
 * @namespace   Tine.Addressbook
 * @class       Tine.Addressbook.ListEditDialogRoleGridPanel
 * @extends     Ext.grid.EditorGridPanel
 * @author      Philipp Schüle <p.schuele@metaways.de>
 */

Tine.Addressbook.contactListsGridPanel = Ext.extend(Tine.widgets.grid.GridPanel, {
  recordClass: 'Addressbook.List',
  usePagingToolbar: false,
  gridConfig: {
    autoExpandColumn: 'name'
  },
  // the list record
  record: null,
  // deactivate some fns
  initActions: Ext.emptyFn,
  initFilterPanel: Ext.emptyFn,

  /**
   * init component
   */
  initComponent: function initComponent() {
    this.app = this.app ? this.app : Tine.Tinebase.appMgr.get('Addressbook');
    this.store = new Ext.data.JsonStore({
      fields: Tine.Addressbook.Model.List
    });
    this.gridConfig.cm = new Ext.grid.ColumnModel({
      defaults: {
        resizable: true
      },
      columns: this.getColumns()
    });
    Tine.Addressbook.contactListsGridPanel.superclass.initComponent.call(this);
  },
  getColumns: function getColumns() {
    return [{
      id: 'type',
      header: this.app.i18n._('Type'),
      dataIndex: 'type',
      width: 20,
      renderer: Tine.Addressbook.ListGridPanel.listTypeRenderer,
      hidden: false
    }, {
      id: 'name',
      header: this.app.i18n._('Name'),
      width: 100,
      sortable: true,
      dataIndex: 'name'
    }];
  }
});

/***/ }),

/***/ 1661:
/***/ (function(module, exports) {

/**
 * Tine 2.0
 * 
 * @package     Addressbook
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Frederic Heihoff <heihoff@sh-systems.eu>
 * @copyright   Copyright (c) 2007-2009 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 */
Ext.ns('Tine.Addressbook');
/**
 * the details panel (shows List details)
 * 
 * @namespace   Tine.Addressbook
 * @class       Tine.Addressbook.ListGridDetailsPanel
 * @extends     Tine.widgets.grid.DetailsPanel
 */

Tine.Addressbook.ListGridDetailsPanel = Ext.extend(Tine.widgets.grid.DetailsPanel, {
  il8n: null,
  felamimail: false,

  /**
   * init
   */
  initComponent: function initComponent() {
    // init templates
    this.initTemplate();
    this.initDefaultTemplate();
    Tine.Addressbook.ListGridDetailsPanel.superclass.initComponent.call(this);
  },

  /**
   * add on click event after render
   */
  afterRender: function afterRender() {
    Tine.Addressbook.ListGridDetailsPanel.superclass.afterRender.apply(this, arguments);
  },

  /**
   * init default template
   */
  initDefaultTemplate: function initDefaultTemplate() {
    this.defaultTpl = new Ext.XTemplate('<div class="preview-panel-list-nobreak">', '<!-- Preview contacts -->', '<div class="preview-panel preview-panel-list-left">', '<div class="bordercorner_1"></div>', '<div class="bordercorner_2"></div>', '<div class="bordercorner_3"></div>', '<div class="bordercorner_4"></div>', '<div class="preview-panel-declaration">' + this.il8n._('Lists') + '</div>', '<div class="preview-panel-list-leftside preview-panel-left">', '<span class="preview-panel-bold">', this.il8n._('Select list') + '<br/>', '<br/>', '<br/>', '<br/>', '</span>', '</div>', '</div>', '</div>');
  },

  /**
   * init single List template (this.tpl)
   */
  initTemplate: function initTemplate() {
    this.tpl = new Ext.XTemplate('<div class="preview-panel-list-nobreak">', '<!-- Preview contacts -->', '<div class="preview-panel preview-panel-list-left">', '<div class="bordercorner_1"></div>', '<div class="bordercorner_2"></div>', '<div class="bordercorner_3"></div>', '<div class="bordercorner_4"></div>', '<div class="preview-panel-declaration">' + this.il8n._('Lists') + '</div>', '<div class="preview-panel-list-leftside preview-panel-left" style="width: 100%">', '<span class="preview-panel-bold">', this.il8n._('List') + '<br/>', '</span>', '<div style="word-wrap:break-word;">{[values.emails]}</div>', '</div>', '</div>', '</div>');
  }
});

/***/ }),

/***/ 1662:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 *
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Philipp Schüle <p.schuele@metaways.de>
 * @copyright   Copyright (c) 2016 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 */
Ext.ns('Tine.Addressbook');
/**
 * config grid panel
 *
 * @namespace   Tine.Addressbook
 * @class       Tine.Addressbook.ListMemberRoleLayerCombo
 * @extends     Tine.widgets.grid.LayerCombo
 */

Tine.Addressbook.ListMemberRoleLayerCombo = Ext.extend(Tine.widgets.grid.PickerGridLayerCombo, {
  /**
   * @cfg contact record
   */
  record: null,
  stripData: function stripData(value) {
    var listRoles = [];

    if (Ext.isArray(value)) {
      Ext.each(value, function (role) {
        if (role.list_role_id) {
          listRoles.push(role.list_role_id);
        } else {
          listRoles.push(role);
        }
      });
    }

    return listRoles;
  },
  wrapData: function wrapData(listRoles) {
    var result = [];
    Ext.each(listRoles, function (role) {
      result.push({
        list_role_id: role,
        contact_id: this.record
      });
    }, this);
    return result;
  },
  setValue: function setValue(value) {
    this.supr().setValue.call(this, this.stripData(value));
  },

  /**
   * sets values to innerForm (grid)
   */
  setFormValue: function setFormValue(value) {
    this.setStoreFromArray(this.stripData(value));
  },
  getValue: function getValue() {
    var value = this.supr().getValue.call(this);
    return Tine.Tinebase.common.assertComparable(this.wrapData(value));
  },

  /**
   * retrieves values from grid
   *
   * @returns {*|Array}
   */
  getFormValue: function getFormValue() {
    var listRoles = this.getFromStoreAsArray();
    return this.wrapData(listRoles);
  }
});

/***/ }),

/***/ 1663:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 * 
 * @package     Addressbook
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Philipp Schüle <p.schuele@metaways.de>
 * @copyright   Copyright (c) 2016 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 */
Ext.ns('Tine.Addressbook');
/**
 * @namespace   Tine.Addressbook
 * @class       Tine.Addressbook.ListMemberRoleGridPanel
 * @extends     Ext.grid.EditorGridPanel
 * @author      Philipp Schüle <p.schuele@metaways.de>
 */

Tine.Addressbook.ListMemberRoleGridPanel = Ext.extend(Tine.widgets.grid.PickerGridPanel, {
  recordClass: Tine.Addressbook.Model.Contact,
  clicksToEdit: 1,
  enableHdMenu: false,
  autoExpandColumn: 'n_fileas',
  memberroles: null,
  // the list record
  record: null,

  /**
   * init component
   */
  initComponent: function initComponent() {
    this.app = this.app ? this.app : Tine.Tinebase.appMgr.get('Addressbook');
    this.memberProperty = this.memberProperty ? this.memberProperty : 'members';
    this.roleProperty = this.roleProperty ? this.roleProperty : 'memberroles';
    this.memberDataPath = 'data.' + this.memberProperty;
    this.roleDataPath = 'data.' + this.roleProperty;
    this.title = this.hasOwnProperty('title') ? this.title : this.app.i18n._('Members');
    this.plugins = this.plugins || [];
    this.plugins.push(new Ext.ux.grid.GridViewMenuPlugin({}));
    this.sm = new Ext.grid.RowSelectionModel({
      singleSelect: true
    });
    this.initColumns();
    this.store = new Ext.data.Store({
      autoSave: false,
      fields: Tine.Addressbook.Model.Contact
    });
    this.addListener("beforeedit", this.onBeforeEdit, this);
    this.addListener("afteredit", this.onAfterEdit, this); // add specific search combo to be able to switch "userOnly" for system groups

    this.searchCombo = new Tine.Addressbook.SearchCombo({
      accountsStore: this.store,
      emptyText: i18n._('Search for members ...'),
      newRecordClass: this.recordClass,
      newRecordDefaults: this.recordDefaults,
      recordPrefix: this.recordPrefix,
      userOnly: false,
      blurOnSelect: true,
      listeners: {
        scope: this,
        select: this.onAddRecordFromCombo
      }
    });
    Tine.Addressbook.ListMemberRoleGridPanel.superclass.initComponent.call(this);
  },
  onRender: function onRender() {
    this.supr().onRender.apply(this, arguments);

    if (!this.editDialog) {
      this.editDialog = this.findParentBy(function (c) {
        return c instanceof Tine.widgets.dialog.EditDialog;
      });
    }

    this.editDialog.on('load', this.onRecordLoad, this);
    this.editDialog.on('recordUpdate', this.onRecordUpdate, this); // NOTE: in case we are rendered after record was load

    this.onRecordLoad(this.editDialog, this.editDialog.record);
  },

  /**
   * before cell edit
   *
   * @param o
   */
  onBeforeEdit: function onBeforeEdit(o) {
    var ed = this.colModel.getCellEditor(o.column, o.row);
    ed.record = o.record;
  },

  /**
   * before cell edit
   *
   * @param o
   */
  onAfterEdit: function onAfterEdit(o) {
    o.record.commit();
  },

  /**
   * init columns
   */
  initColumns: function initColumns() {
    this.columns = this.getColumns();
    this.editors = [];
    var visibleColumns = ["n_fileas", "email", "memberroles"];
    Ext.each(this.columns, function (value, idx) {
      if (visibleColumns.indexOf(this.columns[idx].id) === -1) {
        this.columns[idx].hidden = true;
      } else {
        this.columns[idx].width = 150;
      }

      if (this.columns[idx].id === "memberroles") {
        this.editors[idx] = new Tine.Addressbook.ListMemberRoleLayerCombo({
          gridRecordClass: Tine.Addressbook.Model.ListRole
        });
        this.columns[idx].editor = this.editors[idx];
      }
    }, this);
  },

  /**
   * returns array with columns
   * 
   * @return {Array}
   */
  getColumns: function getColumns() {
    var _ = window.lodash,
        baseCols = Tine.Addressbook.ContactGridPanel.getBaseColumns(this.app.i18n); // NOTE: contact grid basecols have memberroles with different data layout

    baseCols = _.filter(baseCols, function (c) {
      return c.id != 'memberroles';
    });
    return baseCols.concat([{
      id: 'memberroles',
      header: this.app.i18n._('List Roles'),
      dataIndex: 'memberroles',
      renderer: this.listMemberRoleRenderer
    }]);
  },

  /**
   *list member role render
   *
   * @param value
   * @returns {string}
   * @constructor
   */
  listMemberRoleRenderer: function listMemberRoleRenderer(value) {
    if (Ext.isArray(value)) {
      var result = [];
      Ext.each(value, function (memberrole) {
        if (memberrole.list_role_id.name) {
          result.push(memberrole.list_role_id.name);
        }
      });
      return result.toString();
    }

    return '';
  },
  onRecordLoad: function onRecordLoad(editDialog, record) {
    var _ = window.lodash,
        memberData = _.get(record, this.memberDataPath) || [],
        rolesData = _.get(record, this.roleDataPath) || [];
    this.setStoreFromArray(memberData);
    this.setRolesFromData(rolesData);
  },
  onRecordUpdate: function onRecordUpdate(editDialog, record) {
    var _ = window.lodash,
        memberData = this.getFromStoreAsArray(),
        roleData = this.getRolesFromData(memberData);

    _.set(record, this.memberDataPath, memberData);

    _.set(record, this.roleDataPath, roleData);
  },

  /**
   * get values from store (as array)
   *
   * @param {Array}
   *
   */
  setStoreFromArray: function setStoreFromArray(data) {
    this.store.clearData();

    for (var i = data.length - 1; i >= 0; --i) {
      var recordData = {};
      recordData = data[i];
      this.store.insert(0, new this.recordClass(recordData));
    }
  },

  /**
   * get values from store (as array)
   *
   * @return {Array}
   */
  getFromStoreAsArray: function getFromStoreAsArray() {
    var result = Tine.Tinebase.common.assertComparable([]);
    this.store.each(function (record) {
      var data = record.data;
      result.push(data);
    }, this);
    return result;
  },

  /**
   * get memberrole records from store
   * 
   * @param data
   * @returns {mixed}
   */
  getRolesFromData: function getRolesFromData(data) {
    var result = Tine.Tinebase.common.assertComparable([]);

    if (Ext.isArray(data)) {
      Ext.each(data, function (contact) {
        if (contact.memberroles) {
          var roles = contact.memberroles;
          Ext.each(roles, function (role) {
            role.contact_id = contact.id;
            result.push(role);
          });
        }
      });
    }

    return result;
  },

  /**
   * get memberroles
   * 
   * @param roles
   * @param list
   */
  setRolesFromData: function setRolesFromData(roles) {
    this.store.each(function (contact) {
      var contactRoles = [];
      Ext.each(roles, function (role) {
        if (role.contact_id.id == contact.get('id')) {
          contactRoles.push(role);
        }
      }, this);

      if (contactRoles.length > 0) {
        contact.set('memberroles', contactRoles);
        contact.commit();
      }
    }, this);
  }
});

/***/ }),

/***/ 1664:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 * 
 * @package     Addressbook
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Philipp Schüle <p.schuele@metaways.de>
 * @copyright   Copyright (c) 2016-2021 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 */
Ext.ns('Tine.Addressbook');
/**
 * @namespace   Tine.Addressbook
 * @class       Tine.Addressbook.ListEditDialogRoleGridPanel
 * @extends     Ext.grid.EditorGridPanel
 * @author      Philipp Schüle <p.schuele@metaways.de>
 *
 * NOTE: this is currently only used in ListEditDialog
 */

Tine.Addressbook.ListEditDialogRoleGridPanel = Ext.extend(Tine.widgets.grid.GridPanel, {
  usePagingToolbar: false,
  autoExpandColumn: 'name',
  memberroles: null,
  // the list record
  record: null,
  // deactivate some fns
  initActions: Ext.emptyFn,
  initFilterPanel: Ext.emptyFn,

  /**
   * init component
   */
  initComponent: function initComponent() {
    this.recordClass = Tine.Addressbook.Model.ListRole;
    this.app = this.app ? this.app : Tine.Tinebase.appMgr.get('Addressbook');
    this.gridConfig.cm = new Ext.grid.ColumnModel({
      defaults: {
        resizable: true
      },
      columns: this.getColumns()
    });
    this.title = this.app.i18n._('List Functions');
    Tine.Addressbook.ListEditDialogRoleGridPanel.superclass.initComponent.call(this);
  },
  getColumns: function getColumns() {
    return [{
      id: 'id',
      header: this.app.i18n._("ID"),
      width: 50,
      sortable: true,
      dataIndex: 'id',
      hidden: true
    }, {
      id: 'name',
      header: this.app.i18n._("Name"),
      width: 100,
      sortable: true,
      dataIndex: 'name'
    }, {
      id: 'members',
      header: this.app.i18n._("Members"),
      width: 150,
      sortable: true,
      dataIndex: 'members',
      renderer: this.memberRenderer
    }];
  },

  /**
   * fill store with list roles and the members
   *
   * @param [] memberroles
   */
  setListRoles: function setListRoles(memberroles) {
    Ext.each(memberroles, function (memberrole) {
      this.updateListRole(memberrole);
    }, this);
  },
  updateListRole: function updateListRole(memberrole) {
    // check if already in store
    var listRoleId = memberrole.list_role_id.id;

    if (listRoleId) {
      var listRole = this.getStore().getById(listRoleId),
          insertNew = false,
          members = [],
          newMember = true;

      if (!listRole) {
        listRole = new this.recordClass(memberrole.list_role_id);
        insertNew = true;
        members = [memberrole.contact_id];
      } else {
        members = listRole.get('members');
        Ext.each(members, function (member) {
          if (member.id == memberrole.contact_id.id) {
            // already id
            newMember = false;
          }
        });

        if (!newMember) {
          return;
        }

        members.push(memberrole.contact_id);
      }

      listRole.set('members', members);
      listRole.commit();

      if (insertNew) {
        this.getStore().insert(0, listRole);
      }
    }
  },

  /**
   * TODO implement removal of a memberrole OR reset role members after each update
   *
   * @param contact
   */
  setListRolesOfContact: function setListRolesOfContact(contact) {
    Ext.each(contact.get('memberroles'), function (memberrole) {
      memberrole.contact_id = Ext.copyTo({}, contact.data, 'id,n_fn');
      this.updateListRole(memberrole);
    }, this);
  },
  memberRenderer: function memberRenderer(value) {
    if (Ext.isArray(value)) {
      var result = [];
      Ext.each(value, function (contact) {
        if (contact) {
          result.push(contact.n_fn);
        }
      });
      return result.toString();
    }

    return '';
  }
});

/***/ }),

/***/ 1665:
/***/ (function(module, exports, __webpack_require__) {

/*
 * Tine 2.0
 * 
 * @package     Addressbook
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Frederic Heihoff <heihoff@sh-systems.eu>
 * @copyright   Copyright (c) 2009-2020 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 */

/*global Ext, Tine*/
Ext.ns('Tine.Addressbook');

__webpack_require__(1666);
/**
 * @namespace   Tine.Addressbook
 * @class       Tine.Addressbook.ListEditDialog
 * @extends     Tine.widgets.dialog.EditDialog
 * Addressbook Edit Dialog <br>
 * 
 * @author      Frederic Heihoff <heihoff@sh-systems.eu>
 */


Tine.Addressbook.ListEditDialog = Ext.extend(Tine.widgets.dialog.EditDialog, {
  windowNamePrefix: 'ListEditWindow_',
  appName: 'Addressbook',
  recordClass: 'Addressbook.List',
  showContainerSelector: true,
  multipleEdit: true,
  displayNotes: true,
  enablePrinting: true,

  /**
   * init component
   */
  initComponent: function initComponent() {
    this.on('load', this.resolveMemberData, this);
    this.printer = Tine.Addressbook.Printer.ListRenderer;
    this.memberGridPanel = new Tine.Addressbook.ListMemberRoleGridPanel({
      region: "center",
      frame: true,
      margins: '6 0 0 0'
    });
    this.supr().initComponent.apply(this, arguments);
  },
  getFormItems: function getFormItems() {
    var tabpanelItems = [{
      title: this.app.i18n.n_('List', 'Lists', 1),
      border: false,
      frame: true,
      layout: 'border',
      items: [{
        region: 'north',
        items: new Ext.form.Label({
          text: '.',
          ref: '../../../sysGroupNote'
        })
      }, {
        region: 'center',
        layout: 'border',
        items: [{
          xtype: 'fieldset',
          region: 'north',
          autoHeight: true,
          title: this.app.i18n._('List Information'),
          items: [{
            xtype: 'panel',
            layout: 'hbox',
            align: 'stretch',
            items: [{
              flex: 1,
              xtype: 'columnform',
              autoHeight: true,
              style: 'padding-right: 5px;',
              items: [[{
                columnWidth: 1,
                fieldLabel: this.app.i18n._('Name'),
                name: 'name',
                maxLength: 64,
                allowBlank: false
              }], [{
                columnWidth: 1,
                xtype: 'textfield',
                fieldLabel: this.app.i18n._('E-Mail'),
                name: 'email',
                vtype: 'email',
                maxLength: 255,
                allowBlank: true
              }], [new Tine.Tinebase.widgets.keyfield.ComboBox({
                columnWidth: 0.75,
                fieldLabel: this.app.i18n._('List type'),
                name: 'list_type',
                app: 'Addressbook',
                keyFieldName: 'listType',
                value: '',
                hidden: this.app.featureEnabled('featureMailinglist')
              }), {
                columnWidth: 0.25,
                xtype: 'checkbox',
                fieldLabel: this.app.i18n._('System accounts only'),
                name: 'account_only',
                anchor: '100%',
                disabled: true
              }]]
            }]
          }]
        }, // TODO allow user to switch between those two grid panels (card layout?)
        this.memberGridPanel]
      }, {
        // activities and tags
        region: 'east',
        layout: 'ux.multiaccordion',
        animate: true,
        width: 210,
        split: true,
        collapsible: true,
        collapseMode: 'mini',
        header: false,
        margins: '0 5 0 5',
        border: true,
        items: [new Ext.Panel({
          // @todo generalise!
          title: this.app.i18n._('Description'),
          iconCls: 'descriptionIcon',
          layout: 'form',
          labelAlign: 'top',
          border: false,
          items: [{
            style: 'margin-top: -4px; border 0px;',
            labelSeparator: '',
            xtype: 'textarea',
            name: 'description',
            hideLabel: true,
            grow: false,
            preventScrollbars: false,
            anchor: '100% 100%',
            emptyText: this.app.i18n._('Enter description'),
            requiredGrant: 'editGrant'
          }]
        }), new Tine.widgets.tags.TagPanel({
          app: 'Addressbook',
          border: false,
          bodyStyle: 'border:1px solid #B5B8C8;'
        })]
      }]
    }, new Tine.widgets.activities.ActivitiesTabPanel({
      app: this.appName,
      record_id: this.record && !this.copyRecord ? this.record.id : '',
      record_model: this.appName + '_Model_' + this.recordClass.getMeta('modelName')
    })];

    if (Tine.Tinebase.registry.get('manageImapEmailUser') && Tine.Tinebase.registry.get('manageSmtpEmailUser') && this.app.featureEnabled('featureMailinglist')) {
      this.mailingListPanel = new Tine.Addressbook.MailinglistPanel({
        app: this.app,
        editDialog: this
      });
      tabpanelItems.push(this.mailingListPanel);
    }

    return {
      xtype: 'tabpanel',
      border: false,
      plain: true,
      activeTab: 0,
      plugins: [{
        ptype: 'ux.tabpanelkeyplugin'
      }],
      items: tabpanelItems
    };
  },

  /**
   * checks if form data is valid
   * 
   * @return {Boolean}
   */
  isValid: function isValid() {
    var form = this.getForm();
    var isValid = true; // you need to fill in one of: n_given n_family org_name
    // @todo required fields should depend on salutation ('company' -> org_name, etc.)
    //       and not required fields should be disabled (n_given, n_family, etc.)

    if (form.findField('name').getValue() === '') {
      var invalidString = String.format(this.app.i18n._('{0} must be given'), this.app.i18n._('Name'));
      form.findField('name').markInvalid(invalidString);
      isValid = false;
    }

    return isValid && Tine.Addressbook.ListEditDialog.superclass.isValid.apply(this, arguments);
  },

  /**
   * onRecordLoad
   */
  resolveMemberData: function resolveMemberData(editDialog, record, ticketFn) {
    if (this.record.id) {
      if (this.record.get('account_only') === true) {
        this.memberGridPanel.searchCombo.userOnly = true;
      }
    }
  },
  checkStates: function checkStates() {
    var _this$form$findField, _this$form$findField$, _this$form$findField$2, _this$mailingListPane;

    if (this.loadRequest) {
      return _.delay(_.bind(this.checkStates, this), 250);
    }

    this.supr().checkStates.call(this);
    const hasEditGrant = !this.record.id || ((_this$form$findField = this.form.findField('container_id')) === null || _this$form$findField === void 0 ? void 0 : (_this$form$findField$ = _this$form$findField.selectedContainer) === null || _this$form$findField$ === void 0 ? void 0 : (_this$form$findField$2 = _this$form$findField$.account_grants) === null || _this$form$findField$2 === void 0 ? void 0 : _this$form$findField$2.editGrant);
    const isSysGroup = this.record.get('type') === 'group';
    const allowEditSysFields = hasEditGrant && (!isSysGroup || Tine.Tinebase.common.hasRight('manage_accounts', 'Admin'));
    this.sysGroupNote.setText(isSysGroup ? this.app.i18n._("This is a system group. To edit this group you need the Admin.ManageAccounts right.") : '');
    ['name', 'description', 'email', 'account_only'].forEach(fieldName => {
      this.getForm().findField(fieldName).setReadOnly(!allowEditSysFields);
    });
    this.memberGridPanel.setReadOnly(!allowEditSysFields);
    (_this$mailingListPane = this.mailingListPanel) === null || _this$mailingListPane === void 0 ? void 0 : _this$mailingListPane.setReadOnly(!allowEditSysFields);
  }
});
/**
 * Opens a new List edit dialog window
 * 
 * @return {Ext.ux.Window}
 */

Tine.Addressbook.ListEditDialog.openWindow = function (config) {
  // if a container is selected in the tree, take this as default container
  var treeNode = Ext.getCmp('Addressbook_Tree') ? Ext.getCmp('Addressbook_Tree').getSelectionModel().getSelectedNode() : null;

  if (treeNode && treeNode.attributes && treeNode.attributes.container.type) {
    config.forceContainer = treeNode.attributes.container;
  } else {
    config.forceContainer = null;
  }

  var id = config.record && config.record.id ? config.record.id : 0;
  var window = Tine.WindowFactory.getWindow({
    width: 800,
    height: 610,
    name: Tine.Addressbook.ListEditDialog.prototype.windowNamePrefix + id,
    contentPanelConstructor: 'Tine.Addressbook.ListEditDialog',
    contentPanelConstructorConfig: config
  });
  return window;
};

/***/ }),

/***/ 1666:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 *
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Philipp Schüle <p.schuele@metaways.de>
 * @copyright   Copyright (c) 2019 Metaways Infosystems GmbH (http://www.metaways.de)
 */
Ext.ns('Tine.Addressbook');
Tine.Addressbook.MailinglistPanel = Ext.extend(Ext.Panel, {
  /**
   * @cfg {Tine.widgets.dialog.EditDialog}
   */
  editDialog: null,

  /**
   * @cfg {Tine.Tinebase.Application} app
   */
  app: null,

  /**
   * @property {Tine.Addressbook.Model.Contact} recordClass
   */
  recordClass: Tine.Addressbook.Model.Contact,
  requiredGrant: 'editGrant',
  layout: 'fit',
  border: false,
  checkboxes: {},
  initComponent: function initComponent() {
    var _ = window.lodash,
        panel = this;
    this.app = this.app || Tine.Tinebase.appMgr.get('Addressbook');
    this.title = this.title || this.app.i18n._('Mailing List');
    this.editDialog.on('load', this.onRecordLoad, this);
    this.editDialog.on('recordUpdate', this.onRecordUpdate, this);
    this.isMailinglistCheckbox = new Ext.form.Checkbox({
      disabled: true,
      boxLabel: this.app.i18n._('This group is a mailing list'),
      listeners: {
        scope: this,
        check: this.onMailinglistCheck
      }
    });
    var checkboxLabels = {
      'sieveKeepCopy': this.app.i18n._('Keep copy of group mails'),
      'sieveAllowExternal': this.app.i18n._('Forward external mails'),
      'sieveAllowOnlyMembers': this.app.i18n._('Only forward member mails'),
      'sieveForwardOnlySystem': this.app.i18n._('Only forward to system email accounts')
    },
        checkboxItems = [this.isMailinglistCheckbox];

    _.forOwn(checkboxLabels, function (label, key) {
      panel.checkboxes[key] = new Ext.form.Checkbox({
        disabled: true,
        boxLabel: label
      });
      checkboxItems.push(panel.checkboxes[key]);
    });

    this.items = [{
      layout: 'vbox',
      align: 'stretch',
      pack: 'start',
      border: false,
      items: [{
        layout: 'form',
        frame: true,
        hideLabels: true,
        width: '100%',
        items: checkboxItems
      }]
    }];
    this.supr().initComponent.call(this);
  },
  onMailinglistCheck: function onMailinglistCheck(cb, checked) {
    var _ = window.lodash;

    _.forOwn(this.checkboxes, function (checkbox, key) {
      checkbox.setReadOnly(!checked);
      checkbox.setDisabled(!checked);
    });
  },
  onRecordLoad: function onRecordLoad(editDialog, record, ticketFn) {
    var _ = window.lodash,
        evalGrants = editDialog.evalGrants;

    var isMailinglist = _.get(record, 'data.xprops.useAsMailinglist', false); // TODO check right here, too


    var hasRight = Tine.Tinebase.common.hasRight('manage', 'Addressbook', 'list_email_options'),
        hasRequiredGrant = !evalGrants || _.get(record, record.constructor.getMeta('grantsPath') + '.' + this.requiredGrant) && hasRight,
        mailinglistDisabled = !(_.get(record, 'data.account_grants.adminGrant', false) && hasRight);
    this.isMailinglistCheckbox.setDisabled(mailinglistDisabled);
    this.isMailinglistCheckbox.setValue(isMailinglist);

    _.forOwn(this.checkboxes, function (checkbox, key) {
      checkbox.setValue(_.get(record, 'data.xprops.' + key, false));
      checkbox.setDisabled(!isMailinglist);
    });

    this.setReadOnly(!hasRequiredGrant);
  },
  setReadOnly: function setReadOnly(readOnly) {
    this.readOnly = readOnly;
    this.isMailinglistCheckbox.setDisabled(readOnly);
  },
  onRecordUpdate: function onRecordUpdate(editDialog, record) {
    // TODO set record xprops
    var xprops = record.get('xprops'),
        isMailingList = this.isMailinglistCheckbox.getValue();

    if (!xprops || Ext.isArray(xprops)) {
      xprops = {};
    }

    xprops.useAsMailinglist = isMailingList;

    _.forOwn(this.checkboxes, function (checkbox, key) {
      xprops[key] = isMailingList ? checkbox.getValue() : false;
    });

    record.set('xprops', xprops);
  }
});

/***/ }),

/***/ 1667:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 * contacts combo box and store
 *
 * @package     Addressbook
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Cornelius Weiß <c.weiss@metaways.de>
 * @copyright   Copyright (c) 2016 Metaways Infosystems GmbH (http://www.metaways.de)
 */
Ext.ns('Tine.Addressbook');
Tine.Addressbook.ListSearchCombo = Ext.extend(Tine.Tinebase.widgets.form.RecordPickerComboBox, {
  /**
   * @cfg {Boolean} groupOnly
   */
  groupOnly: false,
  departmentOnly: false,
  addPathFilter: true,
  //private
  initComponent: function initComponent() {
    this.app = Tine.Tinebase.appMgr.get('Addressbook');
    this.recordClass = Tine.Addressbook.Model.List;
    this.emptyText = this.emptyText || (this.groupOnly ? this.app.i18n._('Search for system groups ...') : this.app.i18n._('Search for groups ...'));
    this.supr().initComponent.call(this);
  },

  /**
   * use beforequery to set query filter
   *
   * @param {Event} qevent
   */
  onBeforeQuery: function onBeforeQuery(qevent) {
    Tine.Addressbook.SearchCombo.superclass.onBeforeQuery.apply(this, arguments);
    const filter = this.store.baseParams.filter;

    if (this.addPathFilter) {
      const queryFilter = _.find(filter, {
        field: 'query'
      });

      const pathFilter = {
        field: 'path',
        operator: 'contains',
        value: queryFilter.value
      };

      _.remove(filter, queryFilter);

      filter.push({
        condition: "OR",
        filters: [queryFilter, pathFilter]
      });
    }

    if (this.groupOnly) {
      filter.push({
        field: 'type',
        operator: 'equals',
        value: 'group'
      });
    }

    if (this.departmentOnly) {
      filter.push({
        field: 'list_type',
        operator: 'equals',
        value: 'department'
      });
    }
  },

  /**
   * init template
   * @private
   */
  initTemplate: function initTemplate() {
    if (!this.tpl) {
      this.tpl = new Ext.XTemplate('<tpl for=".">', '<div class="x-combo-list-item">', '<table>', '<tr>', '<td style="min-width: 20px;">{[Tine.Addressbook.ListGridPanel.listTypeRenderer(null, null, values)]}</td>', '<td width="100%">{[Tine.Tinebase.EncodingHelper.encode(values.name)]}</td>', '</tr>', '</table>', '{[Tine.widgets.path.pathsRenderer(values.paths, this.getLastQuery())]}', '</div>', '</tpl>', {
        getLastQuery: this.getLastQuery.createDelegate(this)
      });
    }
  }
});
Tine.widgets.form.RecordPickerManager.register('Addressbook', 'List', Tine.Addressbook.ListSearchCombo);

/***/ }),

/***/ 1668:
/***/ (function(module, exports) {

/* 
 * Tine 2.0
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Cornelius Weiss <c.weiss@metaways.de>
 * @copyright   Copyright (c) 2007-2008 Metaways Infosystems GmbH (http://www.metaways.de)
 */

/*global Ext, Tine*/
Ext.ns('Tine.Addressbook');
Tine.Addressbook.MapPanel = Ext.extend(Ext.Panel, {
  /**
   * @property
   */
  activeMapCard: null,
  record: null,
  layout: 'fit',
  frame: true,

  /**
   * Company address map panel
   * @type {Tine.widgets.MapPanel}
   */
  companyMap: null,

  /**
   * Private address map panel
   * @type {Tine.widgets.MapPanel}
   */
  privateMap: null,
  initComponent: function initComponent() {
    this.app = Tine.Tinebase.appMgr.get('Addressbook');
    this.title = this.app.i18n._('Map');
    this.defaults = {
      border: false
    };
    this.mapCards = new Ext.Panel({
      layout: 'card',
      activeItem: 0,
      items: []
    });
    this.idPrefix = Ext.id();
    this.tbar = [{
      id: this.idPrefix + 'tglbtn' + 'companyMap',
      enableToggle: true,
      allowDepress: false,
      text: this.app.i18n._('Company address'),
      handler: this.onMapChange.createDelegate(this, ['companyMap']),
      toggleGroup: this.idPrefix + 'maptglgroup'
    }, ' ', {
      id: this.idPrefix + 'tglbtn' + 'privateMap',
      enableToggle: true,
      allowDepress: false,
      text: this.app.i18n._('Private address'),
      handler: this.onMapChange.createDelegate(this, ['privateMap']),
      toggleGroup: this.idPrefix + 'maptglgroup'
    }];
    this.items = this.mapCards;
    Tine.Addressbook.MapPanel.superclass.initComponent.call(this);
  },

  /**
   * Change active map card
   * 
   * @param {String} map
   */
  onMapChange: function onMapChange(map) {
    this.mapCards.layout.setActiveItem(this[map]);
    this.mapCards.layout.layout();
    this.activeMapCard = this[map];
  },

  /**
   * Called after contact record is loaded to fill map panels
   * 
   * @param {Tine.Addressbook.Model.Contact} record
   */
  onRecordLoad: function onRecordLoad(record) {
    this.record = record;
    var adrOne = !Ext.isEmpty(this.record.get('adr_one_lon')) && !Ext.isEmpty(this.record.get('adr_one_lat')),
        adrTwo = !Ext.isEmpty(this.record.get('adr_two_lon')) && !Ext.isEmpty(this.record.get('adr_two_lat')),
        btnOne = Ext.getCmp(this.idPrefix + 'tglbtn' + 'companyMap'),
        btnTwo = Ext.getCmp(this.idPrefix + 'tglbtn' + 'privateMap'); // if we have coordinates for company address add map panel

    if (adrOne && !this.companyMap) {
      Tine.log.debug('Add company address map');
      this.companyMap = new Tine.widgets.MapPanel({
        map: 'companyMap',
        layout: 'fit',
        zoom: 15,
        listeners: {
          scope: this,
          'mapAdded': function mapAdded(p) {
            if (!p.center) {
              Tine.log.debug('Loading company address map coordinates: ' + this.record.get('adr_one_lon') + ', ' + this.record.get('adr_one_lat'));
              p.setCenter(this.record.get('adr_one_lon'), this.record.get('adr_one_lat'));
            }
          }
        }
      });
      this.mapCards.add(this.companyMap);
      this.mapCards.doLayout();
    } // if we have coordinates for private address add map panel


    if (adrTwo && !this.privateMap) {
      Tine.log.debug('Add private address map');
      this.privateMap = new Tine.widgets.MapPanel({
        map: 'privateMap',
        layout: 'fit',
        zoom: 15,
        listeners: {
          scope: this,
          'mapAdded': function mapAdded(p) {
            if (!p.center) {
              Tine.log.debug('Loading private address map coordinates: ' + this.record.get('adr_two_lon') + ', ' + this.record.get('adr_two_lat'));
              p.setCenter(this.record.get('adr_two_lon'), this.record.get('adr_two_lat'));
            }
          }
        }
      });
      this.mapCards.add(this.privateMap);
      this.mapCards.doLayout();
    }

    btnOne.toggle(adrOne);
    btnOne.setDisabled(!adrOne);
    btnTwo.toggle(!adrOne && adrTwo);
    btnTwo.setDisabled(!adrTwo);
  },
  onRecordUpdate: function onRecordUpdate(record) {}
});

/***/ }),

/***/ 1669:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Cornelius Weiss <c.weiss@metaways.de>
 * @copyright   Copyright (c) 2011 Metaways Infosystems GmbH (http://www.metaways.de)
 */
Ext.ns('Tine.Addressbook');
/**
 * render the CardDAV Url into property panel of contianers
 * 
 * @class   Tine.Addressbook.CardDAVContainerPropertiesHookField
 * @extends Ext.form.TextField
 */

Tine.Addressbook.CardDAVContainerPropertiesHookField = Ext.extend(Ext.form.TextField, {
  anchor: '100%',
  readOnly: true,

  /**
   * @private
   */
  initComponent: function initComponent() {
    this.on('added', this.onContainerAdded, this);
    Tine.Addressbook.CardDAVContainerPropertiesHookField.superclass.initComponent.call(this);
  },

  /**
   * @private
   */
  onContainerAdded: function onContainerAdded() {
    this.app = Tine.Tinebase.appMgr.get('Addressbook');
    this.fieldLabel = this.app.i18n._('CardDAV URL');
    this.propertiesDialog = this.findParentBy(function (p) {
      return !!p.grantContainer;
    });
    this.grantContainer = this.propertiesDialog.grantContainer;

    if (this.grantContainer.application_id && this.grantContainer.application_id.name) {
      this.isAddressbook = this.grantContainer.application_id.name == 'Addressbook';
    } else {
      this.isAddressbook = this.grantContainer.application_id === this.app.id;
    }

    this.hidden = !this.isAddressbook; // cardDAV URL

    this.value = [Tine.Tinebase.common.getUrl('full').replace(/\/$/, ''), // might have an trailing /, we can safely remove it!
    '/addressbooks/', Tine.Tinebase.registry.get('currentAccount').contact_id, '/', this.grantContainer.id].join('');
  }
});
Ext.ux.ItemRegistry.registerItem('Tine.widgets.container.PropertiesDialog.FormItems.Properties', Tine.Addressbook.CardDAVContainerPropertiesHookField, 100);

/***/ }),

/***/ 1670:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 * 
 * @package     Addressbook
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Stefanie Stamer <s.stamer@metaways.de>
 * @copyright   Copyright (c) 2009 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 */
Ext.namespace('Tine.Addressbook');
/**
 * admin settings panel
 * 
 * @namespace   Tine.Addressbook
 * @class       Tine.Addressbook.AdminPanel
 * @extends     Ext.TabPanel
 * 
 * <p>Addressbook Admin Panel</p>
 * <p><pre>
 * </pre></p>
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Stefanie Stamer <s.stamer@metaways.de>
 * @copyright   Copyright (c) 2009 Metaways Infosystems GmbH (http://www.metaways.de)
 * 
 * @param       {Object} config
 * @constructor
 * Create a new Tine.Addressbook.AdminPanel
 */

Tine.Addressbook.AdminPanel = Ext.extend(Ext.TabPanel, {
  border: false,
  activeTab: 0,

  /**
   * @private
   */
  initComponent: function initComponent() {
    this.app = Tine.Tinebase.appMgr.get('Addressbook');
    this.items = [new Tine.Admin.config.GridPanel({
      configApp: this.app
    })];
    Tine.Addressbook.AdminPanel.superclass.initComponent.call(this);
  }
});
/**
 * Addressbook Admin Panel Popup
 * 
 * @param   {Object} config
 * @return  {Ext.ux.Window}
 */

Tine.Addressbook.AdminPanel.openWindow = function (config) {
  var window = Tine.WindowFactory.getWindow({
    width: 600,
    height: 470,
    name: 'addressbook-admin-panel',
    contentPanelConstructor: 'Tine.Addressbook.AdminPanel',
    contentPanelConstructorConfig: config
  });
};

/***/ }),

/***/ 1671:
/***/ (function(module, exports) {

Ext.ns('Tine.Addressbook.Printer');
Tine.Addressbook.Printer.ContactRenderer = Ext.extend(Ext.ux.Printer.EditDialogRenderer, {
  stylesheetPath: 'Tinebase/css/widgets/print.css',
  generateBody: function generateBody(component, data) {
    var i18n = Tine.Tinebase.appMgr.get('Addressbook').i18n;
    return new Promise(function (fulfill, reject) {
      var bodyTpl = new Ext.XTemplate('<div class="rp-print-single">', '{[Tine.widgets.printer.headerRenderer()]}', '<table><tr><td>', '<div class="rp-print-single-image">', '<img src="{jpegphoto}">', '</div>', '</td><td>', '<div class="rp-print-single-block">', '<div class="rp-print-single-details-row">', '<span class="rp-print-single-value">{salutation} {n_prefix}</span>', '</div>', '<div class="rp-print-single-summary">', '<span class="adb-print-single-value">{n_fn}</span>', '</div>', '<div class="rp-print-single-details-row">', '{[this.fieldRenderer(values.org_name, "Company")]}', '</div>', '<div class="rp-print-single-details-row">', '{[this.fieldRenderer(values.org_unit, "Unit")]}', '</div>', '<tpl if="this.featureIndustry()">', '<div class="rp-print-single-details-row">', '{[this.fieldRenderer(values.industry, "Industry")]}', '</div>', '</tpl>', '<div class="rp-print-single-details-row">', '{[this.fieldRenderer(values.title, "Job Title")]}', '</div>', '<div class="rp-print-single-details-row">', '{[this.fieldRenderer(values.bday, "Birthday")]}', '</div>', '</div>', '</td></tr></table></br>', new Ext.ux.Printer.TagsRenderer().generateBody(component.getForm().findField('tags').tagsPanel), '<div class="cal-print-single-block-heading">', i18n._('Description'), '</div>', '<div class="rp-print-single-block">', '{[this.encode(values.note)]}', '</div>', '</br>', '<div class="cal-print-single-block-heading">', i18n._('Contact Information'), '</div>', '<div class="rp-print-single-block">', '<div class="rp-print-single-details-row">', '{[this.fieldRenderer(values.tel_work, "Phone")]}', '</div>', '<div class="rp-print-single-details-row">', '{[this.fieldRenderer(values.tel_cell, "Mobile")]}', '</div>', '<div class="rp-print-single-details-row">', '{[this.fieldRenderer(values.tel_home, "Phone (private)")]}', '</div>', '<div class="rp-print-single-details-row">', '{[this.fieldRenderer(values.tel_cell_private, "Mobile (private)")]}', '</div>', '<div class="rp-print-single-details-row">', '{[this.fieldRenderer(values.email, "E-Mail")]}', '</div>', '<div class="rp-print-single-details-row">', '{[this.fieldRenderer(values.email_home, "E-Mail (private)")]}', '</div>', '<div class="rp-print-single-details-row">', '{[this.fieldRenderer(values.url, "Web")]}', '</div>', '</div>', '</br>', '<div class="cal-print-single-block-heading">', i18n._('Company Address'), '{[values.preferred_address == "0" ? (" (" + Tine.Tinebase.appMgr.get("Addressbook").i18n._("Preferred Address") + ")") : ""]}</div>', '<div class="rp-print-single-block">', "{[this.addressRenderer({'street': 'adr_one_street', 'street2': 'adr_one_street2', 'postalcode': 'adr_one_postalcode', 'locality': 'adr_one_locality', 'region': 'adr_one_region','country': 'adr_one_countryname'})]}", '</div>', '</br>', '<div class="cal-print-single-block-heading">', i18n._('Private Address'), '{[values.preferred_address == "1" ? (" (" + Tine.Tinebase.appMgr.get("Addressbook").i18n._("Preferred Address") + ")") : ""]}</div>', '<div class="rp-print-single-block">', "{[this.addressRenderer({'street': 'adr_two_street', 'street2': 'adr_two_street2', 'postalcode': 'adr_two_postalcode', 'locality': 'adr_two_locality', 'region': 'adr_two_region','country': 'adr_two_countryname'})]}", '</div>', '</br>', '{[this.customFieldRenderer(values.customfields)]}', '</br>', '<div class="cal-print-single-block-heading">', i18n._('Related to'), '</div>', '<div class="rp-print-single-block">', '{[this.relationRenderer(values.relations)]}', '</div>', '</div>', {
        customFieldRenderer: function customFieldRenderer(values) {
          return Tine.widgets.customfields.Renderer.renderAll('Addressbook', Tine.Addressbook.Model.Contact, values);
        },
        fieldRenderer: function fieldRenderer(fieldValue, label) {
          return Tine.widgets.printer.fieldRenderer('Addressbook', Tine.Addressbook.Model.Contact, fieldValue, label);
        },
        addressRenderer: function addressRenderer(config) {
          var renderer = Tine.widgets.grid.RendererManager.get('Addressbook', 'Addressbook_Model_Contact', 'addressblock', 'displayPanel');
          return renderer(null, null, data, null, null, null, config);
        },
        relationRenderer: function relationRenderer(values) {
          return Tine.widgets.relation.Renderer.renderAll(values);
        },
        featureIndustry: function featureIndustry() {
          return Tine.Tinebase.appMgr.get('Addressbook').featureEnabled('featureIndustry');
        }
      });
      fulfill(bodyTpl.apply(data));
    });
  }
});

/***/ }),

/***/ 1672:
/***/ (function(module, exports) {

Ext.ns('Tine.Addressbook.Printer');
Tine.Addressbook.Printer.ListRenderer = Ext.extend(Ext.ux.Printer.EditDialogRenderer, {
  stylesheetPath: 'Tinebase/css/widgets/print.css',
  generateMemberBody: function generateMemberBody(component) {
    var renderer = new Ext.ux.Printer.GridPanelRenderer();
    return new Promise(function (fulfill, reject) {
      var data = renderer.extractData(component, component.store.data.items);
      renderer.generateBody(component).then(function (bodyHtml) {
        fulfill(new Ext.XTemplate(bodyHtml).apply(data));
      });
    });
  },
  generateBody: function generateBody(component, data) {
    var i18n = Tine.Tinebase.appMgr.get('Addressbook').i18n;
    var me = this;
    return new Promise(function (fulfill, reject) {
      me.generateMemberBody(component.memberGridPanel).then(function (memberHtml) {
        fulfill(new Ext.XTemplate('<div class="rp-print-single">', '{[Tine.widgets.printer.headerRenderer()]}', '<div class="rp-print-single-summary">', '<span class="adb-print-single-value">{name}</span>', '</div>', '<div class="rp-print-single-details-row">', '{[this.fieldRenderer("", "List type")]}', '{[this.keyFieldRenderer("listType", values.list_type)]}', '</div>', '<div class="rp-print-single-details-row">', '{[this.fieldRenderer(values.description, "Description")]}', '</div>', '</br>', memberHtml, '</br>', '{[this.customFieldRenderer(values.customfields)]}', '{[this.relationRenderer(values.relations)]}', '</div>', {
          keyFieldRenderer: function keyFieldRenderer(keyField, values) {
            return Tine.Tinebase.widgets.keyfield.Renderer.render('Addressbook', keyField, values);
          },
          customFieldRenderer: function customFieldRenderer(values) {
            var customFields = '';
            customFields = Tine.widgets.customfields.Renderer.renderAll('Addressbook', Tine.Addressbook.Model.List, values);

            if (customFields) {
              return '<div class="rp-print-single-block-heading">' + i18n._('Customfields') + '</div>' + customFields + '</br>';
            }
          },
          fieldRenderer: function fieldRenderer(fieldValue, label) {
            return Tine.widgets.printer.fieldRenderer('Addressbook', Tine.Addressbook.Model.list, fieldValue, label);
          },
          relationRenderer: function relationRenderer(values) {
            var relations = '';
            relations = Tine.widgets.relation.Renderer.renderAll(values);

            if (relations) {
              return '<div class="rp-print-single-block-heading">' + i18n._('Related to') + '</div>' + relations + '</br>';
            }
          }
        }).apply(data));
      });
    });
  }
});

/***/ }),

/***/ 1673:
/***/ (function(module, exports, __webpack_require__) {

// style-loader: Adds some css to the DOM by adding a <style> tag

// load the styles
var content = __webpack_require__(1674);
if(typeof content === 'string') content = [[module.i, content, '']];
// Prepare cssTransformation
var transform;

var options = {"hmr":true}
options.transform = transform
// add the styles to the DOM
var update = __webpack_require__(17)(content, options);
if(content.locals) module.exports = content.locals;
// Hot Module Replacement
if(false) {}

/***/ }),

/***/ 1674:
/***/ (function(module, exports, __webpack_require__) {

var escape = __webpack_require__(100);
exports = module.exports = __webpack_require__(16)(false);
// imports


// module
exports.push([module.i, ".action_addList {\n    background-image:url(" + escape(__webpack_require__(516)) + ") !important;\n}\n\n.AddressbookIconCls, .AddressbookContact {\n    background-image:url(" + escape(__webpack_require__(1675)) + ") !important;\n}\n\n.action_parseAddress {\n    background-image:url(" + escape(__webpack_require__(216)) + ") !important;\n}\n\n.x-form-item-float-left {\n    float: left;\n    margin-right: 5px;\n}\n\n.renderer_typeAccountIcon {\n    background-image:url(" + escape(__webpack_require__(149)) + ") !important;\n}\n\n.renderer_typeContactIcon {\n    background-image:url(" + escape(__webpack_require__(1676)) + ") !important;\n}\n\n.renderer_typeGroupIcon, .AddressbookList{\n    background-image:url(" + escape(__webpack_require__(126)) + ") !important;\n}\n\n.renderer_typeListIcon {\n    background-image:url(" + escape(__webpack_require__(1677)) + ") !important;\n}\n\n.renderer_displayNameRenderer_noName {\n    font-style: italic;\n    /*color: #808080;*/\n}\n\n.addressbook-search-combo table {\n    width: 100%;\n    font-size: 11px;\n    border: none;\n}\n\n.addressbook-search-combo td {\n    vertical-align: top;\n    padding-top: 4px;\n}\n\n.AddressbookStructure {\n    background-image:url(" + escape(__webpack_require__(1678)) + ") !important;\n    background-repeat: no-repeat;\n}", ""]);

// exports


/***/ }),

/***/ 1675:
/***/ (function(module, exports) {

module.exports = "\"data:image/svg+xml,%3C?xml version='1.0' encoding='utf-8'?%3E %3C!-- Generator: Adobe Illustrator 21.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0) --%3E %3Csvg version='1.1' id='Ebene_1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' x='0px' y='0px' viewBox='0 0 42.5 42.5' style='enable-background:new 0 0 42.5 42.5;' xml:space='preserve' width='42.5' height='42.5'%3E %3Cpath d='M20.9,25.5c0,0.8-0.2,1.4-0.7,2s-1,0.8-1.7,0.8H9.1c-0.7,0-1.2-0.3-1.7-0.8s-0.7-1.2-0.7-2c0-0.8,0.1-1.5,0.2-2.2 s0.3-1.3,0.5-1.9c0.3-0.6,0.6-1.1,1.1-1.4c0.5-0.4,1.1-0.5,1.8-0.5c0.1,0,0.3,0.2,0.6,0.3s0.5,0.3,0.7,0.4c0.2,0.1,0.4,0.2,0.7,0.3 c0.3,0.1,0.5,0.2,0.8,0.3c0.3,0.1,0.5,0.1,0.8,0.1c0.3,0,0.5,0,0.8-0.1c0.3-0.1,0.5-0.1,0.8-0.3c0.3-0.1,0.5-0.2,0.7-0.3 c0.2-0.1,0.4-0.2,0.7-0.4c0.3-0.2,0.5-0.3,0.6-0.3c0.7,0,1.3,0.2,1.8,0.5c0.5,0.4,0.9,0.8,1.1,1.4c0.3,0.6,0.4,1.2,0.5,1.9 C20.8,24,20.9,24.7,20.9,25.5z M18,15.9c0,1.2-0.4,2.1-1.2,3c-0.8,0.8-1.8,1.2-3,1.2s-2.1-0.4-3-1.2s-1.2-1.8-1.2-3s0.4-2.1,1.2-3 c0.8-0.8,1.8-1.2,3-1.2s2.1,0.4,3,1.2C17.6,13.8,18,14.8,18,15.9z M35.1,24.1v1.2c0,0.2-0.1,0.3-0.2,0.4c-0.1,0.1-0.3,0.2-0.4,0.2 H23.9c-0.2,0-0.3-0.1-0.4-0.2c-0.1-0.1-0.2-0.3-0.2-0.4v-1.2c0-0.2,0.1-0.3,0.2-0.4c0.1-0.1,0.3-0.2,0.4-0.2h10.6 c0.2,0,0.3,0.1,0.4,0.2C35,23.8,35.1,24,35.1,24.1z M35.1,19.5v1c0,0.2-0.1,0.3-0.2,0.5c-0.1,0.1-0.3,0.2-0.5,0.2H23.9 c-0.2,0-0.3-0.1-0.5-0.2s-0.2-0.3-0.2-0.5v-1c0-0.2,0.1-0.3,0.2-0.5s0.3-0.2,0.5-0.2h10.5c0.2,0,0.3,0.1,0.5,0.2 C35,19.1,35.1,19.3,35.1,19.5z M35.1,14.7v1.2c0,0.2-0.1,0.3-0.2,0.4c-0.1,0.1-0.3,0.2-0.4,0.2H23.9c-0.2,0-0.3-0.1-0.4-0.2 c-0.1-0.1-0.2-0.3-0.2-0.4v-1.2c0-0.2,0.1-0.3,0.2-0.4c0.1-0.1,0.3-0.2,0.4-0.2h10.6c0.2,0,0.3,0.1,0.4,0.2S35.1,14.5,35.1,14.7z M37.4,32.4V10c0-0.2-0.1-0.3-0.2-0.4c-0.1-0.1-0.3-0.2-0.4-0.2H5c-0.2,0-0.3,0.1-0.4,0.2C4.4,9.7,4.4,9.8,4.4,10v22.4 c0,0.2,0.1,0.3,0.2,0.4C4.7,32.9,4.8,33,5,33h6.5v-1.8c0-0.2,0.1-0.3,0.2-0.4c0.1-0.1,0.3-0.2,0.4-0.2h1.2c0.2,0,0.3,0.1,0.4,0.2 c0.1,0.1,0.2,0.3,0.2,0.4V33H28v-1.8c0-0.2,0.1-0.3,0.2-0.4c0.1-0.1,0.3-0.2,0.4-0.2h1.2c0.2,0,0.3,0.1,0.4,0.2 c0.1,0.1,0.2,0.3,0.2,0.4V33h6.5c0.2,0,0.3-0.1,0.4-0.2C37.4,32.7,37.4,32.6,37.4,32.4z M39.8,10v22.4c0,0.8-0.3,1.5-0.9,2.1 c-0.6,0.6-1.3,0.9-2.1,0.9H5c-0.8,0-1.5-0.3-2.1-0.9C2.3,33.9,2,33.2,2,32.4V10c0-0.8,0.3-1.5,0.9-2.1S4.1,7,5,7h31.9 c0.8,0,1.5,0.3,2.1,0.9C39.5,8.4,39.8,9.1,39.8,10z'/%3E %3C/svg%3E\""

/***/ }),

/***/ 1676:
/***/ (function(module, exports) {

module.exports = "\"data:image/svg+xml,%3C?xml version='1.0' encoding='utf-8'?%3E %3C!-- Generator: Adobe Illustrator 21.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0) --%3E %3Csvg version='1.1' id='Ebene_1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' x='0px' y='0px' viewBox='0 0 42.5 42.5' style='enable-background:new 0 0 42.5 42.5;' xml:space='preserve' width='42.5' height='42.5'%3E %3Cpath d='M29.8,18.9c0.6,0.2,1.2,0.4,1.7,0.7c0.5,0.3,1.1,0.8,1.7,1.4s1.1,1.3,1.5,2.2s0.8,1.9,1,3.3c0.3,1.3,0.4,2.8,0.4,4.5 c0,1.9-0.6,3.6-1.9,5c-1.3,1.4-2.8,2.1-4.6,2.1H13.5c-1.8,0-3.3-0.7-4.6-2.1c-1.3-1.4-1.9-3-1.9-5c0-1.7,0.1-3.1,0.4-4.5 c0.3-1.3,0.6-2.4,1-3.3S9.4,21.6,10,21c0.6-0.6,1.1-1.1,1.7-1.4c0.5-0.3,1.1-0.5,1.7-0.7c-1-1.6-1.5-3.3-1.5-5.2 c0-1.3,0.3-2.6,0.8-3.8s1.2-2.2,2.1-3.1c0.9-0.9,1.9-1.6,3.1-2.1S20.2,4,21.5,4s2.6,0.3,3.8,0.8c1.2,0.5,2.2,1.2,3.1,2.1 c0.9,0.9,1.6,1.9,2.1,3.1c0.5,1.2,0.8,2.4,0.8,3.8C31.2,15.6,30.7,17.3,29.8,18.9z M21.5,6.4c-2,0-3.7,0.7-5.1,2.1 c-1.4,1.4-2.1,3.1-2.1,5.1s0.7,3.7,2.1,5.1c1.4,1.4,3.1,2.1,5.1,2.1s3.7-0.7,5.1-2.1c1.4-1.4,2.1-3.1,2.1-5.1s-0.7-3.7-2.1-5.1 C25.3,7.1,23.6,6.4,21.5,6.4z M29.6,35.5c1.1,0,2.1-0.5,2.9-1.4c0.8-0.9,1.2-2,1.2-3.3c0-3-0.5-5.4-1.5-7.1c-1-1.7-2.4-2.7-4.3-2.7 c-1.8,1.6-4,2.4-6.4,2.4S17,22.6,15.2,21c-1.9,0.1-3.3,1-4.3,2.7c-1,1.7-1.5,4.1-1.5,7.1c0,1.3,0.4,2.4,1.2,3.3 c0.8,0.9,1.7,1.4,2.9,1.4H29.6z'/%3E %3C/svg%3E\""

/***/ }),

/***/ 1677:
/***/ (function(module, exports) {

module.exports = "\"data:image/svg+xml,%3C?xml version='1.0' encoding='utf-8'?%3E %3C!-- Generator: Adobe Illustrator 21.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0) --%3E %3Csvg version='1.1' id='Ebene_1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' x='0px' y='0px' viewBox='0 0 42.5 42.5' style='enable-background:new 0 0 42.5 42.5;' xml:space='preserve' width='42.5' height='42.5'%3E %3Cpath d='M34.3,24.1v1.2c0,0.2-0.1,0.3-0.2,0.4c-0.1,0.1-0.3,0.2-0.4,0.2h-5.8c-0.2,0-0.3-0.1-0.4-0.2s-0.2-0.3-0.2-0.4v-1.2 c0-0.2,0.1-0.3,0.2-0.4s0.3-0.2,0.4-0.2h5.8c0.2,0,0.3,0.1,0.4,0.2C34.2,23.8,34.3,24,34.3,24.1z M34.3,19.5v1 c0,0.2-0.1,0.3-0.2,0.5s-0.3,0.2-0.5,0.2H28c-0.2,0-0.3-0.1-0.5-0.2s-0.2-0.3-0.2-0.5v-1c0-0.2,0.1-0.3,0.2-0.5s0.3-0.2,0.5-0.2h5.6 c0.2,0,0.3,0.1,0.5,0.2S34.3,19.3,34.3,19.5z M34.3,14.7v1.2c0,0.2-0.1,0.3-0.2,0.4c-0.1,0.1-0.3,0.2-0.4,0.2h-5.8 c-0.2,0-0.3-0.1-0.4-0.2s-0.2-0.3-0.2-0.4v-1.2c0-0.2,0.1-0.3,0.2-0.4c0.1-0.1,0.3-0.2,0.4-0.2h5.8c0.2,0,0.3,0.1,0.4,0.2 S34.3,14.5,34.3,14.7z M37.4,32.4V10c0-0.2-0.1-0.3-0.2-0.4c-0.1-0.1-0.3-0.2-0.4-0.2H5c-0.2,0-0.3,0.1-0.4,0.2 C4.4,9.7,4.4,9.8,4.4,10v22.4c0,0.2,0.1,0.3,0.2,0.4C4.7,32.9,4.8,33,5,33h6.5v-1.8c0-0.2,0.1-0.3,0.2-0.4c0.1-0.1,0.3-0.2,0.4-0.2 h1.2c0.2,0,0.3,0.1,0.4,0.2c0.1,0.1,0.2,0.3,0.2,0.4V33H28v-1.8c0-0.2,0.1-0.3,0.2-0.4s0.3-0.2,0.4-0.2h1.2c0.2,0,0.3,0.1,0.4,0.2 s0.2,0.3,0.2,0.4V33h6.5c0.2,0,0.3-0.1,0.4-0.2C37.4,32.7,37.4,32.6,37.4,32.4z M39.8,10v22.4c0,0.8-0.3,1.5-0.9,2.1 c-0.6,0.6-1.3,0.9-2.1,0.9H5c-0.8,0-1.5-0.3-2.1-0.9C2.3,33.9,2,33.2,2,32.4V10c0-0.8,0.3-1.5,0.9-2.1S4.1,7,5,7h31.9 c0.8,0,1.5,0.3,2.1,0.9C39.5,8.4,39.8,9.1,39.8,10z M12,20.3c-1.1,0.1-1.9,0.5-2.6,1.3H8c-0.5,0-1-0.2-1.4-0.4 C6.3,21,6.1,20.6,6.1,20c0-2.3,0.4-3.5,1.2-3.5c0.1,0,0.2,0.1,0.4,0.2C8,16.9,8.3,17,8.6,17.1c0.4,0.2,0.8,0.2,1.2,0.2 c0.4,0,0.9-0.1,1.3-0.2c-0.1,0.3-0.1,0.5-0.1,0.6C11.2,18.7,11.4,19.6,12,20.3z M22.7,26.8c0,0.8-0.3,1.4-0.7,1.9 c-0.5,0.5-1.1,0.7-1.9,0.7h-8.6c-0.8,0-1.4-0.2-1.9-0.7c-0.5-0.5-0.7-1.1-0.7-1.9c0-0.4,0-0.7,0.1-1.1C8.9,25.3,8.9,25,9,24.6 c0.1-0.4,0.2-0.7,0.3-1.1c0.1-0.3,0.3-0.6,0.4-0.9c0.2-0.3,0.4-0.6,0.6-0.8c0.2-0.2,0.5-0.4,0.8-0.5c0.3-0.1,0.7-0.2,1.1-0.2 c0.1,0,0.2,0.1,0.4,0.2c0.2,0.2,0.5,0.3,0.7,0.5c0.3,0.2,0.6,0.3,1.1,0.5s0.9,0.2,1.3,0.2c0.4,0,0.9-0.1,1.3-0.2s0.8-0.3,1.1-0.5 c0.3-0.2,0.5-0.3,0.7-0.5c0.2-0.2,0.4-0.2,0.4-0.2c0.4,0,0.8,0.1,1.1,0.2c0.3,0.2,0.6,0.3,0.8,0.5c0.2,0.2,0.4,0.5,0.6,0.8 c0.2,0.3,0.3,0.6,0.4,0.9c0.1,0.3,0.2,0.7,0.3,1.1c0.1,0.4,0.1,0.7,0.2,1.1C22.7,26.1,22.7,26.4,22.7,26.8z M12.4,14 c0,0.7-0.3,1.3-0.7,1.8s-1.1,0.7-1.8,0.7s-1.3-0.3-1.8-0.7S7.4,14.7,7.4,14s0.3-1.3,0.7-1.8c0.5-0.5,1.1-0.7,1.7-0.7 s1.3,0.3,1.8,0.7C12.1,12.7,12.4,13.3,12.4,14z M19.1,17.8c0,0.9-0.3,1.7-1,2.4c-0.7,0.7-1.5,1-2.4,1c-0.9,0-1.7-0.3-2.4-1 c-0.7-0.7-1-1.5-1-2.4s0.3-1.7,1-2.4c0.7-0.6,1.5-1,2.4-1c0.9,0,1.7,0.3,2.4,1C18.8,16.1,19.1,16.9,19.1,17.8z M25.4,20 c0,0.5-0.2,0.9-0.6,1.2c-0.4,0.3-0.8,0.4-1.4,0.4h-1.3c-0.7-0.8-1.6-1.3-2.6-1.3c0.5-0.8,0.8-1.6,0.8-2.5c0-0.2,0-0.4-0.1-0.6 c0.4,0.2,0.9,0.2,1.3,0.2c0.4,0,0.8-0.1,1.2-0.2c0.4-0.2,0.7-0.3,0.9-0.4c0.3-0.2,0.4-0.2,0.4-0.2C25,16.6,25.4,17.7,25.4,20z M24.2,14c0,0.7-0.3,1.3-0.7,1.8s-1.1,0.7-1.8,0.7c-0.7,0-1.3-0.3-1.8-0.7c-0.5-0.5-0.7-1.1-0.7-1.8s0.3-1.3,0.7-1.8 c0.5-0.5,1.1-0.7,1.8-0.7c0.7,0,1.3,0.3,1.8,0.7C23.9,12.7,24.2,13.3,24.2,14z'/%3E %3C/svg%3E\""

/***/ }),

/***/ 1678:
/***/ (function(module, exports) {

module.exports = "\"data:image/svg+xml,%3C?xml version='1.0' encoding='utf-8'?%3E %3C!-- Generator: Adobe Illustrator 21.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0) --%3E %3Csvg version='1.1' id='Ebene_1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' x='0px' y='0px' viewBox='0 0 42.5 42.5' style='enable-background:new 0 0 42.5 42.5;' xml:space='preserve' width='42.5' height='42.5'%3E %3Cpath d='M20.4,15.8h1v8.3h-1V15.8z M32.2,19.6H9.5v4.5h1v-3.8h20.7v3.8h1V19.6z M6.6,28.9h6.9v-4.8H6.6V28.9z M28.2,28.9h6.9v-4.8 h-6.9C28.2,24.1,28.2,28.9,28.2,28.9z M17.4,28.9h6.9v-4.8h-6.9V28.9z M17.4,15.8h6.9V11h-6.9V15.8z M37.4,32.4V10 c0-0.2-0.1-0.3-0.2-0.4c-0.1-0.1-0.3-0.2-0.4-0.2H5c-0.2,0-0.3,0.1-0.4,0.2C4.4,9.7,4.4,9.8,4.4,10v22.4c0,0.2,0.1,0.3,0.2,0.4 C4.7,32.9,4.8,33,5,33h6.5v-1.8c0-0.2,0.1-0.3,0.2-0.4c0.1-0.1,0.3-0.2,0.4-0.2h1.2c0.2,0,0.3,0.1,0.4,0.2c0.1,0.1,0.2,0.3,0.2,0.4 V33H28v-1.8c0-0.2,0.1-0.3,0.2-0.4s0.3-0.2,0.4-0.2h1.2c0.2,0,0.3,0.1,0.4,0.2s0.2,0.3,0.2,0.4V33h6.5c0.2,0,0.3-0.1,0.4-0.2 C37.4,32.7,37.4,32.6,37.4,32.4z M39.8,10v22.4c0,0.8-0.3,1.5-0.9,2.1c-0.6,0.6-1.3,0.9-2.1,0.9H5c-0.8,0-1.5-0.3-2.1-0.9 C2.3,33.9,2,33.2,2,32.4V10c0-0.8,0.3-1.5,0.9-2.1S4.1,7,5,7h31.9c0.8,0,1.5,0.3,2.1,0.9C39.5,8.4,39.8,9.1,39.8,10z M21.4,19.6h-1 v0.7h1V19.6z'/%3E %3C/svg%3E\""

/***/ }),

/***/ 1679:
/***/ (function(module, exports, __webpack_require__) {

// style-loader: Adds some css to the DOM by adding a <style> tag

// load the styles
var content = __webpack_require__(1680);
if(typeof content === 'string') content = [[module.i, content, '']];
// Prepare cssTransformation
var transform;

var options = {"hmr":true}
options.transform = transform
// add the styles to the DOM
var update = __webpack_require__(17)(content, options);
if(content.locals) module.exports = content.locals;
// Hot Module Replacement
if(false) {}

/***/ }),

/***/ 1680:
/***/ (function(module, exports, __webpack_require__) {

var escape = __webpack_require__(100);
exports = module.exports = __webpack_require__(16)(false);
// imports


// module
exports.push([module.i, "/*\n * Tine 2.0\n *\n * @license      http://www.gnu.org/licenses/agpl.html AGPL Version 3\n * @author       Michael Spahn <m.spahn@metaways.de>\n * @copyright    Copyright (c) 2018 Metaways Infosystems GmbH (http://www.metaways.de)\n *\n */\n\n.t-contenttype-contact .action_add {\n    background-image:url(" + escape(__webpack_require__(216)) + ") !important;\n}\n\n.t-contenttype-contact .action_edit {\n    background-image:url(" + escape(__webpack_require__(1681)) + ") !important;\n}\n\n.t-contenttype-contact .action_delete {\n    background-image:url(" + escape(__webpack_require__(278)) + ") !important;\n}\n\n.t-contenttype-contact .action_export {\n    background-image:url(" + escape(__webpack_require__(1682)) + ") !important;\n}\n\n.t-contenttype-contact .action_import {\n    background-image:url(" + escape(__webpack_require__(1683)) + ") !important;\n}", ""]);

// exports


/***/ }),

/***/ 1681:
/***/ (function(module, exports) {

module.exports = "\"data:image/svg+xml,%3C?xml version='1.0' encoding='utf-8'?%3E %3C!-- Generator: Adobe Illustrator 21.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0) --%3E %3Csvg version='1.1' id='Ebene_1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' x='0px' y='0px' viewBox='0 0 42.5 42.5' style='enable-background:new 0 0 42.5 42.5;' xml:space='preserve' width='42.5' height='42.5'%3E %3Cpath d='M35.4,25h2.4v7.4c0,0.8-0.3,1.5-0.9,2.1s-1.3,0.9-2.1,0.9H3c-0.8,0-1.5-0.3-2.1-0.9S0,33.2,0,32.4V10c0-0.8,0.3-1.5,0.9-2.1 S2.1,7,3,7h31.9c0.8,0,1.5,0.3,2.1,0.9s0.9,1.3,0.9,2.1v0.7h-2.4V10c0-0.2-0.1-0.3-0.2-0.4S35,9.4,34.8,9.4H3 c-0.2,0-0.3,0.1-0.4,0.2S2.4,9.8,2.4,10v22.4c0,0.2,0.1,0.3,0.2,0.4S2.8,33,3,33h6.5v-1.8c0-0.2,0.1-0.3,0.2-0.4 c0.1-0.1,0.3-0.2,0.4-0.2h1.2c0.2,0,0.3,0.1,0.4,0.2c0.1,0.1,0.2,0.3,0.2,0.4V33H26v-1.8c0-0.2,0.1-0.3,0.2-0.4s0.3-0.2,0.4-0.2h1.2 c0.2,0,0.3,0.1,0.4,0.2s0.2,0.3,0.2,0.4V33h6.5c0.2,0,0.3-0.1,0.4-0.2s0.2-0.3,0.2-0.4V25H35.4z M35,14.2l4.1,5.2L27,28.9l-4.6-0.6 l0.6-4.6L35,14.2z M41.8,17.2l-1.7,1.3L36,13.3l1.7-1.3c0.3-0.3,0.7-0.4,1.1-0.3s0.8,0.2,1,0.6l2.1,2.7c0.3,0.3,0.4,0.7,0.3,1.1 C42.4,16.6,42.2,16.9,41.8,17.2z M26.4,27.2l2.1-1.6l-2.1-2.7l-2.1,1.6l-0.1,0.9l1.5,0.2l-0.2,1.5L26.4,27.2z M34.9,16.5 c-0.2-0.2-0.3-0.2-0.5,0l-6.3,4.9c-0.2,0.2-0.2,0.3-0.1,0.5c0.2,0.2,0.3,0.2,0.5,0l6.3-4.9C35.1,16.9,35.1,16.7,34.9,16.5z M18.9,25.5c0,0.8-0.2,1.4-0.7,2s-1,0.8-1.7,0.8H7.1c-0.7,0-1.2-0.3-1.7-0.8s-0.7-1.2-0.7-2c0-0.8,0.1-1.5,0.2-2.2s0.3-1.3,0.5-1.9 c0.3-0.6,0.6-1.1,1.1-1.4c0.5-0.4,1.1-0.5,1.8-0.5c0.1,0,0.3,0.2,0.6,0.3s0.5,0.3,0.7,0.4c0.2,0.1,0.4,0.2,0.7,0.3 c0.3,0.1,0.5,0.2,0.8,0.3c0.3,0.1,0.5,0.1,0.8,0.1c0.3,0,0.5,0,0.8-0.1c0.3-0.1,0.5-0.1,0.8-0.3c0.3-0.1,0.5-0.2,0.7-0.3 c0.2-0.1,0.4-0.2,0.7-0.4c0.3-0.2,0.5-0.3,0.6-0.3c0.7,0,1.3,0.2,1.8,0.5c0.5,0.4,0.9,0.8,1.1,1.4c0.3,0.6,0.4,1.2,0.5,1.9 C18.8,24,18.9,24.7,18.9,25.5z M16,15.9c0,1.2-0.4,2.1-1.2,3c-0.8,0.8-1.8,1.2-3,1.2s-2.1-0.4-3-1.2s-1.2-1.8-1.2-3s0.4-2.1,1.2-3 c0.8-0.8,1.8-1.2,3-1.2s2.1,0.4,3,1.2C15.6,13.8,16,14.8,16,15.9z'/%3E %3C/svg%3E\""

/***/ }),

/***/ 1682:
/***/ (function(module, exports) {

module.exports = "\"data:image/svg+xml,%3C?xml version='1.0' encoding='utf-8'?%3E %3C!-- Generator: Adobe Illustrator 21.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0) --%3E %3Csvg version='1.1' id='Ebene_1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' x='0px' y='0px' viewBox='0 0 42.5 42.5' style='enable-background:new 0 0 42.5 42.5;' xml:space='preserve' width='42.5' height='42.5'%3E %3Cpath d='M35.4,32.4c0,0.2-0.1,0.3-0.2,0.4S35,33,34.8,33h-6.5v-1.8c0-0.2-0.1-0.3-0.2-0.4s-0.3-0.2-0.4-0.2h-1.2 c-0.2,0-0.3,0.1-0.4,0.2C26,30.9,26,31,26,31.2V33H11.8v-1.8c0-0.2-0.1-0.3-0.2-0.4c-0.1-0.1-0.3-0.2-0.4-0.2H10 c-0.2,0-0.3,0.1-0.4,0.2c-0.1,0.1-0.2,0.3-0.2,0.4V33H3c-0.2,0-0.3-0.1-0.4-0.2s-0.2-0.3-0.2-0.4V10c0-0.2,0.1-0.3,0.2-0.4 S2.8,9.4,3,9.4h31.9c0.2,0,0.3,0.1,0.4,0.2s0.2,0.3,0.2,0.4v3.1h2.4V10c0-0.8-0.3-1.5-0.9-2.1S35.7,7,34.8,7H3 C2.1,7,1.4,7.3,0.9,7.9S0,9.1,0,10v22.4c0,0.8,0.3,1.5,0.9,2.1s1.3,0.9,2.1,0.9h31.9c0.8,0,1.5-0.3,2.1-0.9s0.9-1.3,0.9-2.1v-3.1 h-2.4L35.4,32.4L35.4,32.4z M42.5,21.2c0,0.3-0.1,0.5-0.3,0.7L37,27.1c-0.2,0.2-0.4,0.3-0.7,0.3s-0.5-0.1-0.7-0.3L35,26.5 c-0.2-0.2-0.3-0.4-0.3-0.7s0.1-0.5,0.3-0.7l2.3-2.3H22.2c-0.3,0-0.5-0.1-0.7-0.3c-0.2-0.2-0.3-0.4-0.3-0.7v-1c0-0.3,0.1-0.5,0.3-0.7 c0.2-0.2,0.4-0.3,0.7-0.3h15.2L35,17.3c-0.2-0.2-0.3-0.4-0.3-0.7s0.1-0.5,0.3-0.7l0.6-0.6c0.2-0.2,0.4-0.3,0.7-0.3s0.5,0.1,0.7,0.3 l5.2,5.2C42.4,20.6,42.5,20.9,42.5,21.2z'/%3E %3C/svg%3E\""

/***/ }),

/***/ 1683:
/***/ (function(module, exports) {

module.exports = "\"data:image/svg+xml,%3C?xml version='1.0' encoding='utf-8'?%3E %3C!-- Generator: Adobe Illustrator 21.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0) --%3E %3Csvg version='1.1' id='Ebene_1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' x='0px' y='0px' viewBox='0 0 42.5 42.5' style='enable-background:new 0 0 42.5 42.5;' xml:space='preserve' width='42.5' height='42.5'%3E %3Cpath d='M32.2,24.1 M37.4,32.4V10c0-0.2-0.1-0.3-0.2-0.4c-0.1-0.1-0.3-0.2-0.4-0.2H5c-0.2,0-0.3,0.1-0.4,0.2C4.4,9.7,4.4,9.8,4.4,10 v22.4c0,0.2,0.1,0.3,0.2,0.4C4.7,32.9,4.8,33,5,33h6.5v-1.8c0-0.2,0.1-0.3,0.2-0.4c0.1-0.1,0.3-0.2,0.4-0.2h1.2 c0.2,0,0.3,0.1,0.4,0.2c0.1,0.1,0.2,0.3,0.2,0.4V33H28v-1.8c0-0.2,0.1-0.3,0.2-0.4c0.1-0.1,0.3-0.2,0.4-0.2h1.2 c0.2,0,0.3,0.1,0.4,0.2c0.1,0.1,0.2,0.3,0.2,0.4V33h6.5c0.2,0,0.3-0.1,0.4-0.2C37.4,32.7,37.4,32.6,37.4,32.4z M39.8,10v22.4 c0,0.8-0.3,1.5-0.9,2.1c-0.6,0.6-1.3,0.9-2.1,0.9H5c-0.8,0-1.5-0.3-2.1-0.9C2.3,33.9,2,33.2,2,32.4V10c0-0.8,0.3-1.5,0.9-2.1 S4.1,7,5,7h31.9c0.8,0,1.5,0.3,2.1,0.9C39.5,8.4,39.8,9.1,39.8,10z M23.3,21.2c0,0.3-0.1,0.5-0.3,0.7l-5.2,5.2 c-0.2,0.2-0.4,0.3-0.7,0.3c-0.3,0-0.5-0.1-0.7-0.3l-0.6-0.6c-0.2-0.2-0.3-0.4-0.3-0.7s0.1-0.5,0.3-0.7l2.3-2.3H2.9 c-0.3,0-0.5-0.1-0.7-0.3C2.1,22.2,2,22,2,21.7v-1c0-0.3,0.1-0.5,0.3-0.7c0.2-0.2,0.4-0.3,0.7-0.3h15.2l-2.3-2.3 c-0.2-0.2-0.3-0.4-0.3-0.7s0.1-0.5,0.3-0.7l0.6-0.6c0.2-0.2,0.4-0.3,0.7-0.3c0.3,0,0.5,0.1,0.7,0.3l5.2,5.2 C23.2,20.6,23.3,20.9,23.3,21.2z'/%3E %3C/svg%3E\""

/***/ }),

/***/ 1684:
/***/ (function(module, exports, __webpack_require__) {

// style-loader: Adds some css to the DOM by adding a <style> tag

// load the styles
var content = __webpack_require__(1685);
if(typeof content === 'string') content = [[module.i, content, '']];
// Prepare cssTransformation
var transform;

var options = {"hmr":true}
options.transform = transform
// add the styles to the DOM
var update = __webpack_require__(17)(content, options);
if(content.locals) module.exports = content.locals;
// Hot Module Replacement
if(false) {}

/***/ }),

/***/ 1685:
/***/ (function(module, exports, __webpack_require__) {

var escape = __webpack_require__(100);
exports = module.exports = __webpack_require__(16)(false);
// imports


// module
exports.push([module.i, "/*\n * Tine 2.0\n *\n * @license      http://www.gnu.org/licenses/agpl.html AGPL Version 3\n * @author       Michael Spahn <m.spahn@metaways.de>\n * @copyright    Copyright (c) 2018 Metaways Infosystems GmbH (http://www.metaways.de)\n *\n */\n\n\n.t-contenttype-list .action_add {\n    background-image:url(" + escape(__webpack_require__(516)) + ") !important;\n}\n\n.t-contenttype-list .action_edit {\n    background-image:url(" + escape(__webpack_require__(1686)) + ") !important;\n}", ""]);

// exports


/***/ }),

/***/ 1686:
/***/ (function(module, exports) {

module.exports = "\"data:image/svg+xml,%3C?xml version='1.0' encoding='utf-8'?%3E %3C!-- Generator: Adobe Illustrator 21.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0) --%3E %3Csvg version='1.1' id='Ebene_1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' x='0px' y='0px' viewBox='0 0 42.5 42.5' style='enable-background:new 0 0 42.5 42.5;' xml:space='preserve' width='42.5' height='42.5'%3E %3Cpath d='M35.5,25h2.4v7.4c0,0.8-0.3,1.5-0.9,2.1s-1.3,0.9-2.1,0.9H3c-0.8,0-1.5-0.3-2.1-0.9S0,33.2,0,32.4V10c0-0.8,0.3-1.5,0.9-2.1 S2.2,7,3,7h31.9c0.8,0,1.5,0.3,2.1,0.9s0.9,1.3,0.9,2.1v0.7h-2.4V10c0-0.2-0.1-0.3-0.2-0.4S35,9.4,34.9,9.4H3 c-0.2,0-0.3,0.1-0.4,0.2S2.4,9.8,2.4,10v22.4c0,0.2,0.1,0.3,0.2,0.4S2.8,33,3,33h6.5v-1.8c0-0.2,0.1-0.3,0.2-0.4 c0.1-0.1,0.3-0.2,0.4-0.2h1.2c0.2,0,0.3,0.1,0.4,0.2c0.1,0.1,0.2,0.3,0.2,0.4V33H26v-1.8c0-0.2,0.1-0.3,0.2-0.4s0.3-0.2,0.4-0.2h1.2 c0.2,0,0.3,0.1,0.4,0.2s0.2,0.3,0.2,0.4V33h6.5c0.2,0,0.3-0.1,0.4-0.2s0.2-0.3,0.2-0.4C35.5,32.4,35.5,25,35.5,25z M35,14.2l4.1,5.2 L27,28.9l-4.6-0.6l0.6-4.6L35,14.2z M41.9,17.2l-1.7,1.3l-4.1-5.2l1.7-1.3c0.3-0.3,0.7-0.4,1.1-0.3c0.4,0.1,0.8,0.2,1,0.6L42,15 c0.3,0.3,0.4,0.7,0.3,1.1C42.2,16.5,42.2,16.9,41.9,17.2z M26.5,27.2l2.1-1.6l-2.1-2.7l-2.1,1.6l-0.1,0.9l1.5,0.2l-0.2,1.5 L26.5,27.2z M35,16.5c-0.2-0.2-0.3-0.2-0.5,0l-6.3,4.9c-0.2,0.2-0.2,0.3-0.1,0.5c0.2,0.2,0.3,0.2,0.5,0l6.3-4.9 C35.1,16.9,35.1,16.7,35,16.5z M10,20.3c-1.1,0.1-1.9,0.5-2.6,1.3H6.1c-0.5,0-1-0.2-1.4-0.4C4.3,21,4.1,20.6,4.1,20 c0-2.3,0.4-3.5,1.2-3.5c0.1,0,0.2,0.1,0.4,0.2C6,16.9,6.3,17,6.7,17.1c0.4,0.2,0.8,0.2,1.2,0.2c0.4,0,0.9-0.1,1.3-0.2 c-0.1,0.3-0.1,0.5-0.1,0.6C9.2,18.7,9.5,19.6,10,20.3z M20.8,26.8c0,0.8-0.3,1.4-0.7,1.9s-1.1,0.7-1.9,0.7H9.5 c-0.8,0-1.4-0.2-1.9-0.7c-0.5-0.5-0.7-1.1-0.7-1.9c0-0.4,0-0.7,0.1-1.1C6.9,25.3,6.9,25,7,24.6c0.1-0.4,0.2-0.7,0.3-1.1 c0.1-0.3,0.3-0.6,0.4-0.9s0.4-0.6,0.6-0.8c0.2-0.2,0.5-0.4,0.8-0.5c0.3-0.1,0.7-0.2,1.1-0.2c0.1,0,0.2,0.1,0.4,0.2 c0.2,0.2,0.5,0.3,0.7,0.5c0.3,0.2,0.6,0.3,1.1,0.5c0.4,0.2,0.9,0.2,1.3,0.2c0.4,0,0.9-0.1,1.3-0.2c0.4-0.2,0.8-0.3,1.1-0.5 c0.3-0.2,0.5-0.3,0.7-0.5c0.2-0.2,0.4-0.2,0.4-0.2c0.4,0,0.8,0.1,1.1,0.2s0.6,0.3,0.8,0.5c0.2,0.2,0.4,0.5,0.6,0.8 c0.2,0.3,0.3,0.6,0.4,0.9c0.1,0.3,0.2,0.7,0.3,1.1c0.1,0.4,0.1,0.7,0.2,1.1C20.8,26.1,20.8,26.4,20.8,26.8z M10.5,14 c0,0.7-0.3,1.3-0.7,1.8c-0.5,0.5-1.1,0.7-1.8,0.7c-0.7,0-1.3-0.3-1.8-0.7c-0.5-0.5-0.7-1.1-0.7-1.8s0.3-1.3,0.7-1.8s1.1-0.7,1.7-0.7 s1.3,0.3,1.8,0.7S10.5,13.3,10.5,14z M17.2,17.8c0,0.9-0.3,1.7-1,2.4c-0.7,0.7-1.5,1-2.4,1c-0.9,0-1.7-0.3-2.4-1 c-0.7-0.7-1-1.5-1-2.4s0.3-1.7,1-2.4s1.5-1,2.4-1c0.9,0,1.7,0.3,2.4,1C16.9,16.1,17.2,16.9,17.2,17.8z M23.5,20 c0,0.5-0.2,0.9-0.6,1.2s-0.8,0.4-1.4,0.4h-1.3c-0.7-0.8-1.6-1.3-2.6-1.3c0.5-0.8,0.8-1.6,0.8-2.5c0-0.2,0-0.4-0.1-0.6 c0.4,0.2,0.9,0.2,1.3,0.2c0.4,0,0.8-0.1,1.2-0.2c0.4-0.2,0.7-0.3,0.9-0.4c0.3-0.2,0.4-0.2,0.4-0.2C23.1,16.6,23.5,17.7,23.5,20z M22.2,14c0,0.7-0.3,1.3-0.7,1.8c-0.5,0.5-1.1,0.7-1.8,0.7c-0.7,0-1.3-0.3-1.8-0.7c-0.5-0.5-0.7-1.1-0.7-1.8s0.3-1.3,0.7-1.8 c0.5-0.5,1.1-0.7,1.8-0.7c0.7,0,1.3,0.3,1.8,0.7C22,12.7,22.2,13.3,22.2,14z'/%3E %3C/svg%3E\""

/***/ }),

/***/ 1687:
/***/ (function(module, exports, __webpack_require__) {

// style-loader: Adds some css to the DOM by adding a <style> tag

// load the styles
var content = __webpack_require__(1688);
if(typeof content === 'string') content = [[module.i, content, '']];
// Prepare cssTransformation
var transform;

var options = {"hmr":true}
options.transform = transform
// add the styles to the DOM
var update = __webpack_require__(17)(content, options);
if(content.locals) module.exports = content.locals;
// Hot Module Replacement
if(false) {}

/***/ }),

/***/ 1688:
/***/ (function(module, exports, __webpack_require__) {

var escape = __webpack_require__(100);
exports = module.exports = __webpack_require__(16)(false);
// imports


// module
exports.push([module.i, "/*\n * Tine 2.0\n *\n * @license      http://www.gnu.org/licenses/agpl.html AGPL Version 3\n * @author       Michael Spahn <m.spahn@metaways.de>\n * @copyright    Copyright (c) 2018 Metaways Infosystems GmbH (http://www.metaways.de)\n *\n */\n\n\n.t-contenttype-structure .action_add {\n    background-image:url(" + escape(__webpack_require__(181)) + ") !important;\n}", ""]);

// exports


/***/ }),

/***/ 1689:
/***/ (function(module, exports, __webpack_require__) {

// style-loader: Adds some css to the DOM by adding a <style> tag

// load the styles
var content = __webpack_require__(1690);
if(typeof content === 'string') content = [[module.i, content, '']];
// Prepare cssTransformation
var transform;

var options = {"hmr":true}
options.transform = transform
// add the styles to the DOM
var update = __webpack_require__(17)(content, options);
if(content.locals) module.exports = content.locals;
// Hot Module Replacement
if(false) {}

/***/ }),

/***/ 1690:
/***/ (function(module, exports, __webpack_require__) {

var escape = __webpack_require__(100);
exports = module.exports = __webpack_require__(16)(false);
// imports


// module
exports.push([module.i, "/*\n * Tine 2.0\n *\n * @license      http://www.gnu.org/licenses/agpl.html AGPL Version 3\n * @author       Michael Spahn <m.spahn@metaways.de>\n * @copyright    Copyright (c) 2018 Metaways Infosystems GmbH (http://www.metaways.de)\n *\n */\n\n.t-contenttype-resource .action_add {\n    background-image:url(" + escape(__webpack_require__(181)) + ") !important;\n}\n\n.t-contenttype-resource .action_edit {\n}", ""]);

// exports


/***/ }),

/***/ 17:
/***/ (function(module, exports, __webpack_require__) {

/*
	MIT License http://www.opensource.org/licenses/mit-license.php
	Author Tobias Koppers @sokra
*/

var stylesInDom = {};

var	memoize = function (fn) {
	var memo;

	return function () {
		if (typeof memo === "undefined") memo = fn.apply(this, arguments);
		return memo;
	};
};

var isOldIE = memoize(function () {
	// Test for IE <= 9 as proposed by Browserhacks
	// @see http://browserhacks.com/#hack-e71d8692f65334173fee715c222cb805
	// Tests for existence of standard globals is to allow style-loader
	// to operate correctly into non-standard environments
	// @see https://github.com/webpack-contrib/style-loader/issues/177
	return window && document && document.all && !window.atob;
});

var getElement = (function (fn) {
	var memo = {};

	return function(selector) {
		if (typeof memo[selector] === "undefined") {
			var styleTarget = fn.call(this, selector);
			// Special case to return head of iframe instead of iframe itself
			if (styleTarget instanceof window.HTMLIFrameElement) {
				try {
					// This will throw an exception if access to iframe is blocked
					// due to cross-origin restrictions
					styleTarget = styleTarget.contentDocument.head;
				} catch(e) {
					styleTarget = null;
				}
			}
			memo[selector] = styleTarget;
		}
		return memo[selector]
	};
})(function (target) {
	return document.querySelector(target)
});

var singleton = null;
var	singletonCounter = 0;
var	stylesInsertedAtTop = [];

var	fixUrls = __webpack_require__(39);

module.exports = function(list, options) {
	if (typeof DEBUG !== "undefined" && DEBUG) {
		if (typeof document !== "object") throw new Error("The style-loader cannot be used in a non-browser environment");
	}

	options = options || {};

	options.attrs = typeof options.attrs === "object" ? options.attrs : {};

	// Force single-tag solution on IE6-9, which has a hard limit on the # of <style>
	// tags it will allow on a page
	if (!options.singleton && typeof options.singleton !== "boolean") options.singleton = isOldIE();

	// By default, add <style> tags to the <head> element
	if (!options.insertInto) options.insertInto = "head";

	// By default, add <style> tags to the bottom of the target
	if (!options.insertAt) options.insertAt = "bottom";

	var styles = listToStyles(list, options);

	addStylesToDom(styles, options);

	return function update (newList) {
		var mayRemove = [];

		for (var i = 0; i < styles.length; i++) {
			var item = styles[i];
			var domStyle = stylesInDom[item.id];

			domStyle.refs--;
			mayRemove.push(domStyle);
		}

		if(newList) {
			var newStyles = listToStyles(newList, options);
			addStylesToDom(newStyles, options);
		}

		for (var i = 0; i < mayRemove.length; i++) {
			var domStyle = mayRemove[i];

			if(domStyle.refs === 0) {
				for (var j = 0; j < domStyle.parts.length; j++) domStyle.parts[j]();

				delete stylesInDom[domStyle.id];
			}
		}
	};
};

function addStylesToDom (styles, options) {
	for (var i = 0; i < styles.length; i++) {
		var item = styles[i];
		var domStyle = stylesInDom[item.id];

		if(domStyle) {
			domStyle.refs++;

			for(var j = 0; j < domStyle.parts.length; j++) {
				domStyle.parts[j](item.parts[j]);
			}

			for(; j < item.parts.length; j++) {
				domStyle.parts.push(addStyle(item.parts[j], options));
			}
		} else {
			var parts = [];

			for(var j = 0; j < item.parts.length; j++) {
				parts.push(addStyle(item.parts[j], options));
			}

			stylesInDom[item.id] = {id: item.id, refs: 1, parts: parts};
		}
	}
}

function listToStyles (list, options) {
	var styles = [];
	var newStyles = {};

	for (var i = 0; i < list.length; i++) {
		var item = list[i];
		var id = options.base ? item[0] + options.base : item[0];
		var css = item[1];
		var media = item[2];
		var sourceMap = item[3];
		var part = {css: css, media: media, sourceMap: sourceMap};

		if(!newStyles[id]) styles.push(newStyles[id] = {id: id, parts: [part]});
		else newStyles[id].parts.push(part);
	}

	return styles;
}

function insertStyleElement (options, style) {
	var target = getElement(options.insertInto)

	if (!target) {
		throw new Error("Couldn't find a style target. This probably means that the value for the 'insertInto' parameter is invalid.");
	}

	var lastStyleElementInsertedAtTop = stylesInsertedAtTop[stylesInsertedAtTop.length - 1];

	if (options.insertAt === "top") {
		if (!lastStyleElementInsertedAtTop) {
			target.insertBefore(style, target.firstChild);
		} else if (lastStyleElementInsertedAtTop.nextSibling) {
			target.insertBefore(style, lastStyleElementInsertedAtTop.nextSibling);
		} else {
			target.appendChild(style);
		}
		stylesInsertedAtTop.push(style);
	} else if (options.insertAt === "bottom") {
		target.appendChild(style);
	} else if (typeof options.insertAt === "object" && options.insertAt.before) {
		var nextSibling = getElement(options.insertInto + " " + options.insertAt.before);
		target.insertBefore(style, nextSibling);
	} else {
		throw new Error("[Style Loader]\n\n Invalid value for parameter 'insertAt' ('options.insertAt') found.\n Must be 'top', 'bottom', or Object.\n (https://github.com/webpack-contrib/style-loader#insertat)\n");
	}
}

function removeStyleElement (style) {
	if (style.parentNode === null) return false;
	style.parentNode.removeChild(style);

	var idx = stylesInsertedAtTop.indexOf(style);
	if(idx >= 0) {
		stylesInsertedAtTop.splice(idx, 1);
	}
}

function createStyleElement (options) {
	var style = document.createElement("style");

	options.attrs.type = "text/css";

	addAttrs(style, options.attrs);
	insertStyleElement(options, style);

	return style;
}

function createLinkElement (options) {
	var link = document.createElement("link");

	options.attrs.type = "text/css";
	options.attrs.rel = "stylesheet";

	addAttrs(link, options.attrs);
	insertStyleElement(options, link);

	return link;
}

function addAttrs (el, attrs) {
	Object.keys(attrs).forEach(function (key) {
		el.setAttribute(key, attrs[key]);
	});
}

function addStyle (obj, options) {
	var style, update, remove, result;

	// If a transform function was defined, run it on the css
	if (options.transform && obj.css) {
	    result = options.transform(obj.css);

	    if (result) {
	    	// If transform returns a value, use that instead of the original css.
	    	// This allows running runtime transformations on the css.
	    	obj.css = result;
	    } else {
	    	// If the transform function returns a falsy value, don't add this css.
	    	// This allows conditional loading of css
	    	return function() {
	    		// noop
	    	};
	    }
	}

	if (options.singleton) {
		var styleIndex = singletonCounter++;

		style = singleton || (singleton = createStyleElement(options));

		update = applyToSingletonTag.bind(null, style, styleIndex, false);
		remove = applyToSingletonTag.bind(null, style, styleIndex, true);

	} else if (
		obj.sourceMap &&
		typeof URL === "function" &&
		typeof URL.createObjectURL === "function" &&
		typeof URL.revokeObjectURL === "function" &&
		typeof Blob === "function" &&
		typeof btoa === "function"
	) {
		style = createLinkElement(options);
		update = updateLink.bind(null, style, options);
		remove = function () {
			removeStyleElement(style);

			if(style.href) URL.revokeObjectURL(style.href);
		};
	} else {
		style = createStyleElement(options);
		update = applyToTag.bind(null, style);
		remove = function () {
			removeStyleElement(style);
		};
	}

	update(obj);

	return function updateStyle (newObj) {
		if (newObj) {
			if (
				newObj.css === obj.css &&
				newObj.media === obj.media &&
				newObj.sourceMap === obj.sourceMap
			) {
				return;
			}

			update(obj = newObj);
		} else {
			remove();
		}
	};
}

var replaceText = (function () {
	var textStore = [];

	return function (index, replacement) {
		textStore[index] = replacement;

		return textStore.filter(Boolean).join('\n');
	};
})();

function applyToSingletonTag (style, index, remove, obj) {
	var css = remove ? "" : obj.css;

	if (style.styleSheet) {
		style.styleSheet.cssText = replaceText(index, css);
	} else {
		var cssNode = document.createTextNode(css);
		var childNodes = style.childNodes;

		if (childNodes[index]) style.removeChild(childNodes[index]);

		if (childNodes.length) {
			style.insertBefore(cssNode, childNodes[index]);
		} else {
			style.appendChild(cssNode);
		}
	}
}

function applyToTag (style, obj) {
	var css = obj.css;
	var media = obj.media;

	if(media) {
		style.setAttribute("media", media)
	}

	if(style.styleSheet) {
		style.styleSheet.cssText = css;
	} else {
		while(style.firstChild) {
			style.removeChild(style.firstChild);
		}

		style.appendChild(document.createTextNode(css));
	}
}

function updateLink (link, options, obj) {
	var css = obj.css;
	var sourceMap = obj.sourceMap;

	/*
		If convertToAbsoluteUrls isn't defined, but sourcemaps are enabled
		and there is no publicPath defined then lets turn convertToAbsoluteUrls
		on by default.  Otherwise default to the convertToAbsoluteUrls option
		directly
	*/
	var autoFixUrls = options.convertToAbsoluteUrls === undefined && sourceMap;

	if (options.convertToAbsoluteUrls || autoFixUrls) {
		css = fixUrls(css);
	}

	if (sourceMap) {
		// http://stackoverflow.com/a/26603875
		css += "\n/*# sourceMappingURL=data:application/json;base64," + btoa(unescape(encodeURIComponent(JSON.stringify(sourceMap)))) + " */";
	}

	var blob = new Blob([css], { type: "text/css" });

	var oldSrc = link.href;

	link.href = URL.createObjectURL(blob);

	if(oldSrc) URL.revokeObjectURL(oldSrc);
}


/***/ }),

/***/ 181:
/***/ (function(module, exports) {

module.exports = "\"data:image/svg+xml,%3C?xml version='1.0' encoding='utf-8'?%3E %3C!-- Generator: Adobe Illustrator 21.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0) --%3E %3Csvg version='1.1' id='Ebene_1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' x='0px' y='0px' viewBox='0 0 42.5 42.5' style='enable-background:new 0 0 42.5 42.5;' xml:space='preserve' width='42.5' height='42.5'%3E %3Cpath d='M28.3,9.8C27.8,6.5,24.7,4,21,4c-4.1,0-7.4,3-7.4,6.8c0,1,0.9,1.9,2,1.9c1.1,0,2-0.8,2-1.9c0-1.7,1.5-3.1,3.4-3.1 c1.9,0,3.4,1.4,3.4,3.1c0,2.6-7,3.6-7,3.6l0,0c-2,0.3-3.5,2-3.5,3.9V34c0,2.2,1.9,4,4.3,4h6c2.2,0,4-1.6,4.2-3.5l0,0v-0.1 c0-0.1,0-0.2,0-0.4V18.3c0-0.1,0-0.2,0-0.4v-6.8c0-0.1,0-0.2,0-0.4c0-0.2,0-0.5,0-0.7L28.3,9.8C28.4,9.8,28.4,9.8,28.3,9.8L28.3,9.8 z M27.7,27.5'/%3E %3C/svg%3E\""

/***/ }),

/***/ 216:
/***/ (function(module, exports) {

module.exports = "\"data:image/svg+xml,%3C?xml version='1.0' encoding='utf-8'?%3E %3C!-- Generator: Adobe Illustrator 21.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0) --%3E %3Csvg version='1.1' id='Ebene_1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' x='0px' y='0px' viewBox='0 0 42.5 42.5' style='enable-background:new 0 0 42.5 42.5;' xml:space='preserve' width='42.5' height='42.5'%3E %3Cpath d='M20.9,25.5c0,0.8-0.2,1.4-0.7,2s-1,0.8-1.7,0.8H9.1c-0.7,0-1.2-0.3-1.7-0.8s-0.7-1.2-0.7-2s0.1-1.5,0.2-2.2s0.3-1.3,0.5-1.9 C7.7,20.8,8,20.3,8.5,20c0.5-0.4,1.1-0.5,1.8-0.5c0.1,0,0.3,0.2,0.6,0.3s0.5,0.3,0.7,0.4s0.4,0.2,0.7,0.3c0.3,0.1,0.5,0.2,0.8,0.3 c0.3,0.1,0.5,0.1,0.8,0.1s0.5,0,0.8-0.1s0.5-0.1,0.8-0.3c0.3-0.1,0.5-0.2,0.7-0.3c0.2-0.1,0.4-0.2,0.7-0.4c0.3-0.2,0.5-0.3,0.6-0.3 c0.7,0,1.3,0.2,1.8,0.5c0.5,0.4,0.9,0.8,1.1,1.4c0.3,0.6,0.4,1.2,0.5,1.9C20.8,24,20.9,24.7,20.9,25.5z M18,15.9 c0,1.2-0.4,2.1-1.2,3c-0.8,0.8-1.8,1.2-3,1.2s-2.1-0.4-3-1.2s-1.2-1.8-1.2-3s0.4-2.1,1.2-3c0.8-0.8,1.8-1.2,3-1.2s2.1,0.4,3,1.2 C17.6,13.8,18,14.8,18,15.9z M37.4,32.4V10c0-0.2-0.1-0.3-0.2-0.4c-0.1-0.1-0.3-0.2-0.4-0.2H5c-0.2,0-0.3,0.1-0.4,0.2 C4.4,9.7,4.4,9.8,4.4,10v22.4c0,0.2,0.1,0.3,0.2,0.4C4.7,32.9,4.8,33,5,33h6.5v-1.8c0-0.2,0.1-0.3,0.2-0.4c0.1-0.1,0.3-0.2,0.4-0.2 h1.2c0.2,0,0.3,0.1,0.4,0.2c0.1,0.1,0.2,0.3,0.2,0.4V33H28v-1.8c0-0.2,0.1-0.3,0.2-0.4s0.3-0.2,0.4-0.2h1.2c0.2,0,0.3,0.1,0.4,0.2 s0.2,0.3,0.2,0.4V33h6.5c0.2,0,0.3-0.1,0.4-0.2C37.4,32.7,37.4,32.6,37.4,32.4z M39.8,10v22.4c0,0.8-0.3,1.5-0.9,2.1 c-0.6,0.6-1.3,0.9-2.1,0.9H5c-0.8,0-1.5-0.3-2.1-0.9C2.3,33.9,2,33.2,2,32.4V10c0-0.8,0.3-1.5,0.9-2.1S4.1,7,5,7h31.9 c0.8,0,1.5,0.3,2.1,0.9C39.5,8.4,39.8,9.1,39.8,10z M23.4,21.1c-0.1-0.1-0.2-0.3-0.2-0.4v-1.2c0-0.2,0.1-0.3,0.2-0.4 s0.3-0.2,0.4-0.2h4.3v-4.3c0-0.2,0.1-0.3,0.2-0.4s0.3-0.2,0.4-0.2h1.2c0.2,0,0.3,0.1,0.4,0.2s0.2,0.3,0.2,0.4v4.3h4.3 c0.2,0,0.3,0.1,0.4,0.2s0.2,0.3,0.2,0.4v1.2c0,0.2-0.1,0.3-0.2,0.4s-0.3,0.2-0.4,0.2h-4.3v4.3c0,0.2-0.1,0.3-0.2,0.4 s-0.3,0.2-0.4,0.2h-1.2c-0.2,0-0.3-0.1-0.4-0.2s-0.2-0.3-0.2-0.4v-4.3h-4.3C23.7,21.2,23.5,21.2,23.4,21.1z'/%3E %3C/svg%3E\""

/***/ }),

/***/ 278:
/***/ (function(module, exports) {

module.exports = "\"data:image/svg+xml,%3C?xml version='1.0' encoding='utf-8'?%3E %3C!-- Generator: Adobe Illustrator 21.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0) --%3E %3Csvg version='1.1' id='Ebene_1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' x='0px' y='0px' viewBox='0 0 42.5 42.5' style='enable-background:new 0 0 42.5 42.5;' xml:space='preserve' width='42.5' height='42.5'%3E %3Cpath d='M32.2,24.1 M37.4,32.4V10c0-0.2-0.1-0.3-0.2-0.4c-0.1-0.1-0.3-0.2-0.4-0.2H5c-0.2,0-0.3,0.1-0.4,0.2C4.4,9.7,4.4,9.8,4.4,10 v22.4c0,0.2,0.1,0.3,0.2,0.4C4.7,32.9,4.8,33,5,33h6.5v-1.8c0-0.2,0.1-0.3,0.2-0.4c0.1-0.1,0.3-0.2,0.4-0.2h1.2 c0.2,0,0.3,0.1,0.4,0.2c0.1,0.1,0.2,0.3,0.2,0.4V33H28v-1.8c0-0.2,0.1-0.3,0.2-0.4c0.1-0.1,0.3-0.2,0.4-0.2h1.2 c0.2,0,0.3,0.1,0.4,0.2c0.1,0.1,0.2,0.3,0.2,0.4V33h6.5c0.2,0,0.3-0.1,0.4-0.2C37.4,32.7,37.4,32.6,37.4,32.4z M39.8,10v22.4 c0,0.8-0.3,1.5-0.9,2.1c-0.6,0.6-1.3,0.9-2.1,0.9H5c-0.8,0-1.5-0.3-2.1-0.9C2.3,33.9,2,33.2,2,32.4V10c0-0.8,0.3-1.5,0.9-2.1 S4.1,7,5,7h31.9c0.8,0,1.5,0.3,2.1,0.9C39.5,8.4,39.8,9.1,39.8,10z M28.3,26.8L27.1,28c-0.2,0.2-0.4,0.2-0.6,0.2s-0.4-0.1-0.6-0.2 l-5-5l-5,5c-0.2,0.2-0.4,0.2-0.6,0.2s-0.4-0.1-0.6-0.2l-1.2-1.2c-0.2-0.2-0.2-0.4-0.2-0.6c0-0.2,0.1-0.4,0.2-0.6l5-5l-5-5 c-0.2-0.2-0.2-0.4-0.2-0.6s0.1-0.4,0.2-0.6l1.2-1.2c0.2-0.2,0.4-0.2,0.6-0.2s0.4,0.1,0.6,0.2l5,5l5-5c0.2-0.2,0.4-0.2,0.6-0.2 s0.4,0.1,0.6,0.2l1.2,1.2c0.2,0.2,0.2,0.4,0.2,0.6s-0.1,0.4-0.2,0.6l-5,5l5,5c0.2,0.2,0.2,0.4,0.2,0.6 C28.6,26.4,28.5,26.6,28.3,26.8z'/%3E %3C/svg%3E\""

/***/ }),

/***/ 293:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 * 
 * @package     Addressbook
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Cornelius Weiss <c.weiss@metaways.de>
 * @copyright   Copyright (c) 2007-2013 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 */
Ext.ns('Tine.Addressbook');
/**
 * Contact grid panel
 * 
 * @namespace   Tine.Addressbook
 * @class       Tine.Addressbook.ContactGridPanel
 * @extends     Tine.widgets.grid.GridPanel
 * 
 * <p>Contact Grid Panel</p>
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Cornelius Weiss <c.weiss@metaways.de>
 * @copyright   Copyright (c) 2007-2011 Metaways Infosystems GmbH (http://www.metaways.de)
 * 
 * @param       {Object} config
 * @constructor
 * Create a new Tine.Addressbook.ContactGridPanel
 */

Tine.Addressbook.ContactGridPanel = Ext.extend(Tine.widgets.grid.GridPanel, {
  /**
   * record class
   * @cfg {Tine.Addressbook.Model.Contact} recordClass
   */
  recordClass: Tine.Addressbook.Model.Contact,

  /**
   * grid specific
   * @private
   */
  defaultSortInfo: {
    field: 'n_fileas',
    direction: 'ASC'
  },
  gridConfig: {
    autoExpandColumn: 'n_fileas',
    enableDragDrop: true,
    ddGroup: 'containerDDGroup'
  },
  copyEditAction: true,
  felamimail: false,
  multipleEdit: true,
  duplicateResolvable: true,

  /**
   * @cfg {Bool} hasDetailsPanel 
   */
  hasDetailsPanel: true,

  /**
   * inits this cmp
   * @private
   */
  initComponent: function initComponent() {
    this.recordProxy = Tine.Addressbook.contactBackend; // check if felamimail is installed and user has run right and wants to use felamimail in adb

    if (Tine.Felamimail && Tine.Tinebase.common.hasRight('run', 'Felamimail') && Tine.Felamimail.registry.get('preferences').get('useInAdb')) {
      this.felamimail = Tine.Felamimail.registry.get('preferences').get('useInAdb') == 1;
    }

    this.gridConfig.cm = this.getColumnModel();

    if (this.hasDetailsPanel) {
      this.detailsPanel = this.getDetailsPanel();
    }

    Tine.Addressbook.ContactGridPanel.superclass.initComponent.call(this);
  },

  /**
   * returns column model
   * 
   * @return Ext.grid.ColumnModel
   * @private
   */
  getColumnModel: function getColumnModel() {
    return new Ext.grid.ColumnModel({
      defaults: {
        sortable: true,
        hidden: true,
        resizable: true
      },
      columns: this.getColumns()
    });
  },

  /**
   * returns array with columns
   * 
   * @return {Array}
   */
  getColumns: function getColumns() {
    return Tine.Addressbook.ContactGridPanel.getBaseColumns(this.app.i18n).concat(this.getModlogColumns().concat(this.getCustomfieldColumns()));
  },

  /**
   * @private
   */
  initActions: function initActions() {
    this.actions_import = new Ext.Action({
      //requiredGrant: 'addGrant',
      text: this.app.i18n._('Import contacts'),
      disabled: false,
      handler: this.onImport,
      iconCls: 'action_import',
      scope: this,
      allowMultiple: true
    }); // register actions in updater

    this.actionUpdater.addActions([this.actions_import]);
    Tine.Addressbook.ContactGridPanel.superclass.initActions.call(this);
  },

  /**
   * get default / selected addressbook container
   *
   * @returns {Object|Tine.Tinebase.Model.Container}
   */
  getDefaultContainer: function getDefaultContainer() {
    return this.app.getMainScreen().getWestPanel().getContainerTreePanel().getDefaultContainer('defaultAddressbook');
  },

  /**
   * returns details panel
   * 
   * @private
   * @return {Tine.Addressbook.ContactGridDetailsPanel}
   */
  getDetailsPanel: function getDetailsPanel() {
    return new Tine.Addressbook.ContactGridDetailsPanel({
      gridpanel: this,
      il8n: this.app.i18n,
      felamimail: this.felamimail
    });
  }
}); // Static Methods

/**
 * tid renderer
 * 
 * @private
 * @return {String} HTML
 */

Tine.Addressbook.ContactGridPanel.contactTypeRenderer = function (data, cell, record) {
  var i18n = Tine.Tinebase.appMgr.get('Addressbook').i18n,
      hasAccount = record.get && record.get('account_id') || record.account_id,
      cssClass = 'tine-grid-row-action-icon ' + (hasAccount ? 'renderer_typeAccountIcon' : 'renderer_typeContactIcon'),
      qtipText = Tine.Tinebase.common.doubleEncode(hasAccount ? i18n._('Contact of a user account') : i18n._('Contact'));
  return '<div ext:qtip="' + qtipText + '" style="background-position:0px;" class="' + cssClass + '">&#160</div>';
};

Tine.Addressbook.ContactGridPanel.displayNameRenderer = function (data) {
  var i18n = Tine.Tinebase.appMgr.get('Addressbook').i18n;
  return data ? Tine.Tinebase.EncodingHelper.encode(data) : '<div class="renderer_displayNameRenderer_noName">' + i18n._('No name') + '</div>';
};

Tine.Addressbook.ContactGridPanel.countryRenderer = function (data) {
  data = Locale.getTranslationData('CountryList', data);
  return Ext.util.Format.htmlEncode(data);
};
/**
 * Column renderer adb preferred_address field
 * @param value
 * @return {*}
 */


Tine.Addressbook.ContactGridPanel.preferredAddressRenderer = function (value) {
  var i18n = Tine.Tinebase.appMgr.get('Addressbook').i18n;

  switch (value) {
    case '0':
      return i18n._('Business');

    case '1':
      return i18n._('Private');

    default:
      return i18n._('Not set');
  }
};
/**
 * Statically constructs the columns used to represent a contact. Reused by ListMemberGridPanel + ListMemberRoleGridPanel
 */


Tine.Addressbook.ContactGridPanel.getBaseColumns = function (i18n) {
  var columns = [{
    id: 'type',
    header: i18n._('Type'),
    tooltip: i18n._('Type'),
    dataIndex: 'type',
    width: 20,
    renderer: Tine.Addressbook.ContactGridPanel.contactTypeRenderer.createDelegate(this),
    hidden: false
  }, {
    id: 'jpegphoto',
    header: i18n._('Contact Image'),
    tooltip: i18n._('Contact Image'),
    dataIndex: 'jpegphoto',
    width: 20,
    sortable: false,
    resizable: false,
    renderer: Tine.widgets.grid.imageRenderer,
    hidden: false
  }, {
    id: 'attachments',
    header: window.i18n._('Attachments'),
    tooltip: window.i18n._('Attachments'),
    dataIndex: 'attachments',
    width: 20,
    sortable: false,
    resizable: false,
    renderer: Tine.widgets.grid.attachmentRenderer,
    hidden: false
  }, {
    id: 'tags',
    header: i18n._('Tags'),
    dataIndex: 'tags',
    width: 50,
    renderer: Tine.Tinebase.common.tagsRenderer,
    sortable: false,
    hidden: false
  }, {
    id: 'salutation',
    header: i18n._('Salutation'),
    dataIndex: 'salutation',
    renderer: Tine.Tinebase.widgets.keyfield.Renderer.get('Addressbook', 'contactSalutation')
  }, {
    id: 'container_id',
    dataIndex: 'container_id',
    header: Tine.Addressbook.Model.Contact.getContainerName(),
    width: 150,
    renderer: Tine.Tinebase.common.containerRenderer
  }, {
    id: 'n_prefix',
    header: i18n._('Title'),
    dataIndex: 'n_prefix',
    width: 80
  }, {
    id: 'n_middle',
    header: i18n._('Middle Name'),
    dataIndex: 'n_middle',
    width: 80
  }, {
    id: 'n_family',
    header: i18n._('Last Name'),
    dataIndex: 'n_family'
  }, {
    id: 'n_given',
    header: i18n._('First Name'),
    dataIndex: 'n_given',
    width: 80
  }, {
    id: 'n_fn',
    header: i18n._('Full Name'),
    dataIndex: 'n_fn',
    renderer: Tine.Addressbook.ContactGridPanel.displayNameRenderer
  }, {
    id: 'n_fileas',
    header: i18n._('Display Name'),
    dataIndex: 'n_fileas',
    hidden: false,
    renderer: Tine.Addressbook.ContactGridPanel.displayNameRenderer
  }, {
    id: 'org_name',
    header: i18n._('Company'),
    dataIndex: 'org_name',
    width: 120,
    hidden: false
  }, {
    id: 'org_unit',
    header: i18n._('Unit'),
    dataIndex: 'org_unit'
  }, {
    id: 'title',
    header: i18n._('Job Title'),
    dataIndex: 'title'
  }, //            { id: 'role', header: i18n._('Job Role'), dataIndex: 'role' },
  //            { id: 'room', header: i18n._('Room'), dataIndex: 'room' },
  {
    id: 'adr_one_street',
    header: i18n._('Street'),
    dataIndex: 'adr_one_street'
  }, {
    id: 'adr_one_locality',
    header: i18n._('City'),
    dataIndex: 'adr_one_locality',
    width: 150,
    hidden: false
  }, {
    id: 'adr_one_region',
    header: i18n._('Region'),
    dataIndex: 'adr_one_region'
  }, {
    id: 'adr_one_postalcode',
    header: i18n._('Postalcode'),
    dataIndex: 'adr_one_postalcode'
  }, {
    id: 'adr_one_countryname',
    header: i18n._('Country'),
    dataIndex: 'adr_one_countryname',
    renderer: Tine.Addressbook.ContactGridPanel.countryRenderer
  }, {
    id: 'adr_two_street',
    header: i18n._('Street (private)'),
    dataIndex: 'adr_two_street'
  }, {
    id: 'adr_two_locality',
    header: i18n._('City (private)'),
    dataIndex: 'adr_two_locality'
  }, {
    id: 'adr_two_region',
    header: i18n._('Region (private)'),
    dataIndex: 'adr_two_region'
  }, {
    id: 'adr_two_postalcode',
    header: i18n._('Postalcode (private)'),
    dataIndex: 'adr_two_postalcode'
  }, {
    id: 'adr_two_countryname',
    header: i18n._('Country (private)'),
    dataIndex: 'adr_two_countryname',
    renderer: Tine.Addressbook.ContactGridPanel.countryRenderer
  }, {
    id: 'preferred_address',
    header: i18n._('Preferred Address'),
    dataIndex: 'preferred_address',
    renderer: Tine.Addressbook.ContactGridPanel.preferredAddressRenderer
  }, {
    id: 'email',
    header: i18n._('Email'),
    dataIndex: 'email',
    width: 150,
    hidden: false
  }, {
    id: 'tel_work',
    header: i18n._('Phone'),
    dataIndex: 'tel_work',
    hidden: false
  }, {
    id: 'tel_cell',
    header: i18n._('Mobile'),
    dataIndex: 'tel_cell',
    hidden: false
  }, {
    id: 'tel_fax',
    header: i18n._('Fax'),
    dataIndex: 'tel_fax'
  }, {
    id: 'tel_car',
    header: i18n._('Car phone'),
    dataIndex: 'tel_car'
  }, {
    id: 'tel_pager',
    header: i18n._('Pager'),
    dataIndex: 'tel_pager'
  }, {
    id: 'tel_home',
    header: i18n._('Phone (private)'),
    dataIndex: 'tel_home'
  }, {
    id: 'tel_fax_home',
    header: i18n._('Fax (private)'),
    dataIndex: 'tel_fax_home'
  }, {
    id: 'tel_cell_private',
    header: i18n._('Mobile (private)'),
    dataIndex: 'tel_cell_private'
  }, {
    id: 'email_home',
    header: i18n._('Email (private)'),
    dataIndex: 'email_home'
  }, {
    id: 'url',
    header: i18n._('Web'),
    dataIndex: 'url'
  }, {
    id: 'url_home',
    header: i18n._('URL (private)'),
    dataIndex: 'url_home'
  }, {
    id: 'language',
    header: i18n._('Language'),
    dataIndex: 'language'
  }, {
    id: 'note',
    header: i18n._('Note'),
    dataIndex: 'note'
  }, {
    id: 'tz',
    header: i18n._('Timezone'),
    dataIndex: 'tz'
  }, {
    id: 'geo',
    header: i18n._('Geo'),
    dataIndex: 'geo'
  }, {
    id: 'bday',
    header: i18n._('Birthday'),
    dataIndex: 'bday',
    renderer: Tine.Tinebase.common.dateRenderer
  }, {
    id: 'memberroles',
    header: i18n._('List Roles'),
    dataIndex: 'memberroles',
    sortable: false,
    renderer: Tine.Addressbook.ListMemberRoleRenderer
  }, {
    id: 'color',
    header: i18n._('Color'),
    dataIndex: 'color'
  }];

  if (Tine.Tinebase.appMgr.get('Addressbook').featureEnabled('featureIndustry')) {
    columns.push({
      id: 'industry',
      header: i18n._('Industry'),
      dataIndex: 'industry',
      renderer: Tine.Tinebase.common.foreignRecordRenderer
    });
  }

  if (Tine.Tinebase.appMgr.get('Addressbook').featureEnabled('featureShortName')) {
    columns.push({
      id: 'n_short',
      header: i18n._('Short Name'),
      dataIndex: 'n_short',
      width: 50
    });
  }

  return columns;
};

/***/ }),

/***/ 294:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 * contacts combo box and store
 * 
 * @package     Addressbook
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Philipp Schüle <p.schuele@metaways.de>
 * @copyright   Copyright (c) 2007-2016 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 */
Ext.ns('Tine.Addressbook');
/**
 * contact selection combo box
 * 
 * @namespace   Tine.Addressbook
 * @class       Tine.Addressbook.SearchCombo
 * @extends     Ext.form.ComboBox
 * 
 * <p>Contact Search Combobox</p>
 * <p><pre>
 * TODO         make this a twin trigger field with 'clear' button?
 * TODO         add switch to filter for expired/enabled/disabled user accounts
 * </pre></p>
 * 
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Philipp Schuele <p.schuele@metaways.de>
 * @copyright   Copyright (c) 2007-2011 Metaways Infosystems GmbH (http://www.metaways.de)
 * 
 * @param       {Object} config
 * @constructor
 * Create a new Tine.Addressbook.SearchCombo
 * 
 * TODO         add     forceSelection: true ?
 */

Tine.Addressbook.ContactSearchCombo = Ext.extend(Tine.Tinebase.widgets.form.RecordPickerComboBox, {
  /**
   * @cfg {Boolean} userOnly
   */
  userOnly: false,

  /**
   * @cfg {Boolean} addPathFilter
   */
  addPathFilter: true,

  /**
   * use account objects/records in get/setValue
   * 
   * @cfg {Boolean} legacy
   * @legacy
   * 
   * TODO remove this later
   */
  useAccountRecord: false,
  allowBlank: true,
  itemSelector: 'div.search-item',
  minListWidth: 350,
  //private
  initComponent: function initComponent() {
    this.app = Tine.Tinebase.appMgr.get('Addressbook');

    if (this.recordClass === null) {
      this.recordClass = Tine.Addressbook.Model.Contact;
      this.recordProxy = Tine.Addressbook.contactBackend;
    }

    this.emptyText = this.emptyText || (this.readOnly || this.disabled ? '' : this.userOnly ? this.app.i18n._('Search for users ...') : this.app.i18n._('Search for Contacts ...'));
    this.initTemplate();
    Tine.Addressbook.SearchCombo.superclass.initComponent.call(this);
  },

  /**
   * is called in accountMode to reset the value
   * @param value
   */
  processValue: function processValue(value) {
    if (this.useAccountRecord) {
      if (value == '') {
        this.accountId = null;
        this.selectedRecord = null;
      }
    }

    return Tine.Addressbook.SearchCombo.superclass.processValue.call(this, value);
  },

  /**
   * use beforequery to set query filter
   * 
   * @param {Event} qevent
   */
  onBeforeQuery: function onBeforeQuery(qevent) {
    Tine.Addressbook.SearchCombo.superclass.onBeforeQuery.apply(this, arguments);
    const filter = this.store.baseParams.filter;

    if (this.addPathFilter) {
      const queryFilter = _.find(filter, {
        field: 'query'
      });

      const pathFilter = {
        field: 'path',
        operator: 'contains',
        value: queryFilter.value
      };

      _.remove(filter, queryFilter);

      filter.push({
        condition: "OR",
        filters: [queryFilter, pathFilter]
      });
    }

    if (this.userOnly) {
      filter.push({
        field: 'type',
        operator: 'equals',
        value: 'user'
      });
    }
  },

  /**
   * init template
   * @private
   */
  initTemplate: function initTemplate() {
    // Custom rendering Template
    if (!this.tpl) {
      this.tpl = new Ext.XTemplate('<tpl for="."><div class="search-item addressbook-search-combo x-combo-list-item">', '<table>', '<tr>', '<td style="min-width: 20px;">{[Tine.Addressbook.ContactGridPanel.contactTypeRenderer(null, null, values)]}</td>', '<td width="30%"><b>{[Tine.Addressbook.ContactGridPanel.displayNameRenderer(values.n_fileas)]}</b><br/>' + '{[Tine.Tinebase.EncodingHelper.encode(values.org_name)]}<br/>{[this.encode(values.org_unit)]}</td>', '<td width="25%">{[Tine.Tinebase.EncodingHelper.encode(values.adr_one_street)]}<br/>', '{[Tine.Tinebase.EncodingHelper.encode(values.adr_one_postalcode)]} {[this.encode(values.adr_one_locality)]}<br/>' + '{[this.encode(values.email)]}</td>', '<td width="25%">{[Tine.Tinebase.EncodingHelper.encode(values.tel_work)]}<br/>{[Tine.Tinebase.EncodingHelper.encode(values.tel_cell)]}</td>', '<td width="50px">', '<img width="45px" height="39px" src="{jpegphoto}" />', '</td>', '</tr>', '</table>', '{[Tine.widgets.path.pathsRenderer(values.paths, this.getLastQuery())]}', '</div></tpl>', {
        getLastQuery: this.getLastQuery.createDelegate(this)
      });
    }
  },
  getValue: function getValue() {
    if (this.useAccountRecord) {
      if (this.selectedRecord) {
        return this.selectedRecord.get('account_id');
      } else {
        return this.accountId;
      }
    } else {
      return Tine.Addressbook.SearchCombo.superclass.getValue.call(this);
    }
  },
  setValue: function setValue(value) {
    if (this.useAccountRecord) {
      if (value) {
        if (value.accountId) {
          // account object
          this.accountId = value.accountId;
          value = value.accountDisplayName;
        } else if (typeof value.get == 'function') {
          // account record
          this.accountId = value.get('id');
          value = value.get('name');
        }
      } else {
        this.accountId = null;
        this.selectedRecord = null;
      }
    }

    return Tine.Addressbook.SearchCombo.superclass.setValue.call(this, value);
  }
}); // legacy

Tine.Addressbook.SearchCombo = Tine.Addressbook.ContactSearchCombo;
Ext.reg('addressbookcontactpicker', Tine.Addressbook.ContactSearchCombo);
Tine.widgets.form.RecordPickerManager.register('Addressbook', 'Contact', Tine.Addressbook.ContactSearchCombo);

/***/ }),

/***/ 39:
/***/ (function(module, exports) {


/**
 * When source maps are enabled, `style-loader` uses a link element with a data-uri to
 * embed the css on the page. This breaks all relative urls because now they are relative to a
 * bundle instead of the current page.
 *
 * One solution is to only use full urls, but that may be impossible.
 *
 * Instead, this function "fixes" the relative urls to be absolute according to the current page location.
 *
 * A rudimentary test suite is located at `test/fixUrls.js` and can be run via the `npm test` command.
 *
 */

module.exports = function (css) {
  // get current location
  var location = typeof window !== "undefined" && window.location;

  if (!location) {
    throw new Error("fixUrls requires window.location");
  }

	// blank or null?
	if (!css || typeof css !== "string") {
	  return css;
  }

  var baseUrl = location.protocol + "//" + location.host;
  var currentDir = baseUrl + location.pathname.replace(/\/[^\/]*$/, "/");

	// convert each url(...)
	/*
	This regular expression is just a way to recursively match brackets within
	a string.

	 /url\s*\(  = Match on the word "url" with any whitespace after it and then a parens
	   (  = Start a capturing group
	     (?:  = Start a non-capturing group
	         [^)(]  = Match anything that isn't a parentheses
	         |  = OR
	         \(  = Match a start parentheses
	             (?:  = Start another non-capturing groups
	                 [^)(]+  = Match anything that isn't a parentheses
	                 |  = OR
	                 \(  = Match a start parentheses
	                     [^)(]*  = Match anything that isn't a parentheses
	                 \)  = Match a end parentheses
	             )  = End Group
              *\) = Match anything and then a close parens
          )  = Close non-capturing group
          *  = Match anything
       )  = Close capturing group
	 \)  = Match a close parens

	 /gi  = Get all matches, not the first.  Be case insensitive.
	 */
	var fixedCss = css.replace(/url\s*\(((?:[^)(]|\((?:[^)(]+|\([^)(]*\))*\))*)\)/gi, function(fullMatch, origUrl) {
		// strip quotes (if they exist)
		var unquotedOrigUrl = origUrl
			.trim()
			.replace(/^"(.*)"$/, function(o, $1){ return $1; })
			.replace(/^'(.*)'$/, function(o, $1){ return $1; });

		// already a full url? no change
		if (/^(#|data:|http:\/\/|https:\/\/|file:\/\/\/)/i.test(unquotedOrigUrl)) {
		  return fullMatch;
		}

		// convert the url to a full url
		var newUrl;

		if (unquotedOrigUrl.indexOf("//") === 0) {
		  	//TODO: should we add protocol?
			newUrl = unquotedOrigUrl;
		} else if (unquotedOrigUrl.indexOf("/") === 0) {
			// path should be relative to the base url
			newUrl = baseUrl + unquotedOrigUrl; // already starts with '/'
		} else {
			// path should be relative to current directory
			newUrl = currentDir + unquotedOrigUrl.replace(/^\.\//, ""); // Strip leading './'
		}

		// send back the fixed url(...)
		return "url(" + JSON.stringify(newUrl) + ")";
	});

	// send back the fixed css
	return fixedCss;
};


/***/ }),

/***/ 49:
/***/ (function(module, exports, __webpack_require__) {

/* pkg: Addressbook FAT Client (js/Addressbook-FAT.js)*/
__webpack_require__(1643);
__webpack_require__(1644);
__webpack_require__(1645);
__webpack_require__(1646);
__webpack_require__(1647);
__webpack_require__(1651);
__webpack_require__(1652);
__webpack_require__(1653);
__webpack_require__(1654);
__webpack_require__(1655);
__webpack_require__(1656);
__webpack_require__(293);
__webpack_require__(1657);
__webpack_require__(1658);
__webpack_require__(1659);
__webpack_require__(1660);
__webpack_require__(1661);
__webpack_require__(1662);
__webpack_require__(1663);
__webpack_require__(1664);
__webpack_require__(1665);
__webpack_require__(294);
__webpack_require__(1667);
__webpack_require__(1668);
__webpack_require__(1669);
__webpack_require__(1670);
__webpack_require__(1671);
__webpack_require__(1672);
/* pkg: Addressbook FAT Client (css/Addressbook-FAT.css)*/
__webpack_require__(1673);
__webpack_require__(1679);
__webpack_require__(1684);
__webpack_require__(1687);
__webpack_require__(1689);


/***/ }),

/***/ 516:
/***/ (function(module, exports) {

module.exports = "\"data:image/svg+xml,%3C?xml version='1.0' encoding='utf-8'?%3E %3C!-- Generator: Adobe Illustrator 21.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0) --%3E %3Csvg version='1.1' id='Ebene_1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' x='0px' y='0px' viewBox='0 0 42.5 42.5' style='enable-background:new 0 0 42.5 42.5;' xml:space='preserve' width='42.5' height='42.5'%3E %3Cpath d='M37.4,32.4V10c0-0.2-0.1-0.3-0.2-0.4c-0.1-0.1-0.3-0.2-0.4-0.2H5c-0.2,0-0.3,0.1-0.4,0.2C4.4,9.7,4.4,9.8,4.4,10v22.4 c0,0.2,0.1,0.3,0.2,0.4C4.7,32.9,4.8,33,5,33h6.5v-1.8c0-0.2,0.1-0.3,0.2-0.4c0.1-0.1,0.3-0.2,0.4-0.2h1.2c0.2,0,0.3,0.1,0.4,0.2 c0.1,0.1,0.2,0.3,0.2,0.4V33H28v-1.8c0-0.2,0.1-0.3,0.2-0.4s0.3-0.2,0.4-0.2h1.2c0.2,0,0.3,0.1,0.4,0.2s0.2,0.3,0.2,0.4V33h6.5 c0.2,0,0.3-0.1,0.4-0.2C37.4,32.7,37.4,32.6,37.4,32.4z M39.8,10v22.4c0,0.8-0.3,1.5-0.9,2.1c-0.6,0.6-1.3,0.9-2.1,0.9H5 c-0.8,0-1.5-0.3-2.1-0.9C2.3,33.9,2,33.2,2,32.4V10c0-0.8,0.3-1.5,0.9-2.1S4.1,7,5,7h31.9c0.8,0,1.5,0.3,2.1,0.9 C39.5,8.4,39.8,9.1,39.8,10z M23.1,21.1c-0.1-0.1-0.2-0.3-0.2-0.4v-1.2c0-0.2,0.1-0.3,0.2-0.4s0.3-0.2,0.4-0.2h4.3v-4.3 c0-0.2,0.1-0.3,0.2-0.4s0.3-0.2,0.4-0.2h1.2c0.2,0,0.3,0.1,0.4,0.2s0.2,0.3,0.2,0.4v4.3h4.3c0.2,0,0.3,0.1,0.4,0.2s0.2,0.3,0.2,0.4 v1.2c0,0.2-0.1,0.3-0.2,0.4s-0.3,0.2-0.4,0.2h-4.3v4.3c0,0.2-0.1,0.3-0.2,0.4s-0.3,0.2-0.4,0.2h-1.2c-0.2,0-0.3-0.1-0.4-0.2 s-0.2-0.3-0.2-0.4v-4.3h-4.3C23.4,21.2,23.2,21.2,23.1,21.1z M11.9,20.3c-1.1,0.1-1.9,0.5-2.6,1.3H7.9c-0.5,0-1-0.2-1.4-0.4 C6.2,20.9,6,20.5,6,20c0-2.3,0.4-3.5,1.2-3.5c0.1,0,0.2,0.1,0.4,0.2c0.3,0.2,0.6,0.3,0.9,0.4c0.4,0.2,0.8,0.2,1.2,0.2 c0.4,0,0.9-0.1,1.3-0.2C11,17.4,11,17.6,11,17.7C11.1,18.7,11.4,19.5,11.9,20.3z M22.7,26.7c0,0.8-0.3,1.4-0.7,1.9 c-0.5,0.5-1.1,0.7-1.9,0.7h-8.6c-0.8,0-1.4-0.2-1.9-0.7c-0.5-0.5-0.7-1.1-0.7-1.9c0-0.4,0-0.7,0.1-1.1c0.1-0.4,0.1-0.7,0.2-1.1 c0.1-0.4,0.2-0.7,0.3-1.1c0.1-0.3,0.3-0.6,0.4-0.9c0.2-0.3,0.4-0.6,0.6-0.8c0.2-0.2,0.5-0.4,0.8-0.5c0.3-0.1,0.7-0.2,1.1-0.2 c0.1,0,0.2,0.1,0.4,0.2c0.2,0.2,0.5,0.3,0.7,0.5c0.3,0.2,0.6,0.3,1.1,0.5c0.4,0.2,0.9,0.2,1.3,0.2c0.4,0,0.9-0.1,1.3-0.2 c0.4-0.2,0.8-0.3,1.1-0.5s0.5-0.3,0.7-0.5c0.2-0.2,0.4-0.2,0.4-0.2c0.4,0,0.8,0.1,1.1,0.2c0.3,0.2,0.6,0.3,0.8,0.5 c0.2,0.2,0.4,0.5,0.6,0.8c0.2,0.3,0.3,0.6,0.4,0.9c0.1,0.3,0.2,0.7,0.3,1.1c0.1,0.4,0.1,0.7,0.2,1.1C22.7,26,22.7,26.4,22.7,26.7z M12.4,13.9c0,0.7-0.3,1.3-0.7,1.8c-0.5,0.5-1.1,0.7-1.8,0.7s-1.3-0.3-1.8-0.7c-0.5-0.5-0.7-1.1-0.7-1.8s0.3-1.3,0.7-1.8 c0.5-0.5,1.1-0.7,1.7-0.7c0.7,0,1.3,0.3,1.8,0.7C12.1,12.6,12.4,13.2,12.4,13.9z M19.1,17.8c0,0.9-0.3,1.7-1,2.4 c-0.7,0.7-1.5,1-2.4,1c-0.9,0-1.7-0.3-2.4-1c-0.7-0.7-1-1.5-1-2.4s0.3-1.7,1-2.4s1.5-1,2.4-1c0.9,0,1.7,0.3,2.4,1 C18.7,16,19.1,16.8,19.1,17.8z M24.1,13.9c0,0.7-0.3,1.3-0.7,1.8c-0.5,0.5-1.1,0.7-1.8,0.7c-0.7,0-1.3-0.3-1.8-0.7 c-0.5-0.5-0.7-1.1-0.7-1.8s0.3-1.3,0.7-1.8c0.5-0.5,1.1-0.7,1.8-0.7c0.7,0,1.3,0.3,1.8,0.7C23.8,12.7,24.1,13.2,24.1,13.9z'/%3E %3C/svg%3E\""

/***/ })

}]);