(window["webpackJsonp"] = window["webpackJsonp"] || []).push([[12],{

/***/ 170:
/***/ (function(module, exports) {

/*
 * Tine 2.0
 *
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Cornelius Weiß <c.weiss@metaways.de>
 * @copyright   Copyright (c) 2020 Metaways Infosystems GmbH (http://www.metaways.de)
 */
Ext.ns('Tine.Tinebase.widgets.file.LocationTypePlugin');

Tine.Tinebase.widgets.file.LocationTypePlugin.Abstract = function (plugin) {
  Ext.apply(this, plugin);
};

Tine.Tinebase.widgets.file.LocationTypePlugin.Abstract.prototype = {
  /**
   * @cfg {String} locationType
   * locationType name
   */
  locationType: '',

  /**
   * @cfg {String} name
   * _translated_ name of this locationType (required)
   */
  name: '',

  /**
   * @cfg {String} iconCls
   * iconCls for place selection
   */
  iconCls: '',

  /**
   * @param area one of pluginPanel|targetForm|optionsForm
   * @return {Promise<void>}
   */
  getSelectionDialogArea: async function getSelectionDialogArea(area, cmp) {},

  /**
   * @return {Array}
   */
  getFileList: function getFileList() {},

  /**
   * manage state of apply button
   * use buttonApply.setDisabled({Boolean}) to manage state
   * @param {Ext.Action} buttonApply
   */
  manageButtonApply: function manageButtonApply(buttonApply) {},

  /**
   * called before dialog closes, return false to suppress selection
   * @return {Promise<void>}
   */
  validateSelection: async function validateSelection() {},

  /**
   * get string representation of given location
   *
   * @param {Object} location
   * @return {String} string representation of location
   */
  getLocationName: function getLocationName(location) {}
};

/***/ }),

/***/ 2551:
/***/ (function(module, exports, __webpack_require__) {

/*
 * Tine 2.0
 *
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Cornelius Weiß <c.weiss@metaways.de>
 * @copyright   Copyright (c) 2020 Metaways Infosystems GmbH (http://www.metaways.de)
 */
__webpack_require__(170);

Ext.ns('Tine.Filemanager.FileLocationType');

Tine.Filemanager.FileLocationType.FilemanagerPlugin = function (config) {
  Ext.apply(this, config);
  this.app = Tine.Tinebase.appMgr.get('Filemanager');
  this.name = this.app.getTitle();
};

Ext.extend(Tine.Filemanager.FileLocationType.FilemanagerPlugin, Tine.Tinebase.widgets.file.LocationTypePlugin.Abstract, {
  locationType: 'fm_node',
  iconCls: 'FilemanagerIconCls',

  /**
   * @property {Boolean} validSelection
   */
  validSelection: false,
  getSelectionDialogArea: async function getSelectionDialogArea(area, cmp) {
    if (!this.selectionDialogInitialised) {
      this.cmp = cmp;
      this.pluginPanel = new Tine.Filemanager.FilePicker(Ext.apply({
        mode: this.cmp.mode,
        allowMultiple: this.cmp.allowMultiple,
        constraint: this.cmp.constraint,
        requiredGrants: this.cmp.requiredGrants,
        fileName: this.cmp.fileName,
        initialPath: this.cmp.initialPath
      }, _.get(this, 'cmp.pluginConfig.' + this.plugin, {})));
      this.pluginPanel.on('nodeSelected', this.onNodesSelected, this);
      this.pluginPanel.on('forceNodeSelected', this.onForceNodesSelected, this);
      this.pluginPanel.on('invalidNodeSelected', this.onInvalidNodeSelected, this);
      this.selectionDialogInitialised = true;
    }

    return _.get(this, area);
  },
  onNodesSelected: function onNodesSelected(nodes) {
    this.nodes = nodes;
    this.validSelection = true;
    this.manageButtonApply(this.cmp.buttonApply);
  },
  onForceNodesSelected: function onForceNodesSelected(nodes) {
    this.cmp.onButtonApply();
  },
  onInvalidNodeSelected: function onInvalidNodeSelected(nodes) {
    this.validSelection = false;
    this.manageButtonApply(this.cmp.buttonApply);
  },
  getFileList: function getFileList() {
    return _.map(this.pluginPanel.selection, node => {
      return {
        fm_path: node.path,
        node_id: node
      };
    });
  },
  validateSelection: async function validateSelection() {
    return this.pluginPanel.validateSelection();
  },
  manageButtonApply: function manageButtonApply(buttonApply) {
    buttonApply.setDisabled(!this.validSelection);
  },
  getLocationName: function getLocationName(location) {
    return location.fm_path;
  }
});

/***/ })

}]);