<?php
/**
 * Tine 2.0
 * 
 * @package     ActiveSync
 * @subpackage  Acl
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @copyright   Copyright (c) 2015 Metaways Infosystems GmbH (http://www.metaways.de)
 * @author      Philipp Schüle <p.schuele@metaways.de>
 * 
 */

/**
 * this class handles the rights for the ActiveSync application
 * 
 * a right is always specific to an application and not to a record
 * examples for rights are: admin, run
 * 
 * to add a new right you have to do these 3 steps:
 * - add a constant for the right
 * - add the constant to the $addRights in getAllApplicationRights() function
 * . add getText identifier in getTranslatedRightDescriptions() function
 * 
 * @package     ActiveSync
 * @subpackage  Acl
 */
class ActiveSync_Acl_Rights extends Tinebase_Acl_Rights_Abstract
{
    /**
     * the right to manage shared contact favorites
     * 
     * @staticvar string
     */
    const MANAGE_DEVICES = 'manage_devices';

    /**
     * the right to reset a device to factory state, wiping all data
     */
    const RESET_DEVICES = 'reset_devices';
    
    /**
     * holds the instance of the singleton
     *
     * @var ActiveSync_Acl_Rights
     */
    private static $_instance = NULL;
    
    /**
     * the clone function
     *
     * disabled. use the singleton
     */
    private function __clone() 
    {
    }
    
    /**
     * the constructor
     *
     */
    private function __construct()
    {
        
    }    
    
    /**
     * the singleton pattern
     *
     * @return ActiveSync_Acl_Rights
     */
    public static function getInstance() 
    {
        if (self::$_instance === NULL) {
            self::$_instance = new ActiveSync_Acl_Rights;
        }
        
        return self::$_instance;
    }
    
    /**
     * get all possible application rights
     *
     * @return  array   all application rights
     */
    public function getAllApplicationRights()
    {
        
        $allRights = parent::getAllApplicationRights();
        
        $addRights = array(
            self::MANAGE_DEVICES,
            self::RESET_DEVICES,
        );
        $allRights = array_merge($allRights, $addRights);
        
        return $allRights;
    }

    /**
     * get translated right descriptions
     * 
     * @return  array with translated descriptions for this applications rights
     */
    public static function getTranslatedRightDescriptions()
    {
        $translate = Tinebase_Translation::getTranslation('ActiveSync');
        
        $rightDescriptions = array(
            self::MANAGE_DEVICES => array(
                'text'          => $translate->_('Manage ActiveSync devices'),
                'description'   => $translate->_('See, edit and delete ActiveSync devices'),
            ),
            self::RESET_DEVICES => array(
                'text'          => $translate->_('Reset ActiveSync devices'),
                'description'   => $translate->_('Remotely reset ActiveSync devices to factory state, deleting all data'),
            )
        );
        
        $rightDescriptions = array_merge($rightDescriptions, parent::getTranslatedRightDescriptions());
        return $rightDescriptions;
    }
}
