<?php
/**
 * Tine 2.0
 *
 * @package     Tinebase
 * @subpackage  ModelConfiguration
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @copyright   Copyright (c) 2018-2019 Metaways Infosystems GmbH (http://www.metaways.de)
 * @author      Paul Mehrer <p.mehrer@metaways.de>
 */

/**
 * Tinebase_ModelConfiguration_Const provides constants
 *
 * @package     Tinebase
 * @subpackage  ModelConfiguration
 */

class Tinebase_ModelConfiguration_Const {
    const APP_NAME = 'appName';
    const ASSOCIATIONS = 'associations';
    const AVAILABLE_MODELS = 'availableModels';

    const CONFIG = 'config';
    const CONTROLLER = 'controller';
    const CONTROLLER_HOOK_BEFORE_UPDATE = 'controllerHookBeforeUpdate';
    const CONVERTERS = 'converters';
    const COLUMNS = 'columns';
    const COPY_OMIT = 'copyOmit';
    const CREATE_MODULE = 'createModule';

    const DB_COLUMNS = 'dbColumns';
    const DEFAULT_VAL = 'default';
    const DEPENDENT_RECORDS = 'dependentRecords';
    const DISABLED = 'disabled';

    const EXPOSE_HTTP_API = 'exposeHttpApi';
    const EXPOSE_JSON_API = 'exposeJsonApi';

    const FIELDS = 'fields';
    const FILTER = 'filter';
    const FILTER_DEFINITION = 'filterDefinition';
    const FILTER_GROUP = 'filtergroup';
    const FILTER_OPTIONS = 'filterOptions';
    const FLAGS = 'flags';

    const HAS_CUSTOM_FIELDS = 'hasCustomFields';
    const HAS_DELETED_TIME_UNIQUE = 'hasDeletedTimeUnique';
    const HAS_NOTES = 'hasNotes';
    const HAS_PERSONAL_CONTAINER = 'hasPersonalContainer';
    const HAS_RELATIONS = 'hasRelations';
    const HAS_SYSTEM_CUSTOM_FIELDS = 'hasSystemCustomFields';
    const HAS_TAGS = 'hasTags';
    const HAS_XPROPS = 'hasXProps';

    const ID = 'id';
    const ID_GENERATOR_TYPE = 'idGeneratorType';
    const INDEXES = 'indexes';
    const INPUT_FILTERS = 'inputFilters';
    const IS_DEPENDENT = 'isDependent';
    const IS_VIRTUAL = 'isVirtual';

    const LABEL = 'label';
    const LENGTH = 'length';

    const MODEL_NAME = 'modelName';
    const MODLOG_ACTIVE = 'modlogActive';

    const NAME = 'name';
    const NULLABLE = 'nullable';

    const OMIT_MOD_LOG = 'modlogOmit';
    const OPTIONS = 'options';

    const QUERY_FILTER = 'queryFilter';

    const READ_ONLY = 'readOnly';
    const REF_ID_FIELD = 'refIdField';
    const REF_MODEL_FIELD = 'refModelField';
    const RECORD_CLASS_NAME = 'recordClassName';
    const RECORD_NAME = 'recordName';
    const RECORDS_NAME = 'recordsName';

    const SHY = 'shy';
    const SINGULAR_CONTAINER_MODE = 'singularContainerMode';
    const SPECIAL_TYPE = 'specialType';
    const SPECIAL_TYPE_DURATION_SEC = 'durationSec';
    const STORAGE = 'storage';
    const SYSTEM = 'system';

    const TABLE = 'table';
    const TITLE_PROPERTY = 'titleProperty';
    const TYPE = 'type';
    const TYPE_ATTACHMENTS = 'attachments';
    const TYPE_BIGINT = 'bigint';
    const TYPE_BOOLEAN = 'boolean';
    const TYPE_CONTAINER = 'container';
    const TYPE_DATETIME = 'datetime';
    const TYPE_DATE = 'date';
    const TYPE_DYNAMIC_RECORD = 'dynamicRecord';
    const TYPE_FLOAT = 'float';
    const TYPE_FULLTEXT = 'fulltext';
    const TYPE_INTEGER = 'integer';
    const TYPE_JSON = 'json';
    const TYPE_KEY_FIELD = 'keyfield';
    const TYPE_MODEL = 'model';
    const TYPE_MONEY = 'money';
    const TYPE_NOTE = 'note';
    const TYPE_NUMBERABLE_INT = 'numberableInt';
    const TYPE_NUMBERABLE_STRING = 'numberableStr';
    const TYPE_RECORD = 'record';
    const TYPE_RECORDS = 'records';
    const TYPE_RELATION = 'relation';
    const TYPE_STRING = 'string';
    const TYPE_STRING_AUTOCOMPLETE = 'stringAutocomplete';
    const TYPE_TAG = 'tag';
    const TYPE_TEXT = 'text';
    const TYPE_TIME = 'time';
    const TYPE_USER = 'user';
    const TYPE_VIRTUAL = 'virtual';

    const UNIQUE_CONSTRAINTS = 'uniqueConstraints';
    const UNSIGNED = 'unsigned';

    const VALIDATORS = 'validators';
    const VERSION = 'version';
}
