<?php
/**
 * Tine 2.0
 * 
 * @package     Calendar
 * @subpackage  Model
 * @license     http://www.gnu.org/licenses/agpl.html AGPL Version 3
 * @author      Philipp Schüle <p.schuele@metaways.de>
 * @copyright   Copyright (c) 2011-2019 Metaways Infosystems GmbH (http://www.metaways.de)
 *
 */

/**
 * filters for events whose attendee have a certain role
 * 
 * 
 * @package     Calendar
 * @subpackage  Model
 */
class Calendar_Model_AttenderRoleFilter extends Tinebase_Model_Filter_Text 
{
    /**
     * @var array list of allowed operators
     */
    protected $_operators = array(
        0 => 'equals',
        1 => 'not',
        2 => 'in',
        3 => 'notin',
    );

    protected $_dnames = [];

    protected $_currentDname = 'attendee';

    /**
     * returns quoted column name for sql backend
     *
     * @param  Tinebase_Backend_Sql_Interface $_backend
     * @return string
     * 
     * @todo to be removed once we split filter model / backend
     */
    protected function _getQuotedFieldName($_backend) {
        return $_backend->getAdapter()->quoteIdentifier(
            $this->_currentDname . '.role'
        );
    }

    public function addAttendeeJoinName($dname)
    {
        $this->_dnames[$dname] = $dname;
    }

    /**
     * appends sql to given select statement
     *
     * @param  Zend_Db_Select                $_select
     * @param  Tinebase_Backend_Sql_Abstract $_backend
     * @throws Tinebase_Exception_InvalidArgument
     */
    public function appendFilterSql($_select, $_backend)
    {
        if (empty($this->_dnames)) {
            parent::appendFilterSql($_select, $_backend);
        } else {
            foreach ($this->_dnames as $dname) {
                $this->_currentDname = $dname;
                parent::appendFilterSql($_select, $_backend);
            }
        }

        $this->_currentDname = 'attendee';
        $this->_dnames = [];
    }
}
